/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private final Comparator<? super K> comparator;
    private transient Entry<K, V> root;
    private transient int size;
    private transient int modCount;
    private transient EntrySet entrySet;
    private transient KeySet<K> navigableKeySet;
    private transient NavigableMap<K, V> descendingMap;
    private static final Object UNBOUNDED = new Object();
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
        this.root = null;
        this.size = 0;
        this.modCount = 0;
        this.entrySet = null;
        this.navigableKeySet = null;
        this.descendingMap = null;
        this.comparator = null;
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.root = null;
        this.size = 0;
        this.modCount = 0;
        this.entrySet = null;
        this.navigableKeySet = null;
        this.descendingMap = null;
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this.root = null;
        this.size = 0;
        this.modCount = 0;
        this.entrySet = null;
        this.navigableKeySet = null;
        this.descendingMap = null;
        this.comparator = null;
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        this.root = null;
        this.size = 0;
        this.modCount = 0;
        this.entrySet = null;
        this.navigableKeySet = null;
        this.descendingMap = null;
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            if (TreeMap.valEquals(object, entry.value)) {
                return true;
            }
            entry = TreeMap.successor(entry);
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return TreeMap.key(this.getFirstEntry());
    }

    @Override
    public K lastKey() {
        return TreeMap.key(this.getLastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator comparator;
        int n2 = map.size();
        if (this.size == 0 && n2 != 0 && g.convertForInstanceOf(map, SortedMap.class) instanceof SortedMap && (!f.ifAcmp(comparator = ((SortedMap)g.convertForCast(map, SortedMap.class)).comparator(), (Object)this.comparator) || comparator != null && comparator.equals(this.comparator))) {
            TreeMap treeMap = this;
            treeMap.modCount = treeMap.modCount + 1;
            try {
                this.buildFromSorted(n2, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    final Entry<K, V> getEntry(Object object) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(object);
        }
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Comparable comparable = (Comparable)g.convertForCast((Object)object, Comparable.class);
        Entry entry = this.root;
        while (entry != null) {
            int n2 = comparable.compareTo(entry.key);
            if (n2 < 0) {
                entry = entry.left;
                continue;
            }
            if (n2 > 0) {
                entry = entry.right;
                continue;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getEntryUsingComparator(Object object) {
        Object object2 = object;
        Comparator comparator = this.comparator;
        if (comparator != null) {
            Entry entry = this.root;
            while (entry != null) {
                int n2 = comparator.compare(object2, entry.key);
                if (n2 < 0) {
                    entry = entry.left;
                    continue;
                }
                if (n2 > 0) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
        }
        return null;
    }

    final Entry<K, V> getCeilingEntry(K k) {
        Entry entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k, entry.key);
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (n2 > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry entry3 = entry;
                while (entry2 != null && !f.ifAcmp(entry3, entry2.right)) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getFloorEntry(K k) {
        Entry entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k, entry.key);
            if (n2 > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry entry3 = entry;
                while (entry2 != null && !f.ifAcmp(entry3, entry2.left)) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    final Entry<K, V> getHigherEntry(K k) {
        Entry entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k, entry.key);
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right != null) {
                entry = entry.right;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry entry3 = entry;
            while (entry2 != null && !f.ifAcmp(entry3, entry2.right)) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    final Entry<K, V> getLowerEntry(K k) {
        Entry entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k, entry.key);
            if (n2 > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left != null) {
                entry = entry.left;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry entry3 = entry;
            while (entry2 != null && !f.ifAcmp(entry3, entry2.left)) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Object object;
        int n2;
        Entry entry;
        Entry entry2 = this.root;
        if (entry2 == null) {
            this.compare(k, k);
            this.root = new Entry(k, v, null);
            this.size = 1;
            TreeMap treeMap = this;
            treeMap.modCount = treeMap.modCount + 1;
            return null;
        }
        Comparator comparator = this.comparator;
        if (comparator != null) {
            do {
                entry = entry2;
                n2 = comparator.compare(k, entry2.key);
                if (n2 < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n2 > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v);
            } while (entry2 != null);
        } else {
            if (k == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            object = (Comparable)g.convertForCast(k, Comparable.class);
            do {
                entry = entry2;
                n2 = object.compareTo(entry2.key);
                if (n2 < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n2 > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v);
            } while (entry2 != null);
        }
        object = new Entry(k, v, entry);
        if (n2 < 0) {
            entry.left = object;
        } else {
            entry.right = object;
        }
        this.fixAfterInsertion((Entry<K, V>)object);
        TreeMap treeMap = this;
        treeMap.size = treeMap.size + 1;
        TreeMap treeMap2 = this;
        treeMap2.modCount = treeMap2.modCount + 1;
        return null;
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object v = entry.value;
        this.deleteEntry(entry);
        return v;
    }

    @Override
    public void clear() {
        TreeMap treeMap = this;
        treeMap.modCount = treeMap.modCount + 1;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)g.convertForCast((Object)super.clone(), TreeMap.class);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        treeMap.navigableKeySet = null;
        treeMap.descendingMap = null;
        try {
            treeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return treeMap;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return TreeMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return TreeMap.exportEntry(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> entry = this.getFirstEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> entry = this.getLastEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        return TreeMap.exportEntry(this.getLowerEntry(k));
    }

    @Override
    public K lowerKey(K k) {
        return TreeMap.keyOrNull(this.getLowerEntry(k));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        return TreeMap.exportEntry(this.getFloorEntry(k));
    }

    @Override
    public K floorKey(K k) {
        return TreeMap.keyOrNull(this.getFloorEntry(k));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        return TreeMap.exportEntry(this.getCeilingEntry(k));
    }

    @Override
    public K ceilingKey(K k) {
        return TreeMap.keyOrNull(this.getCeilingEntry(k));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        return TreeMap.exportEntry(this.getHigherEntry(k));
    }

    @Override
    public K higherKey(K k) {
        return TreeMap.keyOrNull(this.getHigherEntry(k));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet keySet;
        KeySet keySet2 = this.navigableKeySet;
        if (keySet2 != null) {
            keySet = keySet2;
        } else {
            KeySet keySet3 = new KeySet(this);
            keySet = keySet3;
            this.navigableKeySet = keySet3;
        }
        return keySet;
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        Collection collection2 = TreeMap._jr$ig$values(this);
        if (collection2 != null) {
            collection = collection2;
        } else {
            Values values = new Values(this);
            collection = values;
            TreeMap._jr$ip$values(this, values);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet;
        EntrySet entrySet2 = this.entrySet;
        if (entrySet2 != null) {
            entrySet = entrySet2;
        } else {
            EntrySet entrySet3 = new EntrySet(this);
            entrySet = entrySet3;
            this.entrySet = entrySet3;
        }
        return entrySet;
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        DescendingSubMap descendingSubMap;
        DescendingSubMap descendingSubMap2 = this.descendingMap;
        if (descendingSubMap2 != null) {
            descendingSubMap = descendingSubMap2;
        } else {
            DescendingSubMap descendingSubMap3 = new DescendingSubMap(this, true, null, true, true, null, true);
            descendingSubMap = descendingSubMap3;
            this.descendingMap = descendingSubMap3;
        }
        return descendingSubMap;
    }

    @Override
    public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        return new AscendingSubMap(this, false, k, bl, false, k2, bl2);
    }

    @Override
    public NavigableMap<K, V> headMap(K k, boolean bl) {
        return new AscendingSubMap(this, true, null, true, false, k, bl);
    }

    @Override
    public NavigableMap<K, V> tailMap(K k, boolean bl) {
        return new AscendingSubMap(this, false, k, bl, true, null, true);
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return this.subMap(k, true, k2, false);
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return this.headMap(k, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return this.tailMap(k, true);
    }

    Iterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)g.convertForCast((Object)object, Comparable.class)).compareTo(object2) : this.comparator.compare(object, object2);
    }

    static final boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry(entry);
    }

    static <K, V> K keyOrNull(Entry<K, V> entry) {
        return entry == null ? null : (K)entry.key;
    }

    static <K> K key(Entry<K, ?> entry) {
        if (entry == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }
        return entry.key;
    }

    final Entry<K, V> getFirstEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    final Entry<K, V> getLastEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && !f.ifAcmp(entry4, entry3.right)) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.left != null) {
            Entry entry2 = entry.left;
            while (entry2.right != null) {
                entry2 = entry2.right;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && !f.ifAcmp(entry4, entry3.left)) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static <K, V> boolean colorOf(Entry<K, V> entry) {
        return entry == null ? true : entry.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> entry) {
        return entry == null ? null : entry.parent;
    }

    private static <K, V> void setColor(Entry<K, V> entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> entry) {
        return entry == null ? null : entry.left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> entry) {
        return entry == null ? null : entry.right;
    }

    private void rotateLeft(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.right;
            entry.right = entry2.left;
            if (entry2.left != null) {
                entry2.left.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (!f.ifAcmp(entry.parent.left, entry)) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry2.left = entry;
            entry.parent = entry2;
        }
    }

    private void rotateRight(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.left;
            entry.left = entry2.right;
            if (entry2.right != null) {
                entry2.right.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (!f.ifAcmp(entry.parent.right, entry)) {
                entry.parent.right = entry2;
            } else {
                entry.parent.left = entry2;
            }
            entry2.right = entry;
            entry.parent = entry2;
        }
    }

    private void fixAfterInsertion(Entry<K, V> entry) {
        entry.color = false;
        while (entry != null && f.ifAcmp(entry, (Object)this.root) && !entry.parent.color) {
            Entry<K, V> entry2;
            if (!f.ifAcmp(TreeMap.parentOf(entry), TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry))))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (!f.ifAcmp(entry, TreeMap.rightOf(TreeMap.parentOf(entry)))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (!f.ifAcmp(entry, TreeMap.leftOf(TreeMap.parentOf(entry)))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        ((TreeMap)this).root.color = true;
    }

    private void deleteEntry(Entry<K, V> entry) {
        Entry<K, V> entry2;
        TreeMap treeMap = this;
        treeMap.modCount = treeMap.modCount + 1;
        TreeMap treeMap2 = this;
        treeMap2.size = treeMap2.size - 1;
        if (entry.left != null && entry.right != null) {
            entry2 = TreeMap.successor(entry);
            entry.key = entry2.key;
            entry.value = entry2.value;
            entry = entry2;
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (!f.ifAcmp(entry, entry.parent.left)) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (!f.ifAcmp(entry, entry.parent.left)) {
                    entry.parent.left = null;
                } else if (!f.ifAcmp(entry, entry.parent.right)) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> entry) {
        while (f.ifAcmp(entry, (Object)this.root) && TreeMap.colorOf(entry)) {
            Entry<K, V> entry2;
            if (!f.ifAcmp(entry, TreeMap.leftOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.buildFromSorted(n2, null, objectInputStream, null);
    }

    void readTreeSet(int n2, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n2, null, objectInputStream, v);
    }

    void addAllForTreeSet(SortedSet<? extends K> sortedSet, V v) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, v);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int n2, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.size = n2;
        this.root = this.buildFromSorted(0, 0, n2 - 1, TreeMap.computeRedLevel(n2), iterator, objectInputStream, v);
    }

    private final Entry<K, V> buildFromSorted(int n2, int n3, int n4, int n5, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        V v2;
        Object object;
        Map.Entry entry;
        if (n4 < n3) {
            return null;
        }
        int n6 = n3 + n4 >>> 1;
        Entry<K, V> entry2 = null;
        if (n3 < n6) {
            entry2 = this.buildFromSorted(n2 + 1, n3, n6 - 1, n5, iterator, objectInputStream, v);
        }
        if (iterator != null) {
            if (v == null) {
                entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                object = entry.getKey();
                v2 = entry.getValue();
            } else {
                object = iterator.next();
                v2 = v;
            }
        } else {
            object = objectInputStream.readObject();
            v2 = v != null ? v : objectInputStream.readObject();
        }
        entry = new Entry(object, v2, null);
        if (n2 == n5) {
            ((Entry)entry).color = false;
        }
        if (entry2 != null) {
            ((Entry)entry).left = entry2;
            entry2.parent = entry;
        }
        if (n6 < n4) {
            Entry<K, V> entry3 = this.buildFromSorted(n2 + 1, n6 + 1, n4, n5, iterator, objectInputStream, v);
            ((Entry)entry).right = entry3;
            entry3.parent = entry;
        }
        return entry;
    }

    private static int computeRedLevel(int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            ++n3;
            n4 = n4 / 2 - 1;
        }
        return n3;
    }

    private static /* synthetic */ void _jr$ip$comparator(TreeMap treeMap, Comparator comparator) {
        treeMap.comparator = comparator;
    }

    protected /* synthetic */ TreeMap(h h2) {
        super(h2);
    }

    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.inRange(k, bl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromKey out of range"));
            }
            if (!this.inRange(k2, bl2)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("toKey out of range"));
            }
            return new AscendingSubMap<K, V>(this.m, false, k, bl, false, k2, bl2);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("toKey out of range"));
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromKey out of range"));
            }
            return new AscendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap descendingSubMap = this.descendingMapView;
            return descendingSubMap != null ? descendingSubMap : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : new AscendingEntrySetView();
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subCeiling(K k) {
            return this.absCeiling(k);
        }

        @Override
        Entry<K, V> subHigher(K k) {
            return this.absHigher(k);
        }

        @Override
        Entry<K, V> subFloor(K k) {
            return this.absFloor(k);
        }

        @Override
        Entry<K, V> subLower(K k) {
            return this.absLower(k);
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
                super(AscendingSubMap.this);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }

            static /* synthetic */ AscendingSubMap _jr$ig$this$0(Object object) {
                return ((AscendingEntrySetView)object).AscendingSubMap.this;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, AscendingSubMap ascendingSubMap) {
                ((AscendingEntrySetView)object).AscendingSubMap.this = ascendingSubMap;
            }
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> entry) {
            super(TreeMap.this, entry);
        }

        public K next() {
            return this.prevEntry().key;
        }

        static /* synthetic */ TreeMap _jr$ig$this$0(Object object) {
            return ((DescendingKeyIterator)object).TreeMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((DescendingKeyIterator)object).TreeMap.this = treeMap;
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.inRange(k, bl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromKey out of range"));
            }
            if (!this.inRange(k2, bl2)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("toKey out of range"));
            }
            return new DescendingSubMap<K, V>(this.m, false, k2, bl2, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("toKey out of range"));
            }
            return new DescendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromKey out of range"));
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap ascendingSubMap = this.descendingMapView;
            return ascendingSubMap != null ? ascendingSubMap : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : new DescendingEntrySetView();
        }

        @Override
        Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        Entry<K, V> subCeiling(K k) {
            return this.absFloor(k);
        }

        @Override
        Entry<K, V> subHigher(K k) {
            return this.absLower(k);
        }

        @Override
        Entry<K, V> subFloor(K k) {
            return this.absCeiling(k);
        }

        @Override
        Entry<K, V> subLower(K k) {
            return this.absHigher(k);
        }

        private static /* synthetic */ Comparator _jr$ig$reverseComparator(DescendingSubMap descendingSubMap) {
            return descendingSubMap.reverseComparator;
        }

        private static /* synthetic */ void _jr$ip$reverseComparator(DescendingSubMap descendingSubMap, Comparator comparator) {
            descendingSubMap.reverseComparator = comparator;
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
                super(DescendingSubMap.this);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }

            static /* synthetic */ DescendingSubMap _jr$ig$this$0(Object object) {
                return ((DescendingEntrySetView)object).DescendingSubMap.this;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, DescendingSubMap descendingSubMap) {
                ((DescendingEntrySetView)object).DescendingSubMap.this = descendingSubMap;
            }
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static final class Entry
    extends h
    implements Map.Entry {
        K key;
        V value;
        Entry<K, V> left = null;
        Entry<K, V> right = null;
        Entry<K, V> parent;
        boolean color = true;

        Entry(K k, V v, Entry<K, V> entry) {
            this.key = k;
            this.value = v;
            this.parent = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            Object v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            return TreeMap.valEquals(this.key, entry.getKey()) && TreeMap.valEquals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            int n2 = this.key == null ? 0 : this.key.hashCode();
            int n3 = this.value == null ? 0 : this.value.hashCode();
            return n2 ^ n3;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        static /* synthetic */ void _jr$ip$key(Object object, Object object2) {
            ((Entry)object).key = object2;
        }

        static /* synthetic */ Object _jr$ig$value(Object object) {
            return ((Entry)object).value;
        }

        static /* synthetic */ void _jr$ip$value(Object object, Object object2) {
            ((Entry)object).value = object2;
        }

        static /* synthetic */ void _jr$ip$left(Object object, Entry entry) {
            ((Entry)object).left = entry;
        }

        static /* synthetic */ void _jr$ip$right(Object object, Entry entry) {
            ((Entry)object).right = entry;
        }

        static /* synthetic */ Entry _jr$ig$parent(Object object) {
            return ((Entry)object).parent;
        }

        static /* synthetic */ void _jr$ip$parent(Object object, Entry entry) {
            ((Entry)object).parent = entry;
        }

        static /* synthetic */ boolean _jr$ig$color(Object object) {
            return ((Entry)object).color;
        }

        static /* synthetic */ void _jr$ip$color(Object object, boolean bl) {
            ((Entry)object).color = bl;
        }
    }

    final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        EntryIterator(Entry<K, V> entry) {
            super(TreeMap.this, entry);
        }

        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        static /* synthetic */ TreeMap _jr$ig$this$0(Object object) {
            return ((EntryIterator)object).TreeMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((EntryIterator)object).TreeMap.this = treeMap;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ TreeMap this$0;

        EntrySet(TreeMap treeMap) {
            this.this$0 = treeMap;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ((EntrySet)this).this$0.new EntryIterator(((EntrySet)this).this$0.getFirstEntry());
        }

        @Override
        public boolean contains(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Object v = entry.getValue();
            Entry entry2 = ((EntrySet)this).this$0.getEntry(entry.getKey());
            return entry2 != null && TreeMap.valEquals(entry2.getValue(), v);
        }

        @Override
        public boolean remove(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Object v = entry.getValue();
            Entry entry2 = ((EntrySet)this).this$0.getEntry(entry.getKey());
            if (entry2 != null && TreeMap.valEquals(entry2.getValue(), v)) {
                ((EntrySet)this).this$0.deleteEntry(entry2);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return ((EntrySet)this).this$0.size();
        }

        @Override
        public void clear() {
            ((EntrySet)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((EntrySet)object).this$0 = treeMap;
        }

        protected /* synthetic */ EntrySet(h h2) {
            super(h2);
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(Entry<K, V> entry) {
            super(TreeMap.this, entry);
        }

        public K next() {
            return ((Entry)this.nextEntry()).key;
        }

        static /* synthetic */ TreeMap _jr$ig$this$0(Object object) {
            return ((KeyIterator)object).TreeMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((KeyIterator)object).TreeMap.this = treeMap;
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, Object> m;

        KeySet(NavigableMap<E, Object> navigableMap) {
            this.m = navigableMap;
        }

        @Override
        public Iterator<E> iterator() {
            if (g.convertForInstanceOf(this.m, TreeMap.class) instanceof TreeMap) {
                return ((TreeMap)g.convertForCast(this.m, TreeMap.class)).keyIterator();
            }
            return ((NavigableSubMap)g.convertForCast(this.m, NavigableSubMap.class)).keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (g.convertForInstanceOf(this.m, TreeMap.class) instanceof TreeMap) {
                return ((TreeMap)g.convertForCast(this.m, TreeMap.class)).descendingKeyIterator();
            }
            return ((NavigableSubMap)g.convertForCast(this.m, NavigableSubMap.class)).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e2) {
            return this.m.lowerKey(e2);
        }

        @Override
        public E floor(E e2) {
            return this.m.floorKey(e2);
        }

        @Override
        public E ceiling(E e2) {
            return this.m.ceilingKey(e2);
        }

        @Override
        public E higher(E e2) {
            return this.m.higherKey(e2);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> entry = this.m.pollFirstEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> entry = this.m.pollLastEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public boolean remove(Object object) {
            int n2 = this.size();
            this.m.remove(object);
            return this.size() != n2;
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl, E e3, boolean bl2) {
            return new KeySet<E>(this.m.subMap(e2, bl, e3, bl2));
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl) {
            return new KeySet<E>(this.m.headMap(e2, bl));
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl) {
            return new KeySet<E>(this.m.tailMap(e2, bl));
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return this.subSet(e2, true, e3, false);
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return this.headSet(e2, false);
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return this.tailSet(e2, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }

        private static /* synthetic */ NavigableMap _jr$ig$m(KeySet keySet) {
            return keySet.m;
        }

        private static /* synthetic */ void _jr$ip$m(KeySet keySet, NavigableMap navigableMap) {
            keySet.m = navigableMap;
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMap<K, V> descendingMapView;
        transient EntrySetView entrySetView;
        transient KeySet<K> navigableKeySetView;

        NavigableSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            this.descendingMapView = null;
            this.entrySetView = null;
            this.navigableKeySetView = null;
            if (!bl && !bl3) {
                if (treeMap.compare(k, k2) > 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fromKey > toKey"));
                }
            } else {
                if (!bl) {
                    treeMap.compare(k, k);
                }
                if (!bl3) {
                    treeMap.compare(k2, k2);
                }
            }
            this.m = treeMap;
            this.fromStart = bl;
            this.lo = k;
            this.loInclusive = bl2;
            this.toEnd = bl3;
            this.hi = k2;
            this.hiInclusive = bl4;
        }

        final boolean tooLow(Object object) {
            int n2;
            return !((NavigableSubMap)this).fromStart && ((n2 = ((NavigableSubMap)this).m.compare(object, ((NavigableSubMap)this).lo)) < 0 || n2 == 0 && !((NavigableSubMap)this).loInclusive);
        }

        final boolean tooHigh(Object object) {
            int n2;
            return !((NavigableSubMap)this).toEnd && ((n2 = ((NavigableSubMap)this).m.compare(object, ((NavigableSubMap)this).hi)) > 0 || n2 == 0 && !((NavigableSubMap)this).hiInclusive);
        }

        final boolean inRange(Object object) {
            return !this.tooLow(object) && !this.tooHigh(object);
        }

        final boolean inClosedRange(Object object) {
            return !(!((NavigableSubMap)this).fromStart && ((NavigableSubMap)this).m.compare(object, ((NavigableSubMap)this).lo) < 0 || !((NavigableSubMap)this).toEnd && ((NavigableSubMap)this).m.compare(((NavigableSubMap)this).hi, object) < 0);
        }

        final boolean inRange(Object object, boolean bl) {
            return bl ? this.inRange(object) : this.inClosedRange(object);
        }

        final Entry<K, V> absLowest() {
            Entry entry = ((NavigableSubMap)this).fromStart ? ((NavigableSubMap)this).m.getFirstEntry() : (((NavigableSubMap)this).loInclusive ? ((NavigableSubMap)this).m.getCeilingEntry(((NavigableSubMap)this).lo) : ((NavigableSubMap)this).m.getHigherEntry(((NavigableSubMap)this).lo));
            return entry == null || this.tooHigh(((Entry)entry).key) ? null : entry;
        }

        final Entry<K, V> absHighest() {
            Entry entry = ((NavigableSubMap)this).toEnd ? ((NavigableSubMap)this).m.getLastEntry() : (((NavigableSubMap)this).hiInclusive ? ((NavigableSubMap)this).m.getFloorEntry(((NavigableSubMap)this).hi) : ((NavigableSubMap)this).m.getLowerEntry(((NavigableSubMap)this).hi));
            return entry == null || this.tooLow(((Entry)entry).key) ? null : entry;
        }

        final Entry<K, V> absCeiling(K k) {
            if (this.tooLow(k)) {
                return this.absLowest();
            }
            Entry entry = ((NavigableSubMap)this).m.getCeilingEntry(k);
            return entry == null || this.tooHigh(((Entry)entry).key) ? null : entry;
        }

        final Entry<K, V> absHigher(K k) {
            if (this.tooLow(k)) {
                return this.absLowest();
            }
            Entry entry = ((NavigableSubMap)this).m.getHigherEntry(k);
            return entry == null || this.tooHigh(((Entry)entry).key) ? null : entry;
        }

        final Entry<K, V> absFloor(K k) {
            if (this.tooHigh(k)) {
                return this.absHighest();
            }
            Entry entry = ((NavigableSubMap)this).m.getFloorEntry(k);
            return entry == null || this.tooLow(((Entry)entry).key) ? null : entry;
        }

        final Entry<K, V> absLower(K k) {
            if (this.tooHigh(k)) {
                return this.absHighest();
            }
            Entry entry = ((NavigableSubMap)this).m.getLowerEntry(k);
            return entry == null || this.tooLow(((Entry)entry).key) ? null : entry;
        }

        final Entry<K, V> absHighFence() {
            return ((NavigableSubMap)this).toEnd ? null : (((NavigableSubMap)this).hiInclusive ? ((NavigableSubMap)this).m.getHigherEntry(((NavigableSubMap)this).hi) : ((NavigableSubMap)this).m.getCeilingEntry(((NavigableSubMap)this).hi));
        }

        final Entry<K, V> absLowFence() {
            return ((NavigableSubMap)this).fromStart ? null : (((NavigableSubMap)this).loInclusive ? ((NavigableSubMap)this).m.getLowerEntry(((NavigableSubMap)this).lo) : ((NavigableSubMap)this).m.getFloorEntry(((NavigableSubMap)this).lo));
        }

        abstract Entry<K, V> subLowest();

        abstract Entry<K, V> subHighest();

        abstract Entry<K, V> subCeiling(K var1);

        abstract Entry<K, V> subHigher(K var1);

        abstract Entry<K, V> subFloor(K var1);

        abstract Entry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Iterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return ((NavigableSubMap)this).fromStart && ((NavigableSubMap)this).toEnd ? ((NavigableSubMap)this).m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return ((NavigableSubMap)this).fromStart && ((NavigableSubMap)this).toEnd ? ((NavigableSubMap)this).m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.inRange(object) && ((NavigableSubMap)this).m.containsKey(object);
        }

        @Override
        public final V put(K k, V v) {
            if (!this.inRange(k)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("key out of range"));
            }
            return ((NavigableSubMap)this).m.put(k, v);
        }

        @Override
        public final V get(Object object) {
            return !this.inRange(object) ? null : (V)((NavigableSubMap)this).m.get(object);
        }

        @Override
        public final V remove(Object object) {
            return !this.inRange(object) ? null : (V)((NavigableSubMap)this).m.remove(object);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K k) {
            return TreeMap.exportEntry(this.subCeiling(k));
        }

        @Override
        public final K ceilingKey(K k) {
            return TreeMap.keyOrNull(this.subCeiling(k));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K k) {
            return TreeMap.exportEntry(this.subHigher(k));
        }

        @Override
        public final K higherKey(K k) {
            return TreeMap.keyOrNull(this.subHigher(k));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K k) {
            return TreeMap.exportEntry(this.subFloor(k));
        }

        @Override
        public final K floorKey(K k) {
            return TreeMap.keyOrNull(this.subFloor(k));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K k) {
            return TreeMap.exportEntry(this.subLower(k));
        }

        @Override
        public final K lowerKey(K k) {
            return TreeMap.keyOrNull(this.subLower(k));
        }

        @Override
        public final K firstKey() {
            return TreeMap.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return TreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return TreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return TreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Entry<K, V> entry = this.subLowest();
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            if (entry != null) {
                ((NavigableSubMap)this).m.deleteEntry(entry);
            }
            return entry2;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Entry<K, V> entry = this.subHighest();
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            if (entry != null) {
                ((NavigableSubMap)this).m.deleteEntry(entry);
            }
            return entry2;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet keySet;
            KeySet keySet2 = ((NavigableSubMap)this).navigableKeySetView;
            if (keySet2 != null) {
                keySet = keySet2;
            } else {
                KeySet keySet3 = new KeySet(this);
                keySet = keySet3;
                ((NavigableSubMap)this).navigableKeySetView = keySet3;
            }
            return keySet;
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K k, K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K k) {
            return this.headMap(k, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K k) {
            return this.tailMap(k, true);
        }

        static /* synthetic */ void _jr$ip$m(Object object, TreeMap treeMap) {
            ((NavigableSubMap)object).m = treeMap;
        }

        static /* synthetic */ void _jr$ip$lo(Object object, Object object2) {
            ((NavigableSubMap)object).lo = object2;
        }

        static /* synthetic */ void _jr$ip$hi(Object object, Object object2) {
            ((NavigableSubMap)object).hi = object2;
        }

        static /* synthetic */ void _jr$ip$fromStart(Object object, boolean bl) {
            ((NavigableSubMap)object).fromStart = bl;
        }

        static /* synthetic */ void _jr$ip$toEnd(Object object, boolean bl) {
            ((NavigableSubMap)object).toEnd = bl;
        }

        static /* synthetic */ void _jr$ip$loInclusive(Object object, boolean bl) {
            ((NavigableSubMap)object).loInclusive = bl;
        }

        static /* synthetic */ void _jr$ip$hiInclusive(Object object, boolean bl) {
            ((NavigableSubMap)object).hiInclusive = bl;
        }

        static /* synthetic */ NavigableMap _jr$ig$descendingMapView(Object object) {
            return ((NavigableSubMap)object).descendingMapView;
        }

        static /* synthetic */ void _jr$ip$descendingMapView(Object object, NavigableMap navigableMap) {
            ((NavigableSubMap)object).descendingMapView = navigableMap;
        }

        static /* synthetic */ EntrySetView _jr$ig$entrySetView(Object object) {
            return ((NavigableSubMap)object).entrySetView;
        }

        static /* synthetic */ void _jr$ip$entrySetView(Object object, EntrySetView entrySetView) {
            ((NavigableSubMap)object).entrySetView = entrySetView;
        }

        protected /* synthetic */ NavigableSubMap(h h2) {
            super(h2);
        }

        final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(NavigableSubMap.this, entry, entry2);
            }

            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }

            static /* synthetic */ NavigableSubMap _jr$ig$this$0(Object object) {
                return ((DescendingSubMapEntryIterator)object).NavigableSubMap.this;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NavigableSubMap navigableSubMap) {
                ((DescendingSubMapEntryIterator)object).NavigableSubMap.this = navigableSubMap;
            }
        }

        final class DescendingSubMapKeyIterator
        extends SubMapIterator<K> {
            DescendingSubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(NavigableSubMap.this, entry, entry2);
            }

            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }

            static /* synthetic */ NavigableSubMap _jr$ig$this$0(Object object) {
                return ((DescendingSubMapKeyIterator)object).NavigableSubMap.this;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NavigableSubMap navigableSubMap) {
                ((DescendingSubMapKeyIterator)object).NavigableSubMap.this = navigableSubMap;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size;
            private transient int sizeModCount;
            final /* synthetic */ NavigableSubMap this$0;

            EntrySetView(NavigableSubMap navigableSubMap) {
                this.this$0 = navigableSubMap;
                this.size = -1;
            }

            @Override
            public int size() {
                if (((NavigableSubMap)((EntrySetView)this).this$0).fromStart && ((NavigableSubMap)((EntrySetView)this).this$0).toEnd) {
                    return ((NavigableSubMap)((EntrySetView)this).this$0).m.size();
                }
                if (this.size == -1 || this.sizeModCount != ((NavigableSubMap)((EntrySetView)this).this$0).m.modCount) {
                    this.sizeModCount = ((NavigableSubMap)((EntrySetView)this).this$0).m.modCount;
                    this.size = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        EntrySetView entrySetView = this;
                        entrySetView.size = entrySetView.size + 1;
                        iterator.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                Entry entry = ((EntrySetView)this).this$0.absLowest();
                return entry == null || ((EntrySetView)this).this$0.tooHigh(((Entry)entry).key);
            }

            @Override
            public boolean contains(Object object) {
                if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
                Object k = entry.getKey();
                if (!((EntrySetView)this).this$0.inRange(k)) {
                    return false;
                }
                Entry entry2 = ((NavigableSubMap)((EntrySetView)this).this$0).m.getEntry(k);
                return entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
                Object k = entry.getKey();
                if (!((EntrySetView)this).this$0.inRange(k)) {
                    return false;
                }
                Entry entry2 = ((NavigableSubMap)((EntrySetView)this).this$0).m.getEntry(k);
                if (entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    ((NavigableSubMap)((EntrySetView)this).this$0).m.deleteEntry(entry2);
                    return true;
                }
                return false;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NavigableSubMap navigableSubMap) {
                ((EntrySetView)object).this$0 = navigableSubMap;
            }

            protected /* synthetic */ EntrySetView(h h2) {
                super(h2);
            }
        }

        final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(NavigableSubMap.this, entry, entry2);
            }

            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }

            static /* synthetic */ NavigableSubMap _jr$ig$this$0(Object object) {
                return ((SubMapEntryIterator)object).NavigableSubMap.this;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NavigableSubMap navigableSubMap) {
                ((SubMapEntryIterator)object).NavigableSubMap.this = navigableSubMap;
            }
        }

        /*
         * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
         */
        abstract class SubMapIterator
        extends h
        implements Iterator {
            Entry<K, V> lastReturned;
            Entry<K, V> next;
            final Object fenceKey;
            int expectedModCount;
            final /* synthetic */ NavigableSubMap this$0;

            SubMapIterator(NavigableSubMap navigableSubMap, Entry<K, V> entry, Entry<K, V> entry2) {
                this.this$0 = navigableSubMap;
                this.expectedModCount = ((NavigableSubMap)navigableSubMap).m.modCount;
                this.lastReturned = null;
                this.next = entry;
                this.fenceKey = entry2 == null ? UNBOUNDED : ((Entry)entry2).key;
            }

            @Override
            public final boolean hasNext() {
                return ((SubMapIterator)this).next != null && f.ifAcmp((Object)((Entry)((SubMapIterator)this).next).key, (Object)((SubMapIterator)this).fenceKey);
            }

            final Entry<K, V> nextEntry() {
                Entry entry = ((SubMapIterator)this).next;
                if (entry == null || !f.ifAcmp((Object)((Entry)entry).key, (Object)((SubMapIterator)this).fenceKey)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                }
                if (((NavigableSubMap)((SubMapIterator)this).this$0).m.modCount != ((SubMapIterator)this).expectedModCount) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                }
                ((SubMapIterator)this).next = TreeMap.successor(entry);
                ((SubMapIterator)this).lastReturned = entry;
                return entry;
            }

            final Entry<K, V> prevEntry() {
                Entry entry = ((SubMapIterator)this).next;
                if (entry == null || !f.ifAcmp((Object)((Entry)entry).key, (Object)((SubMapIterator)this).fenceKey)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                }
                if (((NavigableSubMap)((SubMapIterator)this).this$0).m.modCount != ((SubMapIterator)this).expectedModCount) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                }
                ((SubMapIterator)this).next = TreeMap.predecessor(entry);
                ((SubMapIterator)this).lastReturned = entry;
                return entry;
            }

            final void removeAscending() {
                if (((SubMapIterator)this).lastReturned == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
                }
                if (((NavigableSubMap)((SubMapIterator)this).this$0).m.modCount != ((SubMapIterator)this).expectedModCount) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                }
                if (((Entry)((SubMapIterator)this).lastReturned).left != null && ((Entry)((SubMapIterator)this).lastReturned).right != null) {
                    ((SubMapIterator)this).next = ((SubMapIterator)this).lastReturned;
                }
                ((NavigableSubMap)((SubMapIterator)this).this$0).m.deleteEntry(((SubMapIterator)this).lastReturned);
                ((SubMapIterator)this).lastReturned = null;
                ((SubMapIterator)this).expectedModCount = ((NavigableSubMap)((SubMapIterator)this).this$0).m.modCount;
            }

            final void removeDescending() {
                if (((SubMapIterator)this).lastReturned == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
                }
                if (((NavigableSubMap)((SubMapIterator)this).this$0).m.modCount != ((SubMapIterator)this).expectedModCount) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
                }
                ((NavigableSubMap)((SubMapIterator)this).this$0).m.deleteEntry(((SubMapIterator)this).lastReturned);
                ((SubMapIterator)this).lastReturned = null;
                ((SubMapIterator)this).expectedModCount = ((NavigableSubMap)((SubMapIterator)this).this$0).m.modCount;
            }

            static /* synthetic */ void _jr$ip$fenceKey(Object object, Object object2) {
                ((SubMapIterator)object).fenceKey = object2;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NavigableSubMap navigableSubMap) {
                ((SubMapIterator)object).this$0 = navigableSubMap;
            }

            protected /* synthetic */ SubMapIterator(h h2) {
                super(h2);
            }
        }

        final class SubMapKeyIterator
        extends SubMapIterator<K> {
            SubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(NavigableSubMap.this, entry, entry2);
            }

            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }

            static /* synthetic */ NavigableSubMap _jr$ig$this$0(Object object) {
                return ((SubMapKeyIterator)object).NavigableSubMap.this;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, NavigableSubMap navigableSubMap) {
                ((SubMapKeyIterator)object).NavigableSubMap.this = navigableSubMap;
            }
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    abstract class PrivateEntryIterator
    extends h
    implements Iterator {
        Entry<K, V> next;
        Entry<K, V> lastReturned;
        int expectedModCount;
        final /* synthetic */ TreeMap this$0;

        PrivateEntryIterator(TreeMap treeMap, Entry<K, V> entry) {
            this.this$0 = treeMap;
            this.expectedModCount = treeMap.modCount;
            this.lastReturned = null;
            this.next = entry;
        }

        @Override
        public final boolean hasNext() {
            return ((PrivateEntryIterator)this).next != null;
        }

        final Entry<K, V> nextEntry() {
            Entry entry = ((PrivateEntryIterator)this).next;
            if (entry == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            if (((PrivateEntryIterator)this).this$0.modCount != ((PrivateEntryIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            ((PrivateEntryIterator)this).next = TreeMap.successor(entry);
            ((PrivateEntryIterator)this).lastReturned = entry;
            return entry;
        }

        final Entry<K, V> prevEntry() {
            Entry entry = ((PrivateEntryIterator)this).next;
            if (entry == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            if (((PrivateEntryIterator)this).this$0.modCount != ((PrivateEntryIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            ((PrivateEntryIterator)this).next = TreeMap.predecessor(entry);
            ((PrivateEntryIterator)this).lastReturned = entry;
            return entry;
        }

        @Override
        public void remove() {
            if (((PrivateEntryIterator)this).lastReturned == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            if (((PrivateEntryIterator)this).this$0.modCount != ((PrivateEntryIterator)this).expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            if (((Entry)((PrivateEntryIterator)this).lastReturned).left != null && ((Entry)((PrivateEntryIterator)this).lastReturned).right != null) {
                ((PrivateEntryIterator)this).next = ((PrivateEntryIterator)this).lastReturned;
            }
            ((PrivateEntryIterator)this).this$0.deleteEntry(((PrivateEntryIterator)this).lastReturned);
            ((PrivateEntryIterator)this).expectedModCount = ((PrivateEntryIterator)this).this$0.modCount;
            ((PrivateEntryIterator)this).lastReturned = null;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((PrivateEntryIterator)object).this$0 = treeMap;
        }

        protected /* synthetic */ PrivateEntryIterator(h h2) {
            super(h2);
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart;
        private boolean toEnd;
        private K fromKey;
        private K toKey;
        final /* synthetic */ TreeMap this$0;

        private SubMap(TreeMap treeMap) {
            this.this$0 = treeMap;
            this.fromStart = false;
            this.toEnd = false;
        }

        private Object readResolve() {
            return new AscendingSubMap(((SubMap)this).this$0, this.fromStart, this.fromKey, true, this.toEnd, this.toKey, false);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        @Override
        public K lastKey() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        @Override
        public K firstKey() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        @Override
        public Comparator<? super K> comparator() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }

        private static /* synthetic */ void _jr$ip$fromStart(SubMap subMap, boolean bl) {
            subMap.fromStart = bl;
        }

        private static /* synthetic */ void _jr$ip$toEnd(SubMap subMap, boolean bl) {
            subMap.toEnd = bl;
        }

        private static /* synthetic */ void _jr$ip$fromKey(SubMap subMap, Object object) {
            subMap.fromKey = object;
        }

        private static /* synthetic */ void _jr$ip$toKey(SubMap subMap, Object object) {
            subMap.toKey = object;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((SubMap)object).this$0 = treeMap;
        }

        protected /* synthetic */ SubMap(h h2) {
            super(h2);
        }
    }

    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<K, V> entry) {
            super(TreeMap.this, entry);
        }

        public V next() {
            return this.nextEntry().value;
        }

        static /* synthetic */ TreeMap _jr$ig$this$0(Object object) {
            return ((ValueIterator)object).TreeMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((ValueIterator)object).TreeMap.this = treeMap;
        }
    }

    class Values
    extends AbstractCollection<V> {
        final /* synthetic */ TreeMap this$0;

        Values(TreeMap treeMap) {
            this.this$0 = treeMap;
        }

        @Override
        public Iterator<V> iterator() {
            return ((Values)this).this$0.new ValueIterator(((Values)this).this$0.getFirstEntry());
        }

        @Override
        public int size() {
            return ((Values)this).this$0.size();
        }

        @Override
        public boolean contains(Object object) {
            return ((Values)this).this$0.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Entry entry = ((Values)this).this$0.getFirstEntry();
            while (entry != null) {
                if (TreeMap.valEquals(entry.getValue(), object)) {
                    ((Values)this).this$0.deleteEntry(entry);
                    return true;
                }
                entry = TreeMap.successor(entry);
            }
            return false;
        }

        @Override
        public void clear() {
            ((Values)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, TreeMap treeMap) {
            ((Values)object).this$0 = treeMap;
        }

        protected /* synthetic */ Values(h h2) {
            super(h2);
        }
    }
}

