/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private transient NavigableMap<E, Object> m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    TreeSet(NavigableMap<E, Object> navigableMap) {
        this.m = navigableMap;
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(Comparator<? super E> comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new TreeSet(this.m.descendingMap());
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean add(E e2) {
        return this.m.put(e2, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return !f.ifAcmp(this.m.remove(object), (Object)PRESENT);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.m.size() == 0 && collection.size() > 0 && g.convertForInstanceOf(collection, SortedSet.class) instanceof SortedSet && g.convertForInstanceOf((Object)this.m, TreeMap.class) instanceof TreeMap) {
            Comparator comparator;
            SortedSet sortedSet = (SortedSet)g.convertForCast(collection, SortedSet.class);
            TreeMap treeMap = (TreeMap)g.convertForCast((Object)this.m, TreeMap.class);
            Comparator comparator2 = sortedSet.comparator();
            if (!f.ifAcmp(comparator2, comparator = treeMap.comparator()) || comparator2 != null && comparator2.equals(comparator)) {
                treeMap.addAllForTreeSet(sortedSet, PRESENT);
                return true;
            }
        }
        return super.addAll(collection);
    }

    @Override
    public NavigableSet<E> subSet(E e2, boolean bl, E e3, boolean bl2) {
        return new TreeSet<E>(this.m.subMap(e2, bl, e3, bl2));
    }

    @Override
    public NavigableSet<E> headSet(E e2, boolean bl) {
        return new TreeSet<E>(this.m.headMap(e2, bl));
    }

    @Override
    public NavigableSet<E> tailSet(E e2, boolean bl) {
        return new TreeSet<E>(this.m.tailMap(e2, bl));
    }

    @Override
    public SortedSet<E> subSet(E e2, E e3) {
        return this.subSet(e2, true, e3, false);
    }

    @Override
    public SortedSet<E> headSet(E e2) {
        return this.headSet(e2, false);
    }

    @Override
    public SortedSet<E> tailSet(E e2) {
        return this.tailSet(e2, true);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e2) {
        return this.m.lowerKey(e2);
    }

    @Override
    public E floor(E e2) {
        return this.m.floorKey(e2);
    }

    @Override
    public E ceiling(E e2) {
        return this.m.ceilingKey(e2);
    }

    @Override
    public E higher(E e2) {
        return this.m.higherKey(e2);
    }

    @Override
    public E pollFirst() {
        Map.Entry entry = this.m.pollFirstEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry entry = this.m.pollLastEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    public Object clone() {
        TreeSet treeSet = null;
        try {
            treeSet = (TreeSet)g.convertForCast((Object)super.clone(), TreeSet.class);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
        treeSet.m = new TreeMap(this.m);
        return treeSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        for (Object k : this.m.keySet()) {
            objectOutputStream.writeObject(k);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)g.convertForCast((Object)objectInputStream.readObject(), Comparator.class);
        TreeMap treeMap = comparator == null ? new TreeMap() : new TreeMap(comparator);
        this.m = treeMap;
        int n2 = objectInputStream.readInt();
        treeMap.readTreeSet(n2, objectInputStream, PRESENT);
    }

    protected /* synthetic */ TreeSet(h h2) {
        super(h2);
    }
}

