/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue;
    int modCount;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient boolean useAltHashing;
    final transient int hashSeed;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet;

    private Entry<K, V>[] newTable(int n) {
        return (Entry[])g.convertForCast((Object)new Entry[n], Entry[].class);
    }

    public WeakHashMap(int n, float f2) {
        int n2;
        this.queue = new ReferenceQueue();
        this.hashSeed = Hashing.randomHashSeed(this);
        this.entrySet = null;
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal Initial Capacity: " + n));
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal Load factor: " + f2));
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.table = this.newTable(n2);
        this.loadFactor = f2;
        this.threshold = (int)((float)n2 * f2);
        this.useAltHashing = VM.isBooted() && n2 >= Holder.ALTERNATIVE_HASHING_THRESHOLD;
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap() {
        this(16, 0.75f);
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return !f.ifAcmp((Object)object, (Object)NULL_KEY) ? null : object;
    }

    private static boolean eq(Object object, Object object2) {
        return !f.ifAcmp((Object)object, (Object)object2) || object.equals(object2);
    }

    int hash(Object object) {
        int n;
        if (((WeakHashMap)this).useAltHashing) {
            n = ((WeakHashMap)this).hashSeed;
            if (object instanceof String) {
                return Hashing.stringHash32((String)object);
            }
            n ^= object.hashCode();
        } else {
            n = object.hashCode();
        }
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.queue.poll()) != null) {
            Object object = ah.getMonitor((Object)((Object)this.queue));
            synchronized (object) {
                try {
                    Entry entry;
                    Entry entry2 = (Entry)g.convertForCast(reference, Entry.class);
                    int n = WeakHashMap.indexFor(((Entry)entry2).hash, a.arrayLength((Object[])((WeakHashMap)this).table));
                    Entry entry3 = entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])((WeakHashMap)this).table, (int)n), Entry.class);
                    while (entry3 != null) {
                        Entry entry4 = ((Entry)entry3).next;
                        if (!f.ifAcmp((Object)entry3, (Object)entry2)) {
                            if (!f.ifAcmp((Object)entry, (Object)entry2)) {
                                a.arrayStore((Object[])((WeakHashMap)this).table, (int)n, (Object)entry4);
                            } else {
                                ((Entry)entry).next = entry4;
                            }
                            ((Entry)entry2).value = null;
                            WeakHashMap weakHashMap = this;
                            weakHashMap.size = weakHashMap.size - 1;
                            break;
                        }
                        entry = entry3;
                        entry3 = entry4;
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return ((WeakHashMap)this).table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Object[] objectArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, a.arrayLength((Object[])objectArray));
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
        while (entry != null) {
            if (((Entry)entry).hash == n && WeakHashMap.eq(object2, entry.get())) {
                return (V)((Entry)entry).value;
            }
            entry = ((Entry)entry).next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    Entry<K, V> getEntry(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Object[] objectArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, a.arrayLength((Object[])objectArray));
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
        while (!(entry == null || ((Entry)entry).hash == n && WeakHashMap.eq(object2, entry.get()))) {
            entry = ((Entry)entry).next;
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        Object object = WeakHashMap.maskNull(k);
        int n = this.hash(object);
        Object[] objectArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, a.arrayLength((Object[])objectArray));
        Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
        while (entry != null) {
            if (n == ((Entry)entry).hash && WeakHashMap.eq(object, entry.get())) {
                Object object2 = ((Entry)entry).value;
                if (f.ifAcmp(v, (Object)object2)) {
                    ((Entry)entry).value = v;
                }
                return (V)object2;
            }
            entry = ((Entry)entry).next;
        }
        WeakHashMap weakHashMap = this;
        ((WeakHashMap)weakHashMap).modCount = ((WeakHashMap)weakHashMap).modCount + 1;
        entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
        a.arrayStore((Object[])objectArray, (int)n2, new Entry(object, v, this.queue, n, entry));
        WeakHashMap weakHashMap2 = this;
        int n3 = weakHashMap2.size + 1;
        weakHashMap2.size = n3;
        if (n3 >= this.threshold) {
            this.resize(a.arrayLength((Object[])objectArray) * 2);
        }
        return null;
    }

    void resize(int n) {
        Object[] objectArray = this.getTable();
        int n2 = a.arrayLength((Object[])objectArray);
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray = this.newTable(n);
        boolean bl = ((WeakHashMap)this).useAltHashing;
        WeakHashMap weakHashMap = this;
        ((WeakHashMap)weakHashMap).useAltHashing = ((WeakHashMap)weakHashMap).useAltHashing | (VM.isBooted() && n >= Holder.ALTERNATIVE_HASHING_THRESHOLD);
        boolean bl2 = bl ^ ((WeakHashMap)this).useAltHashing;
        this.transfer((Entry<K, V>[])objectArray, entryArray, bl2);
        ((WeakHashMap)this).table = entryArray;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray, (Entry<K, V>[])objectArray, false);
            ((WeakHashMap)this).table = (Entry[])objectArray;
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2, boolean bl) {
        for (int i = 0; i < a.arrayLength((Object[])entryArray); ++i) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])entryArray, (int)i), Entry.class);
            a.arrayStore((Object[])entryArray, (int)i, null);
            while (entry != null) {
                Entry entry2 = ((Entry)entry).next;
                Object t = entry.get();
                if (t == null) {
                    ((Entry)entry).next = null;
                    ((Entry)entry).value = null;
                    WeakHashMap weakHashMap = this;
                    weakHashMap.size = weakHashMap.size - 1;
                } else {
                    if (bl) {
                        ((Entry)entry).hash = this.hash(t);
                    }
                    int n = WeakHashMap.indexFor(((Entry)entry).hash, a.arrayLength((Object[])entryArray2));
                    ((Entry)entry).next = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])entryArray2, (int)n), Entry.class);
                    a.arrayStore((Object[])entryArray2, (int)n, (Object)entry);
                }
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = a.arrayLength((Object[])((WeakHashMap)this).table); n2 < n3; n2 <<= 1) {
            }
            if (n2 > a.arrayLength((Object[])((WeakHashMap)this).table)) {
                this.resize(n2);
            }
        }
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry entry;
        Object object2 = WeakHashMap.maskNull(object);
        int n = this.hash(object2);
        Object[] objectArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, a.arrayLength((Object[])objectArray));
        Entry entry2 = entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
        while (entry2 != null) {
            Entry entry3 = ((Entry)entry2).next;
            if (n == ((Entry)entry2).hash && WeakHashMap.eq(object2, entry2.get())) {
                WeakHashMap weakHashMap = this;
                ((WeakHashMap)weakHashMap).modCount = ((WeakHashMap)weakHashMap).modCount + 1;
                WeakHashMap weakHashMap2 = this;
                weakHashMap2.size = weakHashMap2.size - 1;
                if (!f.ifAcmp((Object)entry, (Object)entry2)) {
                    a.arrayStore((Object[])objectArray, (int)n2, (Object)entry3);
                } else {
                    ((Entry)entry).next = entry3;
                }
                return (V)((Entry)entry2).value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    boolean removeMapping(Object object) {
        Entry entry;
        if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
            return false;
        }
        Object[] objectArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n = this.hash(object2);
        int n2 = WeakHashMap.indexFor(n, a.arrayLength((Object[])objectArray));
        Entry entry3 = entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Entry.class);
        while (entry3 != null) {
            Entry entry4 = ((Entry)entry3).next;
            if (n == ((Entry)entry3).hash && entry3.equals(entry2)) {
                WeakHashMap weakHashMap = this;
                ((WeakHashMap)weakHashMap).modCount = ((WeakHashMap)weakHashMap).modCount + 1;
                WeakHashMap weakHashMap2 = this;
                weakHashMap2.size = weakHashMap2.size - 1;
                if (!f.ifAcmp((Object)entry, (Object)entry3)) {
                    a.arrayStore((Object[])objectArray, (int)n2, (Object)entry4);
                } else {
                    ((Entry)entry).next = entry4;
                }
                return true;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        WeakHashMap weakHashMap = this;
        ((WeakHashMap)weakHashMap).modCount = ((WeakHashMap)weakHashMap).modCount + 1;
        Arrays.fill(((WeakHashMap)this).table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Object[] objectArray = this.getTable();
        int n = a.arrayLength((Object[])objectArray);
        while (n-- > 0) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), Entry.class);
            while (entry != null) {
                if (object.equals(((Entry)entry).value)) {
                    return true;
                }
                entry = ((Entry)entry).next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Object[] objectArray = this.getTable();
        int n = a.arrayLength((Object[])objectArray);
        while (n-- > 0) {
            Entry entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), Entry.class);
            while (entry != null) {
                if (((Entry)entry).value == null) {
                    return true;
                }
                entry = ((Entry)entry).next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set;
        Set set2 = WeakHashMap._jr$ig$keySet(this);
        if (set2 != null) {
            set = set2;
        } else {
            KeySet keySet = new KeySet(this);
            set = keySet;
            WeakHashMap._jr$ip$keySet(this, keySet);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        Collection collection2 = WeakHashMap._jr$ig$values(this);
        if (collection2 != null) {
            collection = collection2;
        } else {
            Values values = new Values(this);
            collection = values;
            WeakHashMap._jr$ip$values(this, values);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set;
        Set set2 = this.entrySet;
        if (set2 != null) {
            set = set2;
        } else {
            EntrySet entrySet = new EntrySet(this);
            set = entrySet;
            this.entrySet = entrySet;
        }
        return set;
    }

    private static /* synthetic */ void _jr$ip$loadFactor(WeakHashMap weakHashMap, float f2) {
        weakHashMap.loadFactor = f2;
    }

    private static /* synthetic */ void _jr$ip$queue(WeakHashMap weakHashMap, ReferenceQueue referenceQueue) {
        weakHashMap.queue = referenceQueue;
    }

    static /* synthetic */ void _jr$ip$hashSeed(Object object, int n) {
        ((WeakHashMap)object).hashSeed = n;
    }

    protected /* synthetic */ WeakHashMap(h h2) {
        super(h2);
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        int hash;
        Entry<K, V> next;

        Entry(Object object, V v, ReferenceQueue<Object> referenceQueue, int n, Entry<K, V> entry) {
            super(object, referenceQueue);
            this.value = v;
            this.hash = n;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return (K)WeakHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return (V)((Entry)this).value;
        }

        @Override
        public V setValue(V v) {
            Object object = ((Entry)this).value;
            ((Entry)this).value = v;
            return (V)object;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            K k2 = this.getKey();
            return (!f.ifAcmp(k2, k = entry.getKey()) || k2 != null && k2.equals(k)) && (!f.ifAcmp(v2 = this.getValue(), v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        protected /* synthetic */ Entry(h h2) {
            super(h2);
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        final /* synthetic */ WeakHashMap this$0;

        private EntryIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            super(weakHashMap);
        }

        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        static /* synthetic */ WeakHashMap _jr$ig$this$0(Object object) {
            return ((EntryIterator)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((EntryIterator)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ EntryIterator(h h2) {
            super(h2);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ WeakHashMap this$0;

        private EntrySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(((EntrySet)this).this$0);
        }

        @Override
        public boolean contains(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Entry entry2 = ((EntrySet)this).this$0.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return ((EntrySet)this).this$0.removeMapping(object);
        }

        @Override
        public int size() {
            return ((EntrySet)this).this$0.size();
        }

        @Override
        public void clear() {
            ((EntrySet)this).this$0.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                arrayList.add(new AbstractMap.SimpleEntry(entry));
            }
            return arrayList;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.deepCopy().toArray(TArray);
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((EntrySet)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ EntrySet(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private abstract class HashIterator
    extends h
    implements Iterator {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;
        final /* synthetic */ WeakHashMap this$0;

        HashIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = ((WeakHashMap)this.this$0).modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = weakHashMap.isEmpty() ? 0 : a.arrayLength((Object[])((WeakHashMap)weakHashMap).table);
        }

        @Override
        public boolean hasNext() {
            Object[] objectArray = ((WeakHashMap)((HashIterator)this).this$0).table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n = this.index;
                while (entry == null && n > 0) {
                    entry = (Entry)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(--n)), Entry.class);
                }
                this.entry = entry;
                this.index = n;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = ((Entry)this.entry).next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (((WeakHashMap)((HashIterator)this).this$0).modCount != this.expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            this.lastReturned = this.entry;
            this.entry = ((Entry)this.entry).next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            if (((WeakHashMap)((HashIterator)this).this$0).modCount != this.expectedModCount) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
            ((HashIterator)this).this$0.remove(this.currentKey);
            this.expectedModCount = ((WeakHashMap)((HashIterator)this).this$0).modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((HashIterator)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ HashIterator(h h2) {
            super(h2);
        }
    }

    private static class Holder
    extends h {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int n;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n2 = n = f.ifAcmp(null, (Object)string) ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("value must be positive integer."));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException));
            }
            ALTERNATIVE_HASHING_THRESHOLD = n;
        }

        protected /* synthetic */ Holder(h h2) {
            super(h2);
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        final /* synthetic */ WeakHashMap this$0;

        private KeyIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            super(weakHashMap);
        }

        public K next() {
            return this.nextEntry().getKey();
        }

        static /* synthetic */ WeakHashMap _jr$ig$this$0(Object object) {
            return ((KeyIterator)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((KeyIterator)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ KeyIterator(h h2) {
            super(h2);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ WeakHashMap this$0;

        private KeySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(((KeySet)this).this$0);
        }

        @Override
        public int size() {
            return ((KeySet)this).this$0.size();
        }

        @Override
        public boolean contains(Object object) {
            return ((KeySet)this).this$0.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (((KeySet)this).this$0.containsKey(object)) {
                ((KeySet)this).this$0.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ((KeySet)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((KeySet)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ KeySet(h h2) {
            super(h2);
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        final /* synthetic */ WeakHashMap this$0;

        private ValueIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            super(weakHashMap);
        }

        public V next() {
            return ((Entry)this.nextEntry()).value;
        }

        static /* synthetic */ WeakHashMap _jr$ig$this$0(Object object) {
            return ((ValueIterator)object).this$0;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((ValueIterator)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ ValueIterator(h h2) {
            super(h2);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        final /* synthetic */ WeakHashMap this$0;

        private Values(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(((Values)this).this$0);
        }

        @Override
        public int size() {
            return ((Values)this).this$0.size();
        }

        @Override
        public boolean contains(Object object) {
            return ((Values)this).this$0.containsValue(object);
        }

        @Override
        public void clear() {
            ((Values)this).this$0.clear();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, WeakHashMap weakHashMap) {
            ((Values)object).this$0 = weakHashMap;
        }

        protected /* synthetic */ Values(h h2) {
            super(h2);
        }
    }
}

