/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Hashing;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MIN_SEGMENT_TABLE_CAPACITY = 2;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    private final transient int hashSeed;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    private static final Unsafe UNSAFE;
    private static final long SBASE;
    private static final int SSHIFT;
    private static final long TBASE;
    private static final int TSHIFT;
    private static final long HASHSEED_OFFSET;
    private static final long SEGSHIFT_OFFSET;
    private static final long SEGMASK_OFFSET;
    private static final long SEGMENTS_OFFSET;

    private static int randomHashSeed(ConcurrentHashMap concurrentHashMap) {
        if (VM.isBooted() && Holder.ALTERNATIVE_HASHING) {
            return Hashing.randomHashSeed(concurrentHashMap);
        }
        return 0;
    }

    static final <K, V> HashEntry<K, V> entryAt(HashEntry<K, V>[] hashEntryArray, int n2) {
        return hashEntryArray == null ? null : (HashEntry)((Object)UNSAFE.getObjectVolatile(hashEntryArray, ((long)n2 << TSHIFT) + TBASE));
    }

    static final <K, V> void setEntryAt(HashEntry<K, V>[] hashEntryArray, int n2, HashEntry<K, V> hashEntry) {
        UNSAFE.putOrderedObject(hashEntryArray, ((long)n2 << TSHIFT) + TBASE, hashEntry);
    }

    private int hash(Object object) {
        int n2 = this.hashSeed;
        if (0 != n2 && object instanceof String) {
            return Hashing.stringHash32((String)object);
        }
        n2 ^= object.hashCode();
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    static final <K, V> Segment<K, V> segmentAt(Segment<K, V>[] segmentArray, int n2) {
        long l2 = (long)(n2 << SSHIFT) + SBASE;
        return segmentArray == null ? null : (Segment)UNSAFE.getObjectVolatile(segmentArray, l2);
    }

    private Segment<K, V> ensureSegment(int n2) {
        Segment segment;
        block2: {
            long l2;
            Segment[] segmentArray = ((ConcurrentHashMap)this).segments;
            segment = (Segment)UNSAFE.getObjectVolatile(segmentArray, l2 = (long)(n2 << SSHIFT) + SBASE);
            if (segment != null) break block2;
            Segment segment2 = segmentArray[0];
            int n3 = segment2.table.length;
            float f2 = segment2.loadFactor;
            int n4 = (int)((float)n3 * f2);
            HashEntry[] hashEntryArray = new HashEntry[n3];
            segment = (Segment)UNSAFE.getObjectVolatile(segmentArray, l2);
            if (segment == null) {
                Segment segment3 = new Segment(f2, n4, hashEntryArray);
                while ((segment = (Segment)UNSAFE.getObjectVolatile(segmentArray, l2)) == null && !UNSAFE.compareAndSwapObject(segmentArray, l2, null, segment = segment3)) {
                }
            }
        }
        return segment;
    }

    private Segment<K, V> segmentForHash(int n2) {
        long l2 = (long)((n2 >>> ((ConcurrentHashMap)this).segmentShift & ((ConcurrentHashMap)this).segmentMask) << SSHIFT) + SBASE;
        return (Segment)UNSAFE.getObjectVolatile(((ConcurrentHashMap)this).segments, l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final <K, V> HashEntry<K, V> entryForHash(Segment<K, V> segment, int n2) {
        if (segment == null) return null;
        HashEntry<K, V>[] hashEntryArray = segment.table;
        if (segment.table == null) {
            return null;
        }
        HashEntry hashEntry = (HashEntry)((Object)UNSAFE.getObjectVolatile(hashEntryArray, ((long)(hashEntryArray.length - 1 & n2) << TSHIFT) + TBASE));
        return hashEntry;
    }

    public ConcurrentHashMap(int n2, float f2, int n3) {
        int n4;
        int n5;
        int n6;
        this.hashSeed = ConcurrentHashMap.randomHashSeed(this);
        if (!(f2 > 0.0f) || n2 < 0 || n3 <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n3 > 65536) {
            n3 = 65536;
        }
        int n7 = 0;
        for (n6 = 1; n6 < n3; n6 <<= 1) {
            ++n7;
        }
        this.segmentShift = 32 - n7;
        this.segmentMask = n6 - 1;
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if ((n5 = n2 / n6) * n6 < n2) {
            ++n5;
        }
        for (n4 = 2; n4 < n5; n4 <<= 1) {
        }
        Segment segment = new Segment(f2, (int)((float)n4 * f2), new HashEntry[n4]);
        Segment[] segmentArray = new Segment[n6];
        UNSAFE.putOrderedObject(segmentArray, SBASE, segment);
        this.segments = segmentArray;
    }

    public ConcurrentHashMap(int n2, float f2) {
        this(n2, f2, 16);
    }

    public ConcurrentHashMap(int n2) {
        this(n2, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        Segment<K, V> segment;
        int n2;
        long l2 = 0L;
        Segment[] segmentArray = ((ConcurrentHashMap)this).segments;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            segment = ConcurrentHashMap.segmentAt(segmentArray, n2);
            if (segment == null) continue;
            if (segment.count != 0) {
                return false;
            }
            l2 += (long)segment.modCount;
        }
        if (l2 != 0L) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segment = ConcurrentHashMap.segmentAt(segmentArray, n2);
                if (segment == null) continue;
                if (segment.count != 0) {
                    return false;
                }
                l2 -= (long)segment.modCount;
            }
            if (l2 != 0L) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int size() {
        boolean bl;
        int n2;
        block11: {
            int n3;
            Segment[] segmentArray = ((ConcurrentHashMap)this).segments;
            long l2 = 0L;
            int n4 = -1;
            try {
                while (true) {
                    if (n4++ == 2) {
                        for (n3 = 0; n3 < segmentArray.length; ++n3) {
                            this.ensureSegment(n3).lock();
                        }
                    }
                    long l3 = 0L;
                    n2 = 0;
                    bl = false;
                    for (n3 = 0; n3 < segmentArray.length; ++n3) {
                        Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, n3);
                        if (segment == null) continue;
                        l3 += (long)segment.modCount;
                        int n5 = segment.count;
                        if (n5 >= 0 && (n2 += n5) >= 0) continue;
                        bl = true;
                    }
                    if (l3 == l2) {
                        if (n4 > 2) {
                            break;
                        }
                        break block11;
                    }
                    l2 = l3;
                }
            }
            catch (Throwable throwable) {
                if (n4 <= 2) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                int n6 = 0;
                while (n6 < segmentArray.length) {
                    ConcurrentHashMap.segmentAt(segmentArray, n6).unlock();
                    ++n6;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            for (n3 = 0; n3 < segmentArray.length; ++n3) {
                ConcurrentHashMap.segmentAt(segmentArray, n3).unlock();
            }
        }
        if (bl) {
            return Integer.MAX_VALUE;
        }
        int n7 = n2;
        return n7;
    }

    @Override
    public V get(Object object) {
        int n2 = this.hash(object);
        long l2 = (long)((n2 >>> ((ConcurrentHashMap)this).segmentShift & ((ConcurrentHashMap)this).segmentMask) << SSHIFT) + SBASE;
        Segment segment = (Segment)UNSAFE.getObjectVolatile(((ConcurrentHashMap)this).segments, l2);
        if (segment != null) {
            HashEntry<K, V>[] hashEntryArray = segment.table;
            if (segment.table != null) {
                HashEntry hashEntry = (HashEntry)((Object)UNSAFE.getObjectVolatile(hashEntryArray, ((long)(hashEntryArray.length - 1 & n2) << TSHIFT) + TBASE));
                while (hashEntry != null) {
                    Object k = hashEntry.key;
                    if (!f.ifAcmp(k, (Object)object) || hashEntry.hash == n2 && object.equals(k)) {
                        return hashEntry.value;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        int n2 = this.hash(object);
        long l2 = (long)((n2 >>> ((ConcurrentHashMap)this).segmentShift & ((ConcurrentHashMap)this).segmentMask) << SSHIFT) + SBASE;
        Segment segment = (Segment)UNSAFE.getObjectVolatile(((ConcurrentHashMap)this).segments, l2);
        if (segment != null) {
            HashEntry<K, V>[] hashEntryArray = segment.table;
            if (segment.table != null) {
                HashEntry hashEntry = (HashEntry)((Object)UNSAFE.getObjectVolatile(hashEntryArray, ((long)(hashEntryArray.length - 1 & n2) << TSHIFT) + TBASE));
                while (hashEntry != null) {
                    Object k = hashEntry.key;
                    if (!f.ifAcmp(k, (Object)object) || hashEntry.hash == n2 && object.equals(k)) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Segment[] segmentArray = ((ConcurrentHashMap)this).segments;
        boolean bl = false;
        long l2 = 0L;
        int n2 = -1;
        try {
            block2: while (true) {
                if (n2++ == 2) {
                    for (int i = 0; i < segmentArray.length; ++i) {
                        this.ensureSegment(i).lock();
                    }
                }
                long l3 = 0L;
                int n3 = 0;
                for (int i = 0; i < segmentArray.length; ++i) {
                    Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, i);
                    if (segment == null) continue;
                    HashEntry<K, V>[] hashEntryArray = segment.table;
                    if (segment.table == null) continue;
                    for (int k = 0; k < hashEntryArray.length; ++k) {
                        HashEntry hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, k);
                        while (hashEntry != null) {
                            Object v = hashEntry.value;
                            if (v != null && object.equals(v)) {
                                bl = true;
                                break block2;
                            }
                            hashEntry = hashEntry.next;
                        }
                    }
                    n3 += segment.modCount;
                }
                if (n2 > 0 && (long)n3 == l2) break;
                l2 = n3;
            }
            if (n2 <= 2) return bl;
        }
        catch (Throwable throwable) {
            if (n2 <= 2) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            for (int i = 0; i < segmentArray.length; ++i) {
                ConcurrentHashMap.segmentAt(segmentArray, i).unlock();
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        for (int i = 0; i < segmentArray.length; ++i) {
            ConcurrentHashMap.segmentAt(segmentArray, i).unlock();
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n2 = this.hash(k);
        int n3 = n2 >>> ((ConcurrentHashMap)this).segmentShift & ((ConcurrentHashMap)this).segmentMask;
        Segment<K, V> segment = (Segment<K, V>)UNSAFE.getObject((Object)((ConcurrentHashMap)this).segments, (long)(n3 << SSHIFT) + SBASE);
        if (segment == null) {
            segment = this.ensureSegment(n3);
        }
        return segment.put(k, n2, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n2 = this.hash(k);
        int n3 = n2 >>> ((ConcurrentHashMap)this).segmentShift & ((ConcurrentHashMap)this).segmentMask;
        Segment<K, V> segment = (Segment<K, V>)UNSAFE.getObject((Object)((ConcurrentHashMap)this).segments, (long)(n3 << SSHIFT) + SBASE);
        if (segment == null) {
            segment = this.ensureSegment(n3);
        }
        return segment.put(k, n2, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n2 = this.hash(object);
        Segment<K, V> segment = this.segmentForHash(n2);
        return segment == null ? null : (V)segment.remove(object, n2, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Segment<K, V> segment;
        int n2 = this.hash(object);
        return object2 != null && (segment = this.segmentForHash(n2)) != null && segment.remove(object, n2, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        int n2 = this.hash(k);
        if (v == null || v2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Segment<K, V> segment = this.segmentForHash(n2);
        return segment != null && segment.replace(k, n2, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        int n2 = this.hash(k);
        if (v == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Segment<K, V> segment = this.segmentForHash(n2);
        return segment == null ? null : (V)segment.replace(k, n2, v);
    }

    @Override
    public void clear() {
        Segment[] segmentArray = ((ConcurrentHashMap)this).segments;
        for (int i = 0; i < segmentArray.length; ++i) {
            Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, i);
            if (segment == null) continue;
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        Set set;
        Set set2 = ((ConcurrentHashMap)this).keySet;
        if (set2 != null) {
            set = set2;
        } else {
            KeySet keySet = new KeySet();
            set = keySet;
            ((ConcurrentHashMap)this).keySet = keySet;
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        Collection collection2 = ((ConcurrentHashMap)this).values;
        if (collection2 != null) {
            collection = collection2;
        } else {
            Values values = new Values();
            collection = values;
            ((ConcurrentHashMap)this).values = values;
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set;
        Set set2 = ((ConcurrentHashMap)this).entrySet;
        if (set2 != null) {
            set = set2;
        } else {
            EntrySet entrySet = new EntrySet();
            set = entrySet;
            ((ConcurrentHashMap)this).entrySet = entrySet;
        }
        return set;
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        for (int i = 0; i < ((ConcurrentHashMap)this).segments.length; ++i) {
            this.ensureSegment(i);
        }
        objectOutputStream.defaultWriteObject();
        Segment[] segmentArray = ((ConcurrentHashMap)this).segments;
        for (int i = 0; i < segmentArray.length; ++i) {
            Segment<K, V> segment = ConcurrentHashMap.segmentAt(segmentArray, i);
            segment.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = segment.table;
                for (int k = 0; k < hashEntryArray.length; ++k) {
                    HashEntry hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, k);
                    while (hashEntry != null) {
                        objectOutputStream.writeObject(hashEntry.key);
                        objectOutputStream.writeObject(hashEntry.value);
                        hashEntry = hashEntry.next;
                    }
                }
            }
            catch (Throwable throwable) {
                segment.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            segment.unlock();
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Segment[] segmentArray = (Segment[])getField.get("segments", null);
        int n2 = segmentArray.length;
        if (n2 < 1 || n2 > 65536 || (n2 & n2 - 1) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidObjectException("Bad number of segments:" + n2));
        }
        int n3 = 0;
        for (int i = n2; i > 1; i >>>= 1) {
            ++n3;
        }
        UNSAFE.putIntVolatile(this, SEGSHIFT_OFFSET, 32 - n3);
        UNSAFE.putIntVolatile(this, SEGMASK_OFFSET, n2 - 1);
        UNSAFE.putObjectVolatile(this, SEGMENTS_OFFSET, segmentArray);
        UNSAFE.putIntVolatile(this, HASHSEED_OFFSET, ConcurrentHashMap.randomHashSeed(this));
        int n4 = 2;
        Segment[] segmentArray2 = ((ConcurrentHashMap)this).segments;
        for (int i = 0; i < segmentArray2.length; ++i) {
            object = segmentArray2[i];
            if (object == null) continue;
            ((Segment)object).threshold = (int)((float)n4 * ((Segment)object).loadFactor);
            ((Segment)object).table = new HashEntry[n4];
        }
        while (true) {
            Object object2 = objectInputStream.readObject();
            object = objectInputStream.readObject();
            if (object2 == null) break;
            this.put(object2, object);
        }
    }

    static {
        int n2;
        int n3;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<HashEntry[]> clazz = HashEntry[].class;
            Class<Segment[]> clazz2 = Segment[].class;
            TBASE = UNSAFE.arrayBaseOffset(clazz);
            SBASE = UNSAFE.arrayBaseOffset(clazz2);
            n3 = UNSAFE.arrayIndexScale(clazz);
            n2 = UNSAFE.arrayIndexScale(clazz2);
            HASHSEED_OFFSET = UNSAFE.objectFieldOffset(ai.getCurrentClass(ConcurrentHashMap.class).getDeclaredField("hashSeed"));
            SEGSHIFT_OFFSET = UNSAFE.objectFieldOffset(ai.getCurrentClass(ConcurrentHashMap.class).getDeclaredField("segmentShift"));
            SEGMASK_OFFSET = UNSAFE.objectFieldOffset(ai.getCurrentClass(ConcurrentHashMap.class).getDeclaredField("segmentMask"));
            SEGMENTS_OFFSET = UNSAFE.objectFieldOffset(ai.getCurrentClass(ConcurrentHashMap.class).getDeclaredField("segments"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
        if ((n2 & n2 - 1) != 0 || (n3 & n3 - 1) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("data type scale not a power of two"));
        }
        SSHIFT = 31 - Integer.numberOfLeadingZeros(n2);
        TSHIFT = 31 - Integer.numberOfLeadingZeros(n3);
    }

    private static /* synthetic */ void _jr$ip$hashSeed(ConcurrentHashMap concurrentHashMap, int n2) {
        concurrentHashMap.hashSeed = n2;
    }

    static /* synthetic */ void _jr$ip$segmentMask(Object object, int n2) {
        ((ConcurrentHashMap)object).segmentMask = n2;
    }

    static /* synthetic */ void _jr$ip$segmentShift(Object object, int n2) {
        ((ConcurrentHashMap)object).segmentShift = n2;
    }

    static /* synthetic */ void _jr$ip$segments(Object object, Segment[] segmentArray) {
        ((ConcurrentHashMap)object).segments = segmentArray;
    }

    protected /* synthetic */ ConcurrentHashMap(h h2) {
        super(h2);
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
            super(ConcurrentHashMap.this);
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key, hashEntry.value);
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((EntryIterator)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((EntryIterator)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            Object v = ConcurrentHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(g.convertForInstanceOf((Object)object, Map.Entry.class) instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)g.convertForCast((Object)object, Map.Entry.class);
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((EntrySet)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((EntrySet)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static final class HashEntry
    extends h {
        final int hash;
        final K key;
        volatile V value;
        volatile HashEntry<K, V> next;
        static final Unsafe UNSAFE;
        static final long nextOffset;

        HashEntry(int n2, K k, V v, HashEntry<K, V> hashEntry) {
            this.hash = n2;
            this.key = k;
            this.value = v;
            this.next = hashEntry;
        }

        final void setNext(HashEntry<K, V> hashEntry) {
            UNSAFE.putOrderedObject((Object)this, nextOffset, (Object)hashEntry);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<HashEntry> clazz = HashEntry.class;
                nextOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("next"));
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
            }
        }

        static /* synthetic */ int _jr$ig$hash(Object object) {
            return ((HashEntry)((Object)object)).hash;
        }

        static /* synthetic */ void _jr$ip$hash(Object object, int n2) {
            ((HashEntry)((Object)object)).hash = n2;
        }

        static /* synthetic */ Object _jr$ig$key(Object object) {
            return ((HashEntry)((Object)object)).key;
        }

        static /* synthetic */ void _jr$ip$key(Object object, Object object2) {
            ((HashEntry)((Object)object)).key = object2;
        }

        static /* synthetic */ Object _jr$ig$value(Object object) {
            return ((HashEntry)((Object)object)).value;
        }

        static /* synthetic */ void _jr$ip$value(Object object, Object object2) {
            ((HashEntry)((Object)object)).value = object2;
        }

        static /* synthetic */ HashEntry _jr$ig$next(Object object) {
            return ((HashEntry)((Object)object)).next;
        }

        static /* synthetic */ void _jr$ip$next(Object object, HashEntry hashEntry) {
            ((HashEntry)((Object)object)).next = hashEntry;
        }
    }

    abstract class HashIterator
    extends h {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        final /* synthetic */ ConcurrentHashMap this$0;

        HashIterator(ConcurrentHashMap concurrentHashMap) {
            this.this$0 = concurrentHashMap;
            this.nextSegmentIndex = ((ConcurrentHashMap)concurrentHashMap).segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            while (true) {
                if (((HashIterator)((Object)((Object)this))).nextTableIndex >= 0) {
                    HashEntry[] hashEntryArray = ((HashIterator)((Object)((Object)this))).currentTable;
                    HashIterator hashIterator = this;
                    int n2 = ((HashIterator)((Object)((Object)hashIterator))).nextTableIndex;
                    ((HashIterator)((Object)((Object)hashIterator))).nextTableIndex = n2 - 1;
                    HashEntry hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, n2);
                    ((HashIterator)((Object)((Object)this))).nextEntry = hashEntry;
                    if (hashEntry == null) continue;
                    break;
                }
                if (((HashIterator)((Object)((Object)this))).nextSegmentIndex < 0) break;
                Segment[] segmentArray = ((ConcurrentHashMap)((HashIterator)((Object)((Object)this))).this$0).segments;
                HashIterator hashIterator = this;
                int n3 = ((HashIterator)((Object)((Object)hashIterator))).nextSegmentIndex;
                ((HashIterator)((Object)((Object)hashIterator))).nextSegmentIndex = n3 - 1;
                Segment segment = ConcurrentHashMap.segmentAt(segmentArray, n3);
                if (segment == null) continue;
                ((HashIterator)((Object)((Object)this))).currentTable = segment.table;
                if (segment.table == null) continue;
                ((HashIterator)((Object)((Object)this))).nextTableIndex = ((HashIterator)((Object)((Object)this))).currentTable.length - 1;
            }
        }

        final HashEntry<K, V> nextEntry() {
            HashEntry hashEntry = ((HashIterator)((Object)((Object)this))).nextEntry;
            if (hashEntry == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            ((HashIterator)((Object)((Object)this))).lastReturned = hashEntry;
            HashEntry hashEntry2 = hashEntry.next;
            ((HashIterator)((Object)((Object)this))).nextEntry = hashEntry2;
            if (hashEntry2 == null) {
                this.advance();
            }
            return hashEntry;
        }

        public final boolean hasNext() {
            return ((HashIterator)((Object)((Object)this))).nextEntry != null;
        }

        public final boolean hasMoreElements() {
            return ((HashIterator)((Object)((Object)this))).nextEntry != null;
        }

        public final void remove() {
            if (((HashIterator)((Object)((Object)this))).lastReturned == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            ((HashIterator)((Object)((Object)this))).this$0.remove(((HashIterator)((Object)((Object)((Object)this)))).lastReturned.key);
            ((HashIterator)((Object)((Object)this))).lastReturned = null;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((HashIterator)((Object)object)).this$0 = concurrentHashMap;
        }

        protected /* synthetic */ HashIterator(h h2) {
            super(h2);
        }
    }

    private static class Holder
    extends h {
        static final boolean ALTERNATIVE_HASHING;

        private Holder() {
        }

        static {
            int n2;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n3 = n2 = f.ifAcmp(null, (Object)string) ? Integer.parseInt(string) : Integer.MAX_VALUE;
                if (n2 == -1) {
                    n2 = Integer.MAX_VALUE;
                }
                if (n2 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("value must be positive integer."));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Illegal value for 'jdk.map.althashing.threshold'", illegalArgumentException));
            }
            ALTERNATIVE_HASHING = n2 <= 0x40000000;
        }

        protected /* synthetic */ Holder(h h2) {
            super(h2);
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
            super(ConcurrentHashMap.this);
        }

        @Override
        public final K next() {
            return super.nextEntry().key;
        }

        @Override
        public final K nextElement() {
            return super.nextEntry().key;
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((KeyIterator)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((KeyIterator)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((KeySet)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((KeySet)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        static final int MAX_SCAN_RETRIES = Runtime.getRuntime().availableProcessors() > 1 ? 64 : 1;
        volatile transient HashEntry<K, V>[] table;
        transient int count;
        transient int modCount;
        transient int threshold;
        final float loadFactor;

        Segment(float f2, int n2, HashEntry<K, V>[] hashEntryArray) {
            this.loadFactor = f2;
            this.threshold = n2;
            this.table = hashEntryArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V put(K k, int n2, V v, boolean bl) {
            Object v2;
            block9: {
                HashEntry hashEntry = this.tryLock() ? null : this.scanAndLockForPut(k, n2, v);
                try {
                    HashEntry<K, V> hashEntry2;
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    int n3 = hashEntryArray.length - 1 & n2;
                    HashEntry<K, V> hashEntry3 = hashEntry2 = ConcurrentHashMap.entryAt(hashEntryArray, n3);
                    while (hashEntry3 != null) {
                        Object k2 = hashEntry3.key;
                        if (!f.ifAcmp(k2, k) || hashEntry3.hash == n2 && k.equals(k2)) {
                            v2 = hashEntry3.value;
                            if (!bl) {
                                hashEntry3.value = v;
                                ++this.modCount;
                            }
                            break block9;
                        }
                        hashEntry3 = hashEntry3.next;
                    }
                    if (hashEntry != null) {
                        hashEntry.setNext(hashEntry2);
                    } else {
                        hashEntry = new HashEntry(n2, k, v, hashEntry2);
                    }
                    int n4 = this.count + 1;
                    if (n4 > this.threshold && hashEntryArray.length < 0x40000000) {
                        this.rehash(hashEntry);
                    } else {
                        ConcurrentHashMap.setEntryAt(hashEntryArray, n3, hashEntry);
                    }
                    ++this.modCount;
                    this.count = n4;
                    v2 = null;
                }
                catch (Throwable throwable) {
                    this.unlock();
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            this.unlock();
            return v2;
        }

        private void rehash(HashEntry<K, V> hashEntry) {
            int n2;
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n3 = hashEntryArray.length;
            int n4 = n3 << 1;
            this.threshold = (int)((float)n4 * this.loadFactor);
            HashEntry[] hashEntryArray2 = new HashEntry[n4];
            int n5 = n4 - 1;
            for (n2 = 0; n2 < n3; ++n2) {
                HashEntry<K, V> hashEntry2 = hashEntryArray[n2];
                if (hashEntry2 == null) continue;
                HashEntry hashEntry3 = hashEntry2.next;
                int n6 = hashEntry2.hash & n5;
                if (hashEntry3 == null) {
                    hashEntryArray2[n6] = hashEntry2;
                    continue;
                }
                HashEntry<K, V> hashEntry4 = hashEntry2;
                int n7 = n6;
                HashEntry hashEntry5 = hashEntry3;
                while (hashEntry5 != null) {
                    int n8 = hashEntry5.hash & n5;
                    if (n8 != n7) {
                        n7 = n8;
                        hashEntry4 = hashEntry5;
                    }
                    hashEntry5 = hashEntry5.next;
                }
                hashEntryArray2[n7] = hashEntry4;
                hashEntry5 = hashEntry2;
                while (f.ifAcmp(hashEntry5, hashEntry4)) {
                    Object v = hashEntry5.value;
                    int n9 = hashEntry5.hash;
                    int n10 = n9 & n5;
                    HashEntry hashEntry6 = hashEntryArray2[n10];
                    hashEntryArray2[n10] = new HashEntry(n9, hashEntry5.key, v, hashEntry6);
                    hashEntry5 = hashEntry5.next;
                }
            }
            n2 = hashEntry.hash & n5;
            hashEntry.setNext(hashEntryArray2[n2]);
            hashEntryArray2[n2] = hashEntry;
            this.table = hashEntryArray2;
        }

        private HashEntry<K, V> scanAndLockForPut(K k, int n2, V v) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntry = ConcurrentHashMap.entryForHash(this, n2);
            HashEntry hashEntry3 = null;
            int n3 = -1;
            while (!this.tryLock()) {
                HashEntry hashEntry4;
                if (n3 < 0) {
                    if (hashEntry2 == null) {
                        if (hashEntry3 == null) {
                            hashEntry3 = new HashEntry(n2, k, v, null);
                        }
                        n3 = 0;
                        continue;
                    }
                    if (k.equals(hashEntry2.key)) {
                        n3 = 0;
                        continue;
                    }
                    hashEntry2 = hashEntry2.next;
                    continue;
                }
                if (++n3 > MAX_SCAN_RETRIES) {
                    this.lock();
                    break;
                }
                if ((n3 & 1) != 0 || !f.ifAcmp(hashEntry4 = ConcurrentHashMap.entryForHash(this, n2), hashEntry)) continue;
                hashEntry2 = hashEntry = hashEntry4;
                n3 = -1;
            }
            return hashEntry3;
        }

        private void scanAndLock(Object object, int n2) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntry = ConcurrentHashMap.entryForHash(this, n2);
            int n3 = -1;
            while (!this.tryLock()) {
                HashEntry hashEntry3;
                if (n3 < 0) {
                    if (hashEntry2 == null || object.equals(hashEntry2.key)) {
                        n3 = 0;
                        continue;
                    }
                    hashEntry2 = hashEntry2.next;
                    continue;
                }
                if (++n3 > MAX_SCAN_RETRIES) {
                    this.lock();
                    break;
                }
                if ((n3 & 1) != 0 || !f.ifAcmp(hashEntry3 = ConcurrentHashMap.entryForHash(this, n2), hashEntry)) continue;
                hashEntry2 = hashEntry = hashEntry3;
                n3 = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final V remove(Object object, int n2, Object object2) {
            if (!this.tryLock()) {
                this.scanAndLock(object, n2);
            }
            V v = null;
            try {
                HashEntry<K, V>[] hashEntryArray = this.table;
                int n3 = hashEntryArray.length - 1 & n2;
                HashEntry<K, V> hashEntry = ConcurrentHashMap.entryAt(hashEntryArray, n3);
                HashEntry<K, V> hashEntry2 = null;
                while (hashEntry != null) {
                    HashEntry hashEntry3 = hashEntry.next;
                    Object k = hashEntry.key;
                    if (!f.ifAcmp(k, (Object)object) || hashEntry.hash == n2 && object.equals(k)) {
                        Object v2 = hashEntry.value;
                        if (object2 == null || !f.ifAcmp((Object)object2, v2) || object2.equals(v2)) {
                            if (hashEntry2 == null) {
                                ConcurrentHashMap.setEntryAt(hashEntryArray, n3, hashEntry3);
                            } else {
                                hashEntry2.setNext(hashEntry3);
                            }
                            ++this.modCount;
                            --this.count;
                            v = v2;
                        }
                        break;
                    }
                    hashEntry2 = hashEntry;
                    hashEntry = hashEntry3;
                }
            }
            catch (Throwable throwable) {
                this.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            this.unlock();
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final boolean replace(K k, int n2, V v, V v2) {
            if (!this.tryLock()) {
                this.scanAndLock(k, n2);
            }
            boolean bl = false;
            try {
                HashEntry hashEntry = ConcurrentHashMap.entryForHash(this, n2);
                while (hashEntry != null) {
                    Object k2 = hashEntry.key;
                    if (!f.ifAcmp(k2, k) || hashEntry.hash == n2 && k.equals(k2)) {
                        if (v.equals(hashEntry.value)) {
                            hashEntry.value = v2;
                            ++this.modCount;
                            bl = true;
                        }
                        break;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            catch (Throwable throwable) {
                this.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            this.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final V replace(K k, int n2, V v) {
            if (!this.tryLock()) {
                this.scanAndLock(k, n2);
            }
            V v2 = null;
            try {
                HashEntry hashEntry = ConcurrentHashMap.entryForHash(this, n2);
                while (hashEntry != null) {
                    Object k2 = hashEntry.key;
                    if (!f.ifAcmp(k2, k) || hashEntry.hash == n2 && k.equals(k2)) {
                        v2 = hashEntry.value;
                        hashEntry.value = v;
                        ++this.modCount;
                        break;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            catch (Throwable throwable) {
                this.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            this.unlock();
            return v2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clear() {
            this.lock();
            try {
                HashEntry<K, V>[] hashEntryArray = this.table;
                for (int i = 0; i < hashEntryArray.length; ++i) {
                    ConcurrentHashMap.setEntryAt(hashEntryArray, i, null);
                }
                ++this.modCount;
                this.count = 0;
            }
            catch (Throwable throwable) {
                this.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            this.unlock();
        }

        static /* synthetic */ HashEntry[] _jr$ig$table(Object object) {
            return ((Segment)object).table;
        }

        static /* synthetic */ void _jr$ip$table(Object object, HashEntry[] hashEntryArray) {
            ((Segment)object).table = hashEntryArray;
        }

        static /* synthetic */ int _jr$ig$count(Object object) {
            return ((Segment)object).count;
        }

        static /* synthetic */ void _jr$ip$count(Object object, int n2) {
            ((Segment)object).count = n2;
        }

        static /* synthetic */ int _jr$ig$modCount(Object object) {
            return ((Segment)object).modCount;
        }

        static /* synthetic */ void _jr$ip$modCount(Object object, int n2) {
            ((Segment)object).modCount = n2;
        }

        static /* synthetic */ int _jr$ig$threshold(Object object) {
            return ((Segment)object).threshold;
        }

        static /* synthetic */ void _jr$ip$threshold(Object object, int n2) {
            ((Segment)object).threshold = n2;
        }

        static /* synthetic */ float _jr$ig$loadFactor(Object object) {
            return ((Segment)object).loadFactor;
        }

        static /* synthetic */ void _jr$ip$loadFactor(Object object, float f2) {
            ((Segment)object).loadFactor = f2;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
            super(ConcurrentHashMap.this);
        }

        @Override
        public final V next() {
            return super.nextEntry().value;
        }

        @Override
        public final V nextElement() {
            return super.nextEntry().value;
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((ValueIterator)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((ValueIterator)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((Values)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((Values)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            Object v2 = super.setValue(v);
            ConcurrentHashMap.this.put(this.getKey(), v);
            return v2;
        }

        static /* synthetic */ ConcurrentHashMap _jr$ig$this$0(Object object) {
            return ((WriteThroughEntry)object).ConcurrentHashMap.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentHashMap concurrentHashMap) {
            ((WriteThroughEntry)object).ConcurrentHashMap.this = concurrentHashMap;
        }
    }
}

