/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import sun.misc.Unsafe;

public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    public ConcurrentLinkedQueue() {
        this.head = this.tail = new Node(null);
    }

    public ConcurrentLinkedQueue(Collection<? extends E> collection) {
        Node node = null;
        Node node2 = null;
        for (E e2 : collection) {
            ConcurrentLinkedQueue.checkNotNull(e2);
            Node node3 = new Node(e2);
            if (node == null) {
                node = node2 = node3;
                continue;
            }
            node2.lazySetNext(node3);
            node2 = node3;
        }
        if (node == null) {
            node = node2 = new Node(null);
        }
        this.head = node;
        this.tail = node2;
    }

    @Override
    public boolean add(E e2) {
        return this.offer(e2);
    }

    final void updateHead(Node<E> node, Node<E> node2) {
        if (f.ifAcmp(node, node2) && this.casHead(node, node2)) {
            node.lazySetNext(node);
        }
    }

    final Node<E> succ(Node<E> node) {
        Node node2 = ((Node)((Object)node)).next;
        return !f.ifAcmp(node, (Object)((Object)node2)) ? this.head : node2;
    }

    @Override
    public boolean offer(E e2) {
        Node node;
        ConcurrentLinkedQueue.checkNotNull(e2);
        Node node2 = new Node(e2);
        Node node3 = node = this.tail;
        while (true) {
            Node node4;
            if ((node4 = ((Node)((Object)((Object)node3))).next) == null) {
                if (!node3.casNext(null, node2)) continue;
                if (f.ifAcmp((Object)((Object)node3), (Object)((Object)node))) {
                    this.casTail(node, node2);
                }
                return true;
            }
            if (!f.ifAcmp((Object)((Object)node3), (Object)((Object)node4))) {
                node3 = f.ifAcmp((Object)((Object)node), (Object)((Object)(node = this.tail))) ? node : this.head;
                continue;
            }
            node3 = f.ifAcmp((Object)((Object)node3), (Object)((Object)node)) && f.ifAcmp((Object)((Object)node), (Object)((Object)(node = this.tail))) ? node : node4;
        }
    }

    @Override
    public E poll() {
        block0: while (true) {
            Node node;
            Node node2 = node = this.head;
            while (true) {
                Node node3;
                Object object;
                if ((object = ((Node)((Object)((Object)node2))).item) != null && node2.casItem(object, null)) {
                    if (f.ifAcmp((Object)((Object)node2), (Object)((Object)node))) {
                        node3 = ((Node)((Object)((Object)node2))).next;
                        this.updateHead(node, node3 != null ? node3 : node2);
                    }
                    return (E)object;
                }
                node3 = ((Node)((Object)((Object)node2))).next;
                if (node3 == null) {
                    this.updateHead(node, node2);
                    return null;
                }
                if (!f.ifAcmp((Object)((Object)node2), (Object)((Object)node3))) continue block0;
                node2 = node3;
            }
            break;
        }
    }

    @Override
    public E peek() {
        block0: while (true) {
            Node node;
            Node node2 = node = this.head;
            while (true) {
                Node node3;
                Object object;
                if ((object = ((Node)((Object)((Object)node2))).item) != null || (node3 = ((Node)((Object)((Object)node2))).next) == null) {
                    this.updateHead(node, node2);
                    return (E)object;
                }
                if (!f.ifAcmp((Object)((Object)node2), (Object)((Object)node3))) continue block0;
                node2 = node3;
            }
            break;
        }
    }

    Node<E> first() {
        block0: while (true) {
            Node node;
            Node node2 = node = this.head;
            while (true) {
                Node node3;
                boolean bl;
                boolean bl2 = bl = ((Node)((Object)((Object)node2))).item != null;
                if (bl || (node3 = ((Node)((Object)((Object)node2))).next) == null) {
                    this.updateHead(node, node2);
                    return bl ? node2 : null;
                }
                if (!f.ifAcmp((Object)((Object)node2), (Object)((Object)node3))) continue block0;
                node2 = node3;
            }
            break;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int n = 0;
        Node<E> node = this.first();
        while (node != null && (((Node)((Object)node)).item == null || ++n != Integer.MAX_VALUE)) {
            node = this.succ(node);
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = this.first();
        while (node != null) {
            Object object2 = ((Node)((Object)node)).item;
            if (object2 != null && object.equals(object2)) {
                return true;
            }
            node = this.succ(node);
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = null;
        Node<E> node2 = this.first();
        while (node2 != null) {
            Object object2 = ((Node)((Object)node2)).item;
            if (object2 != null && object.equals(object2) && node2.casItem(object2, null)) {
                Node<E> node3 = this.succ(node2);
                if (node != null && node3 != null) {
                    node.casNext(node2, node3);
                }
                return true;
            }
            node = node2;
            node2 = this.succ(node2);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Node node;
        Object object2;
        if (!f.ifAcmp(collection, (Object)this)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        Node node2 = null;
        Node node3 = null;
        for (Object object2 : collection) {
            ConcurrentLinkedQueue.checkNotNull(object2);
            node = new Node(object2);
            if (node2 == null) {
                node2 = node3 = node;
                continue;
            }
            node3.lazySetNext(node);
            node3 = node;
        }
        if (node2 == null) {
            return false;
        }
        Object object3 = this.tail;
        object2 = object3;
        while (true) {
            if ((node = ((Node)((Object)object2)).next) == null) {
                if (!((Node)((Object)object2)).casNext(null, node2)) continue;
                if (!this.casTail((Node<E>)((Object)object3), node3)) {
                    object3 = this.tail;
                    if (((Node)((Object)((Object)node3))).next == null) {
                        this.casTail((Node<E>)((Object)object3), node3);
                    }
                }
                return true;
            }
            if (!f.ifAcmp(object2, (Object)((Object)node))) {
                object2 = f.ifAcmp(object3, (Object)(object3 = this.tail)) ? object3 : this.head;
                continue;
            }
            object2 = f.ifAcmp((Object)object2, object3) && f.ifAcmp(object3, (Object)(object3 = this.tail)) ? object3 : node;
        }
    }

    @Override
    public Object[] toArray() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Node<E> node = this.first();
        while (node != null) {
            Object object = ((Node)((Object)node)).item;
            if (object != null) {
                arrayList.add(object);
            }
            node = this.succ(node);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object object;
        int n = 0;
        Node<E> node = this.first();
        while (node != null && n < a.arrayLength((Object[])TArray)) {
            object = ((Node)((Object)node)).item;
            if (object != null) {
                a.arrayStore((Object[])TArray, (int)n++, (Object)object);
            }
            node = this.succ(node);
        }
        if (node == null) {
            if (n < a.arrayLength((Object[])TArray)) {
                a.arrayStore((Object[])TArray, (int)n, null);
            }
            return TArray;
        }
        object = new ArrayList();
        Node<E> node2 = this.first();
        while (node2 != null) {
            Object object2 = ((Node)((Object)node2)).item;
            if (object2 != null) {
                ((ArrayList)object).add(object2);
            }
            node2 = this.succ(node2);
        }
        return ((ArrayList)object).toArray(TArray);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<E> node = this.first();
        while (node != null) {
            Object object = ((Node)((Object)node)).item;
            if (object != null) {
                objectOutputStream.writeObject(object);
            }
            node = this.succ(node);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        Node node = null;
        Node node2 = null;
        while ((object = objectInputStream.readObject()) != null) {
            Node node3 = new Node(object);
            if (node == null) {
                node = node2 = node3;
                continue;
            }
            node2.lazySetNext(node3);
            node2 = node3;
        }
        if (node == null) {
            node = node2 = new Node(null);
        }
        this.head = node;
        this.tail = node2;
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
    }

    private boolean casTail(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private boolean casHead(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, headOffset, node, node2);
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ConcurrentLinkedQueue> clazz = ConcurrentLinkedQueue.class;
            headOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("tail"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    protected /* synthetic */ ConcurrentLinkedQueue(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class Itr
    extends h
    implements Iterator {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;
        final /* synthetic */ ConcurrentLinkedQueue this$0;

        Itr(ConcurrentLinkedQueue concurrentLinkedQueue) {
            this.this$0 = concurrentLinkedQueue;
            this.advance();
        }

        private E advance() {
            Node node;
            Node node2;
            this.lastRet = this.nextNode;
            Object object = this.nextItem;
            if (this.nextNode == null) {
                node2 = ((Itr)this).this$0.first();
                node = null;
            } else {
                node = this.nextNode;
                node2 = ((Itr)this).this$0.succ(this.nextNode);
            }
            while (true) {
                if (node2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return object;
                }
                Object object2 = ((Node)((Object)node2)).item;
                if (object2 != null) {
                    this.nextNode = node2;
                    this.nextItem = object2;
                    return object;
                }
                Node node3 = ((Itr)this).this$0.succ(node2);
                if (node != null && node3 != null) {
                    node.casNext(node2, node3);
                }
                node2 = node3;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            ((Node)((Object)((Object)node))).item = null;
            this.lastRet = null;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ConcurrentLinkedQueue concurrentLinkedQueue) {
            ((Itr)object).this$0 = concurrentLinkedQueue;
        }

        protected /* synthetic */ Itr(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class Node
    extends h {
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long nextOffset;

        Node(E e2) {
            UNSAFE.putObject((Object)this, itemOffset, e2);
        }

        boolean casItem(E e2, E e3) {
            return UNSAFE.compareAndSwapObject((Object)this, itemOffset, e2, e3);
        }

        void lazySetNext(Node<E> node) {
            UNSAFE.putOrderedObject((Object)this, nextOffset, (Object)node);
        }

        boolean casNext(Node<E> node, Node<E> node2) {
            return UNSAFE.compareAndSwapObject((Object)this, nextOffset, (Object)node, (Object)node2);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Node> clazz = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("next"));
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
            }
        }

        static /* synthetic */ void _jr$ip$next(Object object, Node node) {
            ((Node)((Object)object)).next = node;
        }

        protected /* synthetic */ Node(h h2) {
            super(h2);
        }
    }
}

