/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class CopyOnWriteArrayList
extends h
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient ReentrantLock lock;
    private volatile transient Object[] array;
    private static final Unsafe UNSAFE;
    private static final long lockOffset;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] objectArray) {
        this.array = objectArray;
    }

    public CopyOnWriteArrayList() {
        this.lock = new ReentrantLock();
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        this.lock = new ReentrantLock();
        Object[] objectArray = collection.toArray();
        if (f.ifAcmp(objectArray.getClass(), Object[].class)) {
            objectArray = a.copyOf((Object[])objectArray, (int)a.arrayLength((Object[])objectArray), Object[].class);
        }
        this.setArray(objectArray);
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.lock = new ReentrantLock();
        this.setArray(a.copyOf((Object[])EArray, (int)a.arrayLength((Object[])EArray), Object[].class));
    }

    @Override
    public int size() {
        return a.arrayLength((Object[])this.getArray());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int indexOf(Object object, Object[] objectArray, int n, int n2) {
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (a.arrayLoad((Object[])objectArray, (int)i) != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(a.arrayLoad((Object[])objectArray, (int)i))) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (a.arrayLoad((Object[])objectArray, (int)i) != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(a.arrayLoad((Object[])objectArray, (int)i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, a.arrayLength((Object[])objectArray)) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, a.arrayLength((Object[])objectArray));
    }

    public int indexOf(E e2, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(e2, objectArray, n, a.arrayLength((Object[])objectArray));
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, a.arrayLength((Object[])objectArray) - 1);
    }

    public int lastIndexOf(E e2, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(e2, objectArray, n);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)g.convertForCast((Object)((CopyOnWriteArrayList)g.convertForCast((Object)super.clone(), CopyOnWriteArrayList.class)), CopyOnWriteArrayList.class);
            copyOnWriteArrayList.resetLock();
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = this.getArray();
        return Arrays.copyOf(objectArray, a.arrayLength((Object[])objectArray));
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = this.getArray();
        int n = a.arrayLength((Object[])objectArray);
        if (a.arrayLength((Object[])TArray) < n) {
            return (Object[])g.convertForCast((Object)a.copyOf((Object[])objectArray, (int)n, TArray.getClass()), Object[].class);
        }
        a.arraycopy((Object)objectArray, (int)0, TArray, (int)0, (int)n);
        if (a.arrayLength((Object[])TArray) > n) {
            a.arrayStore((Object[])TArray, (int)n, null);
        }
        return TArray;
    }

    private E get(Object[] objectArray, int n) {
        return a.arrayLoad((Object[])objectArray, (int)n);
    }

    @Override
    public E get(int n) {
        return this.get(this.getArray(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e2) {
        Object e3;
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            Object e4 = this.get(objectArray, n);
            if (f.ifAcmp(e4, e2)) {
                int n2 = a.arrayLength((Object[])objectArray);
                Object[] objectArray2 = Arrays.copyOf(objectArray, n2);
                a.arrayStore((Object[])objectArray2, (int)n, e2);
                this.setArray(objectArray2);
            } else {
                this.setArray(objectArray);
            }
            e3 = e4;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        return e3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e2) {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n = a.arrayLength((Object[])objectArray);
            Object[] objectArray2 = Arrays.copyOf(objectArray, n + 1);
            a.arrayStore((Object[])objectArray2, (int)n, e2);
            this.setArray(objectArray2);
            boolean bl = true;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, E e2) {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray;
            Object[] objectArray2 = this.getArray();
            int n2 = a.arrayLength((Object[])objectArray2);
            if (n > n2 || n < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2));
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                objectArray = Arrays.copyOf(objectArray2, n2 + 1);
            } else {
                objectArray = new Object[n2 + 1];
                a.arraycopy((Object)objectArray2, (int)0, (Object)objectArray, (int)0, (int)n);
                a.arraycopy((Object)objectArray2, (int)n, (Object)objectArray, (int)(n + 1), (int)n3);
            }
            a.arrayStore((Object[])objectArray, (int)n, e2);
            this.setArray(objectArray);
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) {
        Object[] objectArray;
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray2 = this.getArray();
            int n2 = a.arrayLength((Object[])objectArray2);
            Object e2 = this.get(objectArray2, n);
            int n3 = n2 - n - 1;
            if (n3 == 0) {
                this.setArray(Arrays.copyOf(objectArray2, n2 - 1));
            } else {
                objectArray = new Object[n2 - 1];
                a.arraycopy((Object)objectArray2, (int)0, (Object)objectArray, (int)0, (int)n);
                a.arraycopy((Object)objectArray2, (int)(n + 1), (Object)objectArray, (int)n, (int)n3);
                this.setArray(objectArray);
            }
            objectArray = e2;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray = this.getArray();
            int n2 = a.arrayLength((Object[])objectArray);
            if (n2 != 0) {
                int n3;
                n = n2 - 1;
                Object[] objectArray2 = new Object[n];
                for (n3 = 0; n3 < n; n3 += 1) {
                    if (CopyOnWriteArrayList.eq(object, a.arrayLoad((Object[])objectArray, (int)n3))) {
                        int n4 = n3 + 1;
                        while (true) {
                            if (n4 >= n2) {
                                this.setArray(objectArray2);
                                n4 = 1;
                                reentrantLock.unlock();
                                return n4 != 0;
                            }
                            a.arrayStore((Object[])objectArray2, (int)(n4 - 1), (Object)a.arrayLoad((Object[])objectArray, (int)n4));
                            ++n4;
                        }
                    }
                    a.arrayStore((Object[])objectArray2, (int)n3, (Object)a.arrayLoad((Object[])objectArray, (int)n3));
                }
                if (CopyOnWriteArrayList.eq(object, a.arrayLoad((Object[])objectArray, (int)n))) {
                    this.setArray(objectArray2);
                    n3 = 1;
                    reentrantLock.unlock();
                    return n3 != 0;
                }
            }
            n = 0;
            reentrantLock.unlock();
            return n != 0;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRange(int n, int n2) {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n3 = a.arrayLength((Object[])objectArray);
            if (n < 0 || n2 > n3 || n2 < n) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
            }
            int n4 = n3 - (n2 - n);
            int n5 = n3 - n2;
            if (n5 == 0) {
                this.setArray(Arrays.copyOf(objectArray, n4));
            } else {
                Object[] objectArray2 = new Object[n4];
                a.arraycopy((Object)objectArray, (int)0, (Object)objectArray2, (int)0, (int)n);
                a.arraycopy((Object)objectArray, (int)n2, (Object)objectArray2, (int)n, (int)n5);
                this.setArray(objectArray2);
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addIfAbsent(E e2) {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray = this.getArray();
            int n2 = a.arrayLength((Object[])objectArray);
            Object[] objectArray2 = new Object[n2 + 1];
            for (n = 0; n < n2; ++n) {
                if (CopyOnWriteArrayList.eq(e2, a.arrayLoad((Object[])objectArray, (int)n))) {
                    boolean bl = false;
                    reentrantLock.unlock();
                    return bl;
                }
                a.arrayStore((Object[])objectArray2, (int)n, (Object)a.arrayLoad((Object[])objectArray, (int)n));
            }
            a.arrayStore((Object[])objectArray2, (int)n2, e2);
            this.setArray(objectArray2);
            n = 1;
            reentrantLock.unlock();
            return n != 0;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.getArray();
        int n = a.arrayLength((Object[])objectArray);
        for (Object obj : collection) {
            if (CopyOnWriteArrayList.indexOf(obj, objectArray, 0, n) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        int n;
        ReentrantLock reentrantLock;
        block4: {
            reentrantLock = ((CopyOnWriteArrayList)this).lock;
            reentrantLock.lock();
            try {
                int n2;
                Object[] objectArray = this.getArray();
                int n3 = a.arrayLength((Object[])objectArray);
                if (!n3) break block4;
                n = 0;
                Object[] objectArray2 = new Object[n3];
                for (n2 = 0; n2 < n3; n2 += 1) {
                    Object object = a.arrayLoad((Object[])objectArray, (int)n2);
                    if (collection.contains(object)) continue;
                    a.arrayStore((Object[])objectArray2, (int)n++, (Object)object);
                }
                if (n == n3) break block4;
                this.setArray(Arrays.copyOf(objectArray2, n));
                n2 = 1;
                reentrantLock.unlock();
                return n2 != 0;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        n = 0;
        reentrantLock.unlock();
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        int n;
        ReentrantLock reentrantLock;
        block4: {
            reentrantLock = ((CopyOnWriteArrayList)this).lock;
            reentrantLock.lock();
            try {
                int n2;
                Object[] objectArray = this.getArray();
                int n3 = a.arrayLength((Object[])objectArray);
                if (!n3) break block4;
                n = 0;
                Object[] objectArray2 = new Object[n3];
                for (n2 = 0; n2 < n3; n2 += 1) {
                    Object object = a.arrayLoad((Object[])objectArray, (int)n2);
                    if (!collection.contains(object)) continue;
                    a.arrayStore((Object[])objectArray2, (int)n++, (Object)object);
                }
                if (n == n3) break block4;
                this.setArray(Arrays.copyOf(objectArray2, n));
                n2 = 1;
                reentrantLock.unlock();
                return n2 != 0;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        n = 0;
        reentrantLock.unlock();
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (a.arrayLength((Object[])objectArray) == 0) {
            return 0;
        }
        Object[] objectArray2 = new Object[a.arrayLength((Object[])objectArray)];
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            int n;
            Object[] objectArray3 = this.getArray();
            int n2 = a.arrayLength((Object[])objectArray3);
            int n3 = 0;
            for (n = 0; n < a.arrayLength((Object[])objectArray); ++n) {
                Object object = a.arrayLoad((Object[])objectArray, (int)n);
                if (CopyOnWriteArrayList.indexOf(object, objectArray3, 0, n2) >= 0 || CopyOnWriteArrayList.indexOf(object, objectArray2, 0, n3) >= 0) continue;
                a.arrayStore((Object[])objectArray2, (int)n3++, (Object)object);
            }
            if (n3 > 0) {
                Object[] objectArray4 = Arrays.copyOf(objectArray3, n2 + n3);
                a.arraycopy((Object)objectArray2, (int)0, (Object)objectArray4, (int)n2, (int)n3);
                this.setArray(objectArray4);
            }
            n = n3;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            this.setArray(new Object[0]);
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        if (a.arrayLength((Object[])objectArray) == 0) {
            return false;
        }
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray2 = this.getArray();
            int n = a.arrayLength((Object[])objectArray2);
            Object[] objectArray3 = Arrays.copyOf(objectArray2, n + a.arrayLength((Object[])objectArray));
            a.arraycopy((Object)objectArray, (int)0, (Object)objectArray3, (int)n, (int)a.arrayLength((Object[])objectArray));
            this.setArray(objectArray3);
            boolean bl = true;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        ReentrantLock reentrantLock;
        Object[] objectArray3;
        block6: {
            objectArray3 = collection.toArray();
            reentrantLock = ((CopyOnWriteArrayList)this).lock;
            reentrantLock.lock();
            try {
                objectArray2 = this.getArray();
                n2 = a.arrayLength((Object[])objectArray2);
                if (n > n2 || n < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2));
                }
                if (a.arrayLength((Object[])objectArray3) != 0) break block6;
                boolean bl = false;
                reentrantLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            objectArray = Arrays.copyOf(objectArray2, n2 + a.arrayLength((Object[])objectArray3));
        } else {
            objectArray = new Object[n2 + a.arrayLength((Object[])objectArray3)];
            a.arraycopy((Object)objectArray2, (int)0, (Object)objectArray, (int)0, (int)n);
            a.arraycopy((Object)objectArray2, (int)n, (Object)objectArray, (int)(n + a.arrayLength((Object[])objectArray3)), (int)n3);
        }
        a.arraycopy((Object)objectArray3, (int)0, (Object)objectArray, (int)n, (int)a.arrayLength((Object[])objectArray3));
        this.setArray(objectArray);
        boolean bl = true;
        reentrantLock.unlock();
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.getArray();
        objectOutputStream.writeInt(a.arrayLength((Object[])objectArray));
        Object[] objectArray2 = objectArray;
        int n = a.arrayLength((Object[])objectArray2);
        for (int i = 0; i < n; ++i) {
            Object object = a.arrayLoad((Object[])objectArray2, (int)i);
            objectOutputStream.writeObject(object);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.resetLock();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)objectInputStream.readObject());
        }
        this.setArray(objectArray);
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)this)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, List.class) instanceof List)) {
            return false;
        }
        List list = (List)g.convertForCast((Object)((List)g.convertForCast((Object)object, List.class)), List.class);
        Iterator iterator = list.iterator();
        Object[] objectArray = this.getArray();
        int n = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            if (iterator.hasNext() && CopyOnWriteArrayList.eq(a.arrayLoad((Object[])objectArray, (int)i), iterator.next())) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        Object[] objectArray = this.getArray();
        int n2 = a.arrayLength((Object[])objectArray);
        for (int i = 0; i < n2; ++i) {
            Object object = a.arrayLoad((Object[])objectArray, (int)i);
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        Object[] objectArray = this.getArray();
        int n2 = a.arrayLength((Object[])objectArray);
        if (n < 0 || n > n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Index: " + n));
        }
        return new COWIterator(objectArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int n, int n2) {
        ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this).lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.getArray();
            int n3 = a.arrayLength((Object[])objectArray);
            if (n < 0 || n2 > n3 || n > n2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
            }
            COWSubList cOWSubList = new COWSubList(this, n, n2);
            reentrantLock.unlock();
            return cOWSubList;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private void resetLock() {
        UNSAFE.putObjectVolatile(this, lockOffset, new ReentrantLock());
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<CopyOnWriteArrayList> clazz = CopyOnWriteArrayList.class;
            lockOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("lock"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    static /* synthetic */ void _jr$ip$lock(Object object, ReentrantLock reentrantLock) {
        ((CopyOnWriteArrayList)object).lock = reentrantLock;
    }

    protected /* synthetic */ CopyOnWriteArrayList(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class COWIterator
    extends h
    implements ListIterator {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] objectArray, int n) {
            this.cursor = n;
            this.snapshot = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < a.arrayLength((Object[])this.snapshot);
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            Object[] objectArray = this.snapshot;
            COWIterator cOWIterator = this;
            int n = cOWIterator.cursor;
            cOWIterator.cursor = n + 1;
            return a.arrayLoad((Object[])objectArray, (int)n);
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }
            Object[] objectArray = this.snapshot;
            COWIterator cOWIterator = this;
            int n = cOWIterator.cursor - 1;
            cOWIterator.cursor = n;
            return a.arrayLoad((Object[])objectArray, (int)n);
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        @Override
        public void set(E e2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        @Override
        public void add(E e2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        private static /* synthetic */ void _jr$ip$snapshot(COWIterator cOWIterator, Object[] objectArray) {
            cOWIterator.snapshot = objectArray;
        }

        protected /* synthetic */ COWIterator(h h2) {
            super(h2);
        }
    }

    private static class COWSubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        COWSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.getArray();
            this.offset = n;
            this.size = n2 - n;
        }

        private void checkForComodification() {
            if (f.ifAcmp((Object)this.l.getArray(), (Object)this.expectedArray)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ConcurrentModificationException());
            }
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e2) {
            Object e3;
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                Object e4 = this.l.set(n + this.offset, e2);
                this.expectedArray = this.l.getArray();
                e3 = e4;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            return e3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            Object e2;
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                e2 = this.l.get(n + this.offset);
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            return e2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                int n = this.size;
                reentrantLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e2) {
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                this.l.add(n + this.offset, e2);
                this.expectedArray = this.l.getArray();
                COWSubList cOWSubList = this;
                cOWSubList.size = cOWSubList.size + 1;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            Object e2;
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.rangeCheck(n);
                this.checkForComodification();
                Object e3 = this.l.remove(n + this.offset);
                this.expectedArray = this.l.getArray();
                COWSubList cOWSubList = this;
                cOWSubList.size = cOWSubList.size - 1;
                e2 = e3;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            return e2;
        }

        @Override
        public boolean remove(Object object) {
            int n = this.indexOf(object);
            if (n == -1) {
                return false;
            }
            this.remove(n);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                COWSubListIterator cOWSubListIterator = new COWSubListIterator(this.l, 0, this.offset, this.size);
                reentrantLock.unlock();
                return cOWSubListIterator;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n) {
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size));
                }
                COWSubListIterator cOWSubListIterator = new COWSubListIterator(this.l, n, this.offset, this.size);
                reentrantLock.unlock();
                return cOWSubListIterator;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            ReentrantLock reentrantLock = ((CopyOnWriteArrayList)this.l).lock;
            reentrantLock.lock();
            try {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                COWSubList<E> cOWSubList = new COWSubList<E>(this.l, n + this.offset, n2 + this.offset);
                reentrantLock.unlock();
                return cOWSubList;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        private static /* synthetic */ void _jr$ip$l(COWSubList cOWSubList, CopyOnWriteArrayList copyOnWriteArrayList) {
            cOWSubList.l = copyOnWriteArrayList;
        }

        private static /* synthetic */ void _jr$ip$offset(COWSubList cOWSubList, int n) {
            cOWSubList.offset = n;
        }

        protected /* synthetic */ COWSubList(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private static class COWSubListIterator
    extends h
    implements ListIterator {
        private final ListIterator<E> i;
        private final int index;
        private final int offset;
        private final int size;

        COWSubListIterator(List<E> list, int n, int n2, int n3) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.i = list.listIterator(n + n2);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        @Override
        public void set(E e2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        @Override
        public void add(E e2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
        }

        private static /* synthetic */ void _jr$ip$i(COWSubListIterator cOWSubListIterator, ListIterator listIterator) {
            cOWSubListIterator.i = listIterator;
        }

        private static /* synthetic */ int _jr$ig$index(COWSubListIterator cOWSubListIterator) {
            return cOWSubListIterator.index;
        }

        private static /* synthetic */ void _jr$ip$index(COWSubListIterator cOWSubListIterator, int n) {
            cOWSubListIterator.index = n;
        }

        private static /* synthetic */ void _jr$ip$offset(COWSubListIterator cOWSubListIterator, int n) {
            cOWSubListIterator.offset = n;
        }

        private static /* synthetic */ void _jr$ip$size(COWSubListIterator cOWSubListIterator, int n) {
            cOWSubListIterator.size = n;
        }

        protected /* synthetic */ COWSubListIterator(h h2) {
            super(h2);
        }
    }
}

