/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class ExecutorCompletionService
extends h
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue<Future<V>> completionQueue;

    private RunnableFuture<V> newTaskFor(Callable<V> callable) {
        if (this.aes == null) {
            return new FutureTask(callable);
        }
        return this.aes.newTaskFor(callable);
    }

    private RunnableFuture<V> newTaskFor(Runnable runnable, V v) {
        if (this.aes == null) {
            return new FutureTask(runnable, v);
        }
        return this.aes.newTaskFor(runnable, v);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.executor = executor;
        this.aes = g.convertForInstanceOf((Object)executor, AbstractExecutorService.class) instanceof AbstractExecutorService ? (AbstractExecutorService)g.convertForCast((Object)executor, AbstractExecutorService.class) : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue<Future<V>> blockingQueue) {
        if (executor == null || blockingQueue == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.executor = executor;
        this.aes = g.convertForInstanceOf((Object)executor, AbstractExecutorService.class) instanceof AbstractExecutorService ? (AbstractExecutorService)g.convertForCast((Object)executor, AbstractExecutorService.class) : null;
        this.completionQueue = blockingQueue;
    }

    @Override
    public Future<V> submit(Callable<V> callable) {
        if (callable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        RunnableFuture runnableFuture = this.newTaskFor(callable);
        this.executor.execute(new QueueingFuture(this, runnableFuture));
        return runnableFuture;
    }

    @Override
    public Future<V> submit(Runnable runnable, V v) {
        if (runnable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, v);
        this.executor.execute(new QueueingFuture(this, runnableFuture));
        return runnableFuture;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return (Future)g.convertForCast(this.completionQueue.take(), Future.class);
    }

    @Override
    public Future<V> poll() {
        return (Future)g.convertForCast(this.completionQueue.poll(), Future.class);
    }

    @Override
    public Future<V> poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        return (Future)g.convertForCast(this.completionQueue.poll(l2, timeUnit), Future.class);
    }

    private static /* synthetic */ void _jr$ip$executor(ExecutorCompletionService executorCompletionService, Executor executor) {
        executorCompletionService.executor = executor;
    }

    private static /* synthetic */ void _jr$ip$aes(ExecutorCompletionService executorCompletionService, AbstractExecutorService abstractExecutorService) {
        executorCompletionService.aes = abstractExecutorService;
    }

    private static /* synthetic */ void _jr$ip$completionQueue(ExecutorCompletionService executorCompletionService, BlockingQueue blockingQueue) {
        executorCompletionService.completionQueue = blockingQueue;
    }

    protected /* synthetic */ ExecutorCompletionService(h h2) {
        super(h2);
    }

    private class QueueingFuture
    extends FutureTask<Void> {
        private final Future<V> task;
        final /* synthetic */ ExecutorCompletionService this$0;

        QueueingFuture(ExecutorCompletionService executorCompletionService, RunnableFuture<V> runnableFuture) {
            this.this$0 = executorCompletionService;
            super(runnableFuture, null);
            this.task = runnableFuture;
        }

        @Override
        protected void done() {
            ((QueueingFuture)this).this$0.completionQueue.add(this.task);
        }

        private static /* synthetic */ void _jr$ip$task(QueueingFuture queueingFuture, Future future) {
            queueingFuture.task = future;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ExecutorCompletionService executorCompletionService) {
            ((QueueingFuture)object).this$0 = executorCompletionService;
        }

        protected /* synthetic */ QueueingFuture(h h2) {
            super(h2);
        }
    }
}

