/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.h;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.util.SecurityConstants;

public class Executors
extends h {
    public static ExecutorService newFixedThreadPool(int n2) {
        return new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newFixedThreadPool(int n2, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1, threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n2) {
        return new ScheduledThreadPoolExecutor(n2);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n2, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(n2, threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executorService) {
        if (executorService == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new DelegatedExecutorService(executorService);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new DelegatedScheduledExecutorService(scheduledExecutorService);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static <T> Callable<T> callable(Runnable runnable, T t) {
        if (runnable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new RunnableAdapter(runnable, t);
    }

    public static Callable<Object> callable(Runnable runnable) {
        if (runnable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new RunnableAdapter(runnable, null);
    }

    public static Callable<Object> callable(final PrivilegedAction<?> privilegedAction) {
        if (privilegedAction == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new Callable<Object>(){

            @Override
            public Object call() {
                return privilegedAction.run();
            }
        };
    }

    public static Callable<Object> callable(final PrivilegedExceptionAction<?> privilegedExceptionAction) {
        if (privilegedExceptionAction == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return privilegedExceptionAction.run();
            }
        };
    }

    public static <T> Callable<T> privilegedCallable(Callable<T> callable) {
        if (callable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new PrivilegedCallable(callable);
    }

    public static <T> Callable<T> privilegedCallableUsingCurrentClassLoader(Callable<T> callable) {
        if (callable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return new PrivilegedCallableUsingCurrentClassLoader(callable);
    }

    private Executors() {
    }

    protected /* synthetic */ Executors(h h2) {
        super(h2);
    }

    static class DefaultThreadFactory
    extends h
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber;
        private final String namePrefix;

        DefaultThreadFactory() {
            this.threadNumber = new AtomicInteger(1);
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }

        private static /* synthetic */ void _jr$ip$group(DefaultThreadFactory defaultThreadFactory, ThreadGroup threadGroup) {
            defaultThreadFactory.group = threadGroup;
        }

        private static /* synthetic */ void _jr$ip$threadNumber(DefaultThreadFactory defaultThreadFactory, AtomicInteger atomicInteger) {
            defaultThreadFactory.threadNumber = atomicInteger;
        }

        private static /* synthetic */ void _jr$ip$namePrefix(DefaultThreadFactory defaultThreadFactory, String string) {
            defaultThreadFactory.namePrefix = string;
        }

        protected /* synthetic */ DefaultThreadFactory(h h2) {
            super(h2);
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executorService) {
            this.e = executorService;
        }

        @Override
        public void execute(Runnable runnable) {
            this.e.execute(runnable);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.e.awaitTermination(l, timeUnit);
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            return this.e.submit(runnable);
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            return this.e.submit(callable);
        }

        @Override
        public <T> Future<T> submit(Runnable runnable, T t) {
            return this.e.submit(runnable, t);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
            return this.e.invokeAll(collection);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
            return this.e.invokeAll(collection, l, timeUnit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(collection);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(collection, l, timeUnit);
        }

        private static /* synthetic */ void _jr$ip$e(DelegatedExecutorService delegatedExecutorService, ExecutorService executorService) {
            delegatedExecutorService.e = executorService;
        }

        protected /* synthetic */ DelegatedExecutorService(h h2) {
            super(h2);
        }
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService);
            this.e = scheduledExecutorService;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
            return this.e.schedule(runnable, l, timeUnit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
            return this.e.schedule(callable, l, timeUnit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            return this.e.scheduleAtFixedRate(runnable, l, l2, timeUnit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            return this.e.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
        }

        private static /* synthetic */ void _jr$ip$e(DelegatedScheduledExecutorService delegatedScheduledExecutorService, ScheduledExecutorService scheduledExecutorService) {
            delegatedScheduledExecutorService.e = scheduledExecutorService;
        }

        protected /* synthetic */ DelegatedScheduledExecutorService(h h2) {
            super(h2);
        }
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executorService) {
            super(executorService);
        }

        protected void finalize() {
            if (!this._jr$iCur()) {
                return;
            }
            super.shutdown();
        }

        protected /* synthetic */ FinalizableDelegatedExecutorService(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static final class PrivilegedCallable
    extends h
    implements Callable {
        private final Callable<T> task;
        private final AccessControlContext acc;

        PrivilegedCallable(Callable<T> callable) {
            this.task = callable;
            this.acc = AccessController.getContext();
        }

        public T call() throws Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                    @Override
                    public T run() throws Exception {
                        return task.call();
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)privilegedActionException.getException());
            }
        }

        static /* synthetic */ Callable access$000(PrivilegedCallable privilegedCallable) {
            return privilegedCallable.task;
        }

        private static /* synthetic */ Callable _jr$ig$task(PrivilegedCallable privilegedCallable) {
            return privilegedCallable.task;
        }

        private static /* synthetic */ void _jr$ip$task(PrivilegedCallable privilegedCallable, Callable callable) {
            privilegedCallable.task = callable;
        }

        private static /* synthetic */ AccessControlContext _jr$ig$acc(PrivilegedCallable privilegedCallable) {
            return privilegedCallable.acc;
        }

        private static /* synthetic */ void _jr$ip$acc(PrivilegedCallable privilegedCallable, AccessControlContext accessControlContext) {
            privilegedCallable.acc = accessControlContext;
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static final class PrivilegedCallableUsingCurrentClassLoader
    extends h
    implements Callable {
        private final Callable<T> task;
        private final AccessControlContext acc;
        private final ClassLoader ccl;

        PrivilegedCallableUsingCurrentClassLoader(Callable<T> callable) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
                securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
            }
            this.task = callable;
            this.acc = AccessController.getContext();
            this.ccl = Thread.currentThread().getContextClassLoader();
        }

        public T call() throws Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T run() throws Exception {
                        Thread t = Thread.currentThread();
                        ClassLoader cl = t.getContextClassLoader();
                        if (ccl == cl) {
                            return task.call();
                        }
                        t.setContextClassLoader(ccl);
                        try {
                            Object t2 = task.call();
                            return t2;
                        }
                        finally {
                            t.setContextClassLoader(cl);
                        }
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)privilegedActionException.getException());
            }
        }

        static /* synthetic */ ClassLoader access$100(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.ccl;
        }

        static /* synthetic */ Callable access$200(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.task;
        }

        private static /* synthetic */ Callable _jr$ig$task(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.task;
        }

        private static /* synthetic */ void _jr$ip$task(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, Callable callable) {
            privilegedCallableUsingCurrentClassLoader.task = callable;
        }

        private static /* synthetic */ AccessControlContext _jr$ig$acc(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.acc;
        }

        private static /* synthetic */ void _jr$ip$acc(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, AccessControlContext accessControlContext) {
            privilegedCallableUsingCurrentClassLoader.acc = accessControlContext;
        }

        private static /* synthetic */ ClassLoader _jr$ig$ccl(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader) {
            return privilegedCallableUsingCurrentClassLoader.ccl;
        }

        private static /* synthetic */ void _jr$ip$ccl(PrivilegedCallableUsingCurrentClassLoader privilegedCallableUsingCurrentClassLoader, ClassLoader classLoader) {
            privilegedCallableUsingCurrentClassLoader.ccl = classLoader;
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final AccessControlContext acc;
        private final ClassLoader ccl;

        PrivilegedThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
                securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
            }
            this.acc = AccessController.getContext();
            this.ccl = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Thread newThread(final Runnable runnable) {
            return super.newThread(new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Void run() {
                            Thread.currentThread().setContextClassLoader(ccl);
                            runnable.run();
                            return null;
                        }
                    }, acc);
                }
            });
        }

        static /* synthetic */ ClassLoader access$300(PrivilegedThreadFactory privilegedThreadFactory) {
            return privilegedThreadFactory.ccl;
        }

        static /* synthetic */ AccessControlContext access$400(PrivilegedThreadFactory privilegedThreadFactory) {
            return privilegedThreadFactory.acc;
        }

        private static /* synthetic */ void _jr$ip$acc(PrivilegedThreadFactory privilegedThreadFactory, AccessControlContext accessControlContext) {
            privilegedThreadFactory.acc = accessControlContext;
        }

        private static /* synthetic */ void _jr$ip$ccl(PrivilegedThreadFactory privilegedThreadFactory, ClassLoader classLoader) {
            privilegedThreadFactory.ccl = classLoader;
        }

        protected /* synthetic */ PrivilegedThreadFactory(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static final class RunnableAdapter
    extends h
    implements Callable {
        final Runnable task;
        final T result;

        RunnableAdapter(Runnable runnable, T t) {
            this.task = runnable;
            this.result = t;
        }

        public T call() {
            this.task.run();
            return this.result;
        }

        static /* synthetic */ Runnable _jr$ig$task(Object object) {
            return ((RunnableAdapter)object).task;
        }

        static /* synthetic */ void _jr$ip$task(Object object, Runnable runnable) {
            ((RunnableAdapter)object).task = runnable;
        }

        static /* synthetic */ Object _jr$ig$result(Object object) {
            return ((RunnableAdapter)object).result;
        }

        static /* synthetic */ void _jr$ip$result(Object object, Object object2) {
            ((RunnableAdapter)object).result = object2;
        }
    }
}

