/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class FutureTask
extends h
implements RunnableFuture {
    private volatile int state;
    private static final int NEW = 0;
    private static final int COMPLETING = 1;
    private static final int NORMAL = 2;
    private static final int EXCEPTIONAL = 3;
    private static final int CANCELLED = 4;
    private static final int INTERRUPTING = 5;
    private static final int INTERRUPTED = 6;
    private Callable<V> callable;
    private Object outcome;
    private volatile Thread runner;
    private volatile WaitNode waiters;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;
    private static final long runnerOffset;
    private static final long waitersOffset;

    private V report(int n) throws ExecutionException {
        Object object = this.outcome;
        if (n == 2) {
            return object;
        }
        if (n >= 4) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CancellationException());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ExecutionException((Throwable)g.convertForCast((Object)object, Throwable.class)));
    }

    public FutureTask(Callable<V> callable) {
        if (callable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.callable = callable;
        this.state = 0;
    }

    public FutureTask(Runnable runnable, V v) {
        this.callable = Executors.callable(runnable, v);
        this.state = 0;
    }

    @Override
    public boolean isCancelled() {
        return this.state >= 4;
    }

    @Override
    public boolean isDone() {
        return this.state != 0;
    }

    @Override
    public boolean cancel(boolean bl) {
        if (this.state != 0) {
            return false;
        }
        if (bl) {
            if (!UNSAFE.compareAndSwapInt(this, stateOffset, 0, 5)) {
                return false;
            }
            Thread thread = this.runner;
            if (thread != null) {
                thread.interrupt();
            }
            UNSAFE.putOrderedInt(this, stateOffset, 6);
        } else if (!UNSAFE.compareAndSwapInt(this, stateOffset, 0, 4)) {
            return false;
        }
        this.finishCompletion();
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        int n = this.state;
        if (n <= 1) {
            n = this.awaitDone(false, 0L);
        }
        return this.report(n);
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeUnit == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n = this.state;
        if (n <= 1 && (n = this.awaitDone(true, timeUnit.toNanos(l))) <= 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new TimeoutException());
        }
        return this.report(n);
    }

    protected void done() {
    }

    protected void set(V v) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = v;
            UNSAFE.putOrderedInt(this, stateOffset, 2);
            this.finishCompletion();
        }
    }

    protected void setException(Throwable throwable) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = throwable;
            UNSAFE.putOrderedInt(this, stateOffset, 3);
            this.finishCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
                return;
            }
            try {
                boolean bl;
                Object v;
                Callable callable = this.callable;
                if (callable == null || this.state != 0) break block7;
                try {
                    v = callable.call();
                    bl = true;
                }
                catch (Throwable throwable) {
                    v = null;
                    bl = false;
                    this.setException(throwable);
                }
                if (!bl) break block7;
                this.set(v);
            }
            catch (Throwable throwable) {
                this.runner = null;
                int n = this.state;
                if (n >= 5) {
                    this.handlePossibleCancellationInterrupt(n);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        this.runner = null;
        int n = this.state;
        if (n >= 5) {
            this.handlePossibleCancellationInterrupt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runAndReset() {
        int n;
        boolean bl;
        block7: {
            if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
                return false;
            }
            bl = false;
            n = this.state;
            try {
                Callable callable = this.callable;
                if (callable == null || n != 0) break block7;
                try {
                    callable.call();
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.setException(throwable);
                }
            }
            catch (Throwable throwable) {
                this.runner = null;
                n = this.state;
                if (n >= 5) {
                    this.handlePossibleCancellationInterrupt(n);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        this.runner = null;
        n = this.state;
        if (n >= 5) {
            this.handlePossibleCancellationInterrupt(n);
        }
        return bl && n == 0;
    }

    private void handlePossibleCancellationInterrupt(int n) {
        if (n == 5) {
            while (this.state == 5) {
                Thread.yield();
            }
        }
    }

    private void finishCompletion() {
        WaitNode waitNode;
        block0: while ((waitNode = this.waiters) != null) {
            if (!UNSAFE.compareAndSwapObject(this, waitersOffset, (Object)waitNode, null)) continue;
            while (true) {
                WaitNode waitNode2;
                Thread thread;
                if ((thread = waitNode.thread) != null) {
                    waitNode.thread = null;
                    LockSupport.unpark(thread);
                }
                if ((waitNode2 = waitNode.next) == null) break block0;
                waitNode.next = null;
                waitNode = waitNode2;
            }
        }
        this.done();
        this.callable = null;
    }

    private int awaitDone(boolean bl, long l) throws InterruptedException {
        long l2 = bl ? System.nanoTime() + l : 0L;
        WaitNode waitNode = null;
        boolean bl2 = false;
        while (true) {
            if (Thread.interrupted()) {
                this.removeWaiter(waitNode);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
            }
            int n = this.state;
            if (n > 1) {
                if (waitNode != null) {
                    waitNode.thread = null;
                }
                return n;
            }
            if (n == 1) {
                Thread.yield();
                continue;
            }
            if (waitNode == null) {
                waitNode = new WaitNode();
                continue;
            }
            if (!bl2) {
                waitNode.next = this.waiters;
                bl2 = UNSAFE.compareAndSwapObject(this, waitersOffset, (Object)waitNode.next, (Object)waitNode);
                continue;
            }
            if (bl) {
                l = l2 - System.nanoTime();
                if (l <= 0L) {
                    this.removeWaiter(waitNode);
                    return this.state;
                }
                LockSupport.parkNanos(this, l);
                continue;
            }
            LockSupport.park(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode var1_1) {
        if (var1_1 != null) {
            var1_1.thread = null;
            block0: while (true) {
                var2_2 = null;
                var3_3 = FutureTask._jr$ig$waiters(this);
                while (var3_3 != null) {
                    var4_4 = var3_3.next;
                    if (var3_3.thread != null) {
                        var2_2 = var3_3;
                    } else if (var2_2 != null) {
                        var2_2.next = var4_4;
                        if (var2_2.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (FutureTask.UNSAFE.compareAndSwapObject(this, FutureTask.waitersOffset, (Object)var3_3, (Object)var4_4)) ** break;
                        continue block0;
                    }
                    var3_3 = var4_4;
                }
                break;
            }
        }
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<FutureTask> clazz = FutureTask.class;
            stateOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("state"));
            runnerOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("runner"));
            waitersOffset = UNSAFE.objectFieldOffset(ai.getCurrentClass(clazz).getDeclaredField("waiters"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    private static /* synthetic */ void _jr$ip$state(FutureTask futureTask, int n) {
        futureTask.state = n;
    }

    private static /* synthetic */ void _jr$ip$waiters(FutureTask futureTask, WaitNode waitNode) {
        futureTask.waiters = waitNode;
    }

    protected /* synthetic */ FutureTask(h h2) {
        super(h2);
    }

    static final class WaitNode
    extends h {
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode() {
        }

        static /* synthetic */ Thread _jr$ig$thread(Object object) {
            return ((WaitNode)((Object)object)).thread;
        }

        static /* synthetic */ void _jr$ip$thread(Object object, Thread thread) {
            ((WaitNode)((Object)object)).thread = thread;
        }

        static /* synthetic */ WaitNode _jr$ig$next(Object object) {
            return ((WaitNode)((Object)object)).next;
        }

        static /* synthetic */ void _jr$ip$next(Object object, WaitNode waitNode) {
            ((WaitNode)((Object)object)).next = waitNode;
        }
    }
}

