/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count;
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock;
    private final Condition notEmpty;
    private final ReentrantLock putLock;
    private final Condition notFull;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            this.notEmpty.signal();
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            this.notFull.signal();
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private void enqueue(Node<E> node) {
        Node<E> node2 = node;
        ((Node)((Object)((Object)this.last))).next = (Node)node2;
        this.last = node2;
    }

    private E dequeue() {
        Node node = this.head;
        Node node2 = ((Node)((Object)((Object)node))).next;
        ((Node)((Object)((Object)node))).next = node;
        this.head = node2;
        Object object = ((Node)((Object)((Object)node2))).item;
        ((Node)((Object)((Object)node2))).item = null;
        return (E)object;
    }

    void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int n2) {
        this.count = new AtomicInteger(0);
        this.takeLock = new ReentrantLock();
        this.notEmpty = this.takeLock.newCondition();
        this.putLock = new ReentrantLock();
        this.notFull = this.putLock.newCondition();
        if (n2 <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        this.capacity = n2;
        this.last = this.head = new Node(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingQueue(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            int n2 = 0;
            for (E e2 : collection) {
                if (e2 == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                if (n2 == this.capacity) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("Queue full"));
                }
                super.enqueue(new Node(e2));
                ++n2;
            }
            this.count.set(n2);
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e2) throws InterruptedException {
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n2 = -1;
        Node node = new Node(e2);
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == this.capacity) {
                this.notFull.await();
            }
            this.enqueue(node);
            n2 = atomicInteger.getAndIncrement();
            if (n2 + 1 < this.capacity) {
                this.notFull.signal();
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (n2 == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offer(E e2, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        long l2 = timeUnit.toNanos(l);
        int n2 = -1;
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == this.capacity) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    reentrantLock.unlock();
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            this.enqueue(new Node(e2));
            n2 = atomicInteger.getAndIncrement();
            if (n2 + 1 < this.capacity) {
                this.notFull.signal();
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (n2 == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        if (e2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == this.capacity) {
            return false;
        }
        int n2 = -1;
        Node node = new Node(e2);
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() < this.capacity) {
                this.enqueue(node);
                n2 = atomicInteger.getAndIncrement();
                if (n2 + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (n2 == 0) {
            this.signalNotEmpty();
        }
        return n2 >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e2;
        int n2 = -1;
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lockInterruptibly();
        try {
            while (atomicInteger.get() == 0) {
                this.notEmpty.await();
            }
            e2 = this.dequeue();
            n2 = atomicInteger.getAndDecrement();
            if (n2 > 1) {
                this.notEmpty.signal();
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (n2 == this.capacity) {
            this.signalNotFull();
        }
        return e2;
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == 0) {
            return null;
        }
        E e2 = null;
        int n2 = -1;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() > 0) {
                e2 = this.dequeue();
                n2 = atomicInteger.getAndDecrement();
                if (n2 > 1) {
                    this.notEmpty.signal();
                }
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        if (n2 == this.capacity) {
            this.signalNotFull();
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Node node;
        ReentrantLock reentrantLock;
        block4: {
            E e2;
            if (this.count.get() == 0) {
                return null;
            }
            reentrantLock = this.takeLock;
            reentrantLock.lock();
            try {
                node = ((Node)((Object)((Object)this.head))).next;
                if (node != null) break block4;
                e2 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            return e2;
        }
        Object object = ((Node)((Object)((Object)node))).item;
        reentrantLock.unlock();
        return (E)object;
    }

    void unlink(Node<E> node, Node<E> node2) {
        ((Node)((Object)node)).item = null;
        ((Node)((Object)node2)).next = ((Node)((Object)node)).next;
        if (!f.ifAcmp((Object)((Object)this.last), node)) {
            this.last = node2;
        }
        if (this.count.getAndDecrement() == this.capacity) {
            this.notFull.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node node = this.head;
            Node node2 = ((Node)((Object)((Object)node))).next;
            while (node2 != null) {
                if (object.equals(((Node)((Object)((Object)node2))).item)) {
                    this.unlink(node2, node);
                    boolean bl = true;
                    this.fullyUnlock();
                    return bl;
                }
                node = node2;
                node2 = ((Node)((Object)((Object)node2))).next;
            }
            boolean bl = false;
            this.fullyUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node node = ((Node)((Object)((Object)this.head))).next;
            while (node != null) {
                if (object.equals(((Node)((Object)((Object)node))).item)) {
                    boolean bl = true;
                    this.fullyUnlock();
                    return bl;
                }
                node = ((Node)((Object)((Object)node))).next;
            }
            boolean bl = false;
            this.fullyUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.fullyLock();
        try {
            int n2 = this.count.get();
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            Object object = ((Node)((Object)((Object)this.head))).next;
            while (object != null) {
                a.arrayStore((Object[])objectArray, (int)n3++, (Object)((Node)((Object)object)).item);
                object = ((Node)((Object)object)).next;
            }
            object = objectArray;
            this.fullyUnlock();
            return object;
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.fullyLock();
        try {
            int n2 = this.count.get();
            if (a.arrayLength((Object[])objectArray) < n2) {
                objectArray = (Object[])g.convertForCast((Object)((Object[])g.convertForCast((Object)Array.newInstance(ai.getCurrentClass(objectArray.getClass()).getComponentType(), n2), Object[].class)), Object[].class);
            }
            int n3 = 0;
            Object object = ((Node)((Object)((Object)this.head))).next;
            while (object != null) {
                a.arrayStore((Object[])objectArray, (int)n3++, (Object)((Node)((Object)object)).item);
                object = ((Node)((Object)object)).next;
            }
            if (a.arrayLength((Object[])objectArray) > n3) {
                a.arrayStore((Object[])objectArray, (int)n3, null);
            }
            object = objectArray;
            this.fullyUnlock();
            return object;
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        this.fullyLock();
        try {
            Node node = ((Node)((Object)((Object)this.head))).next;
            if (node == null) {
                String string = "[]";
                this.fullyUnlock();
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            while (true) {
                Object object;
                stringBuilder.append(!f.ifAcmp((Object)(object = ((Node)((Object)((Object)node))).item), (Object)this) ? "(this Collection)" : object);
                node = ((Node)((Object)((Object)node))).next;
                if (node == null) {
                    String string = stringBuilder.append(']').toString();
                    this.fullyUnlock();
                    return string;
                }
                stringBuilder.append(',').append(' ');
            }
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fullyLock();
        try {
            Node node;
            Node node2 = this.head;
            while ((node = ((Node)((Object)((Object)node2))).next) != null) {
                ((Node)((Object)((Object)node2))).next = node2;
                ((Node)((Object)((Object)node))).item = null;
                node2 = node;
            }
            this.head = this.last;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signal();
            }
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        int n3;
        ReentrantLock reentrantLock;
        boolean bl;
        block11: {
            int n4;
            if (collection == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            if (!f.ifAcmp(collection, (Object)this)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
            }
            bl = false;
            reentrantLock = this.takeLock;
            reentrantLock.lock();
            int n5 = Math.min(n2, this.count.get());
            Node node = this.head;
            try {
                for (n4 = 0; n4 < n5; ++n4) {
                    Node node2 = ((Node)((Object)((Object)node))).next;
                    collection.add(((Node)((Object)((Object)node2))).item);
                    ((Node)((Object)((Object)node2))).item = null;
                    ((Node)((Object)((Object)node))).next = node;
                    node = node2;
                }
                n3 = n5;
                if (n4 <= 0) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (n4 > 0) {
                        this.head = node;
                        bl = this.count.getAndAdd(-n4) == this.capacity;
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                catch (Throwable throwable2) {
                    reentrantLock.unlock();
                    if (bl) {
                        this.signalNotFull();
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable2);
                }
            }
            this.head = node;
            bl = this.count.getAndAdd(-n4) == this.capacity;
        }
        reentrantLock.unlock();
        if (bl) {
            this.signalNotFull();
        }
        return n3;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.fullyLock();
        try {
            objectOutputStream.defaultWriteObject();
            Node node = ((Node)((Object)((Object)this.head))).next;
            while (node != null) {
                objectOutputStream.writeObject(((Node)((Object)((Object)node))).item);
                node = ((Node)((Object)((Object)node))).next;
            }
            objectOutputStream.writeObject(null);
            this.fullyUnlock();
        }
        catch (Throwable throwable) {
            this.fullyUnlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count.set(0);
        Node node = new Node(null);
        this.head = node;
        this.last = node;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    private static /* synthetic */ void _jr$ip$capacity(LinkedBlockingQueue linkedBlockingQueue, int n2) {
        linkedBlockingQueue.capacity = n2;
    }

    private static /* synthetic */ void _jr$ip$count(LinkedBlockingQueue linkedBlockingQueue, AtomicInteger atomicInteger) {
        linkedBlockingQueue.count = atomicInteger;
    }

    private static /* synthetic */ void _jr$ip$takeLock(LinkedBlockingQueue linkedBlockingQueue, ReentrantLock reentrantLock) {
        linkedBlockingQueue.takeLock = reentrantLock;
    }

    private static /* synthetic */ void _jr$ip$notEmpty(LinkedBlockingQueue linkedBlockingQueue, Condition condition) {
        linkedBlockingQueue.notEmpty = condition;
    }

    private static /* synthetic */ void _jr$ip$putLock(LinkedBlockingQueue linkedBlockingQueue, ReentrantLock reentrantLock) {
        linkedBlockingQueue.putLock = reentrantLock;
    }

    private static /* synthetic */ void _jr$ip$notFull(LinkedBlockingQueue linkedBlockingQueue, Condition condition) {
        linkedBlockingQueue.notFull = condition;
    }

    protected /* synthetic */ LinkedBlockingQueue(h h2) {
        super(h2);
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    private class Itr
    extends h
    implements Iterator {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;
        final /* synthetic */ LinkedBlockingQueue this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr(LinkedBlockingQueue linkedBlockingQueue) {
            this.this$0 = linkedBlockingQueue;
            linkedBlockingQueue.fullyLock();
            try {
                this.current = ((Node)((Object)((Object)linkedBlockingQueue.head))).next;
                if (this.current != null) {
                    this.currentElement = ((Node)((Object)this.current)).item;
                }
                linkedBlockingQueue.fullyUnlock();
            }
            catch (Throwable throwable) {
                linkedBlockingQueue.fullyUnlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        private Node<E> nextNode(Node<E> node) {
            Node node2;
            while (f.ifAcmp((Object)((Object)(node2 = ((Node)((Object)node)).next)), node)) {
                if (node2 == null || ((Node)((Object)((Object)node2))).item != null) {
                    return node2;
                }
                node = node2;
            }
            return ((Node)((Object)((Object)((Itr)this).this$0.head))).next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object object;
            ((Itr)this).this$0.fullyLock();
            try {
                if (this.current == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                }
                Object object2 = this.currentElement;
                this.lastRet = this.current;
                this.current = this.nextNode(this.current);
                this.currentElement = this.current == null ? null : ((Node)((Object)((Object)this.current))).item;
                object = object2;
                ((Itr)this).this$0.fullyUnlock();
            }
            catch (Throwable throwable) {
                ((Itr)this).this$0.fullyUnlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException());
            }
            ((Itr)this).this$0.fullyLock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node node2 = ((Itr)this).this$0.head;
                Node node3 = ((Node)((Object)((Object)node2))).next;
                while (node3 != null) {
                    if (!f.ifAcmp((Object)((Object)node3), (Object)((Object)node))) {
                        ((Itr)this).this$0.unlink(node3, node2);
                        break;
                    }
                    node2 = node3;
                    node3 = ((Node)((Object)((Object)node3))).next;
                }
                ((Itr)this).this$0.fullyUnlock();
            }
            catch (Throwable throwable) {
                ((Itr)this).this$0.fullyUnlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, LinkedBlockingQueue linkedBlockingQueue) {
            ((Itr)object).this$0 = linkedBlockingQueue;
        }

        protected /* synthetic */ Itr(h h2) {
            super(h2);
        }
    }

    /*
     * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
     */
    static class Node
    extends h {
        E item;
        Node<E> next;

        Node(E e2) {
            this.item = e2;
        }

        protected /* synthetic */ Node(h h2) {
            super(h2);
        }
    }
}

