/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private final AtomicInteger ctl;
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock;
    private final HashSet<Worker> workers;
    private final Condition termination;
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;

    private static int runStateOf(int n2) {
        return n2 & 0xE0000000;
    }

    private static int workerCountOf(int n2) {
        return n2 & 0x1FFFFFFF;
    }

    private static int ctlOf(int n2, int n3) {
        return n2 | n3;
    }

    private static boolean runStateLessThan(int n2, int n3) {
        return n2 < n3;
    }

    private static boolean runStateAtLeast(int n2, int n3) {
        return n2 >= n3;
    }

    private static boolean isRunning(int n2) {
        return n2 < 0;
    }

    private boolean compareAndIncrementWorkerCount(int n2) {
        return this.ctl.compareAndSet(n2, n2 + 1);
    }

    private boolean compareAndDecrementWorkerCount(int n2) {
        return this.ctl.compareAndSet(n2, n2 - 1);
    }

    private void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    private void advanceRunState(int n2) {
        int n3;
        while (!ThreadPoolExecutor.runStateAtLeast(n3 = this.ctl.get(), n2) && !this.ctl.compareAndSet(n3, ThreadPoolExecutor.ctlOf(n2, ThreadPoolExecutor.workerCountOf(n3)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int n2;
        while (!(ThreadPoolExecutor.isRunning(n2 = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(n2, 0x40000000) || ThreadPoolExecutor.runStateOf(n2) == 0 && !this.workQueue.isEmpty())) {
            if (ThreadPoolExecutor.workerCountOf(n2) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                if (this.ctl.compareAndSet(n2, ThreadPoolExecutor.ctlOf(0x40000000, 0))) {
                    try {
                        this.terminated();
                        this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                        this.termination.signalAll();
                    }
                    catch (Throwable throwable) {
                        this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                        this.termination.signalAll();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                    reentrantLock.unlock();
                    return;
                }
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                for (Worker worker : this.workers) {
                    securityManager.checkAccess(worker.thread);
                }
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                worker.interruptIfStarted();
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void interruptIdleWorkers(boolean bl) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                Thread thread = worker.thread;
                if (!thread.isInterrupted() && worker.tryLock()) {
                    try {
                        thread.interrupt();
                    }
                    catch (SecurityException securityException) {
                        worker.unlock();
                        catch (Throwable throwable) {
                            worker.unlock();
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                    worker.unlock();
                }
                if (!bl) continue;
                break;
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    final void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    void onShutdown() {
    }

    final boolean isRunningOrShutdown(boolean bl) {
        int n2 = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return n2 == -536870912 || n2 == 0 && bl;
    }

    private List<Runnable> drainQueue() {
        BlockingQueue blockingQueue = this.workQueue;
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        blockingQueue.drainTo(arrayList);
        if (!blockingQueue.isEmpty()) {
            Object[] objectArray = (Runnable[])g.convertForCast((Object)blockingQueue.toArray(new Runnable[0]), Runnable[].class);
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                Runnable runnable = (Runnable)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Runnable.class);
                if (!blockingQueue.remove(runnable)) continue;
                arrayList.add(runnable);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable runnable, boolean bl) {
        boolean bl2;
        int n2;
        block4: while (true) {
            if ((n2 = ThreadPoolExecutor.runStateOf((bl2 = this.ctl.get()) ? 1 : 0)) >= 0 && (n2 != 0 || runnable != null || this.workQueue.isEmpty())) {
                return false;
            }
            do {
                int n3;
                if ((n3 = ThreadPoolExecutor.workerCountOf(bl2 ? 1 : 0)) >= 0x1FFFFFFF || n3 >= (bl ? this.corePoolSize : this.maximumPoolSize)) {
                    return false;
                }
                if (this.compareAndIncrementWorkerCount(bl2 ? 1 : 0)) break block4;
            } while (ThreadPoolExecutor.runStateOf((bl2 = this.ctl.get()) ? 1 : 0) == n2);
        }
        bl2 = false;
        n2 = 0;
        Worker worker = null;
        try {
            ReentrantLock reentrantLock = this.mainLock;
            worker = new Worker(runnable);
            Thread thread = worker.thread;
            if (thread != null) {
                reentrantLock.lock();
                try {
                    int n4 = this.ctl.get();
                    int n5 = ThreadPoolExecutor.runStateOf(n4);
                    if (n5 < 0 || n5 == 0 && runnable == null) {
                        if (thread._jr$jnim$isAlive()) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalThreadStateException());
                        }
                        this.workers.add(worker);
                        int n6 = this.workers.size();
                        if (n6 > this.largestPoolSize) {
                            this.largestPoolSize = n6;
                        }
                        n2 = 1;
                    }
                    reentrantLock.unlock();
                }
                catch (Throwable throwable) {
                    reentrantLock.unlock();
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
                if (n2 != 0) {
                    thread.start();
                    bl2 = true;
                }
            }
            if (!bl2) {
                this.addWorkerFailed(worker);
            }
        }
        catch (Throwable throwable) {
            if (!bl2) {
                this.addWorkerFailed(worker);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkerFailed(Worker worker) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (worker != null) {
                this.workers.remove(worker);
            }
            this.decrementWorkerCount();
            this.tryTerminate();
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker worker, boolean bl) {
        if (bl) {
            this.decrementWorkerCount();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            ThreadPoolExecutor threadPoolExecutor = this;
            threadPoolExecutor.completedTaskCount = threadPoolExecutor.completedTaskCount + worker.completedTasks;
            this.workers.remove(worker);
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.tryTerminate();
        int n2 = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(n2, 0x20000000)) {
            if (!bl) {
                int n3;
                int n4 = n3 = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
                if (n3 == 0 && !this.workQueue.isEmpty()) {
                    n3 = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(n2) >= n3) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean bl = false;
        while (true) {
            boolean bl2;
            block6: {
                int n2;
                int n3;
                if ((n3 = ThreadPoolExecutor.runStateOf(n2 = this.ctl.get())) >= 0 && (n3 >= 0x20000000 || this.workQueue.isEmpty())) {
                    this.decrementWorkerCount();
                    return null;
                }
                do {
                    int n4 = ThreadPoolExecutor.workerCountOf(n2);
                    boolean bl3 = bl2 = this.allowCoreThreadTimeOut || n4 > this.corePoolSize;
                    if (n4 <= this.maximumPoolSize && (!bl || !bl2)) break block6;
                    if (!this.compareAndDecrementWorkerCount(n2)) continue;
                    return null;
                } while (ThreadPoolExecutor.runStateOf(n2 = this.ctl.get()) == n3);
                continue;
            }
            try {
                Runnable runnable;
                Runnable runnable2 = runnable = bl2 ? (Runnable)g.convertForCast(this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS), Runnable.class) : (Runnable)g.convertForCast(this.workQueue.take(), Runnable.class);
                if (runnable != null) {
                    return runnable;
                }
                bl = true;
                continue;
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void runWorker(Worker var1_1) {
        var2_2 = Thread.currentThread();
        var3_3 = var1_1.firstTask;
        var1_1.firstTask = null;
        var1_1.unlock();
        var4_4 = true;
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                if (var3_3 == null && (var3_3 = this.getTask()) == null) {
                    var4_4 = false;
                    this.processWorkerExit(var1_1, var4_4);
                    return;
                }
                var1_1.lock();
                if ((ThreadPoolExecutor.runStateAtLeast(ThreadPoolExecutor._jr$ig$ctl(this).get(), 0x20000000) || Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(ThreadPoolExecutor._jr$ig$ctl(this).get(), 0x20000000)) && !var2_2.isInterrupted()) {
                    var2_2.interrupt();
                }
                try {
                    this.beforeExecute(var2_2, var3_3);
                    var5_5 /* !! */  = null;
                    try {
                        var3_3.run();
                    }
                    catch (RuntimeException var6_6) {
                        try {
                            var5_5 /* !! */  = var6_6;
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var6_6);
                            catch (Error var6_7) {
                                var5_5 /* !! */  = var6_7;
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var6_7);
                            }
                            catch (Throwable var6_8) {
                                var5_5 /* !! */  = var6_8;
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(var6_8));
                            }
                        }
                        catch (Throwable var7_9) {
                            this.afterExecute(var3_3, var5_5 /* !! */ );
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var7_9);
                        }
                    }
                    this.afterExecute(var3_3, var5_5 /* !! */ );
                    var3_3 = null;
                    ++var1_1.completedTasks;
                    var1_1.unlock();
                    continue;
                }
                catch (Throwable var8_10) {
                    var3_3 = null;
                    ++var1_1.completedTasks;
                    var1_1.unlock();
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var8_10);
                }
                break;
            }
        }
        catch (Throwable var9_11) {
            this.processWorkerExit(var1_1, var4_4);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)var9_11);
        }
        {
            ** while (true)
        }
    }

    public ThreadPoolExecutor(int n2, int n3, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n2, n3, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n2, int n3, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n2, n3, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n2, int n3, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n2, n3, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n2, int n3, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
        this.mainLock = new ReentrantLock();
        this.workers = new HashSet();
        this.termination = this.mainLock.newCondition();
        if (n2 < 0 || n3 <= 0 || n3 < n2 || l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.corePoolSize = n2;
        this.maximumPoolSize = n3;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        int n2 = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(n2) < this.corePoolSize) {
            if (this.addWorker(runnable, true)) {
                return;
            }
            n2 = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(n2) && this.workQueue.offer(runnable)) {
            int n3 = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(n3) && this.remove(runnable)) {
                this.reject(runnable);
            } else if (ThreadPoolExecutor.workerCountOf(n3) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(runnable, false)) {
            this.reject(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.tryTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> list;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            list = this.drainQueue();
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        this.tryTerminate();
        return list;
    }

    @Override
    public boolean isShutdown() {
        return !ThreadPoolExecutor.isRunning(this.ctl.get());
    }

    public boolean isTerminating() {
        int n2 = this.ctl.get();
        return !ThreadPoolExecutor.isRunning(n2) && ThreadPoolExecutor.runStateLessThan(n2, 0x60000000);
    }

    @Override
    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                    boolean bl = true;
                    reentrantLock.unlock();
                    return bl;
                }
                if (l2 <= 0L) {
                    boolean bl = false;
                    reentrantLock.unlock();
                    return bl;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    protected void finalize() {
        if (!this._jr$iCur()) {
            return;
        }
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int n2) {
        block3: {
            int n3;
            block2: {
                if (n2 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
                }
                n3 = n2 - this.corePoolSize;
                this.corePoolSize = n2;
                if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) <= n2) break block2;
                this.interruptIdleWorkers();
                break block3;
            }
            if (n3 <= 0) break block3;
            int n4 = Math.min(n3, this.workQueue.size());
            while (n4-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    void ensurePrestart() {
        int n2 = ThreadPoolExecutor.workerCountOf(this.ctl.get());
        if (n2 < this.corePoolSize) {
            this.addWorker(null, true);
        } else if (n2 == 0) {
            this.addWorker(null, false);
        }
    }

    public int prestartAllCoreThreads() {
        int n2 = 0;
        while (this.addWorker(null, true)) {
            ++n2;
        }
        return n2;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean bl) {
        if (bl && this.keepAliveTime <= 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Core threads must have nonzero keep alive times"));
        }
        if (bl != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = bl;
            if (bl) {
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int n2) {
        if (n2 <= 0 || n2 < this.corePoolSize) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        this.maximumPoolSize = n2;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > n2) {
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (l == 0L && this.allowsCoreThreadTimeOut()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Core threads must have nonzero keep alive times"));
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = l2 - this.keepAliveTime;
        this.keepAliveTime = l2;
        if (l3 < 0L) {
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        boolean bl = this.workQueue.remove(runnable);
        this.tryTerminate();
        return bl;
    }

    public void purge() {
        BlockingQueue blockingQueue = this.workQueue;
        try {
            Iterator iterator = blockingQueue.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)g.convertForCast(iterator.next(), Runnable.class);
                if (!(g.convertForInstanceOf((Object)runnable, Future.class) instanceof Future) || !((Future)g.convertForCast((Object)runnable, Future.class)).isCancelled()) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Object[] objectArray = blockingQueue.toArray();
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                Object object = a.arrayLoad((Object[])objectArray, (int)i);
                if (!(g.convertForInstanceOf((Object)object, Future.class) instanceof Future) || !((Future)g.convertForCast((Object)object, Future.class)).isCancelled()) continue;
                blockingQueue.remove(object);
            }
        }
        this.tryTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = 0;
            for (Worker worker : this.workers) {
                if (!worker.isLocked()) continue;
                ++n2;
            }
            int n3 = n2;
            reentrantLock.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = this.largestPoolSize;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
                if (!worker.isLocked()) continue;
                ++l;
            }
            long l2 = l + (long)this.workQueue.size();
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
            }
            long l2 = l;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object2;
        int n2;
        int n3;
        long l;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            l = this.completedTaskCount;
            n3 = 0;
            n2 = this.workers.size();
            for (Object object2 : this.workers) {
                l += ((Worker)object2).completedTasks;
                if (!((Worker)object2).isLocked()) continue;
                ++n3;
            }
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        int n4 = this.ctl.get();
        object2 = ThreadPoolExecutor.runStateLessThan(n4, 0) ? "Running" : (ThreadPoolExecutor.runStateAtLeast(n4, 0x60000000) ? "Terminated" : "Shutting down");
        return super.toString() + "[" + (String)object2 + ", pool size = " + n2 + ", active threads = " + n3 + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + l + "]";
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    private static /* synthetic */ void _jr$ip$ctl(ThreadPoolExecutor threadPoolExecutor, AtomicInteger atomicInteger) {
        threadPoolExecutor.ctl = atomicInteger;
    }

    private static /* synthetic */ void _jr$ip$workQueue(ThreadPoolExecutor threadPoolExecutor, BlockingQueue blockingQueue) {
        threadPoolExecutor.workQueue = blockingQueue;
    }

    private static /* synthetic */ void _jr$ip$mainLock(ThreadPoolExecutor threadPoolExecutor, ReentrantLock reentrantLock) {
        threadPoolExecutor.mainLock = reentrantLock;
    }

    private static /* synthetic */ void _jr$ip$workers(ThreadPoolExecutor threadPoolExecutor, HashSet hashSet) {
        threadPoolExecutor.workers = hashSet;
    }

    private static /* synthetic */ void _jr$ip$termination(ThreadPoolExecutor threadPoolExecutor, Condition condition) {
        threadPoolExecutor.termination = condition;
    }

    protected /* synthetic */ ThreadPoolExecutor(h h2) {
        super(h2);
    }

    public static class AbortPolicy
    extends h
    implements RejectedExecutionHandler {
        public AbortPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RejectedExecutionException("Task " + runnable.toString() + " rejected from " + threadPoolExecutor.toString()));
        }

        protected /* synthetic */ AbortPolicy(h h2) {
            super(h2);
        }
    }

    public static class CallerRunsPolicy
    extends h
    implements RejectedExecutionHandler {
        public CallerRunsPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }

        protected /* synthetic */ CallerRunsPolicy(h h2) {
            super(h2);
        }
    }

    public static class DiscardOldestPolicy
    extends h
    implements RejectedExecutionHandler {
        public DiscardOldestPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }

        protected /* synthetic */ DiscardOldestPolicy(h h2) {
            super(h2);
        }
    }

    public static class DiscardPolicy
    extends h
    implements RejectedExecutionHandler {
        public DiscardPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }

        protected /* synthetic */ DiscardPolicy(h h2) {
            super(h2);
        }
    }

    private final class Worker
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable runnable) {
            this.setState(-1);
            this.firstTask = runnable;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        @Override
        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int n2) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int n2) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        public void lock() {
            this.acquire(1);
        }

        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        public void unlock() {
            this.release(1);
        }

        public boolean isLocked() {
            return this.isHeldExclusively();
        }

        void interruptIfStarted() {
            Thread thread;
            if (this.getState() >= 0 && (thread = this.thread) != null && !thread.isInterrupted()) {
                try {
                    thread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Thread _jr$ig$thread(Object object) {
            return ((Worker)object).thread;
        }

        static /* synthetic */ void _jr$ip$thread(Object object, Thread thread) {
            ((Worker)object).thread = thread;
        }

        static /* synthetic */ Runnable _jr$ig$firstTask(Object object) {
            return ((Worker)object).firstTask;
        }

        static /* synthetic */ void _jr$ip$firstTask(Object object, Runnable runnable) {
            ((Worker)object).firstTask = runnable;
        }

        static /* synthetic */ long _jr$ig$completedTasks(Object object) {
            return ((Worker)object).completedTasks;
        }

        static /* synthetic */ void _jr$ip$completedTasks(Object object, long l) {
            ((Worker)object).completedTasks = l;
        }

        static /* synthetic */ ThreadPoolExecutor _jr$ig$this$0(Object object) {
            return ((Worker)object).ThreadPoolExecutor.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ThreadPoolExecutor threadPoolExecutor) {
            ((Worker)object).ThreadPoolExecutor.this = threadPoolExecutor;
        }
    }
}

