/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import com.zeroturnaround.jrebelbase.h;
import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicIntegerArray
extends h
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(int[].class);
    private static final int shift;
    private final int[] array;

    private long checkedByteOffset(int n2) {
        if (n2 < 0 || n2 >= this.array.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("index " + n2));
        }
        return AtomicIntegerArray.byteOffset(n2);
    }

    private static long byteOffset(int n2) {
        return ((long)n2 << shift) + (long)base;
    }

    public AtomicIntegerArray(int n2) {
        this.array = new int[n2];
    }

    public AtomicIntegerArray(int[] nArray) {
        this.array = (int[])nArray.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final int get(int n2) {
        return this.getRaw(this.checkedByteOffset(n2));
    }

    private int getRaw(long l) {
        return unsafe.getIntVolatile(this.array, l);
    }

    public final void set(int n2, int n3) {
        unsafe.putIntVolatile(this.array, this.checkedByteOffset(n2), n3);
    }

    public final void lazySet(int n2, int n3) {
        unsafe.putOrderedInt(this.array, this.checkedByteOffset(n2), n3);
    }

    public final int getAndSet(int n2, int n3) {
        int n4;
        long l = this.checkedByteOffset(n2);
        while (!this.compareAndSetRaw(l, n4 = this.getRaw(l), n3)) {
        }
        return n4;
    }

    public final boolean compareAndSet(int n2, int n3, int n4) {
        return this.compareAndSetRaw(this.checkedByteOffset(n2), n3, n4);
    }

    private boolean compareAndSetRaw(long l, int n2, int n3) {
        return unsafe.compareAndSwapInt(this.array, l, n2, n3);
    }

    public final boolean weakCompareAndSet(int n2, int n3, int n4) {
        return this.compareAndSet(n2, n3, n4);
    }

    public final int getAndIncrement(int n2) {
        return this.getAndAdd(n2, 1);
    }

    public final int getAndDecrement(int n2) {
        return this.getAndAdd(n2, -1);
    }

    public final int getAndAdd(int n2, int n3) {
        int n4;
        long l = this.checkedByteOffset(n2);
        while (!this.compareAndSetRaw(l, n4 = this.getRaw(l), n4 + n3)) {
        }
        return n4;
    }

    public final int incrementAndGet(int n2) {
        return this.addAndGet(n2, 1);
    }

    public final int decrementAndGet(int n2) {
        return this.addAndGet(n2, -1);
    }

    public final int addAndGet(int n2, int n3) {
        int n4;
        int n5;
        long l = this.checkedByteOffset(n2);
        while (!this.compareAndSetRaw(l, n5 = this.getRaw(l), n4 = n5 + n3)) {
        }
        return n4;
    }

    public String toString() {
        int n2 = this.array.length - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(this.getRaw(AtomicIntegerArray.byteOffset(n3)));
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n3;
        }
    }

    static {
        int n2 = unsafe.arrayIndexScale(int[].class);
        if ((n2 & n2 - 1) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("data type scale not a power of two"));
        }
        shift = 31 - Integer.numberOfLeadingZeros(n2);
    }

    private static /* synthetic */ void _jr$ip$array(AtomicIntegerArray atomicIntegerArray, int[] nArray) {
        atomicIntegerArray.array = nArray;
    }

    protected /* synthetic */ AtomicIntegerArray(h h2) {
        super(h2);
    }
}

