/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.h;
import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    static final boolean VM_SUPPORTS_LONG_CAS;
    private volatile long value;

    private static native boolean VMSupportsCS8();

    public AtomicLong(long l2) {
        this.value = l2;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long l2) {
        this.value = l2;
    }

    public final void lazySet(long l2) {
        unsafe.putOrderedLong(this, valueOffset, l2);
    }

    public final long getAndSet(long l2) {
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2)) {
        }
        return l3;
    }

    public final boolean compareAndSet(long l2, long l3) {
        return unsafe.compareAndSwapLong(this, valueOffset, l2, l3);
    }

    public final boolean weakCompareAndSet(long l2, long l3) {
        return unsafe.compareAndSwapLong(this, valueOffset, l2, l3);
    }

    public final long getAndIncrement() {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 + 1L)) {
        }
        return l3;
    }

    public final long getAndDecrement() {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 - 1L)) {
        }
        return l3;
    }

    public final long getAndAdd(long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(l4 = this.get(), l3 = l4 + l2)) {
        }
        return l4;
    }

    public final long incrementAndGet() {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 + 1L)) {
        }
        return l2;
    }

    public final long decrementAndGet() {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 - 1L)) {
        }
        return l2;
    }

    public final long addAndGet(long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(l4 = this.get(), l3 = l4 + l2)) {
        }
        return l3;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    static {
        VM_SUPPORTS_LONG_CAS = AtomicLong.VMSupportsCS8();
        try {
            valueOffset = unsafe.objectFieldOffset(ai.getCurrentClass(AtomicLong.class).getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    protected /* synthetic */ AtomicLong(h h2) {
        super(h2);
    }
}

