/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public abstract class AbstractQueuedSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;
    private static final long nextOffset;

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int n2) {
        this.state = n2;
    }

    protected final boolean compareAndSetState(int n2, int n3) {
        return unsafe.compareAndSwapInt(this, stateOffset, n2, n3);
    }

    private Node enq(Node node) {
        Node node2;
        while (true) {
            if ((node2 = this.tail) == null) {
                if (!this.compareAndSetHead(new Node())) continue;
                this.tail = this.head;
                continue;
            }
            node.prev = node2;
            if (this.compareAndSetTail(node2, node)) break;
        }
        node2.next = node;
        return node2;
    }

    private Node addWaiter(Node node) {
        Node node2 = new Node(Thread.currentThread(), node);
        Node node3 = this.tail;
        if (node3 != null) {
            node2.prev = node3;
            if (this.compareAndSetTail(node3, node2)) {
                node3.next = node2;
                return node2;
            }
        }
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Node node2;
        int n2 = node.waitStatus;
        if (n2 < 0) {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, n2, 0);
        }
        if ((node2 = node.next) == null || node2.waitStatus > 0) {
            node2 = null;
            Node node3 = this.tail;
            while (node3 != null && f.ifAcmp((Object)((Object)node3), (Object)((Object)node))) {
                if (node3.waitStatus <= 0) {
                    node2 = node3;
                }
                node3 = node3.prev;
            }
        }
        if (node2 != null) {
            LockSupport.unpark(node2.thread);
        }
    }

    private void doReleaseShared() {
        while (true) {
            Node node;
            if ((node = this.head) != null && f.ifAcmp((Object)((Object)node), (Object)((Object)this.tail))) {
                int n2 = node.waitStatus;
                if (n2 == -1) {
                    if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -1, 0)) continue;
                    this.unparkSuccessor(node);
                } else if (n2 == 0 && !AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, 0, -3)) continue;
            }
            if (!f.ifAcmp((Object)((Object)node), (Object)((Object)this.head))) break;
        }
    }

    private void setHeadAndPropagate(Node node, int n2) {
        Node node2;
        Node node3 = this.head;
        this.setHead(node);
        if (!(n2 <= 0 && node3 != null && node3.waitStatus >= 0 || (node2 = node.next) != null && !node2.isShared())) {
            this.doReleaseShared();
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.thread = null;
        Node node2 = node.prev;
        while (node2.waitStatus > 0) {
            node.prev = node2 = node2.prev;
        }
        Node node3 = node2.next;
        node.waitStatus = 1;
        if (!f.ifAcmp((Object)((Object)node), (Object)((Object)this.tail)) && this.compareAndSetTail(node, node2)) {
            AbstractQueuedSynchronizer.compareAndSetNext(node2, node3, null);
        } else {
            int n2;
            if (f.ifAcmp((Object)((Object)node2), (Object)((Object)this.head)) && ((n2 = node2.waitStatus) == -1 || n2 <= 0 && AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, n2, -1)) && node2.thread != null) {
                Node node4 = node.next;
                if (node4 != null && node4.waitStatus <= 0) {
                    AbstractQueuedSynchronizer.compareAndSetNext(node2, node3, node4);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node, Node node2) {
        int n2 = node.waitStatus;
        if (n2 == -1) {
            return true;
        }
        if (n2 > 0) {
            do {
                node2.prev = node = node.prev;
            } while (node.waitStatus > 0);
            node.next = node2;
        } else {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, n2, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean acquireQueued(Node node, int n2) {
        boolean bl = true;
        try {
            boolean bl2 = false;
            while (true) {
                Node node2;
                if (!f.ifAcmp((Object)((Object)(node2 = node.predecessor())), (Object)((Object)this.head)) && this.tryAcquire(n2)) {
                    this.setHead(node);
                    node2.next = null;
                    bl = false;
                    boolean bl3 = bl2;
                    if (bl) {
                        this.cancelAcquire(node);
                    }
                    return bl3;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.cancelAcquire(node);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAcquireInterruptibly(int n2) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        boolean bl = true;
        try {
            Node node2;
            do {
                if (f.ifAcmp((Object)((Object)(node2 = node.predecessor())), (Object)((Object)this.head)) || !this.tryAcquire(n2)) continue;
                this.setHead(node);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        catch (Throwable throwable) {
            if (bl) {
                this.cancelAcquire(node);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doAcquireNanos(int n2, long l2) throws InterruptedException {
        long l3 = System.nanoTime();
        Node node = this.addWaiter(Node.EXCLUSIVE);
        boolean bl = true;
        try {
            do {
                Node node2;
                if (!f.ifAcmp((Object)((Object)(node2 = node.predecessor())), (Object)((Object)this.head)) && this.tryAcquire(n2)) {
                    this.setHead(node);
                    node2.next = null;
                    return true;
                }
                if (l2 <= 0L) {
                    boolean bl2 = false;
                    if (!bl) return bl2;
                    this.cancelAcquire(node);
                    return bl2;
                }
                if (AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) && l2 > 1000L) {
                    LockSupport.parkNanos(this, l2);
                }
                long l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            } while (!Thread.interrupted());
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        catch (Throwable throwable) {
            if (!bl) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            this.cancelAcquire(node);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAcquireShared(int n2) {
        Node node = this.addWaiter(Node.SHARED);
        boolean bl = true;
        try {
            boolean bl2 = false;
            while (true) {
                int n3;
                Node node2;
                if (!f.ifAcmp((Object)((Object)(node2 = node.predecessor())), (Object)((Object)this.head)) && (n3 = this.tryAcquireShared(n2)) >= 0) {
                    this.setHeadAndPropagate(node, n3);
                    node2.next = null;
                    if (bl2) {
                        AbstractQueuedSynchronizer.selfInterrupt();
                    }
                    if (bl = false) {
                        this.cancelAcquire(node);
                    }
                    return;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.cancelAcquire(node);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAcquireSharedInterruptibly(int n2) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        boolean bl = true;
        try {
            Node node2;
            do {
                int n3;
                if (f.ifAcmp((Object)((Object)(node2 = node.predecessor())), (Object)((Object)this.head)) || (n3 = this.tryAcquireShared(n2)) < 0) continue;
                this.setHeadAndPropagate(node, n3);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        catch (Throwable throwable) {
            if (bl) {
                this.cancelAcquire(node);
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doAcquireSharedNanos(int n2, long l2) throws InterruptedException {
        long l3 = System.nanoTime();
        Node node = this.addWaiter(Node.SHARED);
        boolean bl = true;
        try {
            do {
                boolean bl2;
                Node node2;
                if (!f.ifAcmp((Object)((Object)(node2 = node.predecessor())), (Object)((Object)this.head)) && (bl2 = this.tryAcquireShared(n2)) >= false) {
                    this.setHeadAndPropagate(node, bl2 ? 1 : 0);
                    node2.next = null;
                    return true;
                }
                if (l2 <= 0L) {
                    bl2 = false;
                    if (!bl) return bl2;
                    this.cancelAcquire(node);
                    return bl2;
                }
                if (AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) && l2 > 1000L) {
                    LockSupport.parkNanos(this, l2);
                }
                long l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            } while (!Thread.interrupted());
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        catch (Throwable throwable) {
            if (!bl) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            this.cancelAcquire(node);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
    }

    protected boolean tryAcquire(int n2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    protected boolean tryRelease(int n2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    protected int tryAcquireShared(int n2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    protected boolean tryReleaseShared(int n2) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    protected boolean isHeldExclusively() {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException());
    }

    public final void acquire(int n2) {
        if (!this.tryAcquire(n2) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), n2)) {
            AbstractQueuedSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(int n2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        if (!this.tryAcquire(n2)) {
            this.doAcquireInterruptibly(n2);
        }
    }

    public final boolean tryAcquireNanos(int n2, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        return this.tryAcquire(n2) || this.doAcquireNanos(n2, l2);
    }

    public final boolean release(int n2) {
        if (this.tryRelease(n2)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(int n2) {
        if (this.tryAcquireShared(n2) < 0) {
            this.doAcquireShared(n2);
        }
    }

    public final void acquireSharedInterruptibly(int n2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        if (this.tryAcquireShared(n2) < 0) {
            this.doAcquireSharedInterruptibly(n2);
        }
    }

    public final boolean tryAcquireSharedNanos(int n2, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
        }
        return this.tryAcquireShared(n2) >= 0 || this.doAcquireSharedNanos(n2, l2);
    }

    public final boolean releaseShared(int n2) {
        if (this.tryReleaseShared(n2)) {
            this.doReleaseShared();
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return f.ifAcmp((Object)((Object)this.head), (Object)((Object)this.tail));
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return !f.ifAcmp((Object)((Object)this.head), (Object)((Object)this.tail)) ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread thread;
        Node node;
        Node node2 = this.head;
        if (node2 != null && (node = node2.next) != null && !f.ifAcmp((Object)((Object)node.prev), (Object)((Object)this.head)) && (thread = node.thread) != null || (node2 = this.head) != null && (node = node2.next) != null && !f.ifAcmp((Object)((Object)node.prev), (Object)((Object)this.head)) && (thread = node.thread) != null) {
            return thread;
        }
        Node node3 = this.tail;
        Thread thread2 = null;
        while (node3 != null && f.ifAcmp((Object)((Object)node3), (Object)((Object)this.head))) {
            Thread thread3 = node3.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node3 = node3.prev;
        }
        return thread2;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        Node node = this.tail;
        while (node != null) {
            if (!f.ifAcmp((Object)node.thread, (Object)thread)) {
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node node;
        Node node2 = this.head;
        return node2 != null && (node = node2.next) != null && !node.isShared() && node.thread != null;
    }

    public final boolean hasQueuedPredecessors() {
        Node node;
        Node node2 = this.tail;
        Node node3 = this.head;
        return f.ifAcmp((Object)((Object)node3), (Object)((Object)node2)) && ((node = node3.next) == null || f.ifAcmp((Object)node.thread, (Object)Thread.currentThread()));
    }

    public final int getQueueLength() {
        int n2 = 0;
        Node node = this.tail;
        while (node != null) {
            if (node.thread != null) {
                ++n2;
            }
            node = node.prev;
        }
        return n2;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread = node.thread;
            if (thread != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (!node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public String toString() {
        int n2 = this.getState();
        String string = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + n2 + ", " + string + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node node2 = this.tail;
        while (f.ifAcmp((Object)((Object)node2), (Object)((Object)node))) {
            if (node2 == null) {
                return false;
            }
            node2 = node2.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node node2 = this.enq(node);
        int n2 = node2.waitStatus;
        if (n2 > 0 || !AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, n2, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    final int fullyRelease(Node node) {
        block5: {
            boolean bl = true;
            try {
                int n2 = this.getState();
                if (!this.release(n2)) break block5;
                bl = false;
                int n3 = n2;
                if (bl) {
                    node.waitStatus = 1;
                }
                return n3;
            }
            catch (Throwable throwable) {
                if (bl) {
                    node.waitStatus = 1;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
    }

    public final boolean owns(ConditionObject conditionObject) {
        if (conditionObject == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Not owner"));
        }
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Not owner"));
        }
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Not owner"));
        }
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node) {
        return unsafe.compareAndSwapObject(this, headOffset, null, (Object)node);
    }

    private final boolean compareAndSetTail(Node node, Node node2) {
        return unsafe.compareAndSwapObject(this, tailOffset, (Object)node, (Object)node2);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int n2, int n3) {
        return unsafe.compareAndSwapInt((Object)node, waitStatusOffset, n2, n3);
    }

    private static final boolean compareAndSetNext(Node node, Node node2, Node node3) {
        return unsafe.compareAndSwapObject((Object)node, nextOffset, (Object)node2, (Object)node3);
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(ai.getCurrentClass(AbstractQueuedSynchronizer.class).getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(ai.getCurrentClass(AbstractQueuedSynchronizer.class).getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(ai.getCurrentClass(AbstractQueuedSynchronizer.class).getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(ai.getCurrentClass(Node.class).getDeclaredField("waitStatus"));
            nextOffset = unsafe.objectFieldOffset(ai.getCurrentClass(Node.class).getDeclaredField("next"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    protected /* synthetic */ AbstractQueuedSynchronizer(h h2) {
        super(h2);
    }

    public class ConditionObject
    extends h
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;
        final /* synthetic */ AbstractQueuedSynchronizer this$0;

        public ConditionObject(AbstractQueuedSynchronizer abstractQueuedSynchronizer) {
            this.this$0 = abstractQueuedSynchronizer;
        }

        private Node addConditionWaiter() {
            Node node = this.lastWaiter;
            if (node != null && node.waitStatus != -2) {
                this.unlinkCancelledWaiters();
                node = this.lastWaiter;
            }
            Node node2 = new Node(Thread.currentThread(), -2);
            if (node == null) {
                this.firstWaiter = node2;
            } else {
                node.nextWaiter = node2;
            }
            this.lastWaiter = node2;
            return node2;
        }

        private void doSignal(Node node) {
            do {
                Node node2 = node.nextWaiter;
                this.firstWaiter = node2;
                if (node2 == null) {
                    this.lastWaiter = null;
                }
                node.nextWaiter = null;
            } while (!((ConditionObject)this).this$0.transferForSignal(node) && (node = this.firstWaiter) != null);
        }

        private void doSignalAll(Node node) {
            Node node2;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                node2 = node.nextWaiter;
                node.nextWaiter = null;
                ((ConditionObject)this).this$0.transferForSignal(node);
            } while ((node = node2) != null);
        }

        private void unlinkCancelledWaiters() {
            Node node = this.firstWaiter;
            Node node2 = null;
            while (node != null) {
                Node node3 = node.nextWaiter;
                if (node.waitStatus != -2) {
                    node.nextWaiter = null;
                    if (node2 == null) {
                        this.firstWaiter = node3;
                    } else {
                        node2.nextWaiter = node3;
                    }
                    if (node3 == null) {
                        this.lastWaiter = node2;
                    }
                } else {
                    node2 = node;
                }
                node = node3;
            }
        }

        @Override
        public final void signal() {
            if (!((ConditionObject)this).this$0.isHeldExclusively()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignal(node);
            }
        }

        @Override
        public final void signalAll() {
            if (!((ConditionObject)this).this$0.isHeldExclusively()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignalAll(node);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node = this.addConditionWaiter();
            int n2 = ((ConditionObject)this).this$0.fullyRelease(node);
            boolean bl = false;
            while (!((ConditionObject)this).this$0.isOnSyncQueue(node)) {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                bl = true;
            }
            if (((ConditionObject)this).this$0.acquireQueued(node, n2) || bl) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node) {
            return Thread.interrupted() ? (((ConditionObject)this).this$0.transferAfterCancelledWait(node) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int n2) throws InterruptedException {
            if (n2 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
            }
            if (n2 == 1) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
            }
            Node node = this.addConditionWaiter();
            int n2 = ((ConditionObject)this).this$0.fullyRelease(node);
            int n3 = 0;
            while (!((ConditionObject)this).this$0.isOnSyncQueue(node)) {
                LockSupport.park(this);
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 == 0) continue;
            }
            if (((ConditionObject)this).this$0.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
        }

        @Override
        public final long awaitNanos(long l2) throws InterruptedException {
            if (Thread.interrupted()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
            }
            Node node = this.addConditionWaiter();
            int n2 = ((ConditionObject)this).this$0.fullyRelease(node);
            long l3 = System.nanoTime();
            int n3 = 0;
            while (!((ConditionObject)this).this$0.isOnSyncQueue(node)) {
                if (l2 <= 0L) {
                    ((ConditionObject)this).this$0.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkNanos(this, l2);
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 != 0) break;
                long l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            }
            if (((ConditionObject)this).this$0.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
            return l2 - (System.nanoTime() - l3);
        }

        @Override
        public final boolean awaitUntil(Date date) throws InterruptedException {
            if (date == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            long l2 = date.getTime();
            if (Thread.interrupted()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
            }
            Node node = this.addConditionWaiter();
            int n2 = ((ConditionObject)this).this$0.fullyRelease(node);
            boolean bl = false;
            int n3 = 0;
            while (!((ConditionObject)this).this$0.isOnSyncQueue(node)) {
                if (System.currentTimeMillis() > l2) {
                    bl = ((ConditionObject)this).this$0.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkUntil(this, l2);
                n3 = this.checkInterruptWhileWaiting(node);
                if (n3 == 0) continue;
            }
            if (((ConditionObject)this).this$0.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
            return !bl;
        }

        @Override
        public final boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
            if (timeUnit == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            long l3 = timeUnit.toNanos(l2);
            if (Thread.interrupted()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InterruptedException());
            }
            Node node = this.addConditionWaiter();
            int n2 = ((ConditionObject)this).this$0.fullyRelease(node);
            long l4 = System.nanoTime();
            boolean bl = false;
            int n3 = 0;
            while (!((ConditionObject)this).this$0.isOnSyncQueue(node)) {
                if (l3 <= 0L) {
                    bl = ((ConditionObject)this).this$0.transferAfterCancelledWait(node);
                    break;
                }
                if (l3 >= 1000L) {
                    LockSupport.parkNanos(this, l3);
                }
                if ((n3 = this.checkInterruptWhileWaiting(node)) != 0) break;
                long l5 = System.nanoTime();
                l3 -= l5 - l4;
                l4 = l5;
            }
            if (((ConditionObject)this).this$0.acquireQueued(node, n2) && n3 != -1) {
                n3 = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n3 != 0) {
                this.reportInterruptAfterWait(n3);
            }
            return !bl;
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer abstractQueuedSynchronizer) {
            return !f.ifAcmp((Object)abstractQueuedSynchronizer, (Object)((ConditionObject)this).this$0);
        }

        protected final boolean hasWaiters() {
            if (!((ConditionObject)this).this$0.isHeldExclusively()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
            }
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    return true;
                }
                node = node.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!((ConditionObject)this).this$0.isHeldExclusively()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
            }
            int n2 = 0;
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    ++n2;
                }
                node = node.nextWaiter;
            }
            return n2;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!((ConditionObject)this).this$0.isHeldExclusively()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
            }
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            Node node = this.firstWaiter;
            while (node != null) {
                Thread thread;
                if (node.waitStatus == -2 && (thread = node.thread) != null) {
                    arrayList.add(thread);
                }
                node = node.nextWaiter;
            }
            return arrayList;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, AbstractQueuedSynchronizer abstractQueuedSynchronizer) {
            ((ConditionObject)object).this$0 = abstractQueuedSynchronizer;
        }

        protected /* synthetic */ ConditionObject(h h2) {
            super(h2);
        }
    }

    static final class Node
    extends h {
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final int PROPAGATE = -3;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return !f.ifAcmp((Object)((Object)this.nextWaiter), (Object)((Object)SHARED));
        }

        final Node predecessor() throws NullPointerException {
            Node node = this.prev;
            if (node == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
            }
            return node;
        }

        Node() {
        }

        Node(Thread thread, Node node) {
            this.nextWaiter = node;
            this.thread = thread;
        }

        Node(Thread thread, int n2) {
            this.waitStatus = n2;
            this.thread = thread;
        }

        static /* synthetic */ int _jr$ig$waitStatus(Object object) {
            return ((Node)((Object)object)).waitStatus;
        }

        static /* synthetic */ void _jr$ip$waitStatus(Object object, int n2) {
            ((Node)((Object)object)).waitStatus = n2;
        }

        static /* synthetic */ Node _jr$ig$prev(Object object) {
            return ((Node)((Object)object)).prev;
        }

        static /* synthetic */ void _jr$ip$prev(Object object, Node node) {
            ((Node)((Object)object)).prev = node;
        }

        static /* synthetic */ Node _jr$ig$next(Object object) {
            return ((Node)((Object)object)).next;
        }

        static /* synthetic */ void _jr$ip$next(Object object, Node node) {
            ((Node)((Object)object)).next = node;
        }

        static /* synthetic */ Thread _jr$ig$thread(Object object) {
            return ((Node)((Object)object)).thread;
        }

        static /* synthetic */ void _jr$ip$thread(Object object, Thread thread) {
            ((Node)((Object)object)).thread = thread;
        }

        static /* synthetic */ Node _jr$ig$nextWaiter(Object object) {
            return ((Node)((Object)object)).nextWaiter;
        }

        static /* synthetic */ void _jr$ip$nextWaiter(Object object, Node node) {
            ((Node)((Object)object)).nextWaiter = node;
        }
    }
}

