/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.h;
import sun.misc.Unsafe;

public class LockSupport
extends h {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long parkBlockerOffset;

    private LockSupport() {
    }

    private static void setBlocker(Thread thread, Object object) {
        unsafe.putObject((Object)thread, parkBlockerOffset, object);
    }

    public static void unpark(Thread thread) {
        if (thread != null) {
            unsafe.unpark(thread);
        }
    }

    public static void park(Object object) {
        Thread thread = Thread.currentThread();
        LockSupport.setBlocker(thread, object);
        unsafe.park(false, 0L);
        LockSupport.setBlocker(thread, null);
    }

    public static void parkNanos(Object object, long l2) {
        if (l2 > 0L) {
            Thread thread = Thread.currentThread();
            LockSupport.setBlocker(thread, object);
            unsafe.park(false, l2);
            LockSupport.setBlocker(thread, null);
        }
    }

    public static void parkUntil(Object object, long l2) {
        Thread thread = Thread.currentThread();
        LockSupport.setBlocker(thread, object);
        unsafe.park(true, l2);
        LockSupport.setBlocker(thread, null);
    }

    public static Object getBlocker(Thread thread) {
        if (thread == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        return unsafe.getObjectVolatile(thread, parkBlockerOffset);
    }

    public static void park() {
        unsafe.park(false, 0L);
    }

    public static void parkNanos(long l2) {
        if (l2 > 0L) {
            unsafe.park(false, l2);
        }
    }

    public static void parkUntil(long l2) {
        unsafe.park(true, l2);
    }

    static {
        try {
            parkBlockerOffset = unsafe.objectFieldOffset(ai.getCurrentClass(Thread.class).getDeclaredField("parkBlocker"));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error(exception));
        }
    }

    protected /* synthetic */ LockSupport(h h2) {
        super(h2);
    }
}

