/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class ReentrantLock
extends h
implements Lock,
Serializable {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public ReentrantLock() {
        this.sync = new NonfairSync();
    }

    public ReentrantLock(boolean bl) {
        this.sync = bl ? new FairSync() : new NonfairSync();
    }

    @Override
    public void lock() {
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.sync.nonfairTryAcquire(1);
    }

    @Override
    public boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireNanos(1, timeUnit.toNanos(l2));
    }

    @Override
    public void unlock() {
        this.sync.release(1);
    }

    @Override
    public Condition newCondition() {
        return this.sync.newCondition();
    }

    public int getHoldCount() {
        return this.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        if (condition == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)condition, AbstractQueuedSynchronizer.ConditionObject.class) instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("not owner"));
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)g.convertForCast((Object)condition, AbstractQueuedSynchronizer.ConditionObject.class));
    }

    public int getWaitQueueLength(Condition condition) {
        if (condition == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)condition, AbstractQueuedSynchronizer.ConditionObject.class) instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("not owner"));
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)g.convertForCast((Object)condition, AbstractQueuedSynchronizer.ConditionObject.class));
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        if (condition == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (!(g.convertForInstanceOf((Object)condition, AbstractQueuedSynchronizer.ConditionObject.class) instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("not owner"));
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)g.convertForCast((Object)condition, AbstractQueuedSynchronizer.ConditionObject.class));
    }

    public String toString() {
        Thread thread = this.sync.getOwner();
        return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
    }

    private static /* synthetic */ void _jr$ip$sync(ReentrantLock reentrantLock, Sync sync) {
        reentrantLock.sync = sync;
    }

    protected /* synthetic */ ReentrantLock(h h2) {
        super(h2);
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -3000897897090466540L;

        FairSync() {
        }

        @Override
        final void lock() {
            this.acquire(1);
        }

        @Override
        protected final boolean tryAcquire(int n2) {
            Thread thread = Thread.currentThread();
            int n3 = this.getState();
            if (n3 == 0) {
                if (!this.hasQueuedPredecessors() && this.compareAndSetState(0, n2)) {
                    this.setExclusiveOwnerThread(thread);
                    return true;
                }
            } else if (!f.ifAcmp((Object)thread, (Object)this.getExclusiveOwnerThread())) {
                int n4 = n3 + n2;
                if (n4 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Maximum lock count exceeded"));
                }
                this.setState(n4);
                return true;
            }
            return false;
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = 7316153563782823691L;

        NonfairSync() {
        }

        @Override
        final void lock() {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
            } else {
                this.acquire(1);
            }
        }

        @Override
        protected final boolean tryAcquire(int n2) {
            return this.nonfairTryAcquire(n2);
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -5179523762034025860L;

        Sync() {
        }

        abstract void lock();

        final boolean nonfairTryAcquire(int n2) {
            Thread thread = Thread.currentThread();
            int n3 = this.getState();
            if (n3 == 0) {
                if (this.compareAndSetState(0, n2)) {
                    this.setExclusiveOwnerThread(thread);
                    return true;
                }
            } else if (!f.ifAcmp((Object)thread, (Object)this.getExclusiveOwnerThread())) {
                int n4 = n3 + n2;
                if (n4 < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Maximum lock count exceeded"));
                }
                this.setState(n4);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryRelease(int n2) {
            int n3 = this.getState() - n2;
            if (f.ifAcmp((Object)Thread.currentThread(), (Object)this.getExclusiveOwnerThread())) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalMonitorStateException());
            }
            boolean bl = false;
            if (n3 == 0) {
                bl = true;
                this.setExclusiveOwnerThread(null);
            }
            this.setState(n3);
            return bl;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return !f.ifAcmp((Object)this.getExclusiveOwnerThread(), (Object)Thread.currentThread());
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return this.getState() == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getHoldCount() {
            return this.isHeldExclusively() ? this.getState() : 0;
        }

        final boolean isLocked() {
            return this.getState() != 0;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.setState(0);
        }

        protected /* synthetic */ Sync(h h2) {
            super(h2);
        }
    }
}

