/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarVerifier;
import java.util.jar.JavaUtilJarAccessImpl;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.IOUtils;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.util.ManifestEntryVerifier;

public class JarFile
extends ZipFile {
    private SoftReference<Manifest> manRef;
    private JarEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean computedHasClassPathAttribute;
    private boolean hasClassPathAttribute;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static int[] lastOcc;
    private static int[] optoSft;
    private static char[] src;
    private static String javaHome;
    private static String[] jarNames;

    public JarFile(String string) throws IOException {
        this(new File(string), true, 1);
    }

    public JarFile(String string, boolean bl) throws IOException {
        this(new File(string), bl, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl) throws IOException {
        this(file, bl, 1);
    }

    public JarFile(File file, boolean bl, int n2) throws IOException {
        super(file, n2);
        this.verify = bl;
    }

    public Manifest getManifest() throws IOException {
        return this.getManifestFromReference();
    }

    private Manifest getManifestFromReference() throws IOException {
        JarEntry jarEntry;
        Manifest manifest;
        Manifest manifest2 = manifest = this.manRef != null ? (Manifest)g.convertForCast(this.manRef.get(), Manifest.class) : null;
        if (manifest == null && (jarEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] byArray = this.getBytes(jarEntry);
                manifest = new Manifest(new ByteArrayInputStream(byArray));
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(byArray);
                }
            } else {
                manifest = new Manifest(super.getInputStream(jarEntry));
            }
            this.manRef = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    private String[] _jr$jnim$getMetaInfEntryNames() {
        return ((JarFile)this._jr$gOrg()).getMetaInfEntryNames();
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        return (JarEntry)g.convertForCast((Object)this.getEntry(string), JarEntry.class);
    }

    @Override
    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(this, zipEntry);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        Enumeration<? extends ZipEntry> enumeration = super.entries();
        return new Enumeration(this, enumeration){
            final /* synthetic */ Enumeration val$enum_;
            final /* synthetic */ JarFile this$0;
            {
                this.this$0 = jarFile;
                this.val$enum_ = enumeration;
            }

            @Override
            public boolean hasMoreElements() {
                return (this).val$enum_.hasMoreElements();
            }

            public JarFileEntry nextElement() {
                ZipEntry zipEntry = (ZipEntry)g.convertForCast((this).val$enum_.nextElement(), ZipEntry.class);
                return new JarFileEntry(this.this$0, zipEntry);
            }

            static /* synthetic */ void _jr$ip$val$enum_(Object object, Enumeration enumeration) {
                (object).val$enum_ = enumeration;
            }

            static /* synthetic */ JarFile _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, JarFile jarFile) {
                (object).this$0 = jarFile;
            }
        };
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            Object[] objectArray = this._jr$jnim$getMetaInfEntryNames();
            if (objectArray != null) {
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    String string = ((String)a.arrayLoad((Object[])objectArray, (int)i)).toUpperCase(Locale.ENGLISH);
                    if (!string.endsWith(".DSA") && !string.endsWith(".RSA") && !string.endsWith(".EC") && !string.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block10: {
            ManifestEntryVerifier manifestEntryVerifier = null;
            try {
                Object[] objectArray = this._jr$jnim$getMetaInfEntryNames();
                if (objectArray != null) {
                    for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                        byte[] byArray;
                        JarEntry jarEntry = this.getJarEntry((String)a.arrayLoad((Object[])objectArray, (int)i));
                        if (jarEntry == null) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new JarException("corrupted jar file"));
                        }
                        if (jarEntry.isDirectory()) continue;
                        if (manifestEntryVerifier == null) {
                            manifestEntryVerifier = new ManifestEntryVerifier(this.getManifestFromReference());
                        }
                        if ((byArray = this.getBytes(jarEntry)) == null || byArray.length <= 0) continue;
                        this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                        this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                        this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                    }
                }
            }
            catch (IOException iOException) {
                this.jv = null;
                this.verify = false;
                if (JarVerifier.debug == null) break block10;
                JarVerifier.debug.println("jarfile parsing error!");
                iOException.printStackTrace();
            }
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        byte[] byArray;
        InputStream inputStream;
        block9: {
            inputStream = super.getInputStream(zipEntry);
            Throwable throwable = null;
            try {
                byArray = IOUtils.readFully(inputStream, (int)zipEntry.getSize(), true);
                if (inputStream == null) return byArray;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                }
                catch (Throwable throwable4) {
                    if (inputStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    if (throwable == null) {
                        inputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    try {
                        inputStream.close();
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                    }
                }
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return byArray;
            }
        }
        inputStream.close();
        return byArray;
    }

    @Override
    @af(modifiers=33)
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.maybeInstantiateVerifier();
                if (this.jv == null) {
                    return super.getInputStream(zipEntry);
                }
                if (!this.jvInitialized) {
                    this.initializeVerifier();
                    this.jvInitialized = true;
                    if (this.jv == null) {
                        return super.getInputStream(zipEntry);
                    }
                }
                return new JarVerifier.VerifierStream(this.getManifestFromReference(), g.convertForInstanceOf((Object)zipEntry, JarFileEntry.class) instanceof JarFileEntry ? (JarEntry)g.convertForCast((Object)zipEntry, JarEntry.class) : this.getJarEntry(zipEntry.getName()), super.getInputStream(zipEntry), this.jv);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private JarEntry getManEntry() {
        if (this.manEntry == null) {
            Object[] objectArray;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (objectArray = this._jr$jnim$getMetaInfEntryNames()) != null) {
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    if (!MANIFEST_NAME.equals(((String)a.arrayLoad((Object[])objectArray, (int)i)).toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry((String)a.arrayLoad((Object[])objectArray, (int)i));
                    break;
                }
            }
        }
        return this.manEntry;
    }

    boolean hasClassPathAttribute() throws IOException {
        JarEntry jarEntry;
        if (this.computedHasClassPathAttribute) {
            return this.hasClassPathAttribute;
        }
        this.hasClassPathAttribute = false;
        if (!this.isKnownToNotHaveClassPathAttribute() && (jarEntry = this.getManEntry()) != null) {
            char c;
            int n2;
            byte[] byArray = this.getBytes(jarEntry);
            int n3 = byArray.length - src.length;
            block0: for (int i = 0; i <= n3; i += Math.max(n2 + 1 - lastOcc[c & 0x7F], optoSft[n2])) {
                for (n2 = 9; n2 >= 0; --n2) {
                    c = (char)byArray[i + n2];
                    char c2 = c = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : c;
                    if (c == src[n2]) continue;
                    continue block0;
                }
                this.hasClassPathAttribute = true;
                break;
            }
        }
        this.computedHasClassPathAttribute = true;
        return this.hasClassPathAttribute;
    }

    private boolean isKnownToNotHaveClassPathAttribute() {
        String string;
        Object object;
        if (javaHome == null) {
            javaHome = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
        }
        if (jarNames == null) {
            object = new String[10];
            string = File.separator;
            int n2 = 0;
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "rt.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "sunrsasign.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "jsse.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "jce.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "charsets.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "dnsns.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "ldapsec.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "localedata.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "sunjce_provider.jar"));
            a.arrayStore((Object[])object, (int)n2++, (Object)(string + "sunpkcs11.jar"));
            jarNames = object;
        }
        if (((String)(object = this.getName())).startsWith(string = javaHome)) {
            Object[] objectArray = jarNames;
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                if (!((String)object).endsWith((String)a.arrayLoad((Object[])objectArray, (int)i))) continue;
                return true;
            }
        }
        return false;
    }

    @af(modifiers=34)
    private void ensureInitialization() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                try {
                    this.maybeInstantiateVerifier();
                }
                catch (IOException iOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
                }
                if (this.jv != null && !this.jvInitialized) {
                    this.initializeVerifier();
                    this.jvInitialized = true;
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    JarEntry newEntry(ZipEntry zipEntry) {
        return new JarFileEntry(this, zipEntry);
    }

    Enumeration<String> entryNames(CodeSource[] codeSourceArray) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entryNames(this, codeSourceArray);
        }
        boolean bl = false;
        for (int i = 0; i < a.arrayLength((Object[])codeSourceArray); ++i) {
            if (((CodeSource)g.convertForCast((Object)a.arrayLoad((Object[])codeSourceArray, (int)i), CodeSource.class)).getCodeSigners() != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            return this.unsignedEntryNames();
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Enumeration<JarEntry> entries2() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entries2(this, super.entries());
        }
        Enumeration<? extends ZipEntry> enumeration = super.entries();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    CodeSource[] getCodeSources(URL uRL) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getCodeSources(this, uRL);
        }
        Enumeration<String> enumeration = this.unsignedEntryNames();
        if (enumeration.hasMoreElements()) {
            Object[] objectArray = new CodeSource[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)JarVerifier.getUnsignedCS(uRL));
            return objectArray;
        }
        return null;
    }

    private Enumeration<String> unsignedEntryNames() {
        Enumeration<JarEntry> enumeration = this.entries();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    CodeSource getCodeSource(URL uRL, String string) {
        this.ensureInitialization();
        if (this.jv != null) {
            if (JarVerifier._jr$ig$eagerValidation((Object)this.jv)) {
                CodeSource codeSource = null;
                JarEntry jarEntry = this.getJarEntry(string);
                codeSource = jarEntry != null ? this.jv.getCodeSource(uRL, this, jarEntry) : this.jv.getCodeSource(uRL, string);
                return codeSource;
            }
            return this.jv.getCodeSource(uRL, string);
        }
        return JarVerifier.getUnsignedCS(uRL);
    }

    void setEagerValidation(boolean bl) {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
        }
        if (this.jv != null) {
            this.jv.setEagerValidation(bl);
        }
    }

    List getManifestDigests() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getManifestDigests();
        }
        return new ArrayList();
    }

    static {
        SharedSecrets.setJavaUtilJarAccess(new JavaUtilJarAccessImpl());
        src = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        lastOcc = new int[128];
        optoSft = new int[10];
        JarFile.lastOcc[99] = 1;
        JarFile.lastOcc[108] = 2;
        JarFile.lastOcc[115] = 5;
        JarFile.lastOcc[45] = 6;
        JarFile.lastOcc[112] = 7;
        JarFile.lastOcc[97] = 8;
        JarFile.lastOcc[116] = 9;
        JarFile.lastOcc[104] = 10;
        for (int i = 0; i < 9; ++i) {
            JarFile.optoSft[i] = 10;
        }
        JarFile.optoSft[9] = 1;
    }

    protected /* synthetic */ JarFile(h h2) {
        super(h2);
    }

    private class JarFileEntry
    extends JarEntry {
        final /* synthetic */ JarFile this$0;

        JarFileEntry(JarFile jarFile, ZipEntry zipEntry) {
            this.this$0 = jarFile;
            super(zipEntry);
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest manifest = ((JarFileEntry)this).this$0.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            try {
                ((JarFileEntry)this).this$0.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
            }
            if (JarFileEntry._jr$ig$certs(this) == null && ((JarFileEntry)this).this$0.jv != null) {
                JarFileEntry._jr$ip$certs(this, ((JarFileEntry)this).this$0.jv.getCerts(((JarFileEntry)this).this$0, this));
            }
            return JarFileEntry._jr$ig$certs(this) == null ? null : (Certificate[])g.convertForCast((Object)a.cloneArray((Object)JarFileEntry._jr$ig$certs(this)), Certificate[].class);
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            try {
                ((JarFileEntry)this).this$0.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
            }
            if (JarFileEntry._jr$ig$signers(this) == null && ((JarFileEntry)this).this$0.jv != null) {
                JarFileEntry._jr$ip$signers(this, ((JarFileEntry)this).this$0.jv.getCodeSigners(((JarFileEntry)this).this$0, this));
            }
            return JarFileEntry._jr$ig$signers(this) == null ? null : (CodeSigner[])a.cloneArray((Object)JarFileEntry._jr$ig$signers(this));
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, JarFile jarFile) {
            ((JarFileEntry)object).this$0 = jarFile;
        }

        protected /* synthetic */ JarFileEntry(h h2) {
            super(h2);
        }
    }
}

