/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarOutputStream
extends ZipOutputStream {
    private static final int JAR_MAGIC = 51966;
    private boolean firstEntry;

    public JarOutputStream(OutputStream outputStream, Manifest manifest) throws IOException {
        super(outputStream);
        this.firstEntry = true;
        if (manifest == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("man"));
        }
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(zipEntry);
        manifest.write(new BufferedOutputStream(this));
        this.closeEntry();
    }

    public JarOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.firstEntry = true;
    }

    @Override
    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.firstEntry) {
            byte[] byArray = zipEntry.getExtra();
            if (byArray == null || !JarOutputStream.hasMagic(byArray)) {
                if (byArray == null) {
                    byArray = new byte[4];
                } else {
                    byte[] byArray2 = new byte[byArray.length + 4];
                    a.arraycopy((Object)byArray, (int)0, (Object)byArray2, (int)4, (int)byArray.length);
                    byArray = byArray2;
                }
                JarOutputStream.set16(byArray, 0, 51966);
                JarOutputStream.set16(byArray, 2, 0);
                zipEntry.setExtra(byArray);
            }
            this.firstEntry = false;
        }
        super.putNextEntry(zipEntry);
    }

    private static boolean hasMagic(byte[] byArray) {
        try {
            for (int i = 0; i < byArray.length; i += JarOutputStream.get16(byArray, i + 2) + 4) {
                if (JarOutputStream.get16(byArray, i) != 51966) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int get16(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    private static void set16(byte[] byArray, int n2, int n3) {
        byArray[n2 + 0] = (byte)n3;
        byArray[n2 + 1] = (byte)(n3 >> 8);
    }

    protected /* synthetic */ JarOutputStream(h h2) {
        super(h2);
    }
}

