/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

class JarVerifier
extends h {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedSigners;
    private Hashtable sigFileSigners;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList signerCache;
    private boolean parsingBlockOrSF;
    private boolean parsingMeta;
    private boolean anyToVerify;
    private ByteArrayOutputStream baos;
    private volatile ManifestDigester manDig;
    byte[] manifestRawBytes;
    boolean eagerValidation;
    private Object csdomain;
    private List manifestDigests;
    private Map urlToCodeSourceMap;
    private Map signerToCodeSource;
    private URL lastURL;
    private Map lastURLMap;
    private CodeSigner[] emptySigner;
    private Map signerMap;
    private Enumeration emptyEnumeration;
    private List jarCodeSigners;

    public JarVerifier(byte[] byArray) {
        this.parsingBlockOrSF = false;
        this.parsingMeta = true;
        this.anyToVerify = true;
        this.manifestRawBytes = null;
        this.csdomain = new Object();
        this.urlToCodeSourceMap = new HashMap();
        this.signerToCodeSource = new HashMap();
        this.emptySigner = new CodeSigner[0];
        this.emptyEnumeration = new Enumeration(this){
            final /* synthetic */ JarVerifier this$0;
            {
                this.this$0 = jarVerifier;
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public String nextElement() {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
            }

            static /* synthetic */ JarVerifier _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, JarVerifier jarVerifier) {
                (object).this$0 = jarVerifier;
            }
        };
        this.manifestRawBytes = byArray;
        this.sigFileSigners = new Hashtable();
        this.verifiedSigners = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
        this.manifestDigests = new ArrayList();
    }

    public void beginEntry(JarEntry jarEntry, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        String string;
        if (jarEntry == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + jarEntry.getName());
        }
        String string2 = jarEntry.getName();
        if (this.parsingMeta && ((string = string2.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") || string.startsWith("/META-INF/"))) {
            if (jarEntry.isDirectory()) {
                manifestEntryVerifier.setEntry(null, jarEntry);
                return;
            }
            if (SignatureFileVerifier.isBlockOrSF(string)) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                manifestEntryVerifier.setEntry(null, jarEntry);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (jarEntry.isDirectory()) {
            manifestEntryVerifier.setEntry(null, jarEntry);
            return;
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (this.sigFileSigners.get(string2) != null) {
            manifestEntryVerifier.setEntry(string2, jarEntry);
            return;
        }
        manifestEntryVerifier.setEntry(null, jarEntry);
    }

    public void update(int n, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(n);
            } else {
                manifestEntryVerifier.update((byte)n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    public void update(int n, byte[] byArray, int n2, int n3, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(byArray, n2, n);
            } else {
                manifestEntryVerifier.update(byArray, n2, n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntry(ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        block24: {
            if (!this.parsingBlockOrSF) {
                JarEntry jarEntry = manifestEntryVerifier.getEntry();
                if (jarEntry != null && JarEntry._jr$ig$signers(jarEntry) == null) {
                    JarEntry._jr$ip$signers(jarEntry, manifestEntryVerifier.verify(this.verifiedSigners, this.sigFileSigners));
                    JarEntry._jr$ip$certs(jarEntry, JarVerifier.mapSignersToCertArray(JarEntry._jr$ig$signers(jarEntry)));
                }
            } else {
                try {
                    Object object;
                    String string;
                    this.parsingBlockOrSF = false;
                    if (debug != null) {
                        debug.println("processEntry: processing block");
                    }
                    if ((string = manifestEntryVerifier.getEntry().getName().toUpperCase(Locale.ENGLISH)).endsWith(".SF")) {
                        String string2 = string.substring(0, string.length() - 3);
                        byte[] byArray = this.baos.toByteArray();
                        this.sigFileData.put(string2, byArray);
                        Iterator iterator = this.pendingBlocks.iterator();
                        while (iterator.hasNext()) {
                            SignatureFileVerifier signatureFileVerifier = (SignatureFileVerifier)((Object)g.convertForCast(iterator.next(), SignatureFileVerifier.class));
                            if (!signatureFileVerifier.needSignatureFile(string2)) continue;
                            if (debug != null) {
                                debug.println("processEntry: processing pending block");
                            }
                            signatureFileVerifier.setSignatureFile(byArray);
                            signatureFileVerifier.process(this.sigFileSigners, this.manifestDigests);
                        }
                        return;
                    }
                    String string3 = string.substring(0, string.lastIndexOf("."));
                    if (this.signerCache == null) {
                        this.signerCache = new ArrayList();
                    }
                    if (this.manDig == null) {
                        object = ah.getMonitor((Object)((JarVerifier)((Object)((Object)this))).manifestRawBytes);
                        synchronized (object) {
                            try {
                                if (this.manDig == null) {
                                    this.manDig = new ManifestDigester(((JarVerifier)((Object)((Object)this))).manifestRawBytes);
                                    ((JarVerifier)((Object)((Object)this))).manifestRawBytes = null;
                                }
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                    }
                    if (((SignatureFileVerifier)((Object)(object = new SignatureFileVerifier(this.signerCache, this.manDig, string, this.baos.toByteArray())))).needSignatureFileBytes()) {
                        byte[] byArray = (byte[])this.sigFileData.get(string3);
                        if (byArray == null) {
                            if (debug != null) {
                                debug.println("adding pending block");
                            }
                            this.pendingBlocks.add(object);
                            return;
                        }
                        ((SignatureFileVerifier)((Object)object)).setSignatureFile(byArray);
                    }
                    ((SignatureFileVerifier)((Object)object)).process(this.sigFileSigners, this.manifestDigests);
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        debug.println("processEntry caught: " + iOException);
                    }
                }
                catch (SignatureException signatureException) {
                    if (debug != null) {
                        debug.println("processEntry caught: " + signatureException);
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (debug != null) {
                        debug.println("processEntry caught: " + noSuchAlgorithmException);
                    }
                }
                catch (CertificateException certificateException) {
                    if (debug == null) break block24;
                    debug.println("processEntry caught: " + certificateException);
                }
            }
        }
    }

    public Certificate[] getCerts(String string) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(string));
    }

    public Certificate[] getCerts(JarFile jarFile, JarEntry jarEntry) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(jarFile, jarEntry));
    }

    public CodeSigner[] getCodeSigners(String string) {
        return (CodeSigner[])g.convertForCast((Object)((CodeSigner[])g.convertForCast(this.verifiedSigners.get(string), CodeSigner[].class)), CodeSigner[].class);
    }

    public CodeSigner[] getCodeSigners(JarFile jarFile, JarEntry jarEntry) {
        String string = jarEntry.getName();
        if (((JarVerifier)((Object)((Object)this))).eagerValidation && this.sigFileSigners.get(string) != null) {
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = new byte[1024];
                int n = byArray.length;
                while (n != -1) {
                    n = inputStream.read(byArray, 0, byArray.length);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getCodeSigners(string);
    }

    private static Certificate[] mapSignersToCertArray(CodeSigner[] codeSignerArray) {
        if (codeSignerArray != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < a.arrayLength((Object[])codeSignerArray); ++i) {
                arrayList.addAll(((CodeSigner)g.convertForCast((Object)a.arrayLoad((Object[])codeSignerArray, (int)i), CodeSigner.class)).getSignerCertPath().getCertificates());
            }
            return (Certificate[])g.convertForCast((Object)((Certificate[])g.convertForCast((Object)arrayList.toArray(new Certificate[arrayList.size()]), Certificate[].class)), Certificate[].class);
        }
        return null;
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileSigners.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.signerCache = null;
        this.manDig = null;
        if (this.sigFileSigners.containsKey("META-INF/MANIFEST.MF")) {
            this.verifiedSigners.put("META-INF/MANIFEST.MF", this.sigFileSigners.remove("META-INF/MANIFEST.MF"));
        }
    }

    @af(modifiers=34)
    private CodeSource mapSignersToCodeSource(URL uRL, CodeSigner[] codeSignerArray) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                Map map;
                if (!f.ifAcmp((Object)uRL, (Object)this.lastURL)) {
                    map = this.lastURLMap;
                } else {
                    map = (Map)g.convertForCast(this.urlToCodeSourceMap.get(uRL), Map.class);
                    if (map == null) {
                        map = new HashMap();
                        this.urlToCodeSourceMap.put(uRL, map);
                    }
                    this.lastURLMap = map;
                    this.lastURL = uRL;
                }
                CodeSource codeSource = (CodeSource)g.convertForCast(map.get(codeSignerArray), CodeSource.class);
                if (codeSource == null) {
                    codeSource = new VerifierCodeSource(this.csdomain, uRL, codeSignerArray);
                    this.signerToCodeSource.put(codeSignerArray, codeSource);
                }
                return codeSource;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private CodeSource[] mapSignersToCodeSources(URL uRL, List list, boolean bl) {
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.mapSignersToCodeSource(uRL, (CodeSigner[])g.convertForCast((Object)((CodeSigner[])g.convertForCast(list.get(i), CodeSigner[].class)), CodeSigner[].class)));
        }
        if (bl) {
            arrayList.add(this.mapSignersToCodeSource(uRL, null));
        }
        return (CodeSource[])g.convertForCast((Object)((CodeSource[])g.convertForCast((Object)arrayList.toArray(new CodeSource[arrayList.size()]), CodeSource[].class)), CodeSource[].class);
    }

    private CodeSigner[] findMatchingSigners(CodeSource codeSource) {
        int n;
        Object[] objectArray;
        if (g.convertForInstanceOf((Object)codeSource, VerifierCodeSource.class) instanceof VerifierCodeSource && (objectArray = (Object[])g.convertForCast((Object)codeSource, VerifierCodeSource.class)).isSameDomain(this.csdomain)) {
            return ((VerifierCodeSource)g.convertForCast((Object)codeSource, VerifierCodeSource.class)).getPrivateSigners();
        }
        objectArray = this.mapSignersToCodeSources(codeSource.getLocation(), this.getJarCodeSigners(), true);
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        for (n = 0; n < a.arrayLength((Object[])objectArray); ++n) {
            arrayList.add((CodeSource)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n), CodeSource.class));
        }
        n = arrayList.indexOf(codeSource);
        if (n != -1) {
            CodeSigner[] codeSignerArray = ((VerifierCodeSource)g.convertForCast(arrayList.get(n), VerifierCodeSource.class)).getPrivateSigners();
            if (codeSignerArray == null) {
                codeSignerArray = this.emptySigner;
            }
            return codeSignerArray;
        }
        return null;
    }

    @af(modifiers=34)
    private Map signerMap() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.signerMap == null) {
                    this.signerMap = new HashMap(this.verifiedSigners.size() + this.sigFileSigners.size());
                    this.signerMap.putAll(this.verifiedSigners);
                    this.signerMap.putAll(this.sigFileSigners);
                }
                return this.signerMap;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public Enumeration<String> entryNames(JarFile jarFile, CodeSource[] codeSourceArray) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                Object[] objectArray;
                Map map = this.signerMap();
                Iterator iterator = map.entrySet().iterator();
                boolean bl = false;
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>(a.arrayLength((Object[])codeSourceArray));
                for (int i = 0; i < a.arrayLength((Object[])codeSourceArray); ++i) {
                    objectArray = this.findMatchingSigners((CodeSource)g.convertForCast((Object)a.arrayLoad((Object[])codeSourceArray, (int)i), CodeSource.class));
                    if (objectArray == null) continue;
                    if (a.arrayLength((Object[])objectArray) > 0) {
                        arrayList.add(objectArray);
                        continue;
                    }
                    bl = true;
                }
                ArrayList<Object[]> arrayList2 = arrayList;
                objectArray = bl ? this.unsignedEntryNames(jarFile) : this.emptyEnumeration;
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public Enumeration<JarEntry> entries2(JarFile jarFile, Enumeration enumeration) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.signerMap());
        Enumeration enumeration2 = enumeration;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static boolean isSigningRelated(String string) {
        if (!(string = string.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/")) {
            return false;
        }
        if ((string = string.substring(9)).indexOf(47) != -1) {
            return false;
        }
        return string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF") || string.endsWith(".EC") || string.startsWith("SIG-") || string.equals("MANIFEST.MF");
    }

    private Enumeration<String> unsignedEntryNames(JarFile jarFile) {
        Map map = this.signerMap();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @af(modifiers=34)
    private List getJarCodeSigners() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.jarCodeSigners == null) {
                    HashSet hashSet = new HashSet();
                    hashSet.addAll(this.signerMap().values());
                    this.jarCodeSigners = new ArrayList();
                    this.jarCodeSigners.addAll(hashSet);
                }
                return this.jarCodeSigners;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public CodeSource[] getCodeSources(JarFile jarFile, URL uRL) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                boolean bl = this.unsignedEntryNames(jarFile).hasMoreElements();
                return this.mapSignersToCodeSources(uRL, this.getJarCodeSigners(), bl);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public CodeSource getCodeSource(URL uRL, String string) {
        CodeSigner[] codeSignerArray = (CodeSigner[])g.convertForCast((Object)((CodeSigner[])g.convertForCast(this.signerMap().get(string), CodeSigner[].class)), CodeSigner[].class);
        return this.mapSignersToCodeSource(uRL, codeSignerArray);
    }

    public CodeSource getCodeSource(URL uRL, JarFile jarFile, JarEntry jarEntry) {
        return this.mapSignersToCodeSource(uRL, this.getCodeSigners(jarFile, jarEntry));
    }

    public void setEagerValidation(boolean bl) {
        ((JarVerifier)((Object)((Object)this))).eagerValidation = bl;
    }

    @af(modifiers=33)
    public List getManifestDigests() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                return Collections.unmodifiableList(this.manifestDigests);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    static CodeSource getUnsignedCS(URL uRL) {
        return new VerifierCodeSource(null, uRL, (Certificate[])g.convertForCast(null, Certificate[].class));
    }

    private static /* synthetic */ void _jr$ip$verifiedSigners(JarVerifier jarVerifier, Hashtable hashtable) {
        jarVerifier.verifiedSigners = hashtable;
    }

    private static /* synthetic */ void _jr$ip$sigFileSigners(JarVerifier jarVerifier, Hashtable hashtable) {
        jarVerifier.sigFileSigners = hashtable;
    }

    private static /* synthetic */ void _jr$ip$csdomain(JarVerifier jarVerifier, Object object) {
        jarVerifier.csdomain = object;
    }

    private static /* synthetic */ void _jr$ip$manifestDigests(JarVerifier jarVerifier, List list) {
        jarVerifier.manifestDigests = list;
    }

    private static /* synthetic */ void _jr$ip$urlToCodeSourceMap(JarVerifier jarVerifier, Map map) {
        jarVerifier.urlToCodeSourceMap = map;
    }

    private static /* synthetic */ void _jr$ip$signerToCodeSource(JarVerifier jarVerifier, Map map) {
        jarVerifier.signerToCodeSource = map;
    }

    private static /* synthetic */ void _jr$ip$emptySigner(JarVerifier jarVerifier, CodeSigner[] codeSignerArray) {
        jarVerifier.emptySigner = codeSignerArray;
    }

    private static /* synthetic */ void _jr$ip$emptyEnumeration(JarVerifier jarVerifier, Enumeration enumeration) {
        jarVerifier.emptyEnumeration = enumeration;
    }

    protected /* synthetic */ JarVerifier(h h2) {
        super(h2);
    }

    private static class VerifierCodeSource
    extends CodeSource {
        URL vlocation;
        CodeSigner[] vsigners;
        Certificate[] vcerts;
        Object csdomain;

        VerifierCodeSource(Object object, URL uRL, CodeSigner[] codeSignerArray) {
            super(uRL, codeSignerArray);
            this.csdomain = object;
            this.vlocation = uRL;
            this.vsigners = codeSignerArray;
        }

        VerifierCodeSource(Object object, URL uRL, Certificate[] certificateArray) {
            super(uRL, certificateArray);
            this.csdomain = object;
            this.vlocation = uRL;
            this.vcerts = certificateArray;
        }

        @Override
        public boolean equals(Object object) {
            VerifierCodeSource verifierCodeSource;
            if (!f.ifAcmp((Object)object, (Object)this)) {
                return true;
            }
            if (g.convertForInstanceOf((Object)object, VerifierCodeSource.class) instanceof VerifierCodeSource && this.isSameDomain(((VerifierCodeSource)(verifierCodeSource = (VerifierCodeSource)g.convertForCast((Object)object, VerifierCodeSource.class))).csdomain)) {
                if (f.ifAcmp((Object)((VerifierCodeSource)verifierCodeSource).vsigners, (Object)((VerifierCodeSource)this).vsigners) || f.ifAcmp((Object)((VerifierCodeSource)verifierCodeSource).vcerts, (Object)((VerifierCodeSource)this).vcerts)) {
                    return false;
                }
                if (((VerifierCodeSource)verifierCodeSource).vlocation != null) {
                    return ((VerifierCodeSource)verifierCodeSource).vlocation.equals(((VerifierCodeSource)this).vlocation);
                }
                if (((VerifierCodeSource)this).vlocation != null) {
                    return ((VerifierCodeSource)this).vlocation.equals(((VerifierCodeSource)verifierCodeSource).vlocation);
                }
                return true;
            }
            return super.equals(object);
        }

        boolean isSameDomain(Object object) {
            return !f.ifAcmp((Object)((VerifierCodeSource)this).csdomain, (Object)object);
        }

        private CodeSigner[] getPrivateSigners() {
            return ((VerifierCodeSource)this).vsigners;
        }

        private Certificate[] getPrivateCertificates() {
            return ((VerifierCodeSource)this).vcerts;
        }

        static /* synthetic */ void _jr$ip$vlocation(Object object, URL uRL) {
            ((VerifierCodeSource)object).vlocation = uRL;
        }

        static /* synthetic */ void _jr$ip$vsigners(Object object, CodeSigner[] codeSignerArray) {
            ((VerifierCodeSource)object).vsigners = codeSignerArray;
        }

        static /* synthetic */ void _jr$ip$vcerts(Object object, Certificate[] certificateArray) {
            ((VerifierCodeSource)object).vcerts = certificateArray;
        }

        static /* synthetic */ void _jr$ip$csdomain(Object object, Object object2) {
            ((VerifierCodeSource)object).csdomain = object2;
        }

        protected /* synthetic */ VerifierCodeSource(h h2) {
            super(h2);
        }
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest manifest, JarEntry jarEntry, InputStream inputStream, JarVerifier jarVerifier) throws IOException {
            this.is = inputStream;
            this.jv = jarVerifier;
            this.mev = new ManifestEntryVerifier(manifest);
            this.jv.beginEntry(jarEntry, this.mev);
            this.numLeft = jarEntry.getSize();
            if (this.numLeft == 0L) {
                this.jv.update(-1, this.mev);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int n = this.is.read();
                this.jv.update(n, this.mev);
                VerifierStream verifierStream = this;
                verifierStream.numLeft = verifierStream.numLeft - 1L;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return n;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)n2) {
                n2 = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n3 = this.is.read(byArray, n, n2);
                this.jv.update(n3, byArray, n, n2, this.mev);
                VerifierStream verifierStream = this;
                verifierStream.numLeft = verifierStream.numLeft - (long)n3;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, byArray, n, n2, this.mev);
                }
                return n3;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        protected /* synthetic */ VerifierStream(h h2) {
            super(h2);
        }
    }
}

