/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;

public class Manifest
extends h
implements Cloneable {
    private Attributes attr;
    private Map entries;

    public Manifest() {
        this.attr = new Attributes();
        this.entries = new HashMap();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this.attr = new Attributes();
        this.entries = new HashMap();
        this.read(inputStream);
    }

    public Manifest(Manifest manifest) {
        this.attr = new Attributes();
        this.entries = new HashMap();
        this.attr.putAll((Map<?, ?>)manifest.getMainAttributes());
        this.entries.putAll(manifest.getEntries());
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String string) {
        return (Attributes)g.convertForCast((Object)this.getEntries().get(string), Attributes.class);
    }

    public void clear() {
        this.attr.clear();
        this.entries.clear();
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.attr.writeMain(dataOutputStream);
        Iterator iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
            StringBuffer stringBuffer = new StringBuffer("Name: ");
            String string = (String)entry.getKey();
            if (string != null) {
                byte[] byArray = string.getBytes("UTF8");
                string = new String(byArray, 0, 0, byArray.length);
            }
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            ((Attributes)g.convertForCast(entry.getValue(), Attributes.class)).write(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    static void make72Safe(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        if (n2 > 72) {
            int n3 = 70;
            while (n3 < n2 - 2) {
                stringBuffer.insert(n3, "\r\n ");
                n3 += 72;
                n2 += 3;
            }
        }
    }

    public void read(InputStream inputStream) throws IOException {
        int n2;
        FastInputStream fastInputStream = new FastInputStream(inputStream);
        byte[] byArray = new byte[512];
        this.attr.read(fastInputStream, byArray);
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        String string = null;
        boolean bl = true;
        Object object = null;
        while ((n2 = fastInputStream.readLine(byArray)) != -1) {
            Object object2;
            if (byArray[--n2] != 10) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("manifest line too long"));
            }
            if (n2 > 0 && byArray[n2 - 1] == 13) {
                --n2;
            }
            if (n2 == 0 && bl) continue;
            bl = false;
            if (string == null) {
                string = this.parseName(byArray, n2);
                if (string == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("invalid manifest format"));
                }
                if (fastInputStream.peek() == 32) {
                    object = new byte[n2 - 6];
                    a.arraycopy((Object)byArray, (int)6, (Object)object, (int)0, (int)(n2 - 6));
                    continue;
                }
            } else {
                object2 = new byte[(object).length + n2 - 1];
                a.arraycopy(object, (int)0, (Object)object2, (int)0, (int)(object).length);
                a.arraycopy((Object)byArray, (int)1, (Object)object2, (int)((byte[])object).length, (int)(n2 - 1));
                if (fastInputStream.peek() == 32) {
                    object = object2;
                    continue;
                }
                string = new String((byte[])object2, 0, ((Object)object2).length, "UTF8");
                object = null;
            }
            if ((object2 = (Object)this.getAttributes(string)) == null) {
                object2 = new Attributes(n5);
                this.entries.put(string, object2);
            }
            ((Attributes)object2).read(fastInputStream, byArray);
            n5 = Math.max(2, (n4 += ((Attributes)object2).size()) / ++n3);
            string = null;
            bl = true;
        }
    }

    private String parseName(byte[] byArray, int n2) {
        if (this.toLower(byArray[0]) == 110 && this.toLower(byArray[1]) == 97 && this.toLower(byArray[2]) == 109 && this.toLower(byArray[3]) == 101 && byArray[4] == 58 && byArray[5] == 32) {
            try {
                return new String(byArray, 6, n2 - 6, "UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int toLower(int n2) {
        return n2 >= 65 && n2 <= 90 ? 97 + (n2 - 65) : n2;
    }

    public boolean equals(Object object) {
        if (g.convertForInstanceOf((Object)object, Manifest.class) instanceof Manifest) {
            Manifest manifest = (Manifest)g.convertForCast((Object)object, Manifest.class);
            return this.attr.equals(manifest.getMainAttributes()) && this.entries.equals(manifest.getEntries());
        }
        return false;
    }

    public int hashCode() {
        return this.attr.hashCode() + this.entries.hashCode();
    }

    public Object clone() {
        return new Manifest(this);
    }

    private static /* synthetic */ void _jr$ip$attr(Manifest manifest, Attributes attributes) {
        manifest.attr = attributes;
    }

    private static /* synthetic */ void _jr$ip$entries(Manifest manifest, Map map) {
        manifest.entries = map;
    }

    protected /* synthetic */ Manifest(h h2) {
        super(h2);
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count;
        private int pos;

        FastInputStream(InputStream inputStream) {
            this(inputStream, 8192);
        }

        FastInputStream(InputStream inputStream, int n2) {
            super(inputStream);
            this.count = 0;
            this.pos = 0;
            this.buf = new byte[n2];
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            byte[] byArray = this.buf;
            FastInputStream fastInputStream = this;
            int n2 = fastInputStream.pos;
            fastInputStream.pos = n2 + 1;
            return byArray[n2] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (n3 >= this.buf.length) {
                    return FastInputStream._jr$ig$in(this).read(byArray, n2, n3);
                }
                this.fill();
                n4 = this.count - this.pos;
                if (n4 <= 0) {
                    return -1;
                }
            }
            if (n3 > n4) {
                n3 = n4;
            }
            a.arraycopy((Object)this.buf, (int)this.pos, (Object)byArray, (int)n2, (int)n3);
            FastInputStream fastInputStream = this;
            fastInputStream.pos = fastInputStream.pos + n3;
            return n3;
        }

        public int readLine(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            int n5;
            byte[] byArray2 = this.buf;
            for (n4 = 0; n4 < n3; n4 += n5) {
                int n6 = this.count - this.pos;
                if (n6 <= 0) {
                    this.fill();
                    n6 = this.count - this.pos;
                    if (n6 <= 0) {
                        return -1;
                    }
                }
                if ((n5 = n3 - n4) > n6) {
                    n5 = n6;
                }
                int n7 = this.pos;
                int n8 = n7 + n5;
                while (n7 < n8 && byArray2[n7++] != 10) {
                }
                n5 = n7 - this.pos;
                a.arraycopy((Object)byArray2, (int)this.pos, (Object)byArray, (int)n2, (int)n5);
                n2 += n5;
                this.pos = n7;
                if (byArray2[n7 - 1] != 10) continue;
                break;
            }
            return n4;
        }

        public byte peek() throws IOException {
            if (this.pos == this.count) {
                this.fill();
            }
            if (this.pos == this.count) {
                return -1;
            }
            return this.buf[this.pos];
        }

        public int readLine(byte[] byArray) throws IOException {
            return this.readLine(byArray, 0, byArray.length);
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return FastInputStream._jr$ig$in(this).skip(l);
            }
            if (l > l2) {
                l = l2;
            }
            FastInputStream fastInputStream = this;
            fastInputStream.pos = (int)((long)fastInputStream.pos + l);
            return l;
        }

        @Override
        public int available() throws IOException {
            return this.count - this.pos + FastInputStream._jr$ig$in(this).available();
        }

        @Override
        public void close() throws IOException {
            if (FastInputStream._jr$ig$in(this) != null) {
                FastInputStream._jr$ig$in(this).close();
                FastInputStream._jr$ip$in(this, null);
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n2 = FastInputStream._jr$ig$in(this).read(this.buf, 0, this.buf.length);
            if (n2 > 0) {
                this.count = n2;
            }
        }

        protected /* synthetic */ FastInputStream(h h2) {
            super(h2);
        }
    }
}

