/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class Handler
extends h {
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager;
    private Filter filter;
    private Formatter formatter;
    private Level logLevel;
    private ErrorManager errorManager;
    private String encoding;
    boolean sealed;

    protected Handler() {
        this.manager = LogManager.getLogManager();
        this.logLevel = Level.ALL;
        this.errorManager = new ErrorManager();
        this.sealed = true;
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public void setFormatter(Formatter formatter) throws SecurityException {
        this.checkPermission();
        ((Object)((Object)formatter)).getClass();
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        this.checkPermission();
        if (string != null) {
            try {
                if (!Charset.isSupported(string)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string));
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedEncodingException(string));
            }
        }
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFilter(Filter filter) throws SecurityException {
        this.checkPermission();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setErrorManager(ErrorManager errorManager) {
        this.checkPermission();
        if (errorManager == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.errorManager = errorManager;
    }

    public ErrorManager getErrorManager() {
        this.checkPermission();
        return this.errorManager;
    }

    protected void reportError(String string, Exception exception, int n2) {
        try {
            this.errorManager.error(string, exception, n2);
        }
        catch (Exception exception2) {
            System.err.println("Handler.reportError caught:");
            exception2.printStackTrace();
        }
    }

    @af(modifiers=33)
    public void setLevel(Level level) throws SecurityException {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (level == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                this.checkPermission();
                this.logLevel = level;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=33)
    public Level getLevel() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                return this.logLevel;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        int n2 = this.getLevel().intValue();
        if (logRecord.getLevel().intValue() < n2 || n2 == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(logRecord);
    }

    void checkPermission() throws SecurityException {
        if (((Handler)((Object)((Object)this))).sealed) {
            this.manager.checkPermission();
        }
    }

    private static /* synthetic */ void _jr$ip$manager(Handler handler, LogManager logManager) {
        handler.manager = logManager;
    }

    static /* synthetic */ void _jr$ip$sealed(Object object, boolean bl) {
        ((Handler)((Object)object)).sealed = bl;
    }

    protected /* synthetic */ Handler(h h2) {
        super(h2);
    }
}

