/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class Level
extends h
implements Serializable {
    private static String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private String localizedLevelName;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, defaultBundle);
    public static final Level SEVERE = new Level("SEVERE", 1000, defaultBundle);
    public static final Level WARNING = new Level("WARNING", 900, defaultBundle);
    public static final Level INFO = new Level("INFO", 800, defaultBundle);
    public static final Level CONFIG = new Level("CONFIG", 700, defaultBundle);
    public static final Level FINE = new Level("FINE", 500, defaultBundle);
    public static final Level FINER = new Level("FINER", 400, defaultBundle);
    public static final Level FINEST = new Level("FINEST", 300, defaultBundle);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, defaultBundle);
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String string, int n2) {
        this(string, n2, null);
    }

    protected Level(String string, int n2, String string2) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.name = string;
        this.value = n2;
        this.resourceBundleName = string2;
        this.localizedLevelName = string2 == null ? string : null;
        KnownLevel.add(this);
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.getLocalizedLevelName();
    }

    final String getLevelName() {
        return this.name;
    }

    @af(modifiers=48)
    final String getLocalizedLevelName() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.localizedLevelName != null) {
                    return this.localizedLevelName;
                }
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
                    this.localizedLevelName = resourceBundle.getString(this.name);
                }
                catch (Exception exception) {
                    this.localizedLevelName = this.name;
                }
                return this.localizedLevelName;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    static Level findLevel(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        KnownLevel knownLevel = KnownLevel.findByName(string);
        if (knownLevel != null) {
            return knownLevel.mirroredLevel;
        }
        try {
            int n2 = Integer.parseInt(string);
            knownLevel = KnownLevel.findByValue(n2);
            if (knownLevel == null) {
                Level level = new Level(string, n2);
                knownLevel = KnownLevel.findByValue(n2);
            }
            return knownLevel.mirroredLevel;
        }
        catch (NumberFormatException numberFormatException) {
            knownLevel = KnownLevel.findByLocalizedLevelName(string);
            if (knownLevel != null) {
                return knownLevel.mirroredLevel;
            }
            return null;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    private Object readResolve() {
        KnownLevel knownLevel = KnownLevel.matches(this);
        if (knownLevel != null) {
            return knownLevel.levelObject;
        }
        Level level = new Level(this.name, this.value, this.resourceBundleName);
        return level;
    }

    public static synchronized Level parse(String string) throws IllegalArgumentException {
        string.length();
        KnownLevel knownLevel = KnownLevel.findByName(string);
        if (knownLevel != null) {
            return knownLevel.levelObject;
        }
        try {
            int n2 = Integer.parseInt(string);
            knownLevel = KnownLevel.findByValue(n2);
            if (knownLevel == null) {
                Level level = new Level(string, n2);
                knownLevel = KnownLevel.findByValue(n2);
            }
            return knownLevel.levelObject;
        }
        catch (NumberFormatException numberFormatException) {
            knownLevel = KnownLevel.findByLocalizedName(string);
            if (knownLevel != null) {
                return knownLevel.levelObject;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Bad level \"" + string + "\""));
        }
    }

    public boolean equals(Object object) {
        try {
            Level level = (Level)g.convertForCast((Object)object, Level.class);
            return level.value == this.value;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    private static /* synthetic */ void _jr$ip$name(Level level, String string) {
        level.name = string;
    }

    private static /* synthetic */ void _jr$ip$value(Level level, int n2) {
        level.value = n2;
    }

    private static /* synthetic */ void _jr$ip$resourceBundleName(Level level, String string) {
        level.resourceBundleName = string;
    }

    protected /* synthetic */ Level(h h2) {
        super(h2);
    }

    static final class KnownLevel
    extends h {
        private static Map<String, List<KnownLevel>> nameToLevels = new HashMap<String, List<KnownLevel>>();
        private static Map<Integer, List<KnownLevel>> intToLevels = new HashMap<Integer, List<KnownLevel>>();
        final Level levelObject;
        final Level mirroredLevel;

        KnownLevel(Level level) {
            this.levelObject = level;
            this.mirroredLevel = !f.ifAcmp(level.getClass(), Level.class) ? level : new Level(level.name, level.value, level.resourceBundleName);
        }

        static synchronized void add(Level level) {
            KnownLevel knownLevel = new KnownLevel(level);
            List<KnownLevel> list = (ArrayList<KnownLevel>)g.convertForCast(nameToLevels.get(level.name), List.class);
            if (list == null) {
                list = new ArrayList<KnownLevel>();
                nameToLevels.put(level.name, list);
            }
            list.add(knownLevel);
            list = (List)g.convertForCast(intToLevels.get(level.value), List.class);
            if (list == null) {
                list = new ArrayList();
                intToLevels.put(level.value, list);
            }
            list.add(knownLevel);
        }

        static synchronized KnownLevel findByName(String string) {
            List list = (List)g.convertForCast(nameToLevels.get(string), List.class);
            if (list != null) {
                return (KnownLevel)((Object)list.get(0));
            }
            return null;
        }

        static synchronized KnownLevel findByValue(int n2) {
            List list = (List)g.convertForCast(intToLevels.get(n2), List.class);
            if (list != null) {
                return (KnownLevel)((Object)list.get(0));
            }
            return null;
        }

        static synchronized KnownLevel findByLocalizedLevelName(String string) {
            Iterator<List<KnownLevel>> iterator = nameToLevels.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)g.convertForCast(iterator.next(), List.class);
                for (KnownLevel knownLevel : list) {
                    String string2 = knownLevel.levelObject.getLocalizedLevelName();
                    if (!string.equals(string2)) continue;
                    return knownLevel;
                }
            }
            return null;
        }

        static synchronized KnownLevel findByLocalizedName(String string) {
            Iterator<List<KnownLevel>> iterator = nameToLevels.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)g.convertForCast(iterator.next(), List.class);
                for (KnownLevel knownLevel : list) {
                    String string2 = knownLevel.levelObject.getLocalizedName();
                    if (!string.equals(string2)) continue;
                    return knownLevel;
                }
            }
            return null;
        }

        static synchronized KnownLevel matches(Level level) {
            List list = (List)g.convertForCast(nameToLevels.get(level.name), List.class);
            if (list != null) {
                for (KnownLevel knownLevel : list) {
                    Level level2 = knownLevel.mirroredLevel;
                    if (level.value != level2.value || f.ifAcmp((Object)level.resourceBundleName, (Object)level2.resourceBundleName) && (level.resourceBundleName == null || !level.resourceBundleName.equals(level2.resourceBundleName))) continue;
                    return knownLevel;
                }
            }
            return null;
        }

        static /* synthetic */ Level _jr$ig$levelObject(Object object) {
            return ((KnownLevel)((Object)object)).levelObject;
        }

        static /* synthetic */ void _jr$ip$levelObject(Object object, Level level) {
            ((KnownLevel)((Object)object)).levelObject = level;
        }

        static /* synthetic */ Level _jr$ig$mirroredLevel(Object object) {
            return ((KnownLevel)((Object)object)).mirroredLevel;
        }

        static /* synthetic */ void _jr$ip$mirroredLevel(Object object, Level level) {
            ((KnownLevel)((Object)object)).mirroredLevel = level;
        }
    }
}

