/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.Logging;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public class LogManager
extends h {
    private static LogManager manager;
    private Properties props;
    private PropertyChangeSupport changes;
    private static final Level defaultLevel;
    private final LoggerContext systemContext;
    private final LoggerContext userContext;
    private Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers;
    private boolean deathImminent;
    private final ReferenceQueue<Logger> loggerRefQueue;
    private static final int MAX_ITERATIONS = 400;
    private final Permission controlPermission;
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    protected LogManager() {
        this.props = new Properties();
        this.changes = new PropertyChangeSupport(LogManager.class);
        this.systemContext = new SystemLoggerContext();
        this.userContext = new LoggerContext();
        this.initializedGlobalHandlers = true;
        this.loggerRefQueue = new ReferenceQueue();
        this.controlPermission = new LoggingPermission("control", null);
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner(this));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static LogManager getLogManager() {
        if (manager != null) {
            manager.readPrimordialConfiguration();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrimordialConfiguration() {
        if (!this.readPrimordialConfiguration) {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    if (!this.readPrimordialConfiguration) {
                        if (System.out == null) {
                            return;
                        }
                        this.readPrimordialConfiguration = true;
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                                final /* synthetic */ LogManager this$0;
                                {
                                    this.this$0 = logManager;
                                }

                                public Void run() throws Exception {
                                    this.this$0.readConfiguration();
                                    PlatformLogger.redirectPlatformLoggers();
                                    return null;
                                }

                                static /* synthetic */ LogManager _jr$ig$this$0(Object object) {
                                    return (object).this$0;
                                }

                                static /* synthetic */ void _jr$ip$this$0(Object object, LogManager logManager) {
                                    (object).this$0 = logManager;
                                }
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        if (propertyChangeListener == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.checkPermission();
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        this.checkPermission();
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getUserContext() {
        LoggerContext loggerContext = null;
        SecurityManager securityManager = System.getSecurityManager();
        JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        if (securityManager != null && javaAWTAccess != null) {
            Object object = ah.getMonitor((Object)javaAWTAccess);
            synchronized (object) {
                try {
                    Object object2 = javaAWTAccess.getExecutionContext();
                    if (object2 == null) {
                        object2 = javaAWTAccess.getContext();
                    }
                    if (object2 != null && (loggerContext = (LoggerContext)((Object)g.convertForCast((Object)javaAWTAccess.get(object2, LoggerContext.class), LoggerContext.class))) == null) {
                        loggerContext = javaAWTAccess.isMainAppContext() ? this.userContext : new LoggerContext(true);
                        javaAWTAccess.put(object2, LoggerContext.class, (Object)loggerContext);
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return loggerContext != null ? loggerContext : this.userContext;
    }

    private List<LoggerContext> contexts() {
        ArrayList<LoggerContext> arrayList = new ArrayList<LoggerContext>();
        arrayList.add(this.systemContext);
        arrayList.add(this.getUserContext());
        return arrayList;
    }

    Logger demandLogger(String string, String string2, Class<?> clazz) {
        Logger logger = this.getLogger(string);
        if (logger == null) {
            Logger logger2 = new Logger(string, string2, clazz);
            do {
                if (!this.addLogger(logger2)) continue;
                return logger2;
            } while ((logger = this.getLogger(string)) == null);
        }
        return logger;
    }

    Logger demandSystemLogger(String string, String string2) {
        Logger logger;
        final Logger logger2 = this.systemContext.demandLogger(string, string2);
        while ((logger = this.addLogger(logger2) ? logger2 : this.getLogger(string)) == null) {
        }
        if (f.ifAcmp((Object)((Object)logger), (Object)((Object)logger2)) && a.arrayLength((Object[])logger2.getHandlers()) == 0) {
            final Logger logger3 = logger;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    logger3.mergeWithSystemLogger(logger2);
                    return null;
                }
            });
        }
        return logger2;
    }

    private void loadLoggerHandlers(Logger logger, String string, String string2) {
        AccessController.doPrivileged(new PrivilegedAction(this, string2, logger){
            final /* synthetic */ String val$handlersPropertyName;
            final /* synthetic */ Logger val$logger;
            final /* synthetic */ LogManager this$0;
            {
                this.this$0 = logManager;
                this.val$handlersPropertyName = string;
                this.val$logger = logger;
            }

            public Object run() {
                Object[] objectArray = this.this$0.parseClassNames((this).val$handlersPropertyName);
                for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                    String string = (String)a.arrayLoad((Object[])objectArray, (int)i);
                    try {
                        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                        Handler handler = (Handler)((Object)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), Handler.class));
                        String string2 = this.this$0.getProperty(string + ".level");
                        if (string2 != null) {
                            Level level = Level.findLevel(string2);
                            if (level != null) {
                                handler.setLevel(level);
                            } else {
                                System.err.println("Can't set level for " + string);
                            }
                        }
                        (this).val$logger.addHandler(handler);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Can't load log handler \"" + string + "\"");
                        System.err.println("" + exception);
                        exception.printStackTrace();
                    }
                }
                return null;
            }

            static /* synthetic */ void _jr$ip$val$handlersPropertyName(Object object, String string) {
                (object).val$handlersPropertyName = string;
            }

            static /* synthetic */ void _jr$ip$val$logger(Object object, Logger logger) {
                (object).val$logger = logger;
            }

            static /* synthetic */ LogManager _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, LogManager logManager) {
                (object).this$0 = logManager;
            }
        });
    }

    @af(modifiers=48)
    final void drainLoggerRefQueueBounded() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                LoggerWeakRef loggerWeakRef;
                for (int i = 0; i < 400 && this.loggerRefQueue != null && (loggerWeakRef = (LoggerWeakRef)this.loggerRefQueue.poll()) != null; ++i) {
                    loggerWeakRef.dispose();
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean addLogger(Logger logger) {
        String string = logger.getName();
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.drainLoggerRefQueueBounded();
        LoggerContext loggerContext = this.getUserContext();
        if (loggerContext.addLocalLogger(logger)) {
            this.loadLoggerHandlers(logger, string, string + ".handlers");
            return true;
        }
        return false;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger logger2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setParent(logger2);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setParent(logger2);
                return null;
            }
        });
    }

    public Logger getLogger(String string) {
        return this.getUserContext().findLogger(string);
    }

    public Enumeration<String> getLoggerNames() {
        return this.getUserContext().getLoggerNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readConfiguration() throws IOException, SecurityException {
        h h2;
        String string;
        this.checkPermission();
        String string2 = System.getProperty("java.util.logging.config.class");
        if (string2 != null) {
            try {
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                    ai.getCurrentClass(clazz).newInstance();
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
                    ai.getCurrentClass(clazz).newInstance();
                    return;
                }
            }
            catch (Exception exception) {
                System.err.println("Logging configuration class \"" + string2 + "\" failed");
                System.err.println("" + exception);
            }
        }
        if ((string = System.getProperty("java.util.logging.config.file")) == null) {
            string = System.getProperty("java.home");
            if (string == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Can't find java.home ??"));
            }
            h2 = new File(string, "lib");
            h2 = new File((File)h2, "logging.properties");
            string = h2.getCanonicalPath();
        }
        h2 = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)h2);
        try {
            this.readConfiguration(bufferedInputStream);
            if (h2 == null) return;
        }
        catch (Throwable throwable) {
            if (h2 == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            h2.close();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        h2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkPermission();
        Iterator<LoggerContext> iterator = ah.getMonitor((Object)((Object)this));
        synchronized (iterator) {
            try {
                this.props = new Properties();
                this.initializedGlobalHandlers = true;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        iterator = this.contexts().iterator();
        while (iterator.hasNext()) {
            LoggerContext loggerContext = (LoggerContext)((Object)g.convertForCast((Object)((Object)iterator.next()), LoggerContext.class));
            Enumeration<String> enumeration = loggerContext.getLoggerNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Logger logger = loggerContext.findLogger(string);
                if (logger == null) continue;
                this.resetLogger(logger);
            }
        }
    }

    private void resetLogger(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < a.arrayLength((Object[])handlerArray); ++i) {
            Handler handler = (Handler)((Object)g.convertForCast((Object)a.arrayLoad((Object[])handlerArray, (int)i), Handler.class));
            logger.removeHandler(handler);
            try {
                handler.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = logger.getName();
        if (string != null && string.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        string2 = string2.trim();
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        while (n2 < string2.length()) {
            int n3;
            for (n3 = n2; n3 < string2.length() && !Character.isWhitespace(string2.charAt(n3)) && string2.charAt(n3) != ','; ++n3) {
            }
            String string3 = string2.substring(n2, n3);
            n2 = n3 + 1;
            if ((string3 = string3.trim()).length() == 0) continue;
            vector.add(string3);
        }
        return vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkPermission();
        this.reset();
        this.props.load(inputStream);
        Object[] objectArray = this.parseClassNames("config");
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            String string = (String)a.arrayLoad((Object[])objectArray, (int)i);
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                ai.getCurrentClass(clazz).newInstance();
                continue;
            }
            catch (Exception exception) {
                System.err.println("Can't load config class \"" + string + "\"");
                System.err.println("" + exception);
            }
        }
        this.setLevelsOnExistingLoggers();
        this.changes.firePropertyChange(null, null, null);
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.initializedGlobalHandlers = false;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    String getStringProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    int getIntProperty(String string, int n2) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            return n2;
        }
    }

    boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        return bl;
    }

    Level getLevelProperty(String string, Level level) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return level;
        }
        Level level2 = Level.findLevel(string2.trim());
        return level2 != null ? level2 : level;
    }

    Filter getFilterProperty(String string, Filter filter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Filter)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), Filter.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filter;
    }

    Formatter getFormatterProperty(String string, Formatter formatter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Formatter)((Object)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), Formatter.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatter;
    }

    @af(modifiers=34)
    private void initializeGlobalHandlers() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.initializedGlobalHandlers) {
                    return;
                }
                this.initializedGlobalHandlers = true;
                if (this.deathImminent) {
                    return;
                }
                this.loadLoggerHandlers(this.rootLogger, null, "handlers");
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.controlPermission);
        }
    }

    public void checkAccess() throws SecurityException {
        this.checkPermission();
    }

    @af(modifiers=34)
    private void setLevelsOnExistingLoggers() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                Enumeration<?> enumeration = this.props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.endsWith(".level")) continue;
                    int n2 = string.length() - 6;
                    String string2 = string.substring(0, n2);
                    Level level = this.getLevelProperty(string, null);
                    if (level == null) {
                        System.err.println("Bad level value for property: " + string);
                        continue;
                    }
                    Iterator<LoggerContext> iterator = this.contexts().iterator();
                    while (iterator.hasNext()) {
                        LoggerContext loggerContext = (LoggerContext)((Object)g.convertForCast((Object)((Object)iterator.next()), LoggerContext.class));
                        Logger logger = loggerContext.findLogger(string2);
                        if (logger == null) continue;
                        logger.setLevel(level);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingMXBean == null) {
            loggingMXBean = new Logging();
        }
        return loggingMXBean;
    }

    static /* synthetic */ Logger access$202(LogManager logManager, Logger logger) {
        Logger logger2 = logger;
        logManager.rootLogger = logger2;
        return logger2;
    }

    static /* synthetic */ boolean access$602(LogManager logManager, boolean bl) {
        boolean bl2 = bl;
        logManager.deathImminent = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$702(LogManager logManager, boolean bl) {
        boolean bl2 = bl;
        logManager.initializedGlobalHandlers = bl2;
        return bl2;
    }

    static {
        defaultLevel = Level.INFO;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = null;
                try {
                    string = System.getProperty("java.util.logging.manager");
                    if (string != null) {
                        try {
                            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                            manager = (LogManager)((Object)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), LogManager.class));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                            manager = (LogManager)((Object)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), LogManager.class));
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not load Logmanager \"" + string + "\"");
                    exception.printStackTrace();
                }
                if (manager == null) {
                    manager = new LogManager();
                }
                LogManager logManager = manager;
                LogManager logManager2 = manager;
                ((Object)((Object)logManager2)).getClass();
                LogManager.access$202(logManager, new RootLogger(logManager2));
                manager.addLogger(manager.rootLogger);
                manager.systemContext.addLocalLogger(manager.rootLogger, false);
                manager.userContext.addLocalLogger(manager.rootLogger, false);
                Logger.global.setLogManager(manager);
                manager.addLogger(Logger.global);
                manager.systemContext.addLocalLogger(Logger.global, false);
                manager.userContext.addLocalLogger(Logger.global, false);
                return null;
            }
        });
        loggingMXBean = null;
    }

    private static /* synthetic */ void _jr$ip$changes(LogManager logManager, PropertyChangeSupport propertyChangeSupport) {
        logManager.changes = propertyChangeSupport;
    }

    private static /* synthetic */ void _jr$ip$systemContext(LogManager logManager, LoggerContext loggerContext) {
        logManager.systemContext = loggerContext;
    }

    private static /* synthetic */ void _jr$ip$userContext(LogManager logManager, LoggerContext loggerContext) {
        logManager.userContext = loggerContext;
    }

    private static /* synthetic */ void _jr$ip$loggerRefQueue(LogManager logManager, ReferenceQueue referenceQueue) {
        logManager.loggerRefQueue = referenceQueue;
    }

    private static /* synthetic */ void _jr$ip$controlPermission(LogManager logManager, Permission permission) {
        logManager.controlPermission = permission;
    }

    protected /* synthetic */ LogManager(h h2) {
        super(h2);
    }

    private class Cleaner
    extends Thread {
        final /* synthetic */ LogManager this$0;

        private Cleaner(LogManager logManager) {
            this.this$0 = logManager;
            this.setContextClassLoader(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogManager logManager = manager;
            Object object = ah.getMonitor((Object)((Object)((Cleaner)this).this$0));
            synchronized (object) {
                try {
                    LogManager.access$602(((Cleaner)this).this$0, true);
                    LogManager.access$702(((Cleaner)this).this$0, true);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            ((Cleaner)this).this$0.reset();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, LogManager logManager) {
            ((Cleaner)object).this$0 = logManager;
        }

        protected /* synthetic */ Cleaner(h h2) {
            super(h2);
        }
    }

    private static class LogNode
    extends h {
        HashMap<String, LogNode> children;
        LoggerWeakRef loggerRef;
        LogNode parent;
        final LoggerContext context;

        LogNode(LogNode logNode, LoggerContext loggerContext) {
            this.parent = logNode;
            this.context = loggerContext;
        }

        void walkAndSetParent(Logger logger) {
            if (((LogNode)((Object)((Object)this))).children == null) {
                return;
            }
            Iterator iterator = ((LogNode)((Object)((Object)this))).children.values().iterator();
            while (iterator.hasNext()) {
                Logger logger2;
                LogNode logNode = (LogNode)((Object)g.convertForCast(iterator.next(), LogNode.class));
                LoggerWeakRef loggerWeakRef = ((LogNode)((Object)((Object)logNode))).loggerRef;
                Logger logger3 = logger2 = loggerWeakRef == null ? null : (Logger)((Object)g.convertForCast(loggerWeakRef.get(), Logger.class));
                if (logger2 == null) {
                    logNode.walkAndSetParent(logger);
                    continue;
                }
                LogManager.doSetParent(logger2, logger);
            }
        }

        static /* synthetic */ void _jr$ip$parent(Object object, LogNode logNode) {
            ((LogNode)((Object)object)).parent = logNode;
        }

        static /* synthetic */ void _jr$ip$context(Object object, LoggerContext loggerContext) {
            ((LogNode)((Object)object)).context = loggerContext;
        }

        protected /* synthetic */ LogNode(h h2) {
            super(h2);
        }
    }

    static class LoggerContext
    extends h {
        private final Hashtable<String, LoggerWeakRef> namedLoggers;
        private final LogNode root;
        private final boolean requiresDefaultLoggers;

        private LoggerContext() {
            this(false);
        }

        private LoggerContext(boolean bl) {
            this.namedLoggers = new Hashtable();
            this.root = new LogNode(null, this);
            this.requiresDefaultLoggers = bl;
        }

        Logger demandLogger(String string, String string2) {
            return manager.demandLogger(string, string2, null);
        }

        private void ensureInitialized() {
            if (this.requiresDefaultLoggers) {
                this.ensureDefaultLogger(manager.rootLogger);
                this.ensureDefaultLogger(Logger.global);
            }
        }

        @af(modifiers=32)
        Logger findLogger(String string) {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    this.ensureInitialized();
                    LoggerWeakRef loggerWeakRef = (LoggerWeakRef)((Object)this.namedLoggers.get(string));
                    if (loggerWeakRef == null) {
                        return null;
                    }
                    Logger logger = (Logger)((Object)g.convertForCast(loggerWeakRef.get(), Logger.class));
                    if (logger == null) {
                        this.removeLogger(string);
                    }
                    return logger;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            if (this.requiresDefaultLoggers) {
                String string = logger.getName();
                if (!string.isEmpty()) {
                    this.ensureDefaultLogger(manager.rootLogger);
                }
                if (!"global".equals(string)) {
                    this.ensureDefaultLogger(Logger.global);
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            if (!this.requiresDefaultLoggers || logger == null || f.ifAcmp((Object)((Object)logger), (Object)((Object)Logger.global)) && f.ifAcmp((Object)((Object)logger), (Object)((Object)manager.rootLogger))) {
                if (!$assertionsDisabled && logger != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
                }
                return;
            }
            if (!this.namedLoggers.containsKey(logger.getName())) {
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            return this.addLocalLogger(logger, this.requiresDefaultLoggers);
        }

        @af(modifiers=32)
        boolean addLocalLogger(Logger logger, boolean bl) {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    LoggerWeakRef loggerWeakRef;
                    String string;
                    if (bl) {
                        this.ensureAllDefaultLoggers(logger);
                    }
                    if ((string = logger.getName()) == null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                    }
                    LoggerWeakRef loggerWeakRef2 = (LoggerWeakRef)((Object)this.namedLoggers.get(string));
                    if (loggerWeakRef2 != null) {
                        if (loggerWeakRef2.get() == null) {
                            this.removeLogger(string);
                        } else {
                            return false;
                        }
                    }
                    LogManager logManager = manager;
                    ((Object)((Object)logManager)).getClass();
                    loggerWeakRef2 = logManager.new LoggerWeakRef(logger);
                    this.namedLoggers.put(string, loggerWeakRef2);
                    Level level = manager.getLevelProperty(string + ".level", null);
                    if (level != null) {
                        LogManager.doSetLevel(logger, level);
                    }
                    this.processParentHandlers(logger, string);
                    LogNode logNode = this.getNode(string);
                    ((LogNode)((Object)((Object)logNode))).loggerRef = loggerWeakRef2;
                    Logger logger2 = null;
                    LogNode logNode2 = ((LogNode)((Object)((Object)logNode))).parent;
                    while (logNode2 != null && ((loggerWeakRef = ((LogNode)((Object)((Object)logNode2))).loggerRef) == null || (logger2 = (Logger)((Object)g.convertForCast(loggerWeakRef.get(), Logger.class))) == null)) {
                        logNode2 = ((LogNode)((Object)((Object)logNode2))).parent;
                    }
                    if (logger2 != null) {
                        LogManager.doSetParent(logger, logger2);
                    }
                    logNode.walkAndSetParent(logger);
                    loggerWeakRef2.setNode(logNode);
                    return true;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        void removeLogger(String string) {
            this.namedLoggers.remove(string);
        }

        @af(modifiers=32)
        Enumeration<String> getLoggerNames() {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    this.ensureInitialized();
                    return this.namedLoggers.keys();
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        private void processParentHandlers(Logger logger, String string) {
            int n2;
            AccessController.doPrivileged(new PrivilegedAction(this, logger, string){
                final /* synthetic */ Logger val$logger;
                final /* synthetic */ String val$name;
                final /* synthetic */ LoggerContext this$0;
                {
                    this.this$0 = loggerContext;
                    this.val$logger = logger;
                    this.val$name = string;
                }

                public Void run() {
                    boolean bl;
                    if (f.ifAcmp((Object)((Object)(this).val$logger), (Object)((Object)manager.rootLogger)) && !(bl = manager.getBooleanProperty((this).val$name + ".useParentHandlers", true))) {
                        (this).val$logger.setUseParentHandlers(false);
                    }
                    return null;
                }

                static /* synthetic */ void _jr$ip$val$logger(Object object, Logger logger) {
                    (object).val$logger = logger;
                }

                static /* synthetic */ void _jr$ip$val$name(Object object, String string) {
                    (object).val$name = string;
                }

                static /* synthetic */ LoggerContext _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, LoggerContext loggerContext) {
                    (object).this$0 = loggerContext;
                }
            });
            int n3 = 1;
            while ((n2 = string.indexOf(".", n3)) >= 0) {
                String string2 = string.substring(0, n2);
                if (manager.getProperty(string2 + ".level") != null || manager.getProperty(string2 + ".handlers") != null) {
                    this.demandLogger(string2, null);
                }
                n3 = n2 + 1;
            }
        }

        LogNode getNode(String string) {
            if (string == null || string.equals("")) {
                return this.root;
            }
            LogNode logNode = this.root;
            while (string.length() > 0) {
                LogNode logNode2;
                String string2;
                int n2 = string.indexOf(".");
                if (n2 > 0) {
                    string2 = string.substring(0, n2);
                    string = string.substring(n2 + 1);
                } else {
                    string2 = string;
                    string = "";
                }
                if (((LogNode)((Object)((Object)logNode))).children == null) {
                    ((LogNode)((Object)((Object)logNode))).children = new HashMap();
                }
                if ((logNode2 = (LogNode)((Object)g.convertForCast(((LogNode)((Object)((Object)logNode))).children.get(string2), LogNode.class))) == null) {
                    logNode2 = new LogNode(logNode, this);
                    ((LogNode)((Object)((Object)logNode))).children.put(string2, logNode2);
                }
                logNode = logNode2;
            }
            return logNode;
        }

        private static /* synthetic */ void _jr$ip$namedLoggers(LoggerContext loggerContext, Hashtable hashtable) {
            loggerContext.namedLoggers = hashtable;
        }

        private static /* synthetic */ void _jr$ip$root(LoggerContext loggerContext, LogNode logNode) {
            loggerContext.root = logNode;
        }

        private static /* synthetic */ void _jr$ip$requiresDefaultLoggers(LoggerContext loggerContext, boolean bl) {
            loggerContext.requiresDefaultLoggers = bl;
        }

        protected /* synthetic */ LoggerContext(h h2) {
            super(h2);
        }
    }

    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private String name;
        private LogNode node;
        private WeakReference<Logger> parentRef;

        LoggerWeakRef(Logger logger) {
            super(logger, LogManager.this.loggerRefQueue);
            this.name = logger.getName();
        }

        void dispose() {
            if (this.node != null) {
                ((LogNode)((Object)((Object)this.node))).context.removeLogger(this.name);
                this.name = null;
                ((LogNode)((Object)((Object)this.node))).loggerRef = null;
                this.node = null;
            }
            if (this.parentRef != null) {
                Logger logger = (Logger)((Object)g.convertForCast(this.parentRef.get(), Logger.class));
                if (logger != null) {
                    logger.removeChildLogger(this);
                }
                this.parentRef = null;
            }
        }

        void setNode(LogNode logNode) {
            this.node = logNode;
        }

        void setParentRef(WeakReference<Logger> weakReference) {
            this.parentRef = weakReference;
        }

        private static /* synthetic */ String _jr$ig$name(LoggerWeakRef loggerWeakRef) {
            return loggerWeakRef.name;
        }

        private static /* synthetic */ void _jr$ip$name(LoggerWeakRef loggerWeakRef, String string) {
            loggerWeakRef.name = string;
        }

        private static /* synthetic */ LogNode _jr$ig$node(LoggerWeakRef loggerWeakRef) {
            return loggerWeakRef.node;
        }

        private static /* synthetic */ void _jr$ip$node(LoggerWeakRef loggerWeakRef, LogNode logNode) {
            loggerWeakRef.node = logNode;
        }

        private static /* synthetic */ WeakReference _jr$ig$parentRef(LoggerWeakRef loggerWeakRef) {
            return loggerWeakRef.parentRef;
        }

        private static /* synthetic */ void _jr$ip$parentRef(LoggerWeakRef loggerWeakRef, WeakReference weakReference) {
            loggerWeakRef.parentRef = weakReference;
        }

        static /* synthetic */ LogManager _jr$ig$this$0(Object object) {
            return ((LoggerWeakRef)((Object)object)).LogManager.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, LogManager logManager) {
            ((LoggerWeakRef)((Object)object)).LogManager.this = logManager;
        }
    }

    private class RootLogger
    extends Logger {
        final /* synthetic */ LogManager this$0;

        private RootLogger(LogManager logManager) {
            this.this$0 = logManager;
            super("", null);
            this.setLevel(defaultLevel);
        }

        @Override
        public void log(LogRecord logRecord) {
            ((RootLogger)((Object)((Object)this))).this$0.initializeGlobalHandlers();
            super.log(logRecord);
        }

        @Override
        public void addHandler(Handler handler) {
            ((RootLogger)((Object)((Object)this))).this$0.initializeGlobalHandlers();
            super.addHandler(handler);
        }

        @Override
        public void removeHandler(Handler handler) {
            ((RootLogger)((Object)((Object)this))).this$0.initializeGlobalHandlers();
            super.removeHandler(handler);
        }

        @Override
        public Handler[] getHandlers() {
            ((RootLogger)((Object)((Object)this))).this$0.initializeGlobalHandlers();
            return super.getHandlers();
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, LogManager logManager) {
            ((RootLogger)((Object)object)).this$0 = logManager;
        }

        protected /* synthetic */ RootLogger(h h2) {
            super(h2);
        }
    }

    static class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext() {
        }

        @Override
        Logger demandLogger(String string, String string2) {
            Logger logger = this.findLogger(string);
            if (logger == null) {
                Logger logger2 = new Logger(string, string2);
                while ((logger = this.addLocalLogger(logger2) ? logger2 : this.findLogger(string)) == null) {
                }
            }
            return logger;
        }

        protected /* synthetic */ SystemLoggerContext(h h2) {
            super(h2);
        }
    }
}

