/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private LogManager manager;
    private OutputStream output;
    private boolean doneHeader;
    private Writer writer;

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = x.getName(((Object)((Object)this)).getClass());
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.INFO));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public StreamHandler() {
        this.manager = LogManager.getLogManager();
        this.sealed = false;
        this.configure();
        this.sealed = true;
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        this.manager = LogManager.getLogManager();
        this.sealed = false;
        this.configure();
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
        this.sealed = true;
    }

    @af(modifiers=36)
    protected void setOutputStream(OutputStream outputStream) throws SecurityException {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (outputStream == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
                }
                this.flushAndClose();
                this.output = outputStream;
                this.doneHeader = false;
                String string = this.getEncoding();
                if (string == null) {
                    this.writer = new OutputStreamWriter(this.output);
                } else {
                    try {
                        this.writer = new OutputStreamWriter(this.output, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Error("Unexpected exception " + unsupportedEncodingException));
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        if (this.output == null) {
            return;
        }
        this.flush();
        if (string == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            this.writer = new OutputStreamWriter(this.output, string);
        }
    }

    @Override
    @af(modifiers=33)
    public void publish(LogRecord logRecord) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                String string;
                if (!this.isLoggable(logRecord)) {
                    return;
                }
                try {
                    string = this.getFormatter().format(logRecord);
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 5);
                    return;
                }
                try {
                    if (!this.doneHeader) {
                        this.writer.write(this.getFormatter().getHead(this));
                        this.doneHeader = true;
                    }
                    this.writer.write(string);
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 1);
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        if (this.writer == null || logRecord == null) {
            return false;
        }
        return super.isLoggable(logRecord);
    }

    @Override
    @af(modifiers=33)
    public void flush() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.writer != null) {
                    try {
                        this.writer.flush();
                    }
                    catch (Exception exception) {
                        this.reportError(null, exception, 2);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @af(modifiers=34)
    private void flushAndClose() throws SecurityException {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.checkPermission();
                if (this.writer != null) {
                    try {
                        if (!this.doneHeader) {
                            this.writer.write(this.getFormatter().getHead(this));
                            this.doneHeader = true;
                        }
                        this.writer.write(this.getFormatter().getTail(this));
                        this.writer.flush();
                        this.writer.close();
                    }
                    catch (Exception exception) {
                        this.reportError(null, exception, 3);
                    }
                    this.writer = null;
                    this.output = null;
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void close() throws SecurityException {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.flushAndClose();
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private static /* synthetic */ LogManager _jr$ig$manager(StreamHandler streamHandler) {
        return streamHandler.manager;
    }

    private static /* synthetic */ void _jr$ip$manager(StreamHandler streamHandler, LogManager logManager) {
        streamHandler.manager = logManager;
    }

    protected /* synthetic */ StreamHandler(h h2) {
        super(h2);
    }
}

