/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import com.zeroturnaround.jrebelbase.h;
import java.util.regex.ASCII;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
extends h
implements MatchResult {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    int lookbehindTo;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = 0;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds = false;
    boolean anchoringBounds = true;

    Matcher() {
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.parentPattern = pattern;
        this.text = charSequence;
        int n2 = Math.max(Pattern._jr$ig$capturingGroupCount(pattern), 10);
        this.groups = new int[n2 * 2];
        this.locals = new int[Pattern._jr$ig$localCount(pattern)];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        Matcher matcher = new Matcher(this.parentPattern, this.text.toString());
        matcher.first = this.first;
        matcher.last = this.last;
        matcher.groups = (int[])this.groups.clone();
        return matcher;
    }

    public Matcher usePattern(Pattern pattern) {
        int n2;
        if (pattern == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Pattern cannot be null"));
        }
        this.parentPattern = pattern;
        int n3 = Math.max(Pattern._jr$ig$capturingGroupCount(pattern), 10);
        this.groups = new int[n3 * 2];
        this.locals = new int[Pattern._jr$ig$localCount(pattern)];
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            this.groups[n2] = -1;
        }
        for (n2 = 0; n2 < this.locals.length; ++n2) {
            this.locals[n2] = -1;
        }
        return this;
    }

    public Matcher reset() {
        int n2;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            this.groups[n2] = -1;
        }
        for (n2 = 0; n2 < this.locals.length; ++n2) {
            this.locals[n2] = -1;
        }
        this.lastAppendPosition = 0;
        this.from = 0;
        this.to = this.getTextLength();
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.text = charSequence;
        return this.reset();
    }

    @Override
    public int start() {
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match available"));
        }
        return this.first;
    }

    @Override
    public int start(int n2) {
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match available"));
        }
        if (n2 > this.groupCount()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("No group " + n2));
        }
        return this.groups[n2 * 2];
    }

    @Override
    public int end() {
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match available"));
        }
        return this.last;
    }

    @Override
    public int end(int n2) {
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match available"));
        }
        if (n2 > this.groupCount()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("No group " + n2));
        }
        return this.groups[n2 * 2 + 1];
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int n2) {
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match found"));
        }
        if (n2 < 0 || n2 > this.groupCount()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("No group " + n2));
        }
        if (this.groups[n2 * 2] == -1 || this.groups[n2 * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[n2 * 2], this.groups[n2 * 2 + 1]).toString();
    }

    @Override
    public String group(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Null group name"));
        }
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match found"));
        }
        if (!this.parentPattern.namedGroups().containsKey(string)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No group with name <" + string + ">"));
        }
        int n2 = this.parentPattern.namedGroups().get(string);
        if (this.groups[n2 * 2] == -1 || this.groups[n2 * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[n2 * 2], this.groups[n2 * 2 + 1]).toString();
    }

    @Override
    public int groupCount() {
        return Pattern._jr$ig$capturingGroupCount(this.parentPattern) - 1;
    }

    public boolean matches() {
        return this.match(this.from, 1);
    }

    public boolean find() {
        int n2 = this.last;
        if (n2 == this.first) {
            ++n2;
        }
        if (n2 < this.from) {
            n2 = this.from;
        }
        if (n2 > this.to) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = -1;
            }
            return false;
        }
        return this.search(n2);
    }

    public boolean find(int n2) {
        int n3 = this.getTextLength();
        if (n2 < 0 || n2 > n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("Illegal start index"));
        }
        this.reset();
        return this.search(n2);
    }

    public boolean lookingAt() {
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(36) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '$') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        if (this.first < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("No match available"));
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\\') {
                c = string.charAt(++n2);
                stringBuilder.append(c);
                ++n2;
                continue;
            }
            if (c == '$') {
                c = string.charAt(++n2);
                int n3 = -1;
                if (c == '{') {
                    ++n2;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    while (n2 < string.length() && (ASCII.isLower(c = string.charAt(n2)) || ASCII.isUpper(c) || ASCII.isDigit(c))) {
                        stringBuilder2.append(c);
                        ++n2;
                    }
                    if (stringBuilder2.length() == 0) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("named capturing group has 0 length name"));
                    }
                    if (c != '}') {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("named capturing group is missing trailing '}'"));
                    }
                    String string2 = stringBuilder2.toString();
                    if (ASCII.isDigit(string2.charAt(0))) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("capturing group name {" + string2 + "} starts with digit character"));
                    }
                    if (!this.parentPattern.namedGroups().containsKey(string2)) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No group with name {" + string2 + "}"));
                    }
                    n3 = this.parentPattern.namedGroups().get(string2);
                    ++n2;
                } else {
                    int n4;
                    n3 = c - 48;
                    if (n3 < 0 || n3 > 9) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal group reference"));
                    }
                    ++n2;
                    boolean bl = false;
                    while (!bl && n2 < string.length() && (n4 = string.charAt(n2) - 48) >= 0 && n4 <= 9) {
                        int n5 = n3 * 10 + n4;
                        if (this.groupCount() < n5) {
                            bl = true;
                            continue;
                        }
                        n3 = n5;
                        ++n2;
                    }
                }
                if (this.start(n3) == -1 || this.end(n3) == -1) continue;
                stringBuilder.append(this.text, this.start(n3), this.end(n3));
                continue;
            }
            stringBuilder.append(c);
            ++n2;
        }
        stringBuffer.append(this.text, this.lastAppendPosition, this.first);
        stringBuffer.append(stringBuilder);
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.text, this.lastAppendPosition, this.getTextLength());
        return stringBuffer;
    }

    public String replaceAll(String string) {
        this.reset();
        boolean bl = this.find();
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                this.appendReplacement(stringBuffer, string);
            } while (bl = this.find());
            this.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return this.text.toString();
    }

    public String replaceFirst(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("replacement"));
        }
        this.reset();
        if (!this.find()) {
            return this.text.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendReplacement(stringBuffer, string);
        this.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public Matcher region(int n2, int n3) {
        if (n2 < 0 || n2 > this.getTextLength()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("start"));
        }
        if (n3 < 0 || n3 > this.getTextLength()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("end"));
        }
        if (n2 > n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException("start > end"));
        }
        this.reset();
        this.from = n2;
        this.to = n3;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean bl) {
        this.transparentBounds = bl;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean bl) {
        this.anchoringBounds = bl;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("java.util.regex.Matcher");
        stringBuilder.append("[pattern=" + this.pattern());
        stringBuilder.append(" region=");
        stringBuilder.append(this.regionStart() + "," + this.regionEnd());
        stringBuilder.append(" lastmatch=");
        if (this.first >= 0 && this.group() != null) {
            stringBuilder.append(this.group());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int n2) {
        boolean bl;
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = n2 = n2 < 0 ? 0 : n2;
        this.oldLast = this.oldLast < 0 ? n2 : this.oldLast;
        for (bl = false; bl < this.groups.length; bl += 1) {
            this.groups[bl] = -1;
        }
        this.acceptMode = 0;
        bl = Pattern._jr$ig$root(this.parentPattern).match(this, n2, this.text);
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    boolean match(int n2, int n3) {
        boolean bl;
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = n2 = n2 < 0 ? 0 : n2;
        this.oldLast = this.oldLast < 0 ? n2 : this.oldLast;
        for (bl = false; bl < this.groups.length; bl += 1) {
            this.groups[bl] = -1;
        }
        this.acceptMode = n3;
        bl = Pattern._jr$ig$matchRoot(this.parentPattern).match(this, n2, this.text);
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int n2, int n3) {
        return this.text.subSequence(n2, n3);
    }

    char charAt(int n2) {
        return this.text.charAt(n2);
    }

    static /* synthetic */ Pattern _jr$ig$parentPattern(Object object) {
        return ((Matcher)object).parentPattern;
    }

    static /* synthetic */ void _jr$ip$parentPattern(Object object, Pattern pattern) {
        ((Matcher)object).parentPattern = pattern;
    }

    static /* synthetic */ int[] _jr$ig$groups(Object object) {
        return ((Matcher)object).groups;
    }

    static /* synthetic */ void _jr$ip$groups(Object object, int[] nArray) {
        ((Matcher)object).groups = nArray;
    }

    static /* synthetic */ int _jr$ig$from(Object object) {
        return ((Matcher)object).from;
    }

    static /* synthetic */ void _jr$ip$from(Object object, int n2) {
        ((Matcher)object).from = n2;
    }

    static /* synthetic */ int _jr$ig$to(Object object) {
        return ((Matcher)object).to;
    }

    static /* synthetic */ void _jr$ip$to(Object object, int n2) {
        ((Matcher)object).to = n2;
    }

    static /* synthetic */ int _jr$ig$lookbehindTo(Object object) {
        return ((Matcher)object).lookbehindTo;
    }

    static /* synthetic */ void _jr$ip$lookbehindTo(Object object, int n2) {
        ((Matcher)object).lookbehindTo = n2;
    }

    static /* synthetic */ CharSequence _jr$ig$text(Object object) {
        return ((Matcher)object).text;
    }

    static /* synthetic */ void _jr$ip$text(Object object, CharSequence charSequence) {
        ((Matcher)object).text = charSequence;
    }

    static /* synthetic */ int _jr$ig$acceptMode(Object object) {
        return ((Matcher)object).acceptMode;
    }

    static /* synthetic */ void _jr$ip$acceptMode(Object object, int n2) {
        ((Matcher)object).acceptMode = n2;
    }

    static /* synthetic */ int _jr$ig$first(Object object) {
        return ((Matcher)object).first;
    }

    static /* synthetic */ void _jr$ip$first(Object object, int n2) {
        ((Matcher)object).first = n2;
    }

    static /* synthetic */ int _jr$ig$last(Object object) {
        return ((Matcher)object).last;
    }

    static /* synthetic */ void _jr$ip$last(Object object, int n2) {
        ((Matcher)object).last = n2;
    }

    static /* synthetic */ int _jr$ig$oldLast(Object object) {
        return ((Matcher)object).oldLast;
    }

    static /* synthetic */ void _jr$ip$oldLast(Object object, int n2) {
        ((Matcher)object).oldLast = n2;
    }

    static /* synthetic */ int _jr$ig$lastAppendPosition(Object object) {
        return ((Matcher)object).lastAppendPosition;
    }

    static /* synthetic */ void _jr$ip$lastAppendPosition(Object object, int n2) {
        ((Matcher)object).lastAppendPosition = n2;
    }

    static /* synthetic */ int[] _jr$ig$locals(Object object) {
        return ((Matcher)object).locals;
    }

    static /* synthetic */ void _jr$ip$locals(Object object, int[] nArray) {
        ((Matcher)object).locals = nArray;
    }

    static /* synthetic */ boolean _jr$ig$hitEnd(Object object) {
        return ((Matcher)object).hitEnd;
    }

    static /* synthetic */ void _jr$ip$hitEnd(Object object, boolean bl) {
        ((Matcher)object).hitEnd = bl;
    }

    static /* synthetic */ boolean _jr$ig$requireEnd(Object object) {
        return ((Matcher)object).requireEnd;
    }

    static /* synthetic */ void _jr$ip$requireEnd(Object object, boolean bl) {
        ((Matcher)object).requireEnd = bl;
    }

    static /* synthetic */ boolean _jr$ig$transparentBounds(Object object) {
        return ((Matcher)object).transparentBounds;
    }

    static /* synthetic */ void _jr$ip$transparentBounds(Object object, boolean bl) {
        ((Matcher)object).transparentBounds = bl;
    }

    static /* synthetic */ boolean _jr$ig$anchoringBounds(Object object) {
        return ((Matcher)object).anchoringBounds;
    }

    static /* synthetic */ void _jr$ip$anchoringBounds(Object object, boolean bl) {
        ((Matcher)object).anchoringBounds = bl;
    }
}

