/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import java.util.regex.UnicodeProp;
import sun.text.Normalizer;

public final class Pattern
extends com.zeroturnaround.jrebelbase.h
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient int[] buffer;
    volatile transient Map<String, Integer> namedGroups;
    transient GroupHead[] groupNodes;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    private transient boolean hasSupplementary;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node lookbehindEnd = new Node(){

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 == Matcher._jr$ig$lookbehindTo(matcher);
        }
    };
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n2) {
        return new Pattern(string, n2);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Matcher matcher(CharSequence charSequence) {
        if (this.compiled) return new Matcher(this, charSequence);
        com.zeroturnaround.jrebelbase.h h2 = this;
        synchronized (h2) {
            try {
                if (this.compiled) return new Matcher(this, charSequence);
                this.compile();
                // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var2_2 /* !! */ )] (shouldn't be in output)
                return new Matcher(this, charSequence);
            }
            catch (Throwable throwable) {
                // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var2_2 /* !! */ )] (shouldn't be in output)
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
            }
        }
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String string, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        return matcher.matches();
    }

    public String[] split(CharSequence charSequence, int n2) {
        int n3;
        int n4 = 0;
        boolean bl = n2 > 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.matcher(charSequence);
        while (matcher.find()) {
            String string;
            if (!bl || arrayList.size() < n2 - 1) {
                string = charSequence.subSequence(n4, matcher.start()).toString();
                arrayList.add(string);
                n4 = matcher.end();
                continue;
            }
            if (arrayList.size() != n2 - 1) continue;
            string = charSequence.subSequence(n4, charSequence.length()).toString();
            arrayList.add(string);
            n4 = matcher.end();
        }
        if (n4 == 0) {
            return new String[]{charSequence.toString()};
        }
        if (!bl || arrayList.size() < n2) {
            arrayList.add(charSequence.subSequence(n4, charSequence.length()).toString());
        }
        if (n2 == 0) {
            for (n3 = arrayList.size(); n3 > 0 && ((String)arrayList.get(n3 - 1)).equals(""); --n3) {
            }
        }
        String[] stringArray = new String[n3];
        return arrayList.subList(0, n3).toArray(stringArray);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public static String quote(String string) {
        int n2 = string.indexOf("\\E");
        if (n2 == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        stringBuilder.append("\\Q");
        n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf("\\E", n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2));
            n3 = n2 + 2;
            stringBuilder.append("\\E\\\\E\\Q");
        }
        stringBuilder.append(string.substring(n3, string.length()));
        stringBuilder.append("\\E");
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capturingGroupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
            this.compiled = true;
        }
    }

    private Pattern(String string, int n2) {
        this.pattern = string;
        this.flags = n2;
        if ((this.flags & 0x100) != 0) {
            this.flags |= 0x40;
        }
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        int n2;
        boolean bl = false;
        int n3 = -1;
        this.normalizedPattern = java.text.Normalizer.normalize(this.pattern, Normalizer.Form.NFD);
        this.patternLength = this.normalizedPattern.length();
        StringBuilder stringBuilder = new StringBuilder(this.patternLength);
        for (int i = 0; i < this.patternLength; i += Character.charCount(n2)) {
            n2 = this.normalizedPattern.codePointAt(i);
            if (Character.getType(n2) == 6 && n3 != -1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n3);
                stringBuilder2.appendCodePoint(n2);
                while (Character.getType(n2) == 6 && (i += Character.charCount(n2)) < this.patternLength) {
                    n2 = this.normalizedPattern.codePointAt(i);
                    stringBuilder2.appendCodePoint(n2);
                }
                String string = this.produceEquivalentAlternation(stringBuilder2.toString());
                stringBuilder.setLength(stringBuilder.length() - Character.charCount(n3));
                stringBuilder.append("(?:").append(string).append(")");
            } else if (n2 == 91 && n3 != 92) {
                i = this.normalizeCharClass(stringBuilder, i);
            } else {
                stringBuilder.appendCodePoint(n2);
            }
            n3 = n2;
        }
        this.normalizedPattern = stringBuilder.toString();
    }

    private int normalizeCharClass(StringBuilder stringBuilder, int n2) {
        int n3;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        int n4 = -1;
        ++n2;
        stringBuilder2.append("[");
        while (true) {
            if ((n3 = this.normalizedPattern.codePointAt(n2)) == 93 && n4 != 92) break;
            if (Character.getType(n3) == 6) {
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.appendCodePoint(n4);
                while (Character.getType(n3) == 6) {
                    stringBuilder4.appendCodePoint(n3);
                    if ((n2 += Character.charCount(n3)) >= this.normalizedPattern.length()) break;
                    n3 = this.normalizedPattern.codePointAt(n2);
                }
                String string = this.produceEquivalentAlternation(stringBuilder4.toString());
                stringBuilder2.setLength(stringBuilder2.length() - Character.charCount(n4));
                if (stringBuilder3 == null) {
                    stringBuilder3 = new StringBuilder();
                }
                stringBuilder3.append('|');
                stringBuilder3.append(string);
            } else {
                stringBuilder2.appendCodePoint(n3);
                ++n2;
            }
            if (n2 == this.normalizedPattern.length()) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unclosed character class"));
            }
            n4 = n3;
        }
        stringBuilder2.append((char)n3);
        String string = stringBuilder3 != null ? "(?:" + stringBuilder2.toString() + stringBuilder3.toString() + ")" : stringBuilder2.toString();
        stringBuilder.append(string);
        return n2;
    }

    private String produceEquivalentAlternation(String string) {
        int n2 = Pattern.countChars(string, 0, 1);
        if (string.length() == n2) {
            return string;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2);
        String[] stringArray = this.producePermutations(string3);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = string2 + stringArray[i];
            if (i > 0) {
                stringBuilder.append("|" + string4);
            }
            if ((string4 = this.composeOneStep(string4)) == null) continue;
            stringBuilder.append("|" + this.produceEquivalentAlternation(string4));
        }
        return stringBuilder.toString();
    }

    private String[] producePermutations(String string) {
        int n2;
        int n3;
        if (string.length() == Pattern.countChars(string, 0, 1)) {
            return new String[]{string};
        }
        if (string.length() == Pattern.countChars(string, 0, 2)) {
            int n4 = Character.codePointAt(string, 0);
            int n5 = Character.codePointAt(string, Character.charCount(n4));
            if (this.getClass(n5) == this.getClass(n4)) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.appendCodePoint(n5);
            stringBuilder.appendCodePoint(n4);
            stringArray[1] = stringBuilder.toString();
            return stringArray;
        }
        int n6 = 1;
        int n7 = Pattern.countCodePoints(string);
        for (int i = 1; i < n7; ++i) {
            n6 *= i + 1;
        }
        String[] stringArray = new String[n6];
        int[] nArray = new int[n7];
        int n8 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = Character.codePointAt(string, n8);
            nArray[n3] = this.getClass(n2);
            n8 += Character.charCount(n2);
        }
        n3 = 0;
        n2 = 0;
        int n9 = 0;
        while (n2 < n7) {
            block10: {
                n8 = Pattern.countChars(string, n9, 1);
                boolean bl = false;
                for (int i = n2 - 1; i >= 0; --i) {
                    if (nArray[i] != nArray[n2]) {
                        continue;
                    }
                    break block10;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                String string2 = stringBuilder.delete(n9, n9 + n8).toString();
                String[] stringArray2 = this.producePermutations(string2);
                String string3 = string.substring(n9, n9 + n8);
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[n3++] = string3 + stringArray2[i];
                }
            }
            ++n2;
            n9 += n8;
        }
        String[] stringArray3 = new String[n3];
        for (n9 = 0; n9 < n3; ++n9) {
            stringArray3[n9] = stringArray[n9];
        }
        return stringArray3;
    }

    private int getClass(int n2) {
        return Normalizer.getCombiningClass(n2);
    }

    private String composeOneStep(String string) {
        int n2 = Pattern.countChars(string, 0, 2);
        String string2 = string.substring(0, n2);
        String string3 = java.text.Normalizer.normalize(string2, Normalizer.Form.NFC);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(n2);
        return string3 + string4;
    }

    private void RemoveQEQuoting() {
        int n2 = this.patternLength;
        int n3 = 0;
        while (n3 < n2 - 1) {
            if (this.temp[n3] != 92) {
                ++n3;
                continue;
            }
            if (this.temp[n3 + 1] == 81) break;
            n3 += 2;
        }
        if (n3 >= n2 - 1) {
            return;
        }
        int n4 = n3;
        int[] nArray = new int[n4 + 2 * (n2 - (n3 += 2)) + 2];
        a.arraycopy((Object)this.temp, (int)0, (Object)nArray, (int)0, (int)n4);
        boolean bl = true;
        while (n3 < n2) {
            int n5;
            if (!ASCII.isAscii(n5 = this.temp[n3++]) || ASCII.isAlnum(n5)) {
                nArray[n4++] = n5;
                continue;
            }
            if (n5 != 92) {
                if (bl) {
                    nArray[n4++] = 92;
                }
                nArray[n4++] = n5;
                continue;
            }
            if (bl) {
                if (this.temp[n3] == 69) {
                    ++n3;
                    bl = false;
                    continue;
                }
                nArray[n4++] = 92;
                nArray[n4++] = 92;
                continue;
            }
            if (this.temp[n3] == 81) {
                ++n3;
                bl = true;
                continue;
            }
            nArray[n4++] = n5;
            if (n3 == n2) continue;
            nArray[n4++] = this.temp[n3++];
        }
        this.patternLength = n4;
        this.temp = Arrays.copyOf(nArray, n4 + 2);
    }

    private void compile() {
        int n2;
        if (this.has(128) && !this.has(16)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        this.hasSupplementary = false;
        int n3 = 0;
        for (int i = 0; i < this.patternLength; i += Character.charCount(n2)) {
            n2 = this.normalizedPattern.codePointAt(i);
            if (Pattern.isSupplementary(n2)) {
                this.hasSupplementary = true;
            }
            this.temp[n3++] = n2;
        }
        this.patternLength = n3;
        if (!this.has(16)) {
            this.RemoveQEQuoting();
        }
        this.buffer = new int[32];
        this.groupNodes = new GroupHead[10];
        this.namedGroups = null;
        if (this.has(16)) {
            this.matchRoot = this.newSlice(this.temp, this.patternLength, this.hasSupplementary);
            ((Node)((Object)((Object)this.matchRoot))).next = Pattern.lastAccept;
        } else {
            this.matchRoot = this.expr(lastAccept);
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unmatched closing ')'"));
                }
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unexpected internal error"));
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (!f.ifAcmp((Object)((Object)this.root), (Object)((Object)this.matchRoot))) {
                this.root = this.hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : (this.hasSupplementary ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    Map<String, Integer> namedGroups() {
        if (this.namedGroups == null) {
            this.namedGroups = new HashMap<String, Integer>(2);
        }
        return this.namedGroups;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println((Object)node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (g.convertForInstanceOf((Object)((Object)node), Loop.class) instanceof Loop) {
                System.out.println((Object)node);
                Pattern.printObjectTree(((Loop)((Object)((Object)((Loop)((Object)g.convertForCast((Object)((Object)node), Loop.class)))))).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println((Object)node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else if (node instanceof GroupCurly) {
                System.out.println((Object)node);
                Pattern.printObjectTree(((GroupCurly)node).atom);
                System.out.println("**** end contents GroupCurly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println((Object)node);
                    System.out.println("Tail next is " + (Object)((Object)((Node)((Object)((Object)node))).next));
                    return;
                }
                System.out.println((Object)node);
            }
            node = ((Node)((Object)((Object)node))).next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (f.ifAcmp((Object)((Object)node), (Object)((Object)accept))) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int n2) {
        return (this.flags & n2) != 0;
    }

    private void accept(int n2, String string) {
        int n3 = this.temp[this.cursor++];
        if (this.has(4)) {
            n3 = this.parsePastWhitespace(n3);
        }
        if (n2 != n3) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error(string));
        }
    }

    private void mark(int n2) {
        this.temp[this.patternLength] = n2;
    }

    private int peek() {
        int n2 = this.temp[this.cursor];
        if (this.has(4)) {
            n2 = this.peekPastWhitespace(n2);
        }
        return n2;
    }

    private int read() {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        return n2;
    }

    private int readEscaped() {
        int n2 = this.temp[this.cursor++];
        return n2;
    }

    private int next() {
        int n2 = this.temp[++this.cursor];
        if (this.has(4)) {
            n2 = this.peekPastWhitespace(n2);
        }
        return n2;
    }

    private int nextEscaped() {
        int n2 = this.temp[++this.cursor];
        return n2;
    }

    private int peekPastWhitespace(int n2) {
        while (ASCII.isSpace(n2) || n2 == 35) {
            while (ASCII.isSpace(n2)) {
                n2 = this.temp[++this.cursor];
            }
            if (n2 != 35) continue;
            n2 = this.peekPastLine();
        }
        return n2;
    }

    private int parsePastWhitespace(int n2) {
        while (ASCII.isSpace(n2) || n2 == 35) {
            while (ASCII.isSpace(n2)) {
                n2 = this.temp[this.cursor++];
            }
            if (n2 != 35) continue;
            n2 = this.parsePastLine();
        }
        return n2;
    }

    private int parsePastLine() {
        int n2 = this.temp[this.cursor++];
        while (n2 != 0 && !this.isLineSeparator(n2)) {
            n2 = this.temp[this.cursor++];
        }
        return n2;
    }

    private int peekPastLine() {
        int n2 = this.temp[++this.cursor];
        while (n2 != 0 && !this.isLineSeparator(n2)) {
            n2 = this.temp[++this.cursor];
        }
        return n2;
    }

    private boolean isLineSeparator(int n2) {
        if (this.has(1)) {
            return n2 == 10;
        }
        return n2 == 10 || n2 == 13 || (n2 | 1) == 8233 || n2 == 133;
    }

    private int skip() {
        int n2 = this.cursor;
        int n3 = this.temp[n2 + 1];
        this.cursor = n2 + 2;
        return n3;
    }

    private void unread() {
        --this.cursor;
    }

    private PatternSyntaxException error(String string) {
        return new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private boolean findSupplementary(int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (!Pattern.isSupplementary(this.temp[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isSupplementary(int n2) {
        return n2 >= 65536 || Character.isSurrogate((char)n2);
    }

    private Node expr(Node node) {
        Node node2 = null;
        Node node3 = null;
        BranchConn branchConn = null;
        while (true) {
            Node node4 = this.sequence(node);
            Node node5 = this.root;
            if (node2 == null) {
                node2 = node4;
                node3 = node5;
            } else {
                if (branchConn == null) {
                    branchConn = new BranchConn();
                    ((Node)((Object)((Object)branchConn))).next = node;
                }
                if (!f.ifAcmp((Object)((Object)node4), (Object)((Object)node))) {
                    node4 = null;
                } else {
                    ((Node)((Object)((Object)node5))).next = (Node)branchConn;
                }
                if (node2 instanceof Branch) {
                    ((Branch)node2).add(node4);
                } else {
                    if (!f.ifAcmp((Object)((Object)node2), (Object)((Object)node))) {
                        node2 = null;
                    } else {
                        ((Node)((Object)((Object)node3))).next = (Node)branchConn;
                    }
                    node2 = new Branch(node2, node4, branchConn);
                }
            }
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n2 = this.peek();
            switch (n2) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        ((Node)((Object)node3)).next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n2 = this.nextEscaped();
                    if (n2 == 112 || n2 == 80) {
                        boolean bl = true;
                        boolean bl2 = n2 == 80;
                        n2 = this.next();
                        if (n2 != 123) {
                            this.unread();
                        } else {
                            bl = false;
                        }
                        node4 = this.family(bl, bl2);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Dangling meta character '" + (char)n2 + "'"));
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            ((Node)((Object)((Object)node3))).next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        ((Node)((Object)node3)).next = node;
        this.root = node3;
        return node2;
    }

    private Node atom() {
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        int n4 = this.peek();
        block6: while (true) {
            switch (n4) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n2 <= true) break block6;
                    this.cursor = n3;
                    --n2;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n4 = this.nextEscaped();
                    if (n4 == 112 || n4 == 80) {
                        if (n2 > 0) {
                            this.unread();
                            break block6;
                        }
                        boolean bl2 = n4 == 80;
                        boolean bl3 = true;
                        n4 = this.next();
                        if (n4 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        return this.family(bl3, bl2);
                    }
                    this.unread();
                    n3 = this.cursor;
                    n4 = this.escape(false, n2 == 0);
                    if (n4 >= 0) {
                        this.append(n4, n2);
                        ++n2;
                        if (Pattern.isSupplementary(n4)) {
                            bl = true;
                        }
                        n4 = this.peek();
                        continue block6;
                    }
                    if (n2 == 0) {
                        return this.root;
                    }
                    this.cursor = n3;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n3 = this.cursor;
                    this.append(n4, n2);
                    ++n2;
                    if (Pattern.isSupplementary(n4)) {
                        bl = true;
                    }
                    n4 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n2 == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n2, bl);
    }

    private void append(int n2, int n3) {
        if (n3 >= this.buffer.length) {
            int[] nArray = new int[n3 + n3];
            a.arraycopy((Object)this.buffer, (int)0, (Object)nArray, (int)0, (int)n3);
            this.buffer = nArray;
        }
        this.buffer[n3] = n2;
    }

    private Node ref(int n2) {
        boolean bl = false;
        block3: while (!bl) {
            int n3 = this.peek();
            switch (n3) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n4 = n2 * 10 + (n3 - 48);
                    if (this.capturingGroupCount - 1 < n4) {
                        bl = true;
                        continue block3;
                    }
                    n2 = n4;
                    this.read();
                    continue block3;
                }
            }
            bl = true;
        }
        if (this.has(2)) {
            return new CIBackRef(n2, this.has(64));
        }
        return new BackRef(n2);
    }

    private int escape(boolean bl, boolean bl2) {
        int n2 = this.skip();
        switch (n2) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl) break;
                if (bl2) {
                    this.root = this.ref(n2 - 48);
                }
                return -1;
            }
            case 65: {
                if (bl) break;
                if (bl2) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.NONE, this.has(256));
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.DIGIT).complement() : new Ctype(1024).complement();
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl) break;
                if (bl2) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 83: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WHITE_SPACE).complement() : new Ctype(2048).complement();
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WORD).complement() : new Ctype(67328).complement();
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl) break;
                if (bl2) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl) break;
                if (bl2) {
                    this.root = new Bound(Bound.BOTH, this.has(256));
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.DIGIT) : new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                break;
            }
            case 107: {
                if (bl) break;
                if (this.read() != 60) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("\\k is not followed by '<' for named capturing group"));
                }
                String string = this.groupname(this.read());
                if (!this.namedGroups().containsKey(string)) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("(named capturing group <" + string + "> does not exit"));
                }
                if (bl2) {
                    this.root = this.has(2) ? new CIBackRef(this.namedGroups().get(string), this.has(64)) : new BackRef(this.namedGroups().get(string));
                }
                return -1;
            }
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WHITE_SPACE) : new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (bl2) {
                    this.root = this.has(256) ? new Utype(UnicodeProp.WORD) : new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl) break;
                if (bl2) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n2;
            }
        }
        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal/unsupported escape sequence"));
    }

    private CharProperty clazz(boolean bl) {
        CharProperty charProperty = null;
        CharProperty charProperty2 = null;
        BitClass bitClass = new BitClass();
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = this.next();
        block7: while (true) {
            switch (n2) {
                case 94: {
                    if (!bl3 || this.temp[this.cursor - 1] != 91) break;
                    n2 = this.next();
                    bl2 = !bl2;
                    continue block7;
                }
                case 91: {
                    bl3 = false;
                    charProperty2 = this.clazz(true);
                    charProperty = charProperty == null ? charProperty2 : Pattern.union(charProperty, charProperty2);
                    n2 = this.peek();
                    continue block7;
                }
                case 38: {
                    bl3 = false;
                    n2 = this.next();
                    if (n2 == 38) {
                        n2 = this.next();
                        CharProperty charProperty3 = null;
                        while (n2 != 93 && n2 != 38) {
                            if (n2 == 91) {
                                charProperty3 = charProperty3 == null ? this.clazz(true) : Pattern.union(charProperty3, this.clazz(true));
                            } else {
                                this.unread();
                                charProperty3 = this.clazz(false);
                            }
                            n2 = this.peek();
                        }
                        if (charProperty3 != null) {
                            charProperty2 = charProperty3;
                        }
                        if (charProperty == null) {
                            if (charProperty3 == null) {
                                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Bad class syntax"));
                            }
                            charProperty = charProperty3;
                            continue block7;
                        }
                        charProperty = Pattern.intersection(charProperty, charProperty2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl3 = false;
                    if (this.cursor < this.patternLength) break;
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unclosed character class"));
                }
                case 93: {
                    bl3 = false;
                    if (charProperty == null) break;
                    if (bl) {
                        this.next();
                    }
                    return charProperty;
                }
                default: {
                    bl3 = false;
                }
            }
            charProperty2 = this.range(bitClass);
            if (bl2) {
                if (charProperty == null) {
                    charProperty = charProperty2;
                } else if (f.ifAcmp((Object)((Object)charProperty), (Object)((Object)charProperty2))) {
                    charProperty = Pattern.union(charProperty, charProperty2);
                }
            } else if (charProperty == null) {
                charProperty = charProperty2.complement();
            } else if (f.ifAcmp((Object)((Object)charProperty), (Object)((Object)charProperty2))) {
                charProperty = Pattern.setDifference(charProperty, charProperty2);
            }
            n2 = this.peek();
        }
    }

    private CharProperty bitsOrSingle(BitClass bitClass, int n2) {
        if (n2 < 256 && (!this.has(2) || !this.has(64) || n2 != 255 && n2 != 181 && n2 != 73 && n2 != 105 && n2 != 83 && n2 != 115 && n2 != 75 && n2 != 107 && n2 != 197 && n2 != 229)) {
            return bitClass.add(n2, this.flags());
        }
        return this.newSingle(n2);
    }

    private CharProperty range(BitClass bitClass) {
        int n2 = this.peek();
        if (n2 == 92) {
            n2 = this.nextEscaped();
            if (n2 == 112 || n2 == 80) {
                boolean bl = n2 == 80;
                boolean bl2 = true;
                n2 = this.next();
                if (n2 != 123) {
                    this.unread();
                } else {
                    bl2 = false;
                }
                return this.family(bl2, bl);
            }
            this.unread();
            n2 = this.escape(true, true);
            if (n2 == -1) {
                return (CharProperty)((Object)g.convertForCast((Object)((Object)this.root), CharProperty.class));
            }
        } else {
            n2 = this.single();
        }
        if (n2 >= 0) {
            if (this.peek() == 45) {
                int n3 = this.temp[this.cursor + 1];
                if (n3 == 91) {
                    return this.bitsOrSingle(bitClass, n2);
                }
                if (n3 != 93) {
                    this.next();
                    int n4 = this.single();
                    if (n4 < n2) {
                        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal character range"));
                    }
                    if (this.has(2)) {
                        return this.caseInsensitiveRangeFor(n2, n4);
                    }
                    return Pattern.rangeFor(n2, n4);
                }
            }
            return this.bitsOrSingle(bitClass, n2);
        }
        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unexpected character '" + (char)n2 + "'"));
    }

    private int single() {
        int n2 = this.peek();
        switch (n2) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharProperty family(boolean bl, boolean bl2) {
        String string;
        int n2;
        this.next();
        CharProperty charProperty = null;
        if (bl) {
            n2 = this.temp[this.cursor];
            string = !Character.isSupplementaryCodePoint(n2) ? String.valueOf((char)n2) : new String(this.temp, this.cursor, 1);
            this.read();
        } else {
            n2 = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int n3 = this.cursor;
            if (n3 > this.patternLength) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unclosed character family"));
            }
            if (n2 + 1 >= n3) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Empty character family"));
            }
            string = new String(this.temp, n2, n3 - n2 - 1);
        }
        n2 = string.indexOf(61);
        if (n2 != -1) {
            String string2 = string.substring(n2 + 1);
            if ("sc".equals(string = string.substring(0, n2).toLowerCase(Locale.ENGLISH)) || "script".equals(string)) {
                charProperty = this.unicodeScriptPropertyFor(string2);
            } else if ("blk".equals(string) || "block".equals(string)) {
                charProperty = this.unicodeBlockPropertyFor(string2);
            } else {
                if (!"gc".equals(string)) {
                    if (!"general_category".equals(string)) throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown Unicode property {name=<" + string + ">, " + "value=<" + string2 + ">}"));
                }
                charProperty = this.charPropertyNodeFor(string2);
            }
        } else if (string.startsWith("In")) {
            charProperty = this.unicodeBlockPropertyFor(string.substring(2));
        } else if (string.startsWith("Is")) {
            UnicodeProp unicodeProp = UnicodeProp.forName((String)(string = string.substring(2)));
            if (unicodeProp != null) {
                charProperty = new Utype(unicodeProp);
            }
            if (charProperty == null) {
                charProperty = CharPropertyNames.charPropertyFor(string);
            }
            if (charProperty == null) {
                charProperty = this.unicodeScriptPropertyFor(string);
            }
        } else {
            UnicodeProp unicodeProp;
            if (this.has(256) && (unicodeProp = UnicodeProp.forPOSIXName((String)string)) != null) {
                charProperty = new Utype(unicodeProp);
            }
            if (charProperty == null) {
                charProperty = this.charPropertyNodeFor(string);
            }
        }
        if (!bl2) return charProperty;
        if (!(charProperty instanceof Category)) {
            if (!(charProperty instanceof Block)) return charProperty.complement();
        }
        this.hasSupplementary = true;
        return charProperty.complement();
    }

    private CharProperty unicodeScriptPropertyFor(String string) {
        Character.UnicodeScript unicodeScript;
        try {
            unicodeScript = Character.UnicodeScript.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown character script name {" + string + "}"));
        }
        return new Script(unicodeScript);
    }

    private CharProperty unicodeBlockPropertyFor(String string) {
        Character.UnicodeBlock unicodeBlock;
        try {
            unicodeBlock = Character.UnicodeBlock.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown character block name {" + string + "}"));
        }
        return new Block(unicodeBlock);
    }

    private CharProperty charPropertyNodeFor(String string) {
        CharProperty charProperty = CharPropertyNames.charPropertyFor(string);
        if (charProperty == null) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown character property name {" + string + "}"));
        }
        return charProperty;
    }

    private String groupname(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toChars(n2));
        while (ASCII.isLower(n2 = this.read()) || ASCII.isUpper(n2) || ASCII.isDigit(n2)) {
            stringBuilder.append(Character.toChars(n2));
        }
        if (stringBuilder.length() == 0) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("named capturing group has 0 length name"));
        }
        if (n2 != 62) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("named capturing group is missing trailing '>'"));
        }
        return stringBuilder.toString();
    }

    private Node group0() {
        com.zeroturnaround.jrebelbase.h h2;
        Object object;
        boolean bl = false;
        Node node = null;
        Node node2 = null;
        int n2 = this.flags;
        this.root = null;
        int n3 = this.next();
        if (n3 == 63) {
            n3 = this.skip();
            switch (n3) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    ((Node)((Object)((Object)node))).next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    ((Node)((Object)((Object)node))).next = this.expr(node2);
                    if (n3 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    ((Node)((Object)((Object)node))).next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n3 = this.read();
                    if (ASCII.isLower(n3) || ASCII.isUpper(n3)) {
                        object = this.groupname(n3);
                        if (this.namedGroups().containsKey(object)) {
                            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Named capturing group <" + object + "> is already defined"));
                        }
                        bl = true;
                        node = this.createGroup(false);
                        node2 = this.root;
                        this.namedGroups().put((String)object, this.capturingGroupCount - 1);
                        ((Node)((Object)((Object)node))).next = this.expr(node2);
                        break;
                    }
                    int n4 = this.cursor;
                    node = this.createGroup(true);
                    node2 = this.root;
                    ((Node)((Object)((Object)node))).next = this.expr(node2);
                    ((Node)((Object)((Object)node2))).next = Pattern.lookbehindEnd;
                    h2 = new TreeInfo();
                    node.study((TreeInfo)h2);
                    if (!h2.maxValid) {
                        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Look-behind group does not have an obvious maximum length"));
                    }
                    boolean bl2 = this.findSupplementary(n4, this.patternLength);
                    if (n3 == 61) {
                        node2 = bl2 ? new BehindS(node, h2.maxLength, h2.minLength) : new Behind(node, h2.maxLength, h2.minLength);
                        node = node2;
                        break;
                    }
                    if (n3 == 33) {
                        node2 = bl2 ? new NotBehindS(node, h2.maxLength, h2.minLength) : new NotBehind(node, h2.maxLength, h2.minLength);
                        node = node2;
                        break;
                    }
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown look-behind group"));
                }
                case 36: 
                case 64: {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown group type"));
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n3 = this.read();
                    if (n3 == 41) {
                        return null;
                    }
                    if (n3 != 58) {
                        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unknown inline modifier"));
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    ((Node)((Object)((Object)node))).next = this.expr(node2);
                    break;
                }
            }
        } else {
            bl = true;
            node = this.createGroup(false);
            node2 = this.root;
            ((Node)((Object)((Object)node))).next = this.expr(node2);
        }
        this.accept(41, "Unclosed group");
        this.flags = n2;
        object = this.closure(node);
        if (!f.ifAcmp((Object)object, (Object)((Object)node))) {
            this.root = node2;
            return object;
        }
        if (!f.ifAcmp((Object)((Object)node), (Object)((Object)node2))) {
            this.root = object;
            return object;
        }
        if (object instanceof Ques) {
            h2 = (Ques)((Object)object);
            if (h2.type == 2) {
                this.root = object;
                return object;
            }
            ((Node)((Object)((Object)node2))).next = (Node)new BranchConn();
            node2 = ((Node)((Object)((Object)node2))).next;
            node = h2.type == 0 ? new Branch(node, null, node2) : new Branch(null, node, node2);
            this.root = node2;
            return node;
        }
        if (object instanceof Curly) {
            h2 = (Curly)((Object)object);
            if (h2.type == 2) {
                this.root = object;
                return object;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail groupTail = (GroupTail)node2;
                node = this.root = new GroupCurly(((Node)((Object)((Object)node))).next, h2.cmin, h2.cmax, h2.type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex, bl);
                return node;
            }
            int n5 = ((GroupHead)node).localIndex;
            Loop loop = h2.type == 0 ? new Loop(this.localCount, n5) : new LazyLoop(this.localCount, n5);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            ((Loop)((Object)((Object)loop))).cmin = h2.cmin;
            ((Loop)((Object)((Object)loop))).cmax = h2.cmax;
            ((Loop)((Object)((Object)loop))).body = node;
            ((Node)((Object)((Object)node2))).next = (Node)loop;
            this.root = loop;
            return prolog;
        }
        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Internal logic error"));
    }

    private Node createGroup(boolean bl) {
        int n2 = this.localCount++;
        int n3 = 0;
        if (!bl) {
            n3 = this.capturingGroupCount++;
        }
        GroupHead groupHead = new GroupHead(n2);
        this.root = new GroupTail(n2, n3);
        if (!bl && n3 < 10) {
            this.groupNodes[n3] = groupHead;
        }
        return groupHead;
    }

    private void addFlag() {
        int n2 = this.peek();
        while (true) {
            switch (n2) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 85: {
                    this.flags |= 0x140;
                    break;
                }
                case 45: {
                    n2 = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n2 = this.next();
        }
    }

    private void subFlag() {
        int n2 = this.peek();
        while (true) {
            switch (n2) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                case 85: {
                    this.flags &= 0xFFFFFEBF;
                }
                default: {
                    return;
                }
            }
            n2 = this.next();
        }
    }

    private Node closure(Node node) {
        int n2 = this.peek();
        switch (n2) {
            case 63: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n2 = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n2)) {
                    Curly curly;
                    this.skip();
                    int n3 = 0;
                    do {
                        n3 = n3 * 10 + (n2 - 48);
                    } while (ASCII.isDigit(n2 = this.read()));
                    int n4 = n3;
                    if (n2 == 44) {
                        n2 = this.read();
                        n4 = Integer.MAX_VALUE;
                        if (n2 != 125) {
                            n4 = 0;
                            while (ASCII.isDigit(n2)) {
                                n4 = n4 * 10 + (n2 - 48);
                                n2 = this.read();
                            }
                        }
                    }
                    if (n2 != 125) {
                        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unclosed counted closure"));
                    }
                    if ((n3 | n4 | n4 - n3) < 0) {
                        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal repetition range"));
                    }
                    n2 = this.peek();
                    if (n2 == 63) {
                        this.next();
                        curly = new Curly(node, n3, n4, 1);
                    } else if (n2 == 43) {
                        this.next();
                        curly = new Curly(node, n3, n4, 2);
                    } else {
                        curly = new Curly(node, n3, n4, 0);
                    }
                    return curly;
                }
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal repetition"));
            }
        }
        return node;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal control escape sequence"));
    }

    private int o() {
        int n2 = this.read();
        if ((n2 - 48 | 55 - n2) >= 0) {
            int n3 = this.read();
            if ((n3 - 48 | 55 - n3) >= 0) {
                int n4 = this.read();
                if ((n4 - 48 | 55 - n4) >= 0 && (n2 - 48 | 51 - n2) >= 0) {
                    return (n2 - 48) * 64 + (n3 - 48) * 8 + (n4 - 48);
                }
                this.unread();
                return (n2 - 48) * 8 + (n3 - 48);
            }
            this.unread();
            return n2 - 48;
        }
        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal octal escape sequence"));
    }

    private int x() {
        int n2 = this.read();
        if (ASCII.isHexDigit(n2)) {
            int n3 = this.read();
            if (ASCII.isHexDigit(n3)) {
                return ASCII.toDigit(n2) * 16 + ASCII.toDigit(n3);
            }
        } else if (n2 == 123 && ASCII.isHexDigit(this.peek())) {
            int n4 = 0;
            while (ASCII.isHexDigit(n2 = this.read())) {
                if ((n4 = (n4 << 4) + ASCII.toDigit(n2)) <= 0x10FFFF) continue;
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Hexadecimal codepoint is too big"));
            }
            if (n2 != 125) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Unclosed hexadecimal escape sequence"));
            }
            return n4;
        }
        throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal hexadecimal escape sequence"));
    }

    private int cursor() {
        return this.cursor;
    }

    private void setcursor(int n2) {
        this.cursor = n2;
    }

    private int uxxxx() {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = this.read();
            if (!ASCII.isHexDigit(n3)) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)this.error("Illegal Unicode escape sequence"));
            }
            n2 = n2 * 16 + ASCII.toDigit(n3);
        }
        return n2;
    }

    private int u() {
        int n2 = this.uxxxx();
        if (Character.isHighSurrogate((char)n2)) {
            int n3;
            int n4 = this.cursor();
            if (this.read() == 92 && this.read() == 117 && Character.isLowSurrogate((char)(n3 = this.uxxxx()))) {
                return Character.toCodePoint((char)n2, (char)n3);
            }
            this.setcursor(n4);
        }
        return n2;
    }

    private static final int countChars(CharSequence charSequence, int n2, int n3) {
        if (n3 == 1 && !Character.isHighSurrogate(charSequence.charAt(n2))) {
            if (!($assertionsDisabled || n2 >= 0 && n2 < charSequence.length())) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError());
            }
            return 1;
        }
        int n4 = charSequence.length();
        int n5 = n2;
        if (n3 >= 0) {
            if (!($assertionsDisabled || n2 >= 0 && n2 < n4)) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError());
            }
            for (int i = 0; n5 < n4 && i < n3; ++i) {
                if (!Character.isHighSurrogate(charSequence.charAt(n5++)) || n5 >= n4 || !Character.isLowSurrogate(charSequence.charAt(n5))) continue;
                ++n5;
            }
            return n5 - n2;
        }
        if (!($assertionsDisabled || n2 >= 0 && n2 <= n4)) {
            throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError());
        }
        if (n2 == 0) {
            return 0;
        }
        int n6 = -n3;
        for (int i = 0; n5 > 0 && i < n6; ++i) {
            if (!Character.isLowSurrogate(charSequence.charAt(--n5)) || n5 <= 0 || !Character.isHighSurrogate(charSequence.charAt(n5 - 1))) continue;
            --n5;
        }
        return n2 - n5;
    }

    private static final int countCodePoints(CharSequence charSequence) {
        int n2 = charSequence.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            ++n3;
            if (!Character.isHighSurrogate(charSequence.charAt(n4++)) || n4 >= n2 || !Character.isLowSurrogate(charSequence.charAt(n4))) continue;
            ++n4;
        }
        return n3;
    }

    private CharProperty newSingle(int n2) {
        if (this.has(2)) {
            int n3;
            int n4;
            if (this.has(64)) {
                int n5;
                int n6 = Character.toUpperCase(n2);
                if (n6 != (n5 = Character.toLowerCase(n6))) {
                    return new SingleU(n5);
                }
            } else if (ASCII.isAscii(n2) && (n4 = ASCII.toLower(n2)) != (n3 = ASCII.toUpper(n2))) {
                return new SingleI(n4, n3);
            }
        }
        if (Pattern.isSupplementary(n2)) {
            return new SingleS(n2);
        }
        return new Single(n2);
    }

    private Node newSlice(int[] nArray, int n2, boolean bl) {
        int[] nArray2 = new int[n2];
        if (this.has(2)) {
            if (this.has(64)) {
                for (int i = 0; i < n2; ++i) {
                    nArray2[i] = Character.toLowerCase(Character.toUpperCase(nArray[i]));
                }
                return bl ? new SliceUS(nArray2) : new SliceU(nArray2);
            }
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = ASCII.toLower(nArray[i]);
            }
            return bl ? new SliceIS(nArray2) : new SliceI(nArray2);
        }
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i];
        }
        return bl ? new SliceS(nArray2) : new Slice(nArray2);
    }

    private static boolean inRange(int n2, int n3, int n4) {
        return n2 <= n3 && n3 <= n4;
    }

    private static CharProperty rangeFor(final int n2, final int n3) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n22) {
                return Pattern.inRange(n2, n22, n3);
            }

            static /* synthetic */ int _jr$ig$val$lower(Object object) {
                return ((Object)object).n2;
            }

            static /* synthetic */ void _jr$ip$val$lower(Object object, int n22) {
                ((Object)object).n2 = n22;
            }

            static /* synthetic */ int _jr$ig$val$upper(Object object) {
                return ((Object)object).n3;
            }

            static /* synthetic */ void _jr$ip$val$upper(Object object, int n22) {
                ((Object)object).n3 = n22;
            }
        };
    }

    private CharProperty caseInsensitiveRangeFor(int n2, int n3) {
        if (this.has(64)) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static CharProperty union(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n2) {
                return charProperty.isSatisfiedBy(n2) || charProperty2.isSatisfiedBy(n2);
            }

            static /* synthetic */ CharProperty _jr$ig$val$lhs(Object object) {
                return ((Object)object).charProperty;
            }

            static /* synthetic */ void _jr$ip$val$lhs(Object object, CharProperty charProperty3) {
                ((Object)object).charProperty = charProperty3;
            }

            static /* synthetic */ CharProperty _jr$ig$val$rhs(Object object) {
                return ((Object)object).charProperty2;
            }

            static /* synthetic */ void _jr$ip$val$rhs(Object object, CharProperty charProperty3) {
                ((Object)object).charProperty2 = charProperty3;
            }
        };
    }

    private static CharProperty intersection(CharProperty charProperty, CharProperty charProperty2) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static CharProperty setDifference(final CharProperty charProperty, final CharProperty charProperty2) {
        return new CharProperty(){

            @Override
            boolean isSatisfiedBy(int n2) {
                return !charProperty2.isSatisfiedBy(n2) && charProperty.isSatisfiedBy(n2);
            }

            static /* synthetic */ CharProperty _jr$ig$val$rhs(Object object) {
                return ((Object)object).charProperty2;
            }

            static /* synthetic */ void _jr$ip$val$rhs(Object object, CharProperty charProperty3) {
                ((Object)object).charProperty2 = charProperty3;
            }

            static /* synthetic */ CharProperty _jr$ig$val$lhs(Object object) {
                return ((Object)object).charProperty;
            }

            static /* synthetic */ void _jr$ip$val$lhs(Object object, CharProperty charProperty3) {
                ((Object)object).charProperty = charProperty3;
            }
        };
    }

    private static boolean hasBaseCharacter(Matcher matcher, int n2, CharSequence charSequence) {
        int n3 = !matcher.transparentBounds ? matcher.from : 0;
        for (int i = n2; i >= n3; --i) {
            int n4 = Character.codePointAt(charSequence, i);
            if (Character.isLetterOrDigit(n4)) {
                return true;
            }
            if (Character.getType(n4) == 6) continue;
            return false;
        }
        return false;
    }

    static /* synthetic */ CharProperty access$600(int n2, int n3) {
        return Pattern.rangeFor(n2, n3);
    }

    private static /* synthetic */ String _jr$ig$pattern(Pattern pattern) {
        return pattern.pattern;
    }

    private static /* synthetic */ void _jr$ip$pattern(Pattern pattern, String string) {
        pattern.pattern = string;
    }

    private static /* synthetic */ int _jr$ig$flags(Pattern pattern) {
        return pattern.flags;
    }

    private static /* synthetic */ void _jr$ip$flags(Pattern pattern, int n2) {
        pattern.flags = n2;
    }

    private static /* synthetic */ boolean _jr$ig$compiled(Pattern pattern) {
        return pattern.compiled;
    }

    private static /* synthetic */ void _jr$ip$compiled(Pattern pattern, boolean bl) {
        pattern.compiled = bl;
    }

    private static /* synthetic */ String _jr$ig$normalizedPattern(Pattern pattern) {
        return pattern.normalizedPattern;
    }

    private static /* synthetic */ void _jr$ip$normalizedPattern(Pattern pattern, String string) {
        pattern.normalizedPattern = string;
    }

    static /* synthetic */ Node _jr$ig$root(Object object) {
        return ((Pattern)object).root;
    }

    static /* synthetic */ void _jr$ip$root(Object object, Node node) {
        ((Pattern)object).root = node;
    }

    static /* synthetic */ Node _jr$ig$matchRoot(Object object) {
        return ((Pattern)object).matchRoot;
    }

    static /* synthetic */ void _jr$ip$matchRoot(Object object, Node node) {
        ((Pattern)object).matchRoot = node;
    }

    static /* synthetic */ int[] _jr$ig$buffer(Object object) {
        return ((Pattern)object).buffer;
    }

    static /* synthetic */ void _jr$ip$buffer(Object object, int[] nArray) {
        ((Pattern)object).buffer = nArray;
    }

    static /* synthetic */ Map _jr$ig$namedGroups(Object object) {
        return ((Pattern)object).namedGroups;
    }

    static /* synthetic */ void _jr$ip$namedGroups(Object object, Map map) {
        ((Pattern)object).namedGroups = map;
    }

    static /* synthetic */ GroupHead[] _jr$ig$groupNodes(Object object) {
        return ((Pattern)object).groupNodes;
    }

    static /* synthetic */ void _jr$ip$groupNodes(Object object, GroupHead[] groupHeadArray) {
        ((Pattern)object).groupNodes = groupHeadArray;
    }

    private static /* synthetic */ int[] _jr$ig$temp(Pattern pattern) {
        return pattern.temp;
    }

    private static /* synthetic */ void _jr$ip$temp(Pattern pattern, int[] nArray) {
        pattern.temp = nArray;
    }

    static /* synthetic */ int _jr$ig$capturingGroupCount(Object object) {
        return ((Pattern)object).capturingGroupCount;
    }

    static /* synthetic */ void _jr$ip$capturingGroupCount(Object object, int n2) {
        ((Pattern)object).capturingGroupCount = n2;
    }

    static /* synthetic */ int _jr$ig$localCount(Object object) {
        return ((Pattern)object).localCount;
    }

    static /* synthetic */ void _jr$ip$localCount(Object object, int n2) {
        ((Pattern)object).localCount = n2;
    }

    private static /* synthetic */ int _jr$ig$cursor(Pattern pattern) {
        return pattern.cursor;
    }

    private static /* synthetic */ void _jr$ip$cursor(Pattern pattern, int n2) {
        pattern.cursor = n2;
    }

    private static /* synthetic */ int _jr$ig$patternLength(Pattern pattern) {
        return pattern.patternLength;
    }

    private static /* synthetic */ void _jr$ip$patternLength(Pattern pattern, int n2) {
        pattern.patternLength = n2;
    }

    private static /* synthetic */ boolean _jr$ig$hasSupplementary(Pattern pattern) {
        return pattern.hasSupplementary;
    }

    private static /* synthetic */ void _jr$ip$hasSupplementary(Pattern pattern, boolean bl) {
        pattern.hasSupplementary = bl;
    }

    static final class All
    extends CharProperty {
        All() {
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return true;
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n2) {
            this.groupIndex = n2 + n2;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.groups[((BackRef)((Object)((Object)this))).groupIndex];
            int n4 = matcher.groups[((BackRef)((Object)((Object)this))).groupIndex + 1];
            int n5 = n4 - n3;
            if (n3 < 0) {
                return false;
            }
            if (n2 + n5 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int i = 0; i < n5; ++i) {
                if (charSequence.charAt(n2 + i) == charSequence.charAt(n3 + i)) continue;
                return false;
            }
            return BackRef._jr$ig$next((Object)this).match(matcher, n2 + n5, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return BackRef._jr$ig$next((Object)this).study(treeInfo);
        }

        static /* synthetic */ void _jr$ip$groupIndex(Object object, int n2) {
            ((BackRef)((Object)object)).groupIndex = n2;
        }

        protected /* synthetic */ BackRef(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.from : 0;
            if (n2 == n3 && this.next.match(matcher, n2, charSequence)) {
                matcher.first = n2;
                matcher.groups[0] = n2;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n2, int n3) {
            this.cond = node;
            this.rmax = n2;
            this.rmin = n3;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.from;
            boolean bl = false;
            int n4 = !matcher.transparentBounds ? matcher.from : 0;
            int n5 = Math.max(n2 - ((Behind)((Object)((Object)this))).rmax, n4);
            int n6 = matcher.lookbehindTo;
            matcher.lookbehindTo = n2;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n2 - ((Behind)((Object)((Object)this))).rmin; !bl && i >= n5; --i) {
                bl = ((Behind)((Object)((Object)this))).cond.match(matcher, i, charSequence);
            }
            matcher.from = n3;
            matcher.lookbehindTo = n6;
            return bl && Behind._jr$ig$next((Object)this).match(matcher, n2, charSequence);
        }

        static /* synthetic */ void _jr$ip$cond(Object object, Node node) {
            ((Behind)((Object)object)).cond = node;
        }

        static /* synthetic */ void _jr$ip$rmax(Object object, int n2) {
            ((Behind)((Object)object)).rmax = n2;
        }

        static /* synthetic */ void _jr$ip$rmin(Object object, int n2) {
            ((Behind)((Object)object)).rmin = n2;
        }

        protected /* synthetic */ Behind(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node node, int n2, int n3) {
            super(node, n2, n3);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Pattern.countChars(charSequence, n2, -this.rmax);
            int n4 = Pattern.countChars(charSequence, n2, -this.rmin);
            int n5 = matcher.from;
            int n6 = !matcher.transparentBounds ? matcher.from : 0;
            boolean bl = false;
            int n7 = Math.max(n2 - n3, n6);
            int n8 = matcher.lookbehindTo;
            matcher.lookbehindTo = n2;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n2 - n4; !bl && i >= n7; i -= i > n7 ? Pattern.countChars(charSequence, i, -1) : 1) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n5;
            matcher.lookbehindTo = n8;
            return bl && this.next.match(matcher, n2, charSequence);
        }
    }

    private static final class BitClass
    extends BmpCharProperty {
        final boolean[] bits;

        BitClass() {
            this.bits = new boolean[256];
        }

        private BitClass(boolean[] blArray) {
            this.bits = blArray;
        }

        BitClass add(int n2, int n3) {
            if (!($assertionsDisabled || n2 >= 0 && n2 <= 255)) {
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError());
            }
            if ((n3 & 2) != 0) {
                if (ASCII.isAscii(n2)) {
                    this.bits[ASCII.toUpper((int)n2)] = true;
                    this.bits[ASCII.toLower((int)n2)] = true;
                } else if ((n3 & 0x40) != 0) {
                    this.bits[Character.toLowerCase((int)n2)] = true;
                    this.bits[Character.toUpperCase((int)n2)] = true;
                }
            }
            this.bits[n2] = true;
            return this;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 < 256 && this.bits[n2];
        }

        static /* synthetic */ boolean[] _jr$ig$bits(Object object) {
            return ((BitClass)((Object)object)).bits;
        }

        static /* synthetic */ void _jr$ip$bits(Object object, boolean[] blArray) {
            ((BitClass)((Object)object)).bits = blArray;
        }
    }

    static final class Block
    extends CharProperty {
        final Character.UnicodeBlock block;

        Block(Character.UnicodeBlock unicodeBlock) {
            this.block = unicodeBlock;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return !f.ifAcmp((Object)((Object)this.block), (Object)((Object)Character.UnicodeBlock.of(n2)));
        }

        static /* synthetic */ Character.UnicodeBlock _jr$ig$block(Object object) {
            return ((Block)((Object)object)).block;
        }

        static /* synthetic */ void _jr$ip$block(Object object, Character.UnicodeBlock unicodeBlock) {
            ((Block)((Object)object)).block = unicodeBlock;
        }
    }

    private static abstract class BmpCharProperty
    extends CharProperty {
        private BmpCharProperty() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return this.isSatisfiedBy(charSequence.charAt(n2)) && BmpCharProperty._jr$ig$next((Object)this).match(matcher, n2 + 1, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        protected /* synthetic */ BmpCharProperty(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int n2;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] nArray = ((Slice)node).buffer;
            int n3 = nArray.length;
            if (n3 < 4) {
                return node;
            }
            int[] nArray2 = new int[128];
            int[] nArray3 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[nArray[n2] & 0x7F] = n2 + 1;
            }
            block1: for (n2 = n3; n2 > 0; --n2) {
                int n4;
                for (n4 = n3 - 1; n4 >= n2; --n4) {
                    if (nArray[n4] != nArray[n4 - n2]) continue block1;
                    nArray3[n4 - 1] = n2;
                }
                while (n4 > 0) {
                    nArray3[--n4] = n2;
                }
            }
            nArray3[n3 - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(nArray, nArray2, nArray3, ((Node)((Object)((Object)node))).next);
            }
            return new BnM(nArray, nArray2, nArray3, ((Node)((Object)((Object)node))).next);
        }

        BnM(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            this.buffer = nArray;
            this.lastOcc = nArray2;
            this.optoSft = nArray3;
            this.next = node;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = ((BnM)((Object)((Object)this))).buffer;
            int n3 = nArray.length;
            int n4 = matcher.to - n3;
            block0: while (n2 <= n4) {
                int n5;
                for (n5 = n3 - 1; n5 >= 0; --n5) {
                    char c2 = charSequence.charAt(n2 + n5);
                    if (c2 == nArray[n5]) continue;
                    n2 += Math.max(n5 + 1 - ((BnM)((Object)((Object)this))).lastOcc[c2 & 0x7F], ((BnM)((Object)((Object)this))).optoSft[n5]);
                    continue block0;
                }
                matcher.first = n2;
                n5 = BnM._jr$ig$next((Object)this).match(matcher, n2 + n3, charSequence) ? 1 : 0;
                if (n5 != 0) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n2;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            TreeInfo treeInfo2 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo2))).minLength = ((TreeInfo)((Object)((Object)treeInfo2))).minLength + ((BnM)((Object)((Object)this))).buffer.length;
            ((TreeInfo)((Object)((Object)treeInfo))).maxValid = false;
            return BnM._jr$ig$next((Object)this).study(treeInfo);
        }

        static /* synthetic */ void _jr$ip$buffer(Object object, int[] nArray) {
            ((BnM)((Object)object)).buffer = nArray;
        }

        static /* synthetic */ void _jr$ip$lastOcc(Object object, int[] nArray) {
            ((BnM)((Object)object)).lastOcc = nArray;
        }

        static /* synthetic */ void _jr$ip$optoSft(Object object, int[] nArray) {
            ((BnM)((Object)object)).optoSft = nArray;
        }

        protected /* synthetic */ BnM(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            super(nArray, nArray2, nArray3, node);
            for (int i = 0; i < this.buffer.length; ++i) {
                this.lengthInChars += Character.charCount(this.buffer[i]);
            }
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            int n4 = matcher.to - this.lengthInChars;
            block0: while (n2 <= n4) {
                int n5 = Pattern.countChars(charSequence, n2, n3);
                int n6 = n3 - 1;
                while (n5 > 0) {
                    int n7 = Character.codePointBefore(charSequence, n2 + n5);
                    if (n7 != nArray[n6]) {
                        int n8 = Math.max(n6 + 1 - this.lastOcc[n7 & 0x7F], this.optoSft[n6]);
                        n2 += Pattern.countChars(charSequence, n2, n8);
                        continue block0;
                    }
                    n5 -= Character.charCount(n7);
                    --n6;
                }
                matcher.first = n2;
                n5 = this.next.match(matcher, n2 + this.lengthInChars, charSequence) ? 1 : 0;
                if (n5 != 0) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                n2 += Pattern.countChars(charSequence, n2, 1);
            }
            matcher.hitEnd = true;
            return false;
        }

        static /* synthetic */ int _jr$ig$lengthInChars(Object object) {
            return ((BnMS)((Object)object)).lengthInChars;
        }

        static /* synthetic */ void _jr$ip$lengthInChars(Object object, int n2) {
            ((BnMS)((Object)object)).lengthInChars = n2;
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;
        boolean useUWORD;

        Bound(int n2, boolean bl) {
            this.type = n2;
            this.useUWORD = bl;
        }

        boolean isWord(int n2) {
            return this.useUWORD ? UnicodeProp.WORD.is(n2) : n2 == 95 || Character.isLetterOrDigit(n2);
        }

        int check(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            boolean bl = false;
            int n4 = matcher.from;
            int n5 = matcher.to;
            if (matcher.transparentBounds) {
                n4 = 0;
                n5 = matcher.getTextLength();
            }
            if (n2 > n4) {
                n3 = Character.codePointBefore(charSequence, n2);
                bl = this.isWord(n3) || Character.getType(n3) == 6 && Pattern.hasBaseCharacter(matcher, n2 - 1, charSequence);
            }
            boolean bl2 = false;
            if (n2 < n5) {
                n3 = Character.codePointAt(charSequence, n2);
                bl2 = this.isWord(n3) || Character.getType(n3) == 6 && Pattern.hasBaseCharacter(matcher, n2, charSequence);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return bl ^ bl2 ? (bl2 ? LEFT : RIGHT) : NONE;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return (this.check(matcher, n2, charSequence) & this.type) > 0 && this.next.match(matcher, n2, charSequence);
        }

        static /* synthetic */ int _jr$ig$type(Object object) {
            return ((Bound)((Object)object)).type;
        }

        static /* synthetic */ void _jr$ip$type(Object object, int n2) {
            ((Bound)((Object)object)).type = n2;
        }

        static /* synthetic */ boolean _jr$ig$useUWORD(Object object) {
            return ((Bound)((Object)object)).useUWORD;
        }

        static /* synthetic */ void _jr$ip$useUWORD(Object object, boolean bl) {
            ((Bound)((Object)object)).useUWORD = bl;
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 2;
        Node conn;

        Branch(Node node, Node node2, Node node3) {
            this.conn = node3;
            a.arrayStore((Object[])this.atoms, (int)0, (Object)((Object)node));
            a.arrayStore((Object[])this.atoms, (int)1, (Object)((Object)node2));
        }

        void add(Node node) {
            if (this.size >= a.arrayLength((Object[])this.atoms)) {
                Node[] nodeArray = new Node[a.arrayLength((Object[])this.atoms) * 2];
                a.arraycopy((Object)this.atoms, (int)0, (Object)nodeArray, (int)0, (int)a.arrayLength((Object[])this.atoms));
                this.atoms = nodeArray;
            }
            a.arrayStore((Object[])this.atoms, (int)this.size++, (Object)((Object)node));
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            for (int i = 0; i < this.size; ++i) {
                if (!((Node)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.atoms, (int)i), Node.class)) == null ? ((Node)((Object)((Object)this.conn))).next.match(matcher, n2, charSequence) : ((Node)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.atoms, (int)i), Node.class))).match(matcher, n2, charSequence))) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n2 = ((TreeInfo)((Object)((Object)treeInfo))).minLength;
            int n3 = ((TreeInfo)((Object)((Object)treeInfo))).maxLength;
            boolean bl = ((TreeInfo)((Object)((Object)treeInfo))).maxValid;
            int n4 = Integer.MAX_VALUE;
            int n5 = -1;
            for (int i = 0; i < this.size; ++i) {
                treeInfo.reset();
                if ((Node)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.atoms, (int)i), Node.class)) != null) {
                    ((Node)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.atoms, (int)i), Node.class))).study(treeInfo);
                }
                n4 = Math.min(n4, ((TreeInfo)((Object)((Object)treeInfo))).minLength);
                n5 = Math.max(n5, ((TreeInfo)((Object)((Object)treeInfo))).maxLength);
                bl &= ((TreeInfo)((Object)((Object)treeInfo))).maxValid;
            }
            n2 += n4;
            n3 += n5;
            treeInfo.reset();
            ((Node)((Object)((Object)this.conn))).next.study(treeInfo);
            TreeInfo treeInfo2 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo2))).minLength = ((TreeInfo)((Object)((Object)treeInfo2))).minLength + n2;
            TreeInfo treeInfo3 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo3))).maxLength = ((TreeInfo)((Object)((Object)treeInfo3))).maxLength + n3;
            TreeInfo treeInfo4 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo4))).maxValid = ((TreeInfo)((Object)((Object)treeInfo4))).maxValid & bl;
            ((TreeInfo)((Object)((Object)treeInfo))).deterministic = false;
            return false;
        }

        static /* synthetic */ Node[] _jr$ig$atoms(Object object) {
            return ((Branch)((Object)object)).atoms;
        }

        static /* synthetic */ void _jr$ip$atoms(Object object, Node[] nodeArray) {
            ((Branch)((Object)object)).atoms = nodeArray;
        }

        static /* synthetic */ int _jr$ig$size(Object object) {
            return ((Branch)((Object)object)).size;
        }

        static /* synthetic */ void _jr$ip$size(Object object, int n2) {
            ((Branch)((Object)object)).size = n2;
        }

        static /* synthetic */ Node _jr$ig$conn(Object object) {
            return ((Branch)((Object)object)).conn;
        }

        static /* synthetic */ void _jr$ip$conn(Object object, Node node) {
            ((Branch)((Object)object)).conn = node;
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.next.match(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            return ((TreeInfo)((Object)((Object)treeInfo))).deterministic;
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;
        boolean doUnicodeCase;

        CIBackRef(int n2, boolean bl) {
            this.groupIndex = n2 + n2;
            this.doUnicodeCase = bl;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.groups[((CIBackRef)((Object)((Object)this))).groupIndex];
            int n4 = matcher.groups[((CIBackRef)((Object)((Object)this))).groupIndex + 1];
            int n5 = n4 - n3;
            if (n3 < 0) {
                return false;
            }
            if (n2 + n5 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n6 = n2;
            for (int i = 0; i < n5; ++i) {
                int n7;
                int n8;
                int n9;
                int n10 = Character.codePointAt(charSequence, n6);
                if (n10 != (n9 = Character.codePointAt(charSequence, n3)) && (((CIBackRef)((Object)((Object)this))).doUnicodeCase ? (n8 = Character.toUpperCase(n10)) != (n7 = Character.toUpperCase(n9)) && Character.toLowerCase(n8) != Character.toLowerCase(n7) : ASCII.toLower(n10) != ASCII.toLower(n9))) {
                    return false;
                }
                n6 += Character.charCount(n10);
                n3 += Character.charCount(n9);
            }
            return CIBackRef._jr$ig$next((Object)this).match(matcher, n2 + n5, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return CIBackRef._jr$ig$next((Object)this).study(treeInfo);
        }

        static /* synthetic */ void _jr$ip$groupIndex(Object object, int n2) {
            ((CIBackRef)((Object)object)).groupIndex = n2;
        }

        static /* synthetic */ void _jr$ip$doUnicodeCase(Object object, boolean bl) {
            ((CIBackRef)((Object)object)).doUnicodeCase = bl;
        }

        protected /* synthetic */ CIBackRef(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.from;
            int n4 = matcher.to;
            if (!matcher.anchoringBounds) {
                n3 = 0;
                n4 = matcher.getTextLength();
            }
            if (n2 == n4) {
                matcher.hitEnd = true;
                return false;
            }
            if (n2 > n3) {
                char c2 = charSequence.charAt(n2 - 1);
                if (c2 != '\n' && c2 != '\r' && (c2 | '\u0001') != 8233 && c2 != '\u0085') {
                    return false;
                }
                if (c2 == '\r' && charSequence.charAt(n2) == '\n') {
                    return false;
                }
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Category
    extends CharProperty {
        final int typeMask;

        Category(int n2) {
            this.typeMask = n2;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return (this.typeMask & 1 << Character.getType(n2)) != 0;
        }

        static /* synthetic */ int _jr$ig$typeMask(Object object) {
            return ((Category)((Object)object)).typeMask;
        }

        static /* synthetic */ void _jr$ip$typeMask(Object object, int n2) {
            ((Category)((Object)object)).typeMask = n2;
        }
    }

    private static abstract class CharProperty
    extends Node {
        private CharProperty() {
        }

        abstract boolean isSatisfiedBy(int var1);

        CharProperty complement() {
            return new CharProperty(this){
                final /* synthetic */ CharProperty this$0;
                {
                    this.this$0 = charProperty;
                }

                @Override
                boolean isSatisfiedBy(int n2) {
                    return !this.this$0.isSatisfiedBy(n2);
                }

                static /* synthetic */ CharProperty _jr$ig$this$0(Object object) {
                    return ((Object)object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, CharProperty charProperty) {
                    ((Object)object).this$0 = charProperty;
                }
            };
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < Matcher._jr$ig$to(matcher)) {
                int n3 = Character.codePointAt(charSequence, n2);
                return this.isSatisfiedBy(n3) && CharProperty._jr$ig$next((Object)this).match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            Matcher._jr$ip$hitEnd(matcher, true);
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            TreeInfo treeInfo2 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo2))).minLength = ((TreeInfo)((Object)((Object)treeInfo2))).minLength + 1;
            TreeInfo treeInfo3 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo3))).maxLength = ((TreeInfo)((Object)((Object)treeInfo3))).maxLength + 1;
            return CharProperty._jr$ig$next((Object)this).study(treeInfo);
        }

        protected /* synthetic */ CharProperty(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    private static class CharPropertyNames
    extends com.zeroturnaround.jrebelbase.h {
        private static final HashMap<String, CharPropertyFactory> map = new HashMap();

        private CharPropertyNames() {
        }

        static CharProperty charPropertyFor(String string) {
            CharPropertyFactory charPropertyFactory = (CharPropertyFactory)((Object)g.convertForCast((Object)((Object)map.get(string)), CharPropertyFactory.class));
            return charPropertyFactory == null ? null : charPropertyFactory.make();
        }

        private static void defCategory(String string, int n2) {
            map.put(string, (CharPropertyFactory)new /* Unavailable Anonymous Inner Class!! */);
        }

        private static void defRange(String string, int n2, int n3) {
            map.put(string, (CharPropertyFactory)new /* Unavailable Anonymous Inner Class!! */);
        }

        private static void defCtype(String string, int n2) {
            map.put(string, (CharPropertyFactory)new /* Unavailable Anonymous Inner Class!! */);
        }

        private static void defClone(String string, CloneableProperty cloneableProperty) {
            map.put(string, (CharPropertyFactory)new /* Unavailable Anonymous Inner Class!! */);
        }

        static {
            CharPropertyNames.defCategory("Cn", 1);
            CharPropertyNames.defCategory("Lu", 2);
            CharPropertyNames.defCategory("Ll", 4);
            CharPropertyNames.defCategory("Lt", 8);
            CharPropertyNames.defCategory("Lm", 16);
            CharPropertyNames.defCategory("Lo", 32);
            CharPropertyNames.defCategory("Mn", 64);
            CharPropertyNames.defCategory("Me", 128);
            CharPropertyNames.defCategory("Mc", 256);
            CharPropertyNames.defCategory("Nd", 512);
            CharPropertyNames.defCategory("Nl", 1024);
            CharPropertyNames.defCategory("No", 2048);
            CharPropertyNames.defCategory("Zs", 4096);
            CharPropertyNames.defCategory("Zl", 8192);
            CharPropertyNames.defCategory("Zp", 16384);
            CharPropertyNames.defCategory("Cc", 32768);
            CharPropertyNames.defCategory("Cf", 65536);
            CharPropertyNames.defCategory("Co", 262144);
            CharPropertyNames.defCategory("Cs", 524288);
            CharPropertyNames.defCategory("Pd", 0x100000);
            CharPropertyNames.defCategory("Ps", 0x200000);
            CharPropertyNames.defCategory("Pe", 0x400000);
            CharPropertyNames.defCategory("Pc", 0x800000);
            CharPropertyNames.defCategory("Po", 0x1000000);
            CharPropertyNames.defCategory("Sm", 0x2000000);
            CharPropertyNames.defCategory("Sc", 0x4000000);
            CharPropertyNames.defCategory("Sk", 0x8000000);
            CharPropertyNames.defCategory("So", 0x10000000);
            CharPropertyNames.defCategory("Pi", 0x20000000);
            CharPropertyNames.defCategory("Pf", 0x40000000);
            CharPropertyNames.defCategory("L", 62);
            CharPropertyNames.defCategory("M", 448);
            CharPropertyNames.defCategory("N", 3584);
            CharPropertyNames.defCategory("Z", 28672);
            CharPropertyNames.defCategory("C", 884736);
            CharPropertyNames.defCategory("P", 1643118592);
            CharPropertyNames.defCategory("S", 0x1E000000);
            CharPropertyNames.defCategory("LC", 14);
            CharPropertyNames.defCategory("LD", 574);
            CharPropertyNames.defRange("L1", 0, 255);
            map.put("all", (CharPropertyFactory)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defRange("ASCII", 0, 127);
            CharPropertyNames.defCtype("Alnum", 1792);
            CharPropertyNames.defCtype("Alpha", 768);
            CharPropertyNames.defCtype("Blank", 16384);
            CharPropertyNames.defCtype("Cntrl", 8192);
            CharPropertyNames.defRange("Digit", 48, 57);
            CharPropertyNames.defCtype("Graph", 5888);
            CharPropertyNames.defRange("Lower", 97, 122);
            CharPropertyNames.defRange("Print", 32, 126);
            CharPropertyNames.defCtype("Punct", 4096);
            CharPropertyNames.defCtype("Space", 2048);
            CharPropertyNames.defRange("Upper", 65, 90);
            CharPropertyNames.defCtype("XDigit", 32768);
            CharPropertyNames.defClone("javaLowerCase", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaUpperCase", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaAlphabetic", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaIdeographic", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaTitleCase", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaDigit", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaDefined", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaLetter", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaLetterOrDigit", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaJavaIdentifierStart", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaJavaIdentifierPart", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaUnicodeIdentifierStart", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaUnicodeIdentifierPart", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaIdentifierIgnorable", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaSpaceChar", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaWhitespace", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaISOControl", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
            CharPropertyNames.defClone("javaMirrored", (CloneableProperty)new /* Unavailable Anonymous Inner Class!! */);
        }

        protected /* synthetic */ CharPropertyNames(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }

        private static abstract class CharPropertyFactory
        extends com.zeroturnaround.jrebelbase.h {
            private CharPropertyFactory() {
            }

            abstract CharProperty make();

            protected /* synthetic */ CharPropertyFactory(com.zeroturnaround.jrebelbase.h h2) {
                super(h2);
            }
        }

        private static abstract class CloneableProperty
        extends CharProperty
        implements Cloneable {
            private CloneableProperty() {
            }

            public CloneableProperty clone() {
                try {
                    return (CloneableProperty)g.convertForCast((Object)super.clone(), CloneableProperty.class);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)new AssertionError((Object)cloneNotSupportedException));
                }
            }

            protected /* synthetic */ CloneableProperty(com.zeroturnaround.jrebelbase.h h2) {
                super(h2);
            }
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node node, Node node2, Node node3) {
            this.cond = node;
            this.yes = node2;
            this.not = node3;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (this.cond.match(matcher, n2, charSequence)) {
                return this.yes.match(matcher, n2, charSequence);
            }
            return this.not.match(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            treeInfo.reset();
            this.yes.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.not.study(treeInfo);
            treeInfo.minLength = n2 + Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = n3 + Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl & bl2 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }

        static /* synthetic */ Node _jr$ig$cond(Object object) {
            return ((Conditional)((Object)object)).cond;
        }

        static /* synthetic */ void _jr$ip$cond(Object object, Node node) {
            ((Conditional)((Object)object)).cond = node;
        }

        static /* synthetic */ Node _jr$ig$yes(Object object) {
            return ((Conditional)((Object)object)).yes;
        }

        static /* synthetic */ void _jr$ip$yes(Object object, Node node) {
            ((Conditional)((Object)object)).yes = node;
        }

        static /* synthetic */ Node _jr$ig$not(Object object) {
            return ((Conditional)((Object)object)).not;
        }

        static /* synthetic */ void _jr$ip$not(Object object, Node node) {
            ((Conditional)((Object)object)).not = node;
        }
    }

    static final class Ctype
    extends BmpCharProperty {
        final int ctype;

        Ctype(int n2) {
            this.ctype = n2;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 < 128 && ASCII.isType(n2, this.ctype);
        }

        static /* synthetic */ int _jr$ig$ctype(Object object) {
            return ((Ctype)((Object)object)).ctype;
        }

        static /* synthetic */ void _jr$ip$ctype(Object object, int n2) {
            ((Ctype)((Object)object)).ctype = n2;
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n2, int n3, int n4) {
            this.atom = node;
            this.type = n4;
            this.cmin = n2;
            this.cmax = n3;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            for (n3 = 0; n3 < this.cmin; ++n3) {
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                n2 = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, n2, n3, charSequence);
            }
            if (this.type == 1) {
                return this.match1(matcher, n2, n3, charSequence);
            }
            return this.match2(matcher, n2, n3, charSequence);
        }

        boolean match0(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            int n4;
            if (n3 >= this.cmax) {
                return this.next.match(matcher, n2, charSequence);
            }
            int n5 = n3++;
            if (this.atom.match(matcher, n2, charSequence) && (n4 = matcher.last - n2) != 0) {
                n2 = matcher.last;
                while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                    if (n2 + n4 != matcher.last) {
                        if (!this.match0(matcher, matcher.last, n3 + 1, charSequence)) break;
                        return true;
                    }
                    n2 += n4;
                    ++n3;
                }
                while (n3 >= n5) {
                    if (this.next.match(matcher, n2, charSequence)) {
                        return true;
                    }
                    n2 -= n4;
                    --n3;
                }
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match1(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (!this.next.match(matcher, n2, charSequence)) {
                if (n3 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                if (n2 == matcher.last) {
                    return false;
                }
                n2 = matcher.last;
                ++n3;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence) && n2 != matcher.last) {
                n2 = matcher.last;
                ++n3;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n2 = ((TreeInfo)((Object)((Object)treeInfo))).minLength;
            int n3 = ((TreeInfo)((Object)((Object)treeInfo))).maxLength;
            boolean bl = ((TreeInfo)((Object)((Object)treeInfo))).maxValid;
            boolean bl2 = ((TreeInfo)((Object)((Object)treeInfo))).deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n4 = ((TreeInfo)((Object)((Object)treeInfo))).minLength * this.cmin + n2;
            if (n4 < n2) {
                n4 = 0xFFFFFFF;
            }
            ((TreeInfo)((Object)((Object)treeInfo))).minLength = n4;
            if (bl & ((TreeInfo)((Object)((Object)treeInfo))).maxValid) {
                n4 = ((TreeInfo)((Object)((Object)treeInfo))).maxLength * this.cmax + n3;
                ((TreeInfo)((Object)((Object)treeInfo))).maxLength = n4;
                if (n4 < n3) {
                    ((TreeInfo)((Object)((Object)treeInfo))).maxValid = false;
                }
            } else {
                ((TreeInfo)((Object)((Object)treeInfo))).maxValid = false;
            }
            if (((TreeInfo)((Object)((Object)treeInfo))).deterministic && this.cmin == this.cmax) {
                ((TreeInfo)((Object)((Object)treeInfo))).deterministic = bl2;
            } else {
                ((TreeInfo)((Object)((Object)treeInfo))).deterministic = false;
            }
            return this.next.study(treeInfo);
        }

        static /* synthetic */ Node _jr$ig$atom(Object object) {
            return ((Curly)((Object)object)).atom;
        }

        static /* synthetic */ void _jr$ip$atom(Object object, Node node) {
            ((Curly)((Object)object)).atom = node;
        }

        static /* synthetic */ int _jr$ig$type(Object object) {
            return ((Curly)((Object)object)).type;
        }

        static /* synthetic */ void _jr$ip$type(Object object, int n2) {
            ((Curly)((Object)object)).type = n2;
        }

        static /* synthetic */ int _jr$ig$cmin(Object object) {
            return ((Curly)((Object)object)).cmin;
        }

        static /* synthetic */ void _jr$ip$cmin(Object object, int n2) {
            ((Curly)((Object)object)).cmin = n2;
        }

        static /* synthetic */ int _jr$ig$cmax(Object object) {
            return ((Curly)((Object)object)).cmax;
        }

        static /* synthetic */ void _jr$ip$cmax(Object object, int n2) {
            ((Curly)((Object)object)).cmax = n2;
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl) {
            this.multiline = bl;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            int n3;
            int n4 = n3 = Matcher._jr$ig$anchoringBounds(matcher) ? Matcher._jr$ig$to(matcher) : matcher.getTextLength();
            if (!this.multiline) {
                if (n2 < n3 - 2) {
                    return false;
                }
                if (n2 == n3 - 2) {
                    c2 = charSequence.charAt(n2);
                    if (c2 != '\r') {
                        return false;
                    }
                    c2 = charSequence.charAt(n2 + 1);
                    if (c2 != '\n') {
                        return false;
                    }
                }
            }
            if (n2 < n3) {
                c2 = charSequence.charAt(n2);
                if (c2 == '\n') {
                    if (n2 > 0 && charSequence.charAt(n2 - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n2, charSequence);
                    }
                } else if (c2 == '\r' || c2 == '\u0085' || (c2 | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.next.match(matcher, n2, charSequence);
                    }
                } else {
                    return false;
                }
            }
            Matcher._jr$ip$hitEnd(matcher, true);
            Matcher._jr$ip$requireEnd(matcher, true);
            return this.next.match(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return ((TreeInfo)((Object)((Object)treeInfo))).deterministic;
        }

        static /* synthetic */ boolean _jr$ig$multiline(Object object) {
            return ((Dollar)((Object)object)).multiline;
        }

        static /* synthetic */ void _jr$ip$multiline(Object object, boolean bl) {
            ((Dollar)((Object)object)).multiline = bl;
        }
    }

    static final class Dot
    extends CharProperty {
        Dot() {
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 != 10 && n2 != 13 && (n2 | 1) != 8233 && n2 != 133;
        }
    }

    static final class End
    extends Node {
        End() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n2 == n3) {
                matcher.hitEnd = true;
                return this.next.match(matcher, n2, charSequence);
            }
            return false;
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (g.convertForInstanceOf((Object)((Object)this.atom), BnM.class) instanceof BnM) {
                return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            while (true) {
                if (n2 > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (this.atom.match(matcher, n2, charSequence)) {
                    return this.next.match(matcher, matcher.last, charSequence);
                }
                n2 += Pattern.countChars(charSequence, n2, 1);
                ++matcher.first;
            }
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            ((TreeInfo)((Object)((Object)treeInfo))).maxValid = false;
            ((TreeInfo)((Object)((Object)treeInfo))).deterministic = false;
            return this.next.study(treeInfo);
        }

        static /* synthetic */ Node _jr$ig$atom(Object object) {
            return ((First)((Object)object)).atom;
        }

        static /* synthetic */ void _jr$ip$atom(Object object, Node node) {
            ((First)((Object)object)).atom = node;
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this.atom = node;
            this.type = n4;
            this.cmin = n2;
            this.cmax = n3;
            this.localIndex = n5;
            this.groupIndex = n6;
            this.capture = bl;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int[] nArray2 = matcher.locals;
            int n3 = nArray2[this.localIndex];
            int n4 = 0;
            int n5 = 0;
            if (this.capture) {
                n4 = nArray[this.groupIndex];
                n5 = nArray[this.groupIndex + 1];
            }
            nArray2[this.localIndex] = -1;
            boolean bl = true;
            for (int i = 0; i < this.cmin; ++i) {
                if (this.atom.match(matcher, n2, charSequence)) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n2;
                        nArray[this.groupIndex + 1] = matcher.last;
                    }
                } else {
                    bl = false;
                    break;
                }
                n2 = matcher.last;
            }
            if (bl) {
                bl = this.type == 0 ? this.match0(matcher, n2, this.cmin, charSequence) : (this.type == 1 ? this.match1(matcher, n2, this.cmin, charSequence) : this.match2(matcher, n2, this.cmin, charSequence));
            }
            if (!bl) {
                nArray2[this.localIndex] = n3;
                if (this.capture) {
                    nArray[this.groupIndex] = n4;
                    nArray[this.groupIndex + 1] = n5;
                }
            }
            return bl;
        }

        boolean match0(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int n4 = 0;
            int n5 = 0;
            if (this.capture) {
                n4 = nArray[this.groupIndex];
                n5 = nArray[this.groupIndex + 1];
            }
            if (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                int n6 = matcher.last - n2;
                if (n6 <= 0) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n2;
                        nArray[this.groupIndex + 1] = n2 + n6;
                    }
                    n2 += n6;
                } else {
                    block13: {
                        do {
                            if (this.capture) {
                                nArray[this.groupIndex] = n2;
                                nArray[this.groupIndex + 1] = n2 + n6;
                            }
                            if (++n3 >= this.cmax || !this.atom.match(matcher, n2 += n6, charSequence)) break block13;
                        } while (n2 + n6 == matcher.last);
                        if (this.match0(matcher, n2, n3, charSequence)) {
                            return true;
                        }
                    }
                    while (n3 > this.cmin) {
                        if (this.next.match(matcher, n2, charSequence)) {
                            if (this.capture) {
                                nArray[this.groupIndex + 1] = n2;
                                nArray[this.groupIndex] = n2 - n6;
                            }
                            n2 -= n6;
                            return true;
                        }
                        if (this.capture) {
                            nArray[this.groupIndex + 1] = n2;
                            nArray[this.groupIndex] = n2 - n6;
                        }
                        n2 -= n6;
                        --n3;
                    }
                }
            }
            if (this.capture) {
                nArray[this.groupIndex] = n4;
                nArray[this.groupIndex + 1] = n5;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match1(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (!this.next.match(matcher, n2, charSequence)) {
                if (n3 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                if (n2 == matcher.last) {
                    return false;
                }
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n2;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                n2 = matcher.last;
                ++n3;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n2;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                if (n2 == matcher.last) break;
                n2 = matcher.last;
                ++n3;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl = treeInfo.maxValid;
            boolean bl2 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n4 = treeInfo.minLength * this.cmin + n2;
            if (n4 < n2) {
                n4 = 0xFFFFFFF;
            }
            treeInfo.minLength = n4;
            if (bl & treeInfo.maxValid) {
                treeInfo.maxLength = n4 = treeInfo.maxLength * this.cmax + n3;
                if (n4 < n3) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl2 : false;
            return this.next.study(treeInfo);
        }

        static /* synthetic */ Node _jr$ig$atom(Object object) {
            return ((GroupCurly)((Object)object)).atom;
        }

        static /* synthetic */ void _jr$ip$atom(Object object, Node node) {
            ((GroupCurly)((Object)object)).atom = node;
        }

        static /* synthetic */ int _jr$ig$type(Object object) {
            return ((GroupCurly)((Object)object)).type;
        }

        static /* synthetic */ void _jr$ip$type(Object object, int n2) {
            ((GroupCurly)((Object)object)).type = n2;
        }

        static /* synthetic */ int _jr$ig$cmin(Object object) {
            return ((GroupCurly)((Object)object)).cmin;
        }

        static /* synthetic */ void _jr$ip$cmin(Object object, int n2) {
            ((GroupCurly)((Object)object)).cmin = n2;
        }

        static /* synthetic */ int _jr$ig$cmax(Object object) {
            return ((GroupCurly)((Object)object)).cmax;
        }

        static /* synthetic */ void _jr$ip$cmax(Object object, int n2) {
            ((GroupCurly)((Object)object)).cmax = n2;
        }

        static /* synthetic */ int _jr$ig$localIndex(Object object) {
            return ((GroupCurly)((Object)object)).localIndex;
        }

        static /* synthetic */ void _jr$ip$localIndex(Object object, int n2) {
            ((GroupCurly)((Object)object)).localIndex = n2;
        }

        static /* synthetic */ int _jr$ig$groupIndex(Object object) {
            return ((GroupCurly)((Object)object)).groupIndex;
        }

        static /* synthetic */ void _jr$ip$groupIndex(Object object, int n2) {
            ((GroupCurly)((Object)object)).groupIndex = n2;
        }

        static /* synthetic */ boolean _jr$ig$capture(Object object) {
            return ((GroupCurly)((Object)object)).capture;
        }

        static /* synthetic */ void _jr$ip$capture(Object object, boolean bl) {
            ((GroupCurly)((Object)object)).capture = bl;
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int n2) {
            this.localIndex = n2;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = n2;
            boolean bl = this.next.match(matcher, n2, charSequence);
            matcher.locals[this.localIndex] = n3;
            return bl;
        }

        boolean matchRef(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~n2;
            boolean bl = this.next.match(matcher, n2, charSequence);
            matcher.locals[this.localIndex] = n3;
            return bl;
        }

        static /* synthetic */ int _jr$ig$localIndex(Object object) {
            return ((GroupHead)((Object)object)).localIndex;
        }

        static /* synthetic */ void _jr$ip$localIndex(Object object, int n2) {
            ((GroupHead)((Object)object)).localIndex = n2;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead groupHead) {
            this.head = groupHead;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.head.matchRef(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }

        static /* synthetic */ GroupHead _jr$ig$head(Object object) {
            return ((GroupRef)((Object)object)).head;
        }

        static /* synthetic */ void _jr$ip$head(Object object, GroupHead groupHead) {
            ((GroupRef)((Object)object)).head = groupHead;
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int n2, int n3) {
            this.localIndex = n2;
            this.groupIndex = n3 + n3;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            if (n3 >= 0) {
                int n4 = matcher.groups[this.groupIndex];
                int n5 = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = n3;
                matcher.groups[this.groupIndex + 1] = n2;
                if (this.next.match(matcher, n2, charSequence)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = n4;
                matcher.groups[this.groupIndex + 1] = n5;
                return false;
            }
            matcher.last = n2;
            return true;
        }

        static /* synthetic */ int _jr$ig$localIndex(Object object) {
            return ((GroupTail)((Object)object)).localIndex;
        }

        static /* synthetic */ void _jr$ip$localIndex(Object object, int n2) {
            ((GroupTail)((Object)object)).localIndex = n2;
        }

        static /* synthetic */ int _jr$ig$groupIndex(Object object) {
            return ((GroupTail)((Object)object)).groupIndex;
        }

        static /* synthetic */ void _jr$ip$groupIndex(Object object, int n2) {
            ((GroupTail)((Object)object)).groupIndex = n2;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (Matcher._jr$ig$acceptMode(matcher) == 1 && n2 != Matcher._jr$ig$to(matcher)) {
                return false;
            }
            Matcher._jr$ip$last(matcher, n2);
            Matcher._jr$ig$groups((Object)matcher)[0] = Matcher._jr$ig$first(matcher);
            Matcher._jr$ig$groups((Object)matcher)[1] = Matcher._jr$ig$last(matcher);
            return true;
        }

        protected /* synthetic */ LastNode(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.locals[this.beginIndex]) {
                int n3 = matcher.locals[this.countIndex];
                if (n3 < this.cmin) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl = this.body.match(matcher, n2, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl;
                }
                if (this.next.match(matcher, n2, charSequence)) {
                    return true;
                }
                if (n3 < this.cmax) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl = this.body.match(matcher, n2, charSequence);
                    if (!bl) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl;
                }
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        @Override
        boolean matchInit(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.countIndex];
            boolean bl = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n2, charSequence);
            } else if (this.next.match(matcher, n2, charSequence)) {
                bl = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl = this.body.match(matcher, n2, charSequence);
            }
            matcher.locals[this.countIndex] = n3;
            return bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n2, int n3) {
            this.countIndex = n2;
            this.beginIndex = n3;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > Matcher._jr$ig$locals(matcher)[((Loop)((Object)((Object)this))).beginIndex]) {
                int n3 = Matcher._jr$ig$locals(matcher)[((Loop)((Object)((Object)this))).countIndex];
                if (n3 < ((Loop)((Object)((Object)this))).cmin) {
                    Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = n3 + 1;
                    boolean bl = ((Loop)((Object)((Object)this))).body.match(matcher, n2, charSequence);
                    if (!bl) {
                        Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = n3;
                    }
                    return bl;
                }
                if (n3 < ((Loop)((Object)((Object)this))).cmax) {
                    Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = n3 + 1;
                    boolean bl = ((Loop)((Object)((Object)this))).body.match(matcher, n2, charSequence);
                    if (!bl) {
                        Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = n3;
                    } else {
                        return true;
                    }
                }
            }
            return Loop._jr$ig$next((Object)this).match(matcher, n2, charSequence);
        }

        boolean matchInit(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Matcher._jr$ig$locals(matcher)[((Loop)((Object)((Object)this))).countIndex];
            boolean bl = false;
            if (0 < ((Loop)((Object)((Object)this))).cmin) {
                Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = 1;
                bl = ((Loop)((Object)((Object)this))).body.match(matcher, n2, charSequence);
            } else if (0 < ((Loop)((Object)((Object)this))).cmax) {
                Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = 1;
                bl = ((Loop)((Object)((Object)this))).body.match(matcher, n2, charSequence);
                if (!bl) {
                    bl = Loop._jr$ig$next((Object)this).match(matcher, n2, charSequence);
                }
            } else {
                bl = Loop._jr$ig$next((Object)this).match(matcher, n2, charSequence);
            }
            Matcher._jr$ig$locals((Object)matcher)[((Loop)((Object)((Object)((Object)this)))).countIndex] = n3;
            return bl;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            ((TreeInfo)((Object)((Object)treeInfo))).maxValid = false;
            ((TreeInfo)((Object)((Object)treeInfo))).deterministic = false;
            return false;
        }

        static /* synthetic */ void _jr$ip$countIndex(Object object, int n2) {
            ((Loop)((Object)object)).countIndex = n2;
        }

        static /* synthetic */ void _jr$ip$beginIndex(Object object, int n2) {
            ((Loop)((Object)object)).beginIndex = n2;
        }

        protected /* synthetic */ Loop(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.to;
            boolean bl = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (n2 < matcher.to) {
                    bl = !this.cond.match(matcher, n2, charSequence);
                } else {
                    matcher.requireEnd = true;
                    bl = !this.cond.match(matcher, n2, charSequence);
                }
                matcher.to = n3;
            }
            catch (Throwable throwable) {
                matcher.to = n3;
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
            }
            return bl && this.next.match(matcher, n2, charSequence);
        }

        static /* synthetic */ Node _jr$ig$cond(Object object) {
            return ((Neg)((Object)object)).cond;
        }

        static /* synthetic */ void _jr$ip$cond(Object object, Node node) {
            ((Neg)((Object)object)).cond = node;
        }
    }

    static class Node
    extends com.zeroturnaround.jrebelbase.h {
        Node next;

        Node() {
            this.next = accept;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            matcher.last = n2;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo treeInfo) {
            if (((Node)((Object)((Object)this))).next != null) {
                return ((Node)((Object)((Object)this))).next.study(treeInfo);
            }
            return ((TreeInfo)((Object)((Object)treeInfo))).deterministic;
        }

        protected /* synthetic */ Node(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n2, int n3) {
            this.cond = node;
            this.rmax = n2;
            this.rmin = n3;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.lookbehindTo;
            int n4 = matcher.from;
            boolean bl = false;
            int n5 = !matcher.transparentBounds ? matcher.from : 0;
            int n6 = Math.max(n2 - ((NotBehind)((Object)((Object)this))).rmax, n5);
            matcher.lookbehindTo = n2;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n2 - ((NotBehind)((Object)((Object)this))).rmin; !bl && i >= n6; --i) {
                bl = ((NotBehind)((Object)((Object)this))).cond.match(matcher, i, charSequence);
            }
            matcher.from = n4;
            matcher.lookbehindTo = n3;
            return !bl && NotBehind._jr$ig$next((Object)this).match(matcher, n2, charSequence);
        }

        static /* synthetic */ void _jr$ip$cond(Object object, Node node) {
            ((NotBehind)((Object)object)).cond = node;
        }

        static /* synthetic */ void _jr$ip$rmax(Object object, int n2) {
            ((NotBehind)((Object)object)).rmax = n2;
        }

        static /* synthetic */ void _jr$ip$rmin(Object object, int n2) {
            ((NotBehind)((Object)object)).rmin = n2;
        }

        protected /* synthetic */ NotBehind(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node node, int n2, int n3) {
            super(node, n2, n3);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Pattern.countChars(charSequence, n2, -this.rmax);
            int n4 = Pattern.countChars(charSequence, n2, -this.rmin);
            int n5 = matcher.from;
            int n6 = matcher.lookbehindTo;
            boolean bl = false;
            int n7 = !matcher.transparentBounds ? matcher.from : 0;
            int n8 = Math.max(n2 - n3, n7);
            matcher.lookbehindTo = n2;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int i = n2 - n4; !bl && i >= n8; i -= i > n8 ? Pattern.countChars(charSequence, i, -1) : 1) {
                bl = this.cond.match(matcher, i, charSequence);
            }
            matcher.from = n5;
            matcher.lookbehindTo = n6;
            return !bl && this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.to;
            boolean bl = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                bl = this.cond.match(matcher, n2, charSequence);
                matcher.to = n3;
            }
            catch (Throwable throwable) {
                matcher.to = n3;
                throw (Throwable)h.getCurrentVersion((com.zeroturnaround.jrebelbase.h)throwable);
            }
            return bl && this.next.match(matcher, n2, charSequence);
        }

        static /* synthetic */ Node _jr$ig$cond(Object object) {
            return ((Pos)((Object)object)).cond;
        }

        static /* synthetic */ void _jr$ip$cond(Object object, Node node) {
            ((Pos)((Object)object)).cond = node;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.loop.matchInit(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }

        static /* synthetic */ Loop _jr$ig$loop(Object object) {
            return ((Prolog)((Object)object)).loop;
        }

        static /* synthetic */ void _jr$ip$loop(Object object, Loop loop) {
            ((Prolog)((Object)object)).loop = loop;
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n2) {
            this.atom = node;
            this.type = n2;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence) || this.next.match(matcher, n2, charSequence);
                }
                case 1: {
                    return this.next.match(matcher, n2, charSequence) || this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
                }
                case 2: {
                    if (this.atom.match(matcher, n2, charSequence)) {
                        n2 = matcher.last;
                    }
                    return this.next.match(matcher, n2, charSequence);
                }
            }
            return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n2 = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n2;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }

        static /* synthetic */ Node _jr$ig$atom(Object object) {
            return ((Ques)((Object)object)).atom;
        }

        static /* synthetic */ void _jr$ip$atom(Object object, Node node) {
            ((Ques)((Object)object)).atom = node;
        }

        static /* synthetic */ int _jr$ig$type(Object object) {
            return ((Ques)((Object)object)).type;
        }

        static /* synthetic */ void _jr$ip$type(Object object, int n2) {
            ((Ques)((Object)object)).type = n2;
        }
    }

    static final class Script
    extends CharProperty {
        final Character.UnicodeScript script;

        Script(Character.UnicodeScript unicodeScript) {
            this.script = unicodeScript;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return !f.ifAcmp((Object)((Object)this.script), (Object)((Object)Character.UnicodeScript.of(n2)));
        }

        static /* synthetic */ Character.UnicodeScript _jr$ig$script(Object object) {
            return ((Script)((Object)object)).script;
        }

        static /* synthetic */ void _jr$ip$script(Object object, Character.UnicodeScript unicodeScript) {
            ((Script)((Object)object)).script = unicodeScript;
        }
    }

    static final class Single
    extends BmpCharProperty {
        final int c;

        Single(int n2) {
            this.c = n2;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 == this.c;
        }

        static /* synthetic */ int _jr$ig$c(Object object) {
            return ((Single)((Object)object)).c;
        }

        static /* synthetic */ void _jr$ip$c(Object object, int n2) {
            ((Single)((Object)object)).c = n2;
        }
    }

    static final class SingleI
    extends BmpCharProperty {
        final int lower;
        final int upper;

        SingleI(int n2, int n3) {
            this.lower = n2;
            this.upper = n3;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 == this.lower || n2 == this.upper;
        }

        static /* synthetic */ int _jr$ig$lower(Object object) {
            return ((SingleI)((Object)object)).lower;
        }

        static /* synthetic */ void _jr$ip$lower(Object object, int n2) {
            ((SingleI)((Object)object)).lower = n2;
        }

        static /* synthetic */ int _jr$ig$upper(Object object) {
            return ((SingleI)((Object)object)).upper;
        }

        static /* synthetic */ void _jr$ip$upper(Object object, int n2) {
            ((SingleI)((Object)object)).upper = n2;
        }
    }

    static final class SingleS
    extends CharProperty {
        final int c;

        SingleS(int n2) {
            this.c = n2;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 == this.c;
        }

        static /* synthetic */ int _jr$ig$c(Object object) {
            return ((SingleS)((Object)object)).c;
        }

        static /* synthetic */ void _jr$ip$c(Object object, int n2) {
            ((SingleS)((Object)object)).c = n2;
        }
    }

    static final class SingleU
    extends CharProperty {
        final int lower;

        SingleU(int n2) {
            this.lower = n2;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return this.lower == n2 || this.lower == Character.toLowerCase(Character.toUpperCase(n2));
        }

        static /* synthetic */ int _jr$ig$lower(Object object) {
            return ((SingleU)((Object)object)).lower;
        }

        static /* synthetic */ void _jr$ip$lower(Object object, int n2) {
            ((SingleU)((Object)object)).lower = n2;
        }
    }

    static final class Slice
    extends SliceNode {
        Slice(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                if (n2 + i >= Matcher._jr$ig$to(matcher)) {
                    Matcher._jr$ip$hitEnd(matcher, true);
                    return false;
                }
                if (nArray[i] == charSequence.charAt(n2 + i)) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }
    }

    static class SliceI
    extends SliceNode {
        SliceI(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = SliceI._jr$ig$buffer((Object)this);
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                if (n2 + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c2 = charSequence.charAt(n2 + i);
                if (nArray[i] == c2 || nArray[i] == ASCII.toLower(c2)) continue;
                return false;
            }
            return SliceI._jr$ig$next((Object)this).match(matcher, n2 + n3, charSequence);
        }

        protected /* synthetic */ SliceI(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SliceIS
    extends SliceNode {
        SliceIS(int[] nArray) {
            super(nArray);
        }

        int toLower(int n2) {
            return ASCII.toLower(n2);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = SliceIS._jr$ig$buffer((Object)this);
            int n3 = n2;
            for (int i = 0; i < nArray.length; ++i) {
                if (n3 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n4 = Character.codePointAt(charSequence, n3);
                if (nArray[i] != n4 && nArray[i] != this.toLower(n4)) {
                    return false;
                }
                if ((n3 += Character.charCount(n4)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return SliceIS._jr$ig$next((Object)this).match(matcher, n3, charSequence);
        }

        protected /* synthetic */ SliceIS(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static class SliceNode
    extends Node {
        int[] buffer;

        SliceNode(int[] nArray) {
            this.buffer = nArray;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            TreeInfo treeInfo2 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo2))).minLength = ((TreeInfo)((Object)((Object)treeInfo2))).minLength + ((SliceNode)((Object)((Object)this))).buffer.length;
            TreeInfo treeInfo3 = treeInfo;
            ((TreeInfo)((Object)((Object)treeInfo3))).maxLength = ((TreeInfo)((Object)((Object)treeInfo3))).maxLength + ((SliceNode)((Object)((Object)this))).buffer.length;
            return SliceNode._jr$ig$next((Object)this).study(treeInfo);
        }

        static /* synthetic */ void _jr$ip$buffer(Object object, int[] nArray) {
            ((SliceNode)((Object)object)).buffer = nArray;
        }

        protected /* synthetic */ SliceNode(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class SliceS
    extends SliceNode {
        SliceS(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = n2;
            for (int i = 0; i < nArray.length; ++i) {
                if (n3 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n4 = Character.codePointAt(charSequence, n3);
                if (nArray[i] != n4) {
                    return false;
                }
                if ((n3 += Character.charCount(n4)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n3, charSequence);
        }
    }

    static final class SliceU
    extends SliceNode {
        SliceU(int[] nArray) {
            super(nArray);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                if (n2 + i >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c2 = charSequence.charAt(n2 + i);
                if (nArray[i] == c2 || nArray[i] == Character.toLowerCase(Character.toUpperCase((int)c2))) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }
    }

    static final class SliceUS
    extends SliceIS {
        SliceUS(int[] nArray) {
            super(nArray);
        }

        @Override
        int toLower(int n2) {
            return Character.toLowerCase(Character.toUpperCase(n2));
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.to - ((Start)((Object)((Object)this))).minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = matcher.to - ((Start)((Object)((Object)this))).minLength;
            while (n2 <= n3) {
                if (Start._jr$ig$next((Object)this).match(matcher, n2, charSequence)) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n2;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            Start._jr$ig$next((Object)this).study(treeInfo);
            ((TreeInfo)((Object)((Object)treeInfo))).maxValid = false;
            ((TreeInfo)((Object)((Object)treeInfo))).deterministic = false;
            return false;
        }

        static /* synthetic */ void _jr$ip$minLength(Object object, int n2) {
            ((Start)((Object)object)).minLength = n2;
        }

        protected /* synthetic */ Start(com.zeroturnaround.jrebelbase.h h2) {
            super(h2);
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = matcher.to - this.minLength;
            while (n2 <= n3) {
                if (this.next.match(matcher, n2, charSequence)) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                if (n2 == n3) break;
                if (!Character.isHighSurrogate(charSequence.charAt(n2++)) || n2 >= charSequence.length() || !Character.isLowSurrogate(charSequence.charAt(n2))) continue;
                ++n2;
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static final class TreeInfo
    extends com.zeroturnaround.jrebelbase.h {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            int n3 = matcher.from;
            int n4 = matcher.to;
            if (!matcher.anchoringBounds) {
                n3 = 0;
                n4 = matcher.getTextLength();
            }
            if (n2 == n4) {
                matcher.hitEnd = true;
                return false;
            }
            if (n2 > n3 && (c2 = charSequence.charAt(n2 - 1)) != '\n') {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl) {
            this.multiline = bl;
        }

        @Override
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n2 < n3) {
                char c2 = charSequence.charAt(n2);
                if (c2 == '\n') {
                    if (!this.multiline && n2 != n3 - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n2, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n2, charSequence);
        }

        @Override
        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }

        static /* synthetic */ boolean _jr$ig$multiline(Object object) {
            return ((UnixDollar)((Object)object)).multiline;
        }

        static /* synthetic */ void _jr$ip$multiline(Object object, boolean bl) {
            ((UnixDollar)((Object)object)).multiline = bl;
        }
    }

    static final class UnixDot
    extends CharProperty {
        UnixDot() {
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return n2 != 10;
        }
    }

    static final class Utype
    extends CharProperty {
        final UnicodeProp uprop;

        Utype(UnicodeProp unicodeProp) {
            this.uprop = unicodeProp;
        }

        @Override
        boolean isSatisfiedBy(int n2) {
            return this.uprop.is(n2);
        }

        static /* synthetic */ UnicodeProp _jr$ig$uprop(Object object) {
            return ((Utype)((Object)object)).uprop;
        }

        static /* synthetic */ void _jr$ip$uprop(Object object, UnicodeProp unicodeProp) {
            ((Utype)((Object)object)).uprop = unicodeProp;
        }
    }
}

