/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.util.zip.ZStreamRef;

public class Deflater
extends h {
    private final ZStreamRef zsRef;
    private byte[] buf;
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    private long bytesRead;
    private long bytesWritten;
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;

    public Deflater(int n2, boolean bl) {
        this.buf = new byte[0];
        this.level = n2;
        this.strategy = 0;
        this.zsRef = new ZStreamRef(Deflater.init(n2, 0, bl));
    }

    public Deflater(int n2) {
        this(n2, false);
    }

    public Deflater() {
        this(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException());
        }
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.buf = byArray;
                this.off = n2;
                this.len = n3;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException());
        }
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.ensureOpen();
                Deflater.setDictionary(this.zsRef.address(), byArray, n2, n3);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrategy(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
            }
        }
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                if (this.strategy != n2) {
                    this.strategy = n2;
                    this.setParams = true;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(int n2) {
        if ((n2 < 0 || n2 > 9) && n2 != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid compression level"));
        }
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                if (this.level != n2) {
                    this.level = n2;
                    this.setParams = true;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public boolean needsInput() {
        return this.len <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.finish = true;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                return this.finished;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public int deflate(byte[] byArray, int n2, int n3) {
        return this.deflate(byArray, n2, n3, 0);
    }

    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length, 0);
    }

    public int deflate(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException());
        }
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.ensureOpen();
                if (n4 == 0 || n4 == 2 || n4 == 3) {
                    int n5 = this.len;
                    int n6 = this.deflateBytes(this.zsRef.address(), byArray, n2, n3, n4);
                    Deflater deflater = this;
                    deflater.bytesWritten = deflater.bytesWritten + (long)n6;
                    Deflater deflater2 = this;
                    deflater2.bytesRead = deflater2.bytesRead + (long)(n5 - this.len);
                    return n6;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdler() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.ensureOpen();
                return Deflater.getAdler(this.zsRef.address());
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.ensureOpen();
                return this.bytesRead;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.ensureOpen();
                return this.bytesWritten;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                this.ensureOpen();
                Deflater.reset(this.zsRef.address());
                this.finish = false;
                this.finished = false;
                this.len = 0;
                this.off = 0;
                this.bytesWritten = 0L;
                this.bytesRead = 0L;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Object object = ah.getMonitor((Object)((Object)this.zsRef));
        synchronized (object) {
            try {
                long l = this.zsRef.address();
                this.zsRef.clear();
                if (l != 0L) {
                    Deflater.end(l);
                    this.buf = null;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected void finalize() {
        if (!this._jr$iCur()) {
            return;
        }
        this.end();
    }

    private void ensureOpen() {
        if (!$assertionsDisabled && !Thread.holdsLock(ah.getMonitor((Object)((Object)this.zsRef)))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
        }
        if (this.zsRef.address() == 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Deflater has been closed"));
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private static native int getAdler(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        Deflater.initIDs();
    }

    private static /* synthetic */ void _jr$ip$zsRef(Deflater deflater, ZStreamRef zStreamRef) {
        deflater.zsRef = zStreamRef;
    }

    private static /* synthetic */ byte[] _jr$ig$buf(Deflater deflater) {
        return deflater.buf;
    }

    private static /* synthetic */ int _jr$ig$off(Deflater deflater) {
        return deflater.off;
    }

    private static /* synthetic */ boolean _jr$ig$setParams(Deflater deflater) {
        return deflater.setParams;
    }

    private static /* synthetic */ boolean _jr$ig$finish(Deflater deflater) {
        return deflater.finish;
    }

    protected /* synthetic */ Deflater(h h2) {
        super(h2);
    }
}

