/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.h;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;

public class DeflaterInputStream
extends FilterInputStream {
    protected final Deflater def;
    protected final byte[] buf;
    private byte[] rbuf;
    private boolean usesDefaultDeflater;
    private boolean reachEOF;

    private void ensureOpen() throws IOException {
        if (DeflaterInputStream._jr$ig$in(this) == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    public DeflaterInputStream(InputStream inputStream) {
        this(inputStream, new Deflater());
        this.usesDefaultDeflater = true;
    }

    public DeflaterInputStream(InputStream inputStream, Deflater deflater) {
        this(inputStream, deflater, 512);
    }

    public DeflaterInputStream(InputStream inputStream, Deflater deflater, int n) {
        super(inputStream);
        this.rbuf = new byte[1];
        this.usesDefaultDeflater = false;
        this.reachEOF = false;
        if (inputStream == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Null input"));
        }
        if (deflater == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Null deflater"));
        }
        if (n < 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Buffer size < 1"));
        }
        this.def = deflater;
        this.buf = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (DeflaterInputStream._jr$ig$in(this) != null) {
            try {
                if (this.usesDefaultDeflater) {
                    ((DeflaterInputStream)this).def.end();
                }
                DeflaterInputStream._jr$ig$in(this).close();
            }
            catch (Throwable throwable) {
                DeflaterInputStream._jr$ip$in(this, null);
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            DeflaterInputStream._jr$ip$in(this, null);
        }
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.rbuf, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.rbuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Null buffer for read"));
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n2 > 0 && !((DeflaterInputStream)this).def.finished()) {
            int n4;
            if (((DeflaterInputStream)this).def.needsInput()) {
                n4 = DeflaterInputStream._jr$ig$in(this).read(((DeflaterInputStream)this).buf, 0, ((DeflaterInputStream)this).buf.length);
                if (n4 < 0) {
                    ((DeflaterInputStream)this).def.finish();
                } else if (n4 > 0) {
                    ((DeflaterInputStream)this).def.setInput(((DeflaterInputStream)this).buf, 0, n4);
                }
            }
            n4 = ((DeflaterInputStream)this).def.deflate(byArray, n, n2);
            n3 += n4;
            n += n4;
            n2 -= n4;
        }
        if (n3 == 0 && ((DeflaterInputStream)this).def.finished()) {
            this.reachEOF = true;
            n3 = -1;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("negative skip length"));
        }
        this.ensureOpen();
        if (this.rbuf.length < 512) {
            this.rbuf = new byte[512];
        }
        long l2 = 0L;
        for (int i = (int)Math.min(l, Integer.MAX_VALUE); i > 0 && (n = this.read(this.rbuf, 0, i <= this.rbuf.length ? i : this.rbuf.length)) >= 0; i -= n) {
            l2 += (long)n;
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("mark/reset not supported"));
    }

    protected static /* synthetic */ void _jr$ip$def(Object object, Deflater deflater) {
        ((DeflaterInputStream)object).def = deflater;
    }

    protected static /* synthetic */ void _jr$ip$buf(Object object, byte[] byArray) {
        ((DeflaterInputStream)object).buf = byArray;
    }

    private static /* synthetic */ void _jr$ip$usesDefaultDeflater(DeflaterInputStream deflaterInputStream, boolean bl) {
        deflaterInputStream.usesDefaultDeflater = bl;
    }

    protected /* synthetic */ DeflaterInputStream(h h2) {
        super(h2);
    }
}

