/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.h;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected Deflater def;
    protected byte[] buf;
    private boolean closed;
    private final boolean syncFlush;
    boolean usesDefaultDeflater;

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n2, boolean bl) {
        super(outputStream);
        this.closed = false;
        this.usesDefaultDeflater = false;
        if (outputStream == null || deflater == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (n2 <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("buffer size <= 0"));
        }
        this.def = deflater;
        this.buf = new byte[n2];
        this.syncFlush = bl;
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n2) {
        this(outputStream, deflater, n2, false);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, boolean bl) {
        this(outputStream, deflater, 512, bl);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512, false);
    }

    public DeflaterOutputStream(OutputStream outputStream, boolean bl) {
        this(outputStream, new Deflater(), 512, bl);
        this.usesDefaultDeflater = true;
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, false);
        this.usesDefaultDeflater = true;
    }

    @Override
    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF)};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (((DeflaterOutputStream)this).def.finished()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("write beyond end of stream"));
        }
        if ((n2 | n3 | n2 + n3 | byArray.length - (n2 + n3)) < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        if (n3 == 0) {
            return;
        }
        if (!((DeflaterOutputStream)this).def.finished()) {
            ((DeflaterOutputStream)this).def.setInput(byArray, n2, n3);
            while (!((DeflaterOutputStream)this).def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void finish() throws IOException {
        if (!((DeflaterOutputStream)this).def.finished()) {
            ((DeflaterOutputStream)this).def.finish();
            while (!((DeflaterOutputStream)this).def.finished()) {
                this.deflate();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            if (((DeflaterOutputStream)this).usesDefaultDeflater) {
                ((DeflaterOutputStream)this).def.end();
            }
            DeflaterOutputStream._jr$ig$out(this).close();
            this.closed = true;
        }
    }

    protected void deflate() throws IOException {
        int n2 = ((DeflaterOutputStream)this).def.deflate(((DeflaterOutputStream)this).buf, 0, ((DeflaterOutputStream)this).buf.length);
        if (n2 > 0) {
            DeflaterOutputStream._jr$ig$out(this).write(((DeflaterOutputStream)this).buf, 0, n2);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.syncFlush && !((DeflaterOutputStream)this).def.finished()) {
            int n2 = 0;
            while ((n2 = ((DeflaterOutputStream)this).def.deflate(((DeflaterOutputStream)this).buf, 0, ((DeflaterOutputStream)this).buf.length, 2)) > 0) {
                DeflaterOutputStream._jr$ig$out(this).write(((DeflaterOutputStream)this).buf, 0, n2);
                if (n2 >= ((DeflaterOutputStream)this).buf.length) continue;
            }
        }
        DeflaterOutputStream._jr$ig$out(this).flush();
    }

    protected static /* synthetic */ void _jr$ip$def(Object object, Deflater deflater) {
        ((DeflaterOutputStream)object).def = deflater;
    }

    protected static /* synthetic */ void _jr$ip$buf(Object object, byte[] byArray) {
        ((DeflaterOutputStream)object).buf = byArray;
    }

    private static /* synthetic */ void _jr$ip$syncFlush(DeflaterOutputStream deflaterOutputStream, boolean bl) {
        deflaterOutputStream.syncFlush = bl;
    }

    static /* synthetic */ void _jr$ip$usesDefaultDeflater(Object object, boolean bl) {
        ((DeflaterOutputStream)object).usesDefaultDeflater = bl;
    }

    protected /* synthetic */ DeflaterOutputStream(h h2) {
        super(h2);
    }
}

