/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.h;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private boolean closed;
    private boolean reachEOF;
    boolean usesDefaultInflater;
    private byte[] singleByteBuf;
    private byte[] b;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n2) {
        super(inputStream);
        this.closed = false;
        this.reachEOF = false;
        this.usesDefaultInflater = false;
        this.singleByteBuf = new byte[1];
        this.b = new byte[512];
        if (inputStream == null || inflater == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (n2 <= 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("buffer size <= 0"));
        }
        this.inf = inflater;
        this.buf = new byte[n2];
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater());
        this.usesDefaultInflater = true;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : this.singleByteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        if (n3 == 0) {
            return 0;
        }
        try {
            int n4;
            while ((n4 = ((InflaterInputStream)this).inf.inflate(byArray, n2, n3)) == 0) {
                if (((InflaterInputStream)this).inf.finished() || ((InflaterInputStream)this).inf.needsDictionary()) {
                    this.reachEOF = true;
                    return -1;
                }
                if (!((InflaterInputStream)this).inf.needsInput()) continue;
                this.fill();
            }
            return n4;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException(string != null ? string : "Invalid ZLIB data format"));
        }
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public long skip(long l) throws IOException {
        int n2;
        int n3;
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("negative skip length"));
        }
        this.ensureOpen();
        int n4 = (int)Math.min(l, Integer.MAX_VALUE);
        for (n2 = 0; n2 < n4; n2 += n3) {
            n3 = n4 - n2;
            if (n3 > this.b.length) {
                n3 = this.b.length;
            }
            if ((n3 = this.read(this.b, 0, n3)) != -1) continue;
            this.reachEOF = true;
            break;
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (((InflaterInputStream)this).usesDefaultInflater) {
                ((InflaterInputStream)this).inf.end();
            }
            InflaterInputStream._jr$ig$in(this).close();
            this.closed = true;
        }
    }

    protected void fill() throws IOException {
        this.ensureOpen();
        ((InflaterInputStream)this).len = InflaterInputStream._jr$ig$in(this).read(((InflaterInputStream)this).buf, 0, ((InflaterInputStream)this).buf.length);
        if (((InflaterInputStream)this).len == -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException("Unexpected end of ZLIB input stream"));
        }
        ((InflaterInputStream)this).inf.setInput(((InflaterInputStream)this).buf, 0, ((InflaterInputStream)this).len);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    @af(modifiers=33)
    public void mark(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void reset() throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("mark/reset not supported"));
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected static /* synthetic */ void _jr$ip$inf(Object object, Inflater inflater) {
        ((InflaterInputStream)object).inf = inflater;
    }

    protected static /* synthetic */ void _jr$ip$buf(Object object, byte[] byArray) {
        ((InflaterInputStream)object).buf = byArray;
    }

    static /* synthetic */ void _jr$ip$usesDefaultInflater(Object object, boolean bl) {
        ((InflaterInputStream)object).usesDefaultInflater = bl;
    }

    private static /* synthetic */ void _jr$ip$singleByteBuf(InflaterInputStream inflaterInputStream, byte[] byArray) {
        inflaterInputStream.singleByteBuf = byArray;
    }

    private static /* synthetic */ void _jr$ip$b(InflaterInputStream inflaterInputStream, byte[] byArray) {
        inflaterInputStream.b = byArray;
    }

    protected /* synthetic */ InflaterInputStream(h h2) {
        super(h2);
    }
}

