/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;

final class ZipCoder
extends h {
    private Charset cs;
    private CharsetDecoder dec;
    private CharsetEncoder enc;
    private boolean isUTF8;
    private ZipCoder utf8;

    String toString(byte[] byArray, int n2) {
        CharBuffer charBuffer;
        CharsetDecoder charsetDecoder = this.decoder().reset();
        int n3 = (int)((float)n2 * charsetDecoder.maxCharsPerByte());
        char[] cArray = new char[n3];
        if (n3 == 0) {
            return new String(cArray);
        }
        if (this.isUTF8 && g.convertForInstanceOf((Object)((Object)charsetDecoder), ArrayDecoder.class) instanceof ArrayDecoder) {
            int n4 = ((ArrayDecoder)g.convertForCast((Object)((Object)charsetDecoder), ArrayDecoder.class)).decode(byArray, 0, n2, cArray);
            if (n4 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("MALFORMED"));
            }
            return new String(cArray, 0, n4);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n2);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer = CharBuffer.wrap(cArray), true);
        if (!coderResult.isUnderflow()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(coderResult.toString()));
        }
        coderResult = charsetDecoder.flush(charBuffer);
        if (!coderResult.isUnderflow()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(coderResult.toString()));
        }
        return new String(cArray, 0, charBuffer.position());
    }

    String toString(byte[] byArray) {
        return this.toString(byArray, byArray.length);
    }

    byte[] getBytes(String string) {
        CharsetEncoder charsetEncoder = this.encoder().reset();
        char[] cArray = string.toCharArray();
        int n2 = (int)((float)cArray.length * charsetEncoder.maxBytesPerChar());
        byte[] byArray = new byte[n2];
        if (n2 == 0) {
            return byArray;
        }
        if (this.isUTF8 && g.convertForInstanceOf((Object)((Object)charsetEncoder), ArrayEncoder.class) instanceof ArrayEncoder) {
            int n3 = ((ArrayEncoder)g.convertForCast((Object)((Object)charsetEncoder), ArrayEncoder.class)).encode(cArray, 0, cArray.length, byArray);
            if (n3 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("MALFORMED"));
            }
            return Arrays.copyOf(byArray, n3);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (!coderResult.isUnderflow()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(coderResult.toString()));
        }
        coderResult = charsetEncoder.flush(byteBuffer);
        if (!coderResult.isUnderflow()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(coderResult.toString()));
        }
        if (byteBuffer.position() == byArray.length) {
            return byArray;
        }
        return Arrays.copyOf(byArray, byteBuffer.position());
    }

    byte[] getBytesUTF8(String string) {
        if (this.isUTF8) {
            return this.getBytes(string);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        return this.utf8.getBytes(string);
    }

    String toStringUTF8(byte[] byArray, int n2) {
        if (this.isUTF8) {
            return this.toString(byArray, n2);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        return this.utf8.toString(byArray, n2);
    }

    boolean isUTF8() {
        return this.isUTF8;
    }

    private ZipCoder(Charset charset) {
        this.cs = charset;
        this.isUTF8 = charset.name().equals(StandardCharsets.UTF_8.name());
    }

    static ZipCoder get(Charset charset) {
        return new ZipCoder(charset);
    }

    private CharsetDecoder decoder() {
        if (this.dec == null) {
            this.dec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.dec;
    }

    private CharsetEncoder encoder() {
        if (this.enc == null) {
            this.enc = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.enc;
    }

    private static /* synthetic */ Charset _jr$ig$cs(ZipCoder zipCoder) {
        return zipCoder.cs;
    }

    private static /* synthetic */ void _jr$ip$cs(ZipCoder zipCoder, Charset charset) {
        zipCoder.cs = charset;
    }

    private static /* synthetic */ CharsetDecoder _jr$ig$dec(ZipCoder zipCoder) {
        return zipCoder.dec;
    }

    private static /* synthetic */ void _jr$ip$dec(ZipCoder zipCoder, CharsetDecoder charsetDecoder) {
        zipCoder.dec = charsetDecoder;
    }

    private static /* synthetic */ CharsetEncoder _jr$ig$enc(ZipCoder zipCoder) {
        return zipCoder.enc;
    }

    private static /* synthetic */ void _jr$ip$enc(ZipCoder zipCoder, CharsetEncoder charsetEncoder) {
        zipCoder.enc = charsetEncoder;
    }

    private static /* synthetic */ boolean _jr$ig$isUTF8(ZipCoder zipCoder) {
        return zipCoder.isUTF8;
    }

    private static /* synthetic */ void _jr$ip$isUTF8(ZipCoder zipCoder, boolean bl) {
        zipCoder.isUTF8 = bl;
    }

    private static /* synthetic */ ZipCoder _jr$ig$utf8(ZipCoder zipCoder) {
        return zipCoder.utf8;
    }

    private static /* synthetic */ void _jr$ip$utf8(ZipCoder zipCoder, ZipCoder zipCoder2) {
        zipCoder.utf8 = zipCoder2;
    }
}

