/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.Date;
import java.util.zip.ZipConstants;

public class ZipEntry
extends h
implements ZipConstants,
Cloneable {
    String name;
    long time;
    long crc;
    long size;
    long csize;
    int method;
    int flag;
    byte[] extra;
    String comment;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        this.time = -1L;
        this.crc = -1L;
        this.size = -1L;
        this.csize = -1L;
        this.method = -1;
        this.flag = 0;
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (string.length() > 65535) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("entry name too long"));
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.time = -1L;
        this.crc = -1L;
        this.size = -1L;
        this.csize = -1L;
        this.method = -1;
        this.flag = 0;
        this.name = zipEntry.name;
        this.time = zipEntry.time;
        this.crc = zipEntry.crc;
        this.size = zipEntry.size;
        this.csize = zipEntry.csize;
        this.method = zipEntry.method;
        this.flag = zipEntry.flag;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    ZipEntry() {
        this.time = -1L;
        this.crc = -1L;
        this.size = -1L;
        this.csize = -1L;
        this.method = -1;
        this.flag = 0;
    }

    public String getName() {
        return ((ZipEntry)this).name;
    }

    public void setTime(long l) {
        ((ZipEntry)this).time = ZipEntry.javaToDosTime(l);
    }

    public long getTime() {
        return ((ZipEntry)this).time != -1L ? ZipEntry.dosToJavaTime(((ZipEntry)this).time) : -1L;
    }

    public void setSize(long l) {
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid entry size"));
        }
        ((ZipEntry)this).size = l;
    }

    public long getSize() {
        return ((ZipEntry)this).size;
    }

    public long getCompressedSize() {
        return ((ZipEntry)this).csize;
    }

    public void setCompressedSize(long l) {
        ((ZipEntry)this).csize = l;
    }

    public void setCrc(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid entry crc-32"));
        }
        ((ZipEntry)this).crc = l;
    }

    public long getCrc() {
        return ((ZipEntry)this).crc;
    }

    public void setMethod(int n2) {
        if (n2 != 0 && n2 != 8) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid compression method"));
        }
        ((ZipEntry)this).method = n2;
    }

    public int getMethod() {
        return ((ZipEntry)this).method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && byArray.length > 65535) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid extra field length"));
        }
        ((ZipEntry)this).extra = byArray;
    }

    public byte[] getExtra() {
        return ((ZipEntry)this).extra;
    }

    public void setComment(String string) {
        ((ZipEntry)this).comment = string;
    }

    public String getComment() {
        return ((ZipEntry)this).comment;
    }

    public boolean isDirectory() {
        return ((ZipEntry)this).name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    private static long dosToJavaTime(long l) {
        Date date = new Date((int)((l >> 25 & 0x7FL) + 80L), (int)((l >> 21 & 0xFL) - 1L), (int)(l >> 16 & 0x1FL), (int)(l >> 11 & 0x1FL), (int)(l >> 5 & 0x3FL), (int)(l << 1 & 0x3EL));
        return date.getTime();
    }

    private static long javaToDosTime(long l) {
        Date date = new Date(l);
        int n2 = date.getYear() + 1900;
        if (n2 < 1980) {
            return 0x210000L;
        }
        return n2 - 1980 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }

    public int hashCode() {
        return ((ZipEntry)this).name.hashCode();
    }

    public Object clone() {
        try {
            ZipEntry zipEntry = (ZipEntry)g.convertForCast((Object)super.clone(), ZipEntry.class);
            ((ZipEntry)zipEntry).extra = ((ZipEntry)this).extra == null ? null : (byte[])((ZipEntry)this).extra.clone();
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError());
        }
    }

    static /* synthetic */ void _jr$ip$name(Object object, String string) {
        ((ZipEntry)object).name = string;
    }

    static /* synthetic */ int _jr$ig$flag(Object object) {
        return ((ZipEntry)object).flag;
    }

    static /* synthetic */ void _jr$ip$flag(Object object, int n2) {
        ((ZipEntry)object).flag = n2;
    }

    protected /* synthetic */ ZipEntry(h h2) {
        super(h2);
    }
}

