/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import sun.misc.JavaUtilZipFileAccess;
import sun.misc.PerfCounter;
import sun.misc.SharedSecrets;
import sun.misc.VM;

public class ZipFile
extends h
implements ZipConstants,
Closeable {
    private long jzfile;
    private final String name;
    private final int total;
    private final boolean locsig;
    private volatile boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private ZipCoder zc;
    private final Map<InputStream, Inflater> streams;
    private Deque<Inflater> inflaterCache;
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n) throws IOException {
        this(file, n, StandardCharsets.UTF_8);
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int n, Charset charset) throws IOException {
        this.closeRequested = false;
        this.streams = new WeakHashMap<InputStream, Inflater>();
        this.inflaterCache = new ArrayDeque<Inflater>();
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n)));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        if (charset == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("charset is null"));
        }
        this.zc = ZipCoder.get(charset);
        long l = System.nanoTime();
        this.jzfile = ZipFile.open(string, n, file.lastModified(), usemmap);
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(l);
        PerfCounter.getZipFileCount().increment();
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
        this.locsig = ZipFile.startsWithLOC(this.jzfile);
    }

    public ZipFile(String string, Charset charset) throws IOException {
        this(new File(string), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.ensureOpen();
                byte[] byArray = ZipFile.getCommentBytes(this.jzfile);
                if (byArray == null) {
                    return null;
                }
                return this.zc.toString(byArray, byArray.length);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("name"));
        }
        long l = 0L;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.ensureOpen();
                l = ZipFile.getEntry(this.jzfile, this.zc.getBytes(string), true);
                if (l != 0L) {
                    ZipEntry zipEntry = this.getZipEntry(string, l);
                    ZipFile.freeEntry(this.jzfile, l);
                    return zipEntry;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return null;
    }

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("entry"));
        }
        long l = 0L;
        ZipFileInputStream zipFileInputStream = null;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.ensureOpen();
                l = !this.zc.isUTF8() && (ZipEntry._jr$ig$flag(zipEntry) & 0x800) != 0 ? ZipFile.getEntry(this.jzfile, this.zc.getBytesUTF8(ZipEntry._jr$ig$name(zipEntry)), false) : ZipFile.getEntry(this.jzfile, this.zc.getBytes(ZipEntry._jr$ig$name(zipEntry)), false);
                if (l == 0L) {
                    return null;
                }
                zipFileInputStream = new ZipFileInputStream(this, l);
                switch (ZipFile.getEntryMethod(l)) {
                    case 0: {
                        Object object2 = ah.getMonitor((Object)this.streams);
                        synchronized (object2) {
                            try {
                                this.streams.put(zipFileInputStream, null);
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                        return zipFileInputStream;
                    }
                    case 8: {
                        long l2 = ZipFile.getEntrySize(l) + 2L;
                        if (l2 > 65536L) {
                            l2 = 8192L;
                        }
                        if (l2 <= 0L) {
                            l2 = 4096L;
                        }
                        Inflater inflater = this.getInflater();
                        ZipFileInflaterInputStream zipFileInflaterInputStream = new ZipFileInflaterInputStream(this, zipFileInputStream, inflater, (int)l2);
                        Object object3 = ah.getMonitor((Object)this.streams);
                        synchronized (object3) {
                            try {
                                this.streams.put(zipFileInflaterInputStream, inflater);
                            }
                            catch (Throwable throwable) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                            }
                        }
                        return zipFileInflaterInputStream;
                    }
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid compression method"));
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Object object = ah.getMonitor((Object)this.inflaterCache);
        synchronized (object) {
            try {
                Inflater inflater;
                while (f.ifAcmp(null, (Object)((Object)(inflater = (Inflater)((Object)g.convertForCast(this.inflaterCache.poll(), Inflater.class)))))) {
                    if (inflater.ended()) continue;
                    return inflater;
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        if (!inflater.ended()) {
            inflater.reset();
            Object object = ah.getMonitor((Object)this.inflaterCache);
            synchronized (object) {
                try {
                    this.inflaterCache.add(inflater);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new Enumeration(this){
            private int i;
            final /* synthetic */ ZipFile this$0;
            {
                this.this$0 = zipFile;
                this.i = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                Object object = ah.getMonitor((Object)this.this$0);
                synchronized (object) {
                    try {
                        this.this$0.ensureOpen();
                        return this.i < this.this$0.total;
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ZipEntry nextElement() throws NoSuchElementException {
                Object object = ah.getMonitor((Object)this.this$0);
                synchronized (object) {
                    try {
                        this.this$0.ensureOpen();
                        if (this.i >= this.this$0.total) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoSuchElementException());
                        }
                        long l = this.this$0.jzfile;
                        1 v1 = this;
                        int n = v1.i;
                        v1.i = n + 1;
                        long l2 = ZipFile.getNextEntry(l, n);
                        if (l2 == 0L) {
                            String string = this.this$0.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(this.this$0.jzfile);
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipError("jzentry == 0,\n jzfile = " + this.this$0.jzfile + ",\n total = " + this.this$0.total + ",\n name = " + this.this$0.name + ",\n i = " + this.i + ",\n message = " + string));
                        }
                        ZipEntry zipEntry = this.this$0.getZipEntry(null, l2);
                        ZipFile.freeEntry(this.this$0.jzfile, l2);
                        return zipEntry;
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }

            static /* synthetic */ ZipFile _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, ZipFile zipFile) {
                (object).this$0 = zipFile;
            }
        };
    }

    private ZipEntry getZipEntry(String string, long l) {
        byte[] byArray;
        ZipEntry zipEntry = new ZipEntry();
        ZipEntry._jr$ip$flag(zipEntry, ZipFile.getEntryFlag(l));
        if (string != null) {
            ZipEntry._jr$ip$name(zipEntry, string);
        } else {
            byArray = ZipFile.getEntryBytes(l, 0);
            if (!this.zc.isUTF8() && (ZipEntry._jr$ig$flag(zipEntry) & 0x800) != 0) {
                ZipEntry._jr$ip$name(zipEntry, this.zc.toStringUTF8(byArray, byArray.length));
            } else {
                ZipEntry._jr$ip$name(zipEntry, this.zc.toString(byArray, byArray.length));
            }
        }
        ZipEntry._jr$ip$time(zipEntry, ZipFile.getEntryTime(l));
        ZipEntry._jr$ip$crc(zipEntry, ZipFile.getEntryCrc(l));
        ZipEntry._jr$ip$size(zipEntry, ZipFile.getEntrySize(l));
        ZipEntry._jr$ip$csize(zipEntry, ZipFile.getEntryCSize(l));
        ZipEntry._jr$ip$method(zipEntry, ZipFile.getEntryMethod(l));
        ZipEntry._jr$ip$extra(zipEntry, ZipFile.getEntryBytes(l, 1));
        byArray = ZipFile.getEntryBytes(l, 2);
        if (byArray == null) {
            ZipEntry._jr$ip$comment(zipEntry, null);
        } else if (!this.zc.isUTF8() && (ZipEntry._jr$ig$flag(zipEntry) & 0x800) != 0) {
            ZipEntry._jr$ip$comment(zipEntry, this.zc.toStringUTF8(byArray, byArray.length));
        } else {
            ZipEntry._jr$ip$comment(zipEntry, this.zc.toString(byArray, byArray.length));
        }
        return zipEntry;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                Object object2;
                Object object3 = ah.getMonitor((Object)this.streams);
                synchronized (object3) {
                    try {
                        if (!this.streams.isEmpty()) {
                            object2 = new HashMap(this.streams);
                            this.streams.clear();
                            Iterator iterator = object2.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = (Map.Entry)g.convertForCast(iterator.next(), Map.Entry.class);
                                ((InputStream)g.convertForCast(entry.getKey(), InputStream.class)).close();
                                Inflater inflater = (Inflater)((Object)g.convertForCast(entry.getValue(), Inflater.class));
                                if (inflater == null) continue;
                                inflater.end();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                object2 = ah.getMonitor((Object)this.inflaterCache);
                synchronized (object2) {
                    try {
                        while (f.ifAcmp(null, (Object)(object3 = (Inflater)((Object)g.convertForCast(this.inflaterCache.poll(), Inflater.class))))) {
                            ((Inflater)((Object)object3)).end();
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                if (this.jzfile != 0L) {
                    long l = this.jzfile;
                    this.jzfile = 0L;
                    ZipFile.close(l);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    protected void finalize() throws IOException {
        if (!this._jr$iCur()) {
            return;
        }
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("zip file closed"));
        }
        if (this.jzfile == 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("The object is not initialized."));
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("ZipFile closed"));
        }
    }

    private boolean startsWithLocHeader() {
        return this.locsig;
    }

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int getTotal(long var0);

    private static native boolean startsWithLOC(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
        String string = VM.getSavedProperty("sun.zip.disableMemoryMapping");
        usemmap = string == null || string.length() != 0 && !string.equalsIgnoreCase("true");
        SharedSecrets.setJavaUtilZipFileAccess(new JavaUtilZipFileAccess(){

            public boolean startsWithLocHeader(ZipFile zipFile) {
                return zipFile.startsWithLocHeader();
            }
        });
    }

    private static /* synthetic */ void _jr$ip$name(ZipFile zipFile, String string) {
        zipFile.name = string;
    }

    private static /* synthetic */ void _jr$ip$total(ZipFile zipFile, int n) {
        zipFile.total = n;
    }

    private static /* synthetic */ void _jr$ip$locsig(ZipFile zipFile, boolean bl) {
        zipFile.locsig = bl;
    }

    private static /* synthetic */ void _jr$ip$zc(ZipFile zipFile, ZipCoder zipCoder) {
        zipFile.zc = zipCoder;
    }

    private static /* synthetic */ void _jr$ip$streams(ZipFile zipFile, Map map) {
        zipFile.streams = map;
    }

    private static /* synthetic */ void _jr$ip$inflaterCache(ZipFile zipFile, Deque deque) {
        zipFile.inflaterCache = deque;
    }

    protected /* synthetic */ ZipFile(h h2) {
        super(h2);
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final ZipFileInputStream zfin;
        final /* synthetic */ ZipFile this$0;

        ZipFileInflaterInputStream(ZipFile zipFile, ZipFileInputStream zipFileInputStream, Inflater inflater, int n) {
            this.this$0 = zipFile;
            super(zipFileInputStream, inflater, n);
            this.closeRequested = false;
            this.eof = false;
            this.zfin = zipFileInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Inflater inflater;
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Object object = ah.getMonitor((Object)((ZipFileInflaterInputStream)this).this$0.streams);
            synchronized (object) {
                try {
                    inflater = (Inflater)((Object)g.convertForCast(((ZipFileInflaterInputStream)this).this$0.streams.remove(this), Inflater.class));
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            if (inflater != null) {
                ((ZipFileInflaterInputStream)this).this$0.releaseInflater(inflater);
            }
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException("Unexpected end of ZLIB input stream"));
            }
            ZipFileInflaterInputStream._jr$ip$len(this, ZipFileInflaterInputStream._jr$ig$in(this).read(ZipFileInflaterInputStream._jr$ig$buf(this), 0, ZipFileInflaterInputStream._jr$ig$buf(this).length));
            if (ZipFileInflaterInputStream._jr$ig$len(this) == -1) {
                ZipFileInflaterInputStream._jr$ig$buf((Object)this)[0] = 0;
                ZipFileInflaterInputStream._jr$ip$len(this, 1);
                this.eof = true;
            }
            ZipFileInflaterInputStream._jr$ig$inf(this).setInput(ZipFileInflaterInputStream._jr$ig$buf(this), 0, ZipFileInflaterInputStream._jr$ig$len(this));
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long l = this.zfin.size() - ZipFileInflaterInputStream._jr$ig$inf(this).getBytesWritten();
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        protected void finalize() throws Throwable {
            if (!this._jr$iCur()) {
                return;
            }
            this.close();
        }

        private static /* synthetic */ void _jr$ip$zfin(ZipFileInflaterInputStream zipFileInflaterInputStream, ZipFileInputStream zipFileInputStream) {
            zipFileInflaterInputStream.zfin = zipFileInputStream;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ZipFile zipFile) {
            ((ZipFileInflaterInputStream)object).this$0 = zipFile;
        }

        protected /* synthetic */ ZipFileInflaterInputStream(h h2) {
            super(h2);
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean closeRequested;
        protected long jzentry;
        private long pos;
        protected long rem;
        protected long size;
        final /* synthetic */ ZipFile this$0;

        ZipFileInputStream(ZipFile zipFile, long l) {
            this.this$0 = zipFile;
            this.closeRequested = false;
            this.pos = 0L;
            this.rem = ZipFile.getEntryCSize(l);
            this.size = ZipFile.getEntrySize(l);
            this.jzentry = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (((ZipFileInputStream)this).rem == 0L) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > ((ZipFileInputStream)this).rem) {
                n2 = (int)((ZipFileInputStream)this).rem;
            }
            Object object = ah.getMonitor((Object)((ZipFileInputStream)this).this$0);
            synchronized (object) {
                try {
                    ((ZipFileInputStream)this).this$0.ensureOpenOrZipException();
                    n2 = ZipFile.read(((ZipFileInputStream)this).this$0.jzfile, ((ZipFileInputStream)this).jzentry, this.pos, byArray, n, n2);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            if (n2 > 0) {
                ZipFileInputStream zipFileInputStream = this;
                zipFileInputStream.pos = zipFileInputStream.pos + (long)n2;
                ZipFileInputStream zipFileInputStream2 = this;
                ((ZipFileInputStream)zipFileInputStream2).rem = ((ZipFileInputStream)zipFileInputStream2).rem - (long)n2;
            }
            if (((ZipFileInputStream)this).rem == 0L) {
                this.close();
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long l) {
            if (l > ((ZipFileInputStream)this).rem) {
                l = ((ZipFileInputStream)this).rem;
            }
            ZipFileInputStream zipFileInputStream = this;
            zipFileInputStream.pos = zipFileInputStream.pos + l;
            ZipFileInputStream zipFileInputStream2 = this;
            ((ZipFileInputStream)zipFileInputStream2).rem = ((ZipFileInputStream)zipFileInputStream2).rem - l;
            if (((ZipFileInputStream)this).rem == 0L) {
                this.close();
            }
            return l;
        }

        @Override
        public int available() {
            return ((ZipFileInputStream)this).rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((ZipFileInputStream)this).rem;
        }

        public long size() {
            return ((ZipFileInputStream)this).size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            ((ZipFileInputStream)this).rem = 0L;
            Object object = ah.getMonitor((Object)((ZipFileInputStream)this).this$0);
            synchronized (object) {
                try {
                    if (((ZipFileInputStream)this).jzentry != 0L && ((ZipFileInputStream)this).this$0.jzfile != 0L) {
                        ZipFile.freeEntry(((ZipFileInputStream)this).this$0.jzfile, ((ZipFileInputStream)this).jzentry);
                        ((ZipFileInputStream)this).jzentry = 0L;
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            object = ah.getMonitor((Object)((ZipFileInputStream)this).this$0.streams);
            synchronized (object) {
                try {
                    ((ZipFileInputStream)this).this$0.streams.remove(this);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        protected void finalize() {
            if (!this._jr$iCur()) {
                return;
            }
            this.close();
        }

        protected static /* synthetic */ void _jr$ip$size(Object object, long l) {
            ((ZipFileInputStream)object).size = l;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, ZipFile zipFile) {
            ((ZipFileInputStream)object).this$0 = zipFile;
        }

        protected /* synthetic */ ZipFileInputStream(h h2) {
            super(h2);
        }
    }
}

