/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private int flag;
    private CRC32 crc;
    private long remaining;
    private byte[] tmpbuf;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed;
    private boolean entryEOF;
    private ZipCoder zc;
    private byte[] b;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    public ZipInputStream(InputStream inputStream) {
        this(inputStream, StandardCharsets.UTF_8);
    }

    public ZipInputStream(InputStream inputStream, Charset charset) {
        super(new PushbackInputStream(inputStream, 512), new Inflater(true), 512);
        this.crc = new CRC32();
        this.tmpbuf = new byte[512];
        this.closed = false;
        this.entryEOF = false;
        this.b = new byte[256];
        this.usesDefaultInflater = true;
        if (inputStream == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("in is null"));
        }
        if (charset == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("charset is null"));
        }
        this.zc = ZipCoder.get(charset);
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc.reset();
        ZipInputStream._jr$ig$inf(this).reset();
        ZipEntry zipEntry = this.readLOC();
        this.entry = zipEntry;
        if (zipEntry == null) {
            return null;
        }
        if (ZipEntry._jr$ig$method(this.entry) == 0) {
            this.remaining = ZipEntry._jr$ig$size(this.entry);
        }
        this.entryEOF = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.entry == null) {
            return -1;
        }
        switch (ZipEntry._jr$ig$method(this.entry)) {
            case 8: {
                n2 = super.read(byArray, n, n2);
                if (n2 == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(byArray, n, n2);
                }
                return n2;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)n2 > this.remaining) {
                    n2 = (int)this.remaining;
                }
                if ((n2 = ZipInputStream._jr$ig$in(this).read(byArray, n, n2)) == -1) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("unexpected EOF"));
                }
                this.crc.update(byArray, n, n2);
                ZipInputStream zipInputStream = this;
                zipInputStream.remaining = zipInputStream.remaining - (long)n2;
                if (this.remaining == 0L && ZipEntry._jr$ig$crc(this.entry) != this.crc.getValue()) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(ZipEntry._jr$ig$crc(this.entry)) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")"));
                }
                return n2;
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid compression method"));
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("negative skip length"));
        }
        this.ensureOpen();
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > this.tmpbuf.length) {
                n2 = this.tmpbuf.length;
            }
            if ((n2 = this.read(this.tmpbuf, 0, n2)) != -1) continue;
            this.entryEOF = true;
            break;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private ZipEntry readLOC() throws IOException {
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException eOFException) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            return null;
        }
        this.flag = ZipInputStream.get16(this.tmpbuf, 6);
        int n = ZipInputStream.get16(this.tmpbuf, 26);
        int n2 = this.b.length;
        if (n > n2) {
            while (n > (n2 *= 2)) {
            }
            this.b = new byte[n2];
        }
        this.readFully(this.b, 0, n);
        ZipEntry zipEntry = this.createZipEntry((this.flag & 0x800) != 0 ? this.zc.toStringUTF8(this.b, n) : this.zc.toString(this.b, n));
        if ((this.flag & 1) == 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("encrypted ZIP entry not supported"));
        }
        ZipEntry._jr$ip$method(zipEntry, ZipInputStream.get16(this.tmpbuf, 8));
        ZipEntry._jr$ip$time(zipEntry, ZipInputStream.get32(this.tmpbuf, 10));
        if ((this.flag & 8) == 8) {
            if (ZipEntry._jr$ig$method(zipEntry) != 8) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("only DEFLATED entries can have EXT descriptor"));
            }
        } else {
            ZipEntry._jr$ip$crc(zipEntry, ZipInputStream.get32(this.tmpbuf, 14));
            ZipEntry._jr$ip$csize(zipEntry, ZipInputStream.get32(this.tmpbuf, 18));
            ZipEntry._jr$ip$size(zipEntry, ZipInputStream.get32(this.tmpbuf, 22));
        }
        if ((n = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byte[] byArray = new byte[n];
            this.readFully(byArray, 0, n);
            zipEntry.setExtra(byArray);
            if (ZipEntry._jr$ig$csize(zipEntry) == 0xFFFFFFFFL || ZipEntry._jr$ig$size(zipEntry) == 0xFFFFFFFFL) {
                int n3 = 0;
                while (n3 + 4 < n) {
                    int n4 = ZipInputStream.get16(byArray, n3 + 2);
                    if (ZipInputStream.get16(byArray, n3) == 1) {
                        if (n4 < 16 || (n3 += 4) + n4 > n) {
                            return zipEntry;
                        }
                        ZipEntry._jr$ip$size(zipEntry, ZipInputStream.get64(byArray, n3));
                        ZipEntry._jr$ip$csize(zipEntry, ZipInputStream.get64(byArray, n3 + 8));
                        break;
                    }
                    n3 += n4 + 4;
                }
            }
        }
        return zipEntry;
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    private void readEnd(ZipEntry zipEntry) throws IOException {
        int n = ZipInputStream._jr$ig$inf(this).getRemaining();
        if (n > 0) {
            ((PushbackInputStream)g.convertForCast((Object)ZipInputStream._jr$ig$in(this), PushbackInputStream.class)).unread(ZipInputStream._jr$ig$buf(this), ZipInputStream._jr$ig$len(this) - n, n);
        }
        if ((this.flag & 8) == 8) {
            if (ZipInputStream._jr$ig$inf(this).getBytesWritten() > 0xFFFFFFFFL || ZipInputStream._jr$ig$inf(this).getBytesRead() > 0xFFFFFFFFL) {
                this.readFully(this.tmpbuf, 0, 24);
                long l = ZipInputStream.get32(this.tmpbuf, 0);
                if (l != 134695760L) {
                    ZipEntry._jr$ip$crc(zipEntry, l);
                    ZipEntry._jr$ip$csize(zipEntry, ZipInputStream.get64(this.tmpbuf, 4));
                    ZipEntry._jr$ip$size(zipEntry, ZipInputStream.get64(this.tmpbuf, 12));
                    ((PushbackInputStream)g.convertForCast((Object)ZipInputStream._jr$ig$in(this), PushbackInputStream.class)).unread(this.tmpbuf, 19, 4);
                } else {
                    ZipEntry._jr$ip$crc(zipEntry, ZipInputStream.get32(this.tmpbuf, 4));
                    ZipEntry._jr$ip$csize(zipEntry, ZipInputStream.get64(this.tmpbuf, 8));
                    ZipEntry._jr$ip$size(zipEntry, ZipInputStream.get64(this.tmpbuf, 16));
                }
            } else {
                this.readFully(this.tmpbuf, 0, 16);
                long l = ZipInputStream.get32(this.tmpbuf, 0);
                if (l != 134695760L) {
                    ZipEntry._jr$ip$crc(zipEntry, l);
                    ZipEntry._jr$ip$csize(zipEntry, ZipInputStream.get32(this.tmpbuf, 4));
                    ZipEntry._jr$ip$size(zipEntry, ZipInputStream.get32(this.tmpbuf, 8));
                    ((PushbackInputStream)g.convertForCast((Object)ZipInputStream._jr$ig$in(this), PushbackInputStream.class)).unread(this.tmpbuf, 11, 4);
                } else {
                    ZipEntry._jr$ip$crc(zipEntry, ZipInputStream.get32(this.tmpbuf, 4));
                    ZipEntry._jr$ip$csize(zipEntry, ZipInputStream.get32(this.tmpbuf, 8));
                    ZipEntry._jr$ip$size(zipEntry, ZipInputStream.get32(this.tmpbuf, 12));
                }
            }
        }
        if (ZipEntry._jr$ig$size(zipEntry) != ZipInputStream._jr$ig$inf(this).getBytesWritten()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry size (expected " + ZipEntry._jr$ig$size(zipEntry) + " but got " + ZipInputStream._jr$ig$inf(this).getBytesWritten() + " bytes)"));
        }
        if (ZipEntry._jr$ig$csize(zipEntry) != ZipInputStream._jr$ig$inf(this).getBytesRead()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry compressed size (expected " + ZipEntry._jr$ig$csize(zipEntry) + " but got " + ZipInputStream._jr$ig$inf(this).getBytesRead() + " bytes)"));
        }
        if (ZipEntry._jr$ig$crc(zipEntry) != this.crc.getValue()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(ZipEntry._jr$ig$crc(zipEntry)) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")"));
        }
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = ZipInputStream._jr$ig$in(this).read(byArray, n, n2);
            if (n3 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new EOFException());
            }
            n += n3;
            n2 -= n3;
        }
    }

    private static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) {
        return ((long)ZipInputStream.get16(byArray, n) | (long)ZipInputStream.get16(byArray, n + 2) << 16) & 0xFFFFFFFFL;
    }

    private static final long get64(byte[] byArray, int n) {
        return ZipInputStream.get32(byArray, n) | ZipInputStream.get32(byArray, n + 4) << 32;
    }

    private static /* synthetic */ void _jr$ip$crc(ZipInputStream zipInputStream, CRC32 cRC32) {
        zipInputStream.crc = cRC32;
    }

    private static /* synthetic */ void _jr$ip$tmpbuf(ZipInputStream zipInputStream, byte[] byArray) {
        zipInputStream.tmpbuf = byArray;
    }

    private static /* synthetic */ void _jr$ip$zc(ZipInputStream zipInputStream, ZipCoder zipCoder) {
        zipInputStream.zc = zipCoder;
    }

    protected /* synthetic */ ZipInputStream(h h2) {
        super(h2);
    }
}

