/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private XEntry current;
    private Vector<XEntry> xentries;
    private HashSet<String> names;
    private CRC32 crc;
    private long written;
    private long locoff;
    private byte[] comment;
    private int method;
    private boolean finished;
    private boolean closed;
    private final ZipCoder zc;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private static int version(ZipEntry zipEntry) throws ZipException {
        switch (ZipEntry._jr$ig$method(zipEntry)) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("unsupported compression method"));
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Stream closed"));
        }
    }

    public ZipOutputStream(OutputStream outputStream) {
        this(outputStream, StandardCharsets.UTF_8);
    }

    public ZipOutputStream(OutputStream outputStream, Charset charset) {
        super(outputStream, new Deflater(-1, true));
        this.xentries = new Vector();
        this.names = new HashSet();
        this.crc = new CRC32();
        this.written = 0L;
        this.locoff = 0L;
        this.method = 8;
        this.closed = false;
        if (charset == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("charset is null"));
        }
        this.zc = ZipCoder.get(charset);
        this.usesDefaultDeflater = true;
    }

    public void setComment(String string) {
        if (string != null) {
            this.comment = this.zc.getBytes(string);
            if (this.comment.length > 65535) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("ZIP file comment too long."));
            }
        }
    }

    public void setMethod(int n2) {
        if (n2 != 8 && n2 != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("invalid compression method"));
        }
        this.method = n2;
    }

    public void setLevel(int n2) {
        ZipOutputStream._jr$ig$def(this).setLevel(n2);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            this.closeEntry();
        }
        if (ZipEntry._jr$ig$time(zipEntry) == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        if (ZipEntry._jr$ig$method(zipEntry) == -1) {
            ZipEntry._jr$ip$method(zipEntry, this.method);
        }
        ZipEntry._jr$ip$flag(zipEntry, 0);
        switch (ZipEntry._jr$ig$method(zipEntry)) {
            case 8: {
                if (ZipEntry._jr$ig$size(zipEntry) != -1L && ZipEntry._jr$ig$csize(zipEntry) != -1L && ZipEntry._jr$ig$crc(zipEntry) != -1L) break;
                ZipEntry._jr$ip$flag(zipEntry, 8);
                break;
            }
            case 0: {
                if (ZipEntry._jr$ig$size(zipEntry) == -1L) {
                    ZipEntry._jr$ip$size(zipEntry, ZipEntry._jr$ig$csize(zipEntry));
                } else if (ZipEntry._jr$ig$csize(zipEntry) == -1L) {
                    ZipEntry._jr$ip$csize(zipEntry, ZipEntry._jr$ig$size(zipEntry));
                } else if (ZipEntry._jr$ig$size(zipEntry) != ZipEntry._jr$ig$csize(zipEntry)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("STORED entry where compressed != uncompressed size"));
                }
                if (ZipEntry._jr$ig$size(zipEntry) != -1L && ZipEntry._jr$ig$crc(zipEntry) != -1L) break;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("STORED entry missing size, compressed size, or crc-32"));
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("unsupported compression method"));
            }
        }
        if (!this.names.add(ZipEntry._jr$ig$name(zipEntry))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("duplicate entry: " + ZipEntry._jr$ig$name(zipEntry)));
        }
        if (this.zc.isUTF8()) {
            ZipEntry zipEntry2 = zipEntry;
            ZipEntry._jr$ip$flag(zipEntry2, ZipEntry._jr$ig$flag(zipEntry2) | 0x800);
        }
        this.current = new XEntry(zipEntry, this.written);
        this.xentries.add(this.current);
        this.writeLOC(this.current);
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            ZipEntry zipEntry = ((XEntry)((Object)((Object)this.current))).entry;
            switch (ZipEntry._jr$ig$method(zipEntry)) {
                case 8: {
                    ZipOutputStream._jr$ig$def(this).finish();
                    while (!ZipOutputStream._jr$ig$def(this).finished()) {
                        this.deflate();
                    }
                    if ((ZipEntry._jr$ig$flag(zipEntry) & 8) == 0) {
                        if (ZipEntry._jr$ig$size(zipEntry) != ZipOutputStream._jr$ig$def(this).getBytesRead()) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry size (expected " + ZipEntry._jr$ig$size(zipEntry) + " but got " + ZipOutputStream._jr$ig$def(this).getBytesRead() + " bytes)"));
                        }
                        if (ZipEntry._jr$ig$csize(zipEntry) != ZipOutputStream._jr$ig$def(this).getBytesWritten()) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry compressed size (expected " + ZipEntry._jr$ig$csize(zipEntry) + " but got " + ZipOutputStream._jr$ig$def(this).getBytesWritten() + " bytes)"));
                        }
                        if (ZipEntry._jr$ig$crc(zipEntry) != this.crc.getValue()) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(ZipEntry._jr$ig$crc(zipEntry)) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")"));
                        }
                    } else {
                        ZipEntry._jr$ip$size(zipEntry, ZipOutputStream._jr$ig$def(this).getBytesRead());
                        ZipEntry._jr$ip$csize(zipEntry, ZipOutputStream._jr$ig$def(this).getBytesWritten());
                        ZipEntry._jr$ip$crc(zipEntry, this.crc.getValue());
                        this.writeEXT(zipEntry);
                    }
                    ZipOutputStream._jr$ig$def(this).reset();
                    ZipOutputStream zipOutputStream = this;
                    zipOutputStream.written = zipOutputStream.written + ZipEntry._jr$ig$csize(zipEntry);
                    break;
                }
                case 0: {
                    if (ZipEntry._jr$ig$size(zipEntry) != this.written - this.locoff) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry size (expected " + ZipEntry._jr$ig$size(zipEntry) + " but got " + (this.written - this.locoff) + " bytes)"));
                    }
                    if (ZipEntry._jr$ig$crc(zipEntry) == this.crc.getValue()) break;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(ZipEntry._jr$ig$crc(zipEntry)) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")"));
                }
                default: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid compression method"));
                }
            }
            this.crc.reset();
            this.current = null;
        }
    }

    @Override
    @af(modifiers=33)
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                this.ensureOpen();
                if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException());
                }
                if (n3 == 0) {
                    return;
                }
                if (this.current == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("no current ZIP entry"));
                }
                ZipEntry zipEntry = ((XEntry)((Object)((Object)this.current))).entry;
                switch (ZipEntry._jr$ig$method(zipEntry)) {
                    case 8: {
                        super.write(byArray, n2, n3);
                        break;
                    }
                    case 0: {
                        ZipOutputStream zipOutputStream = this;
                        zipOutputStream.written = zipOutputStream.written + (long)n3;
                        if (this.written - this.locoff > ZipEntry._jr$ig$size(zipEntry)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("attempt to write past end of STORED entry"));
                        }
                        ZipOutputStream._jr$ig$out(this).write(byArray, n2, n3);
                        break;
                    }
                    default: {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ZipException("invalid compression method"));
                    }
                }
                this.crc.update(byArray, n2, n3);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        long l2 = this.written;
        Iterator iterator = this.xentries.iterator();
        while (iterator.hasNext()) {
            XEntry xEntry = (XEntry)((Object)g.convertForCast(iterator.next(), XEntry.class));
            this.writeCEN(xEntry);
        }
        this.writeEND(l2, this.written - l2);
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private void writeLOC(XEntry xEntry) throws IOException {
        ZipEntry zipEntry = ((XEntry)((Object)((Object)xEntry))).entry;
        int n2 = ZipEntry._jr$ig$flag(zipEntry);
        int n3 = ZipEntry._jr$ig$extra(zipEntry) != null ? ZipEntry._jr$ig$extra(zipEntry).length : 0;
        boolean bl = false;
        this.writeInt(67324752L);
        if ((n2 & 8) == 8) {
            this.writeShort(ZipOutputStream.version(zipEntry));
            this.writeShort(n2);
            this.writeShort(ZipEntry._jr$ig$method(zipEntry));
            this.writeInt(ZipEntry._jr$ig$time(zipEntry));
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            if (ZipEntry._jr$ig$csize(zipEntry) >= 0xFFFFFFFFL || ZipEntry._jr$ig$size(zipEntry) >= 0xFFFFFFFFL) {
                bl = true;
                this.writeShort(45);
            } else {
                this.writeShort(ZipOutputStream.version(zipEntry));
            }
            this.writeShort(n2);
            this.writeShort(ZipEntry._jr$ig$method(zipEntry));
            this.writeInt(ZipEntry._jr$ig$time(zipEntry));
            this.writeInt(ZipEntry._jr$ig$crc(zipEntry));
            if (bl) {
                this.writeInt(0xFFFFFFFFL);
                this.writeInt(0xFFFFFFFFL);
                n3 += 20;
            } else {
                this.writeInt(ZipEntry._jr$ig$csize(zipEntry));
                this.writeInt(ZipEntry._jr$ig$size(zipEntry));
            }
        }
        byte[] byArray = this.zc.getBytes(ZipEntry._jr$ig$name(zipEntry));
        this.writeShort(byArray.length);
        this.writeShort(n3);
        this.writeBytes(byArray, 0, byArray.length);
        if (bl) {
            this.writeShort(1);
            this.writeShort(16);
            this.writeLong(ZipEntry._jr$ig$size(zipEntry));
            this.writeLong(ZipEntry._jr$ig$csize(zipEntry));
        }
        if (ZipEntry._jr$ig$extra(zipEntry) != null) {
            this.writeBytes(ZipEntry._jr$ig$extra(zipEntry), 0, ZipEntry._jr$ig$extra(zipEntry).length);
        }
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry zipEntry) throws IOException {
        this.writeInt(134695760L);
        this.writeInt(ZipEntry._jr$ig$crc(zipEntry));
        if (ZipEntry._jr$ig$csize(zipEntry) >= 0xFFFFFFFFL || ZipEntry._jr$ig$size(zipEntry) >= 0xFFFFFFFFL) {
            this.writeLong(ZipEntry._jr$ig$csize(zipEntry));
            this.writeLong(ZipEntry._jr$ig$size(zipEntry));
        } else {
            this.writeInt(ZipEntry._jr$ig$csize(zipEntry));
            this.writeInt(ZipEntry._jr$ig$size(zipEntry));
        }
    }

    private void writeCEN(XEntry xEntry) throws IOException {
        byte[] byArray;
        ZipEntry zipEntry = ((XEntry)((Object)((Object)xEntry))).entry;
        int n2 = ZipEntry._jr$ig$flag(zipEntry);
        int n3 = ZipOutputStream.version(zipEntry);
        long l2 = ZipEntry._jr$ig$csize(zipEntry);
        long l3 = ZipEntry._jr$ig$size(zipEntry);
        long l4 = ((XEntry)((Object)((Object)xEntry))).offset;
        int n4 = 0;
        boolean bl = false;
        if (ZipEntry._jr$ig$csize(zipEntry) >= 0xFFFFFFFFL) {
            l2 = 0xFFFFFFFFL;
            n4 += 8;
            bl = true;
        }
        if (ZipEntry._jr$ig$size(zipEntry) >= 0xFFFFFFFFL) {
            l3 = 0xFFFFFFFFL;
            n4 += 8;
            bl = true;
        }
        if (((XEntry)((Object)((Object)xEntry))).offset >= 0xFFFFFFFFL) {
            l4 = 0xFFFFFFFFL;
            n4 += 8;
            bl = true;
        }
        this.writeInt(33639248L);
        if (bl) {
            this.writeShort(45);
            this.writeShort(45);
        } else {
            this.writeShort(n3);
            this.writeShort(n3);
        }
        this.writeShort(n2);
        this.writeShort(ZipEntry._jr$ig$method(zipEntry));
        this.writeInt(ZipEntry._jr$ig$time(zipEntry));
        this.writeInt(ZipEntry._jr$ig$crc(zipEntry));
        this.writeInt(l2);
        this.writeInt(l3);
        byte[] byArray2 = this.zc.getBytes(ZipEntry._jr$ig$name(zipEntry));
        this.writeShort(byArray2.length);
        if (bl) {
            this.writeShort(n4 + 4 + (ZipEntry._jr$ig$extra(zipEntry) != null ? ZipEntry._jr$ig$extra(zipEntry).length : 0));
        } else {
            this.writeShort(ZipEntry._jr$ig$extra(zipEntry) != null ? ZipEntry._jr$ig$extra(zipEntry).length : 0);
        }
        if (ZipEntry._jr$ig$comment(zipEntry) != null) {
            byArray = this.zc.getBytes(ZipEntry._jr$ig$comment(zipEntry));
            this.writeShort(Math.min(byArray.length, 65535));
        } else {
            byArray = null;
            this.writeShort(0);
        }
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(l4);
        this.writeBytes(byArray2, 0, byArray2.length);
        if (bl) {
            this.writeShort(1);
            this.writeShort(n4);
            if (l3 == 0xFFFFFFFFL) {
                this.writeLong(ZipEntry._jr$ig$size(zipEntry));
            }
            if (l2 == 0xFFFFFFFFL) {
                this.writeLong(ZipEntry._jr$ig$csize(zipEntry));
            }
            if (l4 == 0xFFFFFFFFL) {
                this.writeLong(((XEntry)((Object)((Object)xEntry))).offset);
            }
        }
        if (ZipEntry._jr$ig$extra(zipEntry) != null) {
            this.writeBytes(ZipEntry._jr$ig$extra(zipEntry), 0, ZipEntry._jr$ig$extra(zipEntry).length);
        }
        if (byArray != null) {
            this.writeBytes(byArray, 0, Math.min(byArray.length, 65535));
        }
    }

    private void writeEND(long l2, long l3) throws IOException {
        int n2;
        boolean bl = false;
        long l4 = l3;
        long l5 = l2;
        if (l4 >= 0xFFFFFFFFL) {
            l4 = 0xFFFFFFFFL;
            bl = true;
        }
        if (l5 >= 0xFFFFFFFFL) {
            l5 = 0xFFFFFFFFL;
            bl = true;
        }
        if ((n2 = this.xentries.size()) >= 65535) {
            n2 = 65535;
            bl = true;
        }
        if (bl) {
            long l6 = this.written;
            this.writeInt(101075792L);
            this.writeLong(44L);
            this.writeShort(45);
            this.writeShort(45);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeLong(this.xentries.size());
            this.writeLong(this.xentries.size());
            this.writeLong(l3);
            this.writeLong(l2);
            this.writeInt(117853008L);
            this.writeInt(0L);
            this.writeLong(l6);
            this.writeInt(1L);
        }
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(n2);
        this.writeShort(n2);
        this.writeInt(l4);
        this.writeInt(l5);
        if (this.comment != null) {
            this.writeShort(this.comment.length);
            this.writeBytes(this.comment, 0, this.comment.length);
        } else {
            this.writeShort(0);
        }
    }

    private void writeShort(int n2) throws IOException {
        OutputStream outputStream = ZipOutputStream._jr$ig$out(this);
        outputStream.write(n2 >>> 0 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.written = zipOutputStream.written + 2L;
    }

    private void writeInt(long l2) throws IOException {
        OutputStream outputStream = ZipOutputStream._jr$ig$out(this);
        outputStream.write((int)(l2 >>> 0 & 0xFFL));
        outputStream.write((int)(l2 >>> 8 & 0xFFL));
        outputStream.write((int)(l2 >>> 16 & 0xFFL));
        outputStream.write((int)(l2 >>> 24 & 0xFFL));
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.written = zipOutputStream.written + 4L;
    }

    private void writeLong(long l2) throws IOException {
        OutputStream outputStream = ZipOutputStream._jr$ig$out(this);
        outputStream.write((int)(l2 >>> 0 & 0xFFL));
        outputStream.write((int)(l2 >>> 8 & 0xFFL));
        outputStream.write((int)(l2 >>> 16 & 0xFFL));
        outputStream.write((int)(l2 >>> 24 & 0xFFL));
        outputStream.write((int)(l2 >>> 32 & 0xFFL));
        outputStream.write((int)(l2 >>> 40 & 0xFFL));
        outputStream.write((int)(l2 >>> 48 & 0xFFL));
        outputStream.write((int)(l2 >>> 56 & 0xFFL));
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.written = zipOutputStream.written + 8L;
    }

    private void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        DeflaterOutputStream._jr$ig$out(this).write(byArray, n2, n3);
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.written = zipOutputStream.written + (long)n3;
    }

    private static /* synthetic */ void _jr$ip$xentries(ZipOutputStream zipOutputStream, Vector vector) {
        zipOutputStream.xentries = vector;
    }

    private static /* synthetic */ void _jr$ip$names(ZipOutputStream zipOutputStream, HashSet hashSet) {
        zipOutputStream.names = hashSet;
    }

    private static /* synthetic */ void _jr$ip$crc(ZipOutputStream zipOutputStream, CRC32 cRC32) {
        zipOutputStream.crc = cRC32;
    }

    private static /* synthetic */ void _jr$ip$zc(ZipOutputStream zipOutputStream, ZipCoder zipCoder) {
        zipOutputStream.zc = zipCoder;
    }

    protected /* synthetic */ ZipOutputStream(h h2) {
        super(h2);
    }

    private static class XEntry
    extends h {
        public final ZipEntry entry;
        public final long offset;

        public XEntry(ZipEntry zipEntry, long l2) {
            this.entry = zipEntry;
            this.offset = l2;
        }

        public static /* synthetic */ void _jr$ip$entry(Object object, ZipEntry zipEntry) {
            ((XEntry)((Object)object)).entry = zipEntry;
        }

        public static /* synthetic */ void _jr$ip$offset(Object object, long l2) {
            ((XEntry)((Object)object)).offset = l2;
        }

        protected /* synthetic */ XEntry(h h2) {
            super(h2);
        }
    }
}

