/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;
import javax.net.ssl.SSLContext;
import sun.security.action.GetPropertyAction;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLSocketFactory theFactory;
    private static boolean propertyChecked;
    static final boolean DEBUG;

    private static void log(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public SSLSocketFactory() {
    }

    public static synchronized SocketFactory getDefault() {
        if (theFactory != null) {
            return theFactory;
        }
        if (!propertyChecked) {
            propertyChecked = true;
            String string = SSLSocketFactory.getSecurityProperty("ssl.SocketFactory.provider");
            if (string != null) {
                SSLSocketFactory.log("setting up default SSLSocketFactory");
                try {
                    Class<?> clazz;
                    block9: {
                        clazz = null;
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            if (classLoader == null) break block9;
                            clazz = classLoader.loadClass(string);
                        }
                    }
                    SSLSocketFactory.log("class " + string + " is loaded");
                    SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)((Object)g.convertForCast(ai.getCurrentClass(clazz).newInstance(), SSLSocketFactory.class));
                    SSLSocketFactory.log("instantiated an instance of class " + string);
                    theFactory = sSLSocketFactory;
                    return sSLSocketFactory;
                }
                catch (Exception exception) {
                    SSLSocketFactory.log("SSLSocketFactory instantiation failed: " + exception.toString());
                    theFactory = new DefaultSSLSocketFactory(exception);
                    return theFactory;
                }
            }
        }
        try {
            return SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new DefaultSSLSocketFactory(noSuchAlgorithmException);
        }
    }

    static String getSecurityProperty(String string) {
        return (String)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    static {
        String string = ((String)AccessController.doPrivileged(new GetPropertyAction("javax.net.debug", ""))).toLowerCase(Locale.ENGLISH);
        DEBUG = string.contains("all") || string.contains("ssl");
    }

    protected /* synthetic */ SSLSocketFactory(h h2) {
        super(h2);
    }
}

