/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import sun.security.jca.GetInstance;

public class TrustManagerFactory
extends h {
    private Provider provider;
    private TrustManagerFactorySpi factorySpi;
    private String algorithm;

    public static final String getDefaultAlgorithm() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public String run() {
                return Security.getProperty("ssl.TrustManagerFactory.algorithm");
            }
        });
        if (string == null) {
            string = "SunX509";
        }
        return string;
    }

    protected TrustManagerFactory(TrustManagerFactorySpi trustManagerFactorySpi, Provider provider, String string) {
        this.factorySpi = trustManagerFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final TrustManagerFactory getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("TrustManagerFactory", TrustManagerFactorySpi.class, string);
        return new TrustManagerFactory((TrustManagerFactorySpi)((Object)g.convertForCast((Object)instance.impl, TrustManagerFactorySpi.class)), instance.provider, string);
    }

    public static final TrustManagerFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("TrustManagerFactory", TrustManagerFactorySpi.class, string, string2);
        return new TrustManagerFactory((TrustManagerFactorySpi)((Object)g.convertForCast((Object)instance.impl, TrustManagerFactorySpi.class)), instance.provider, string);
    }

    public static final TrustManagerFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("TrustManagerFactory", TrustManagerFactorySpi.class, string, provider);
        return new TrustManagerFactory((TrustManagerFactorySpi)((Object)g.convertForCast((Object)instance.impl, TrustManagerFactorySpi.class)), instance.provider, string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyStore keyStore) throws KeyStoreException {
        this.factorySpi.engineInit(keyStore);
    }

    public final void init(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.factorySpi.engineInit(managerFactoryParameters);
    }

    public final TrustManager[] getTrustManagers() {
        return this.factorySpi.engineGetTrustManagers();
    }

    private static /* synthetic */ void _jr$ip$provider(TrustManagerFactory trustManagerFactory, Provider provider) {
        trustManagerFactory.provider = provider;
    }

    private static /* synthetic */ void _jr$ip$factorySpi(TrustManagerFactory trustManagerFactory, TrustManagerFactorySpi trustManagerFactorySpi) {
        trustManagerFactory.factorySpi = trustManagerFactorySpi;
    }

    private static /* synthetic */ void _jr$ip$algorithm(TrustManagerFactory trustManagerFactory, String string) {
        trustManagerFactory.algorithm = string;
    }

    protected /* synthetic */ TrustManagerFactory(h h2) {
        super(h2);
    }
}

