/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationDefaultAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.BootstrapMethodsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstantAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.DeprecatedAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.EnclosingMethodAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.InnerClassesAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableTypeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.MethodParametersAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ParameterAnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.SourceFileAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.SyntheticAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.TypeAnnotationsAttribute;

public class AttributeInfo
extends h {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool constPool, int n, byte[] byArray) {
        this.constPool = constPool;
        this.name = n;
        this.info = byArray;
    }

    protected AttributeInfo(ConstPool constPool, String string) {
        this(constPool, string, (byte[])null);
    }

    public AttributeInfo(ConstPool constPool, String string, byte[] byArray) {
        this(constPool, constPool.addUtf8Info(string), byArray);
    }

    protected AttributeInfo(ConstPool constPool, int n, DataInputStream dataInputStream) throws IOException {
        this.constPool = constPool;
        this.name = n;
        int n2 = dataInputStream.readInt();
        this.info = new byte[n2];
        if (n2 > 0) {
            dataInputStream.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool constPool, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        String string = constPool.getUtf8Info(n);
        char c = string.charAt(0);
        if (c < 'M') {
            if (c < 'E') {
                if (string.equals("AnnotationDefault")) {
                    return new AnnotationDefaultAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("BootstrapMethods")) {
                    return new BootstrapMethodsAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("Code")) {
                    return new CodeAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("ConstantValue")) {
                    return new ConstantAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("Deprecated")) {
                    return new DeprecatedAttribute(constPool, n, dataInputStream);
                }
            } else {
                if (string.equals("EnclosingMethod")) {
                    return new EnclosingMethodAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("Exceptions")) {
                    return new ExceptionsAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("InnerClasses")) {
                    return new InnerClassesAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("LineNumberTable")) {
                    return new LineNumberAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("LocalVariableTable")) {
                    return new LocalVariableAttribute(constPool, n, dataInputStream);
                }
                if (string.equals("LocalVariableTypeTable")) {
                    return new LocalVariableTypeAttribute(constPool, n, dataInputStream);
                }
            }
        } else if (c < 'S') {
            if (string.equals("MethodParameters")) {
                return new MethodParametersAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("RuntimeVisibleAnnotations") || string.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("RuntimeVisibleParameterAnnotations") || string.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("RuntimeVisibleTypeAnnotations") || string.equals("RuntimeInvisibleTypeAnnotations")) {
                return new TypeAnnotationsAttribute(constPool, n, dataInputStream);
            }
        } else {
            if (string.equals("Signature")) {
                return new SignatureAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("SourceFile")) {
                return new SourceFileAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("Synthetic")) {
                return new SyntheticAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("StackMap")) {
                return new StackMap(constPool, n, dataInputStream);
            }
            if (string.equals("StackMapTable")) {
                return new StackMapTable(constPool, n, dataInputStream);
            }
        }
        return new AttributeInfo(constPool, n, dataInputStream);
    }

    public String getName() {
        return ((AttributeInfo)((Object)((Object)this))).constPool.getUtf8Info(((AttributeInfo)((Object)((Object)this))).name);
    }

    public ConstPool getConstPool() {
        return ((AttributeInfo)((Object)((Object)this))).constPool;
    }

    public int length() {
        return ((AttributeInfo)((Object)((Object)this))).info.length + 6;
    }

    public byte[] get() {
        return ((AttributeInfo)((Object)((Object)this))).info;
    }

    public void set(byte[] byArray) {
        ((AttributeInfo)((Object)((Object)this))).info = byArray;
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        int n = ((AttributeInfo)((Object)((Object)this))).info.length;
        byte[] byArray = ((AttributeInfo)((Object)((Object)this))).info;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
        return new AttributeInfo(constPool, this.getName(), byArray2);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(((AttributeInfo)((Object)((Object)this))).name);
        dataOutputStream.writeInt(((AttributeInfo)((Object)((Object)this))).info.length);
        if (((AttributeInfo)((Object)((Object)this))).info.length > 0) {
            dataOutputStream.write(((AttributeInfo)((Object)((Object)this))).info);
        }
    }

    static int getLength(ArrayList arrayList) {
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(arrayList.get(i), AttributeInfo.class));
            n += attributeInfo.length();
        }
        return n;
    }

    static AttributeInfo lookup(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(listIterator.next(), AttributeInfo.class));
            if (!attributeInfo.getName().equals(string)) continue;
            return attributeInfo;
        }
        return null;
    }

    static synchronized AttributeInfo remove(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        AttributeInfo attributeInfo = null;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo2 = (AttributeInfo)((Object)g.convertForCast(listIterator.next(), AttributeInfo.class));
            if (!attributeInfo2.getName().equals(string)) continue;
            listIterator.remove();
            attributeInfo = attributeInfo2;
        }
        return attributeInfo;
    }

    static void writeAll(ArrayList arrayList, DataOutputStream dataOutputStream) throws IOException {
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(arrayList.get(i), AttributeInfo.class));
            attributeInfo.write(dataOutputStream);
        }
    }

    static ArrayList copyAll(ArrayList arrayList, ConstPool constPool) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<AttributeInfo> arrayList2 = new ArrayList<AttributeInfo>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(arrayList.get(i), AttributeInfo.class));
            arrayList2.add(attributeInfo.copy(constPool, null));
        }
        return arrayList2;
    }

    void renameClass(String string, String string2) {
    }

    void renameClass(Map map) {
    }

    static void renameClass(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(iterator.next(), AttributeInfo.class));
            attributeInfo.renameClass(string, string2);
        }
    }

    static void renameClass(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(iterator.next(), AttributeInfo.class));
            attributeInfo.renameClass(map);
        }
    }

    void getRefClasses(Map map) {
    }

    static void getRefClasses(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(iterator.next(), AttributeInfo.class));
            attributeInfo.getRefClasses(map);
        }
    }

    protected static /* synthetic */ void _jr$ip$constPool(Object object, ConstPool constPool) {
        ((AttributeInfo)((Object)object)).constPool = constPool;
    }

    static /* synthetic */ void _jr$ip$name(Object object, int n) {
        ((AttributeInfo)((Object)object)).name = n;
    }

    protected /* synthetic */ AttributeInfo(h h2) {
        super(h2);
    }
}

