/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.bytecode.ByteVector;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;

public class Bytecode
extends ByteVector
implements Cloneable,
Opcode {
    public static final CtClass THIS = ConstPool.THIS;
    ConstPool constPool;
    int maxStack;
    int maxLocals;
    ExceptionTable tryblocks;
    private int stackDepth;

    public Bytecode(ConstPool constPool, int n2, int n3) {
        this.constPool = constPool;
        this.maxStack = n2;
        this.maxLocals = n3;
        this.tryblocks = new ExceptionTable(constPool);
        this.stackDepth = 0;
    }

    public Bytecode(ConstPool constPool) {
        this(constPool, 0, 0);
    }

    public Object clone() {
        try {
            Bytecode bytecode = (Bytecode)g.convertForCast((Object)super.clone(), Bytecode.class);
            ((Bytecode)bytecode).tryblocks = (ExceptionTable)g.convertForCast((Object)((Bytecode)this).tryblocks.clone(), ExceptionTable.class);
            return bytecode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(cloneNotSupportedException));
        }
    }

    public ConstPool getConstPool() {
        return ((Bytecode)this).constPool;
    }

    public ExceptionTable getExceptionTable() {
        return ((Bytecode)this).tryblocks;
    }

    public CodeAttribute toCodeAttribute() {
        return new CodeAttribute(((Bytecode)this).constPool, ((Bytecode)this).maxStack, ((Bytecode)this).maxLocals, this.get(), ((Bytecode)this).tryblocks);
    }

    public int length() {
        return this.getSize();
    }

    public byte[] get() {
        return this.copy();
    }

    public int getMaxStack() {
        return ((Bytecode)this).maxStack;
    }

    public void setMaxStack(int n2) {
        ((Bytecode)this).maxStack = n2;
    }

    public int getMaxLocals() {
        return ((Bytecode)this).maxLocals;
    }

    public void setMaxLocals(int n2) {
        ((Bytecode)this).maxLocals = n2;
    }

    public void setMaxLocals(boolean bl, CtClass[] ctClassArray, int n2) {
        if (!bl) {
            ++n2;
        }
        if (ctClassArray != null) {
            CtClass ctClass = CtClass.doubleType;
            CtClass ctClass2 = CtClass.longType;
            int n3 = a.arrayLength((Object[])ctClassArray);
            for (int i = 0; i < n3; ++i) {
                CtClass ctClass3 = (CtClass)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctClassArray, (int)i), CtClass.class));
                if (!f.ifAcmp((Object)((Object)ctClass3), (Object)((Object)ctClass)) || !f.ifAcmp((Object)((Object)ctClass3), (Object)((Object)ctClass2))) {
                    n2 += 2;
                    continue;
                }
                ++n2;
            }
        }
        ((Bytecode)this).maxLocals = n2;
    }

    public void incMaxLocals(int n2) {
        Bytecode bytecode = this;
        ((Bytecode)bytecode).maxLocals = ((Bytecode)bytecode).maxLocals + n2;
    }

    public void addExceptionHandler(int n2, int n3, int n4, CtClass ctClass) {
        this.addExceptionHandler(n2, n3, n4, ((Bytecode)this).constPool.addClassInfo(ctClass));
    }

    public void addExceptionHandler(int n2, int n3, int n4, String string) {
        this.addExceptionHandler(n2, n3, n4, ((Bytecode)this).constPool.addClassInfo(string));
    }

    public void addExceptionHandler(int n2, int n3, int n4, int n5) {
        ((Bytecode)this).tryblocks.add(n2, n3, n4, n5);
    }

    public int currentPc() {
        return this.getSize();
    }

    public int read(int n2) {
        return super.read(n2);
    }

    public int read16bit(int n2) {
        int n3 = this.read(n2);
        int n4 = this.read(n2 + 1);
        return (n3 << 8) + (n4 & 0xFF);
    }

    public int read32bit(int n2) {
        int n3 = this.read16bit(n2);
        int n4 = this.read16bit(n2 + 2);
        return (n3 << 16) + (n4 & 0xFFFF);
    }

    public void write(int n2, int n3) {
        super.write(n2, n3);
    }

    public void write16bit(int n2, int n3) {
        this.write(n2, n3 >> 8);
        this.write(n2 + 1, n3);
    }

    public void write32bit(int n2, int n3) {
        this.write16bit(n2, n3 >> 16);
        this.write16bit(n2 + 2, n3);
    }

    public void add(int n2) {
        super.add(n2);
    }

    public void add32bit(int n2) {
        this.add(n2 >> 24, n2 >> 16, n2 >> 8, n2);
    }

    public void addGap(int n2) {
        super.addGap(n2);
    }

    public void addOpcode(int n2) {
        this.add(n2);
        this.growStack(STACK_GROW[n2]);
    }

    public void growStack(int n2) {
        this.setStackDepth(this.stackDepth + n2);
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public void setStackDepth(int n2) {
        this.stackDepth = n2;
        if (this.stackDepth > ((Bytecode)this).maxStack) {
            ((Bytecode)this).maxStack = this.stackDepth;
        }
    }

    public void addIndex(int n2) {
        this.add(n2 >> 8, n2);
    }

    public void addAload(int n2) {
        if (n2 < 4) {
            this.addOpcode(42 + n2);
        } else if (n2 < 256) {
            this.addOpcode(25);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(25);
            this.addIndex(n2);
        }
    }

    public void addAstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(75 + n2);
        } else if (n2 < 256) {
            this.addOpcode(58);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(58);
            this.addIndex(n2);
        }
    }

    public void addIconst(int n2) {
        if (n2 < 6 && -2 < n2) {
            this.addOpcode(3 + n2);
        } else if (n2 <= 127 && -128 <= n2) {
            this.addOpcode(16);
            this.add(n2);
        } else if (n2 <= Short.MAX_VALUE && Short.MIN_VALUE <= n2) {
            this.addOpcode(17);
            this.add(n2 >> 8);
            this.add(n2);
        } else {
            this.addLdc(((Bytecode)this).constPool.addIntegerInfo(n2));
        }
    }

    public void addConstZero(CtClass ctClass) {
        if (ctClass.isPrimitive()) {
            if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.longType))) {
                this.addOpcode(9);
            } else if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.floatType))) {
                this.addOpcode(11);
            } else if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.doubleType))) {
                this.addOpcode(14);
            } else {
                if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.voidType))) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("void type?"));
                }
                this.addOpcode(3);
            }
        } else {
            this.addOpcode(1);
        }
    }

    public void addIload(int n2) {
        if (n2 < 4) {
            this.addOpcode(26 + n2);
        } else if (n2 < 256) {
            this.addOpcode(21);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(21);
            this.addIndex(n2);
        }
    }

    public void addIstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(59 + n2);
        } else if (n2 < 256) {
            this.addOpcode(54);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(54);
            this.addIndex(n2);
        }
    }

    public void addLconst(long l2) {
        if (l2 == 0L || l2 == 1L) {
            this.addOpcode(9 + (int)l2);
        } else {
            this.addLdc2w(l2);
        }
    }

    public void addLload(int n2) {
        if (n2 < 4) {
            this.addOpcode(30 + n2);
        } else if (n2 < 256) {
            this.addOpcode(22);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(22);
            this.addIndex(n2);
        }
    }

    public void addLstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(63 + n2);
        } else if (n2 < 256) {
            this.addOpcode(55);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(55);
            this.addIndex(n2);
        }
    }

    public void addDconst(double d) {
        if (d == 0.0 || d == 1.0) {
            this.addOpcode(14 + (int)d);
        } else {
            this.addLdc2w(d);
        }
    }

    public void addDload(int n2) {
        if (n2 < 4) {
            this.addOpcode(38 + n2);
        } else if (n2 < 256) {
            this.addOpcode(24);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(24);
            this.addIndex(n2);
        }
    }

    public void addDstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(71 + n2);
        } else if (n2 < 256) {
            this.addOpcode(57);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(57);
            this.addIndex(n2);
        }
    }

    public void addFconst(float f2) {
        if (f2 == 0.0f || f2 == 1.0f || f2 == 2.0f) {
            this.addOpcode(11 + (int)f2);
        } else {
            this.addLdc(((Bytecode)this).constPool.addFloatInfo(f2));
        }
    }

    public void addFload(int n2) {
        if (n2 < 4) {
            this.addOpcode(34 + n2);
        } else if (n2 < 256) {
            this.addOpcode(23);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(23);
            this.addIndex(n2);
        }
    }

    public void addFstore(int n2) {
        if (n2 < 4) {
            this.addOpcode(67 + n2);
        } else if (n2 < 256) {
            this.addOpcode(56);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(56);
            this.addIndex(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addLoad(int n2, CtClass ctClass) {
        if (!ctClass.isPrimitive()) {
            this.addAload(n2);
            return 1;
        }
        if (!(f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.booleanType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.charType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.byteType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.shortType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.intType)))) {
            this.addIload(n2);
            return 1;
        }
        if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.longType))) {
            this.addLload(n2);
            return 2;
        }
        if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.floatType))) {
            this.addFload(n2);
            return 1;
        }
        if (f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.doubleType))) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("void type?"));
        this.addDload(n2);
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addStore(int n2, CtClass ctClass) {
        if (!ctClass.isPrimitive()) {
            this.addAstore(n2);
            return 1;
        }
        if (!(f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.booleanType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.charType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.byteType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.shortType)) && f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.intType)))) {
            this.addIstore(n2);
            return 1;
        }
        if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.longType))) {
            this.addLstore(n2);
            return 2;
        }
        if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.floatType))) {
            this.addFstore(n2);
            return 1;
        }
        if (f.ifAcmp((Object)((Object)ctClass), (Object)((Object)CtClass.doubleType))) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("void type?"));
        this.addDstore(n2);
        return 2;
    }

    public int addLoadParameters(CtClass[] ctClassArray, int n2) {
        int n3 = 0;
        if (ctClassArray != null) {
            int n4 = a.arrayLength((Object[])ctClassArray);
            for (int i = 0; i < n4; ++i) {
                n3 += this.addLoad(n3 + n2, (CtClass)((Object)g.convertForCast((Object)a.arrayLoad((Object[])ctClassArray, (int)i), CtClass.class)));
            }
        }
        return n3;
    }

    public void addCheckcast(CtClass ctClass) {
        this.addOpcode(192);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(ctClass));
    }

    public void addCheckcast(String string) {
        this.addOpcode(192);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(string));
    }

    public void addInstanceof(String string) {
        this.addOpcode(193);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(string));
    }

    public void addGetfield(CtClass ctClass, String string, String string2) {
        this.add(180);
        int n2 = ((Bytecode)this).constPool.addClassInfo(ctClass);
        this.addIndex(((Bytecode)this).constPool.addFieldrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addGetfield(String string, String string2, String string3) {
        this.add(180);
        int n2 = ((Bytecode)this).constPool.addClassInfo(string);
        this.addIndex(((Bytecode)this).constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(Descriptor.dataSize(string3) - 1);
    }

    public void addGetstatic(CtClass ctClass, String string, String string2) {
        this.add(178);
        int n2 = ((Bytecode)this).constPool.addClassInfo(ctClass);
        this.addIndex(((Bytecode)this).constPool.addFieldrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2));
    }

    public void addGetstatic(String string, String string2, String string3) {
        this.add(178);
        int n2 = ((Bytecode)this).constPool.addClassInfo(string);
        this.addIndex(((Bytecode)this).constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(Descriptor.dataSize(string3));
    }

    public void addInvokespecial(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokespecial(ctClass, string, string2);
    }

    public void addInvokespecial(CtClass ctClass, String string, String string2) {
        boolean bl = ctClass == null ? false : ctClass.isInterface();
        this.addInvokespecial(bl, ((Bytecode)this).constPool.addClassInfo(ctClass), string, string2);
    }

    public void addInvokespecial(String string, String string2, String string3) {
        this.addInvokespecial(false, ((Bytecode)this).constPool.addClassInfo(string), string2, string3);
    }

    public void addInvokespecial(int n2, String string, String string2) {
        this.addInvokespecial(false, n2, string, string2);
    }

    public void addInvokespecial(boolean bl, int n2, String string, String string2) {
        int n3 = bl ? ((Bytecode)this).constPool.addInterfaceMethodrefInfo(n2, string, string2) : ((Bytecode)this).constPool.addMethodrefInfo(n2, string, string2);
        this.addInvokespecial(n3, string2);
    }

    public void addInvokespecial(int n2, String string) {
        this.add(183);
        this.addIndex(n2);
        this.growStack(Descriptor.dataSize(string) - 1);
    }

    public void addInvokestatic(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokestatic(ctClass, string, string2);
    }

    public void addInvokestatic(CtClass ctClass, String string, String string2) {
        boolean bl = !f.ifAcmp((Object)((Object)ctClass), (Object)((Object)THIS)) ? false : ctClass.isInterface();
        this.addInvokestatic(((Bytecode)this).constPool.addClassInfo(ctClass), string, string2, bl);
    }

    public void addInvokestatic(String string, String string2, String string3) {
        this.addInvokestatic(((Bytecode)this).constPool.addClassInfo(string), string2, string3);
    }

    public void addInvokestatic(int n2, String string, String string2) {
        this.addInvokestatic(n2, string, string2, false);
    }

    private void addInvokestatic(int n2, String string, String string2, boolean bl) {
        this.add(184);
        int n3 = bl ? ((Bytecode)this).constPool.addInterfaceMethodrefInfo(n2, string, string2) : ((Bytecode)this).constPool.addMethodrefInfo(n2, string, string2);
        this.addIndex(n3);
        this.growStack(Descriptor.dataSize(string2));
    }

    public void addInvokevirtual(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokevirtual(ctClass, string, string2);
    }

    public void addInvokevirtual(CtClass ctClass, String string, String string2) {
        this.addInvokevirtual(((Bytecode)this).constPool.addClassInfo(ctClass), string, string2);
    }

    public void addInvokevirtual(String string, String string2, String string3) {
        this.addInvokevirtual(((Bytecode)this).constPool.addClassInfo(string), string2, string3);
    }

    public void addInvokevirtual(int n2, String string, String string2) {
        this.add(182);
        this.addIndex(((Bytecode)this).constPool.addMethodrefInfo(n2, string, string2));
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addInvokeinterface(CtClass ctClass, String string, CtClass ctClass2, CtClass[] ctClassArray, int n2) {
        String string2 = Descriptor.ofMethod(ctClass2, ctClassArray);
        this.addInvokeinterface(ctClass, string, string2, n2);
    }

    public void addInvokeinterface(CtClass ctClass, String string, String string2, int n2) {
        this.addInvokeinterface(((Bytecode)this).constPool.addClassInfo(ctClass), string, string2, n2);
    }

    public void addInvokeinterface(String string, String string2, String string3, int n2) {
        this.addInvokeinterface(((Bytecode)this).constPool.addClassInfo(string), string2, string3, n2);
    }

    public void addInvokeinterface(int n2, String string, String string2, int n3) {
        this.add(185);
        this.addIndex(((Bytecode)this).constPool.addInterfaceMethodrefInfo(n2, string, string2));
        this.add(n3);
        this.add(0);
        this.growStack(Descriptor.dataSize(string2) - 1);
    }

    public void addInvokedynamic(int n2, String string, String string2) {
        int n3 = ((Bytecode)this).constPool.addNameAndTypeInfo(string, string2);
        int n4 = ((Bytecode)this).constPool.addInvokeDynamicInfo(n2, n3);
        this.add(186);
        this.addIndex(n4);
        this.add(0, 0);
        this.growStack(Descriptor.dataSize(string2));
    }

    public void addLdc(String string) {
        this.addLdc(((Bytecode)this).constPool.addStringInfo(string));
    }

    public void addLdc(int n2) {
        if (n2 > 255) {
            this.addOpcode(19);
            this.addIndex(n2);
        } else {
            this.addOpcode(18);
            this.add(n2);
        }
    }

    public void addLdc2w(long l2) {
        this.addOpcode(20);
        this.addIndex(((Bytecode)this).constPool.addLongInfo(l2));
    }

    public void addLdc2w(double d) {
        this.addOpcode(20);
        this.addIndex(((Bytecode)this).constPool.addDoubleInfo(d));
    }

    public void addNew(CtClass ctClass) {
        this.addOpcode(187);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(ctClass));
    }

    public void addNew(String string) {
        this.addOpcode(187);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(string));
    }

    public void addAnewarray(String string) {
        this.addOpcode(189);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(string));
    }

    public void addAnewarray(CtClass ctClass, int n2) {
        this.addIconst(n2);
        this.addOpcode(189);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(ctClass));
    }

    public void addNewarray(int n2, int n3) {
        this.addIconst(n3);
        this.addOpcode(188);
        this.add(n2);
    }

    public int addMultiNewarray(CtClass ctClass, int[] nArray) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            this.addIconst(nArray[i]);
        }
        this.growStack(n2);
        return this.addMultiNewarray(ctClass, n2);
    }

    public int addMultiNewarray(CtClass ctClass, int n2) {
        this.add(197);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(ctClass));
        this.add(n2);
        this.growStack(1 - n2);
        return n2;
    }

    public int addMultiNewarray(String string, int n2) {
        this.add(197);
        this.addIndex(((Bytecode)this).constPool.addClassInfo(string));
        this.add(n2);
        this.growStack(1 - n2);
        return n2;
    }

    public void addPutfield(CtClass ctClass, String string, String string2) {
        this.addPutfield0(ctClass, null, string, string2);
    }

    public void addPutfield(String string, String string2, String string3) {
        this.addPutfield0(null, string, string2, string3);
    }

    private void addPutfield0(CtClass ctClass, String string, String string2, String string3) {
        this.add(181);
        int n2 = string == null ? ((Bytecode)this).constPool.addClassInfo(ctClass) : ((Bytecode)this).constPool.addClassInfo(string);
        this.addIndex(((Bytecode)this).constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(-1 - Descriptor.dataSize(string3));
    }

    public void addPutstatic(CtClass ctClass, String string, String string2) {
        this.addPutstatic0(ctClass, null, string, string2);
    }

    public void addPutstatic(String string, String string2, String string3) {
        this.addPutstatic0(null, string, string2, string3);
    }

    private void addPutstatic0(CtClass ctClass, String string, String string2, String string3) {
        this.add(179);
        int n2 = string == null ? ((Bytecode)this).constPool.addClassInfo(ctClass) : ((Bytecode)this).constPool.addClassInfo(string);
        this.addIndex(((Bytecode)this).constPool.addFieldrefInfo(n2, string2, string3));
        this.growStack(-Descriptor.dataSize(string3));
    }

    public void addReturn(CtClass ctClass) {
        if (ctClass == null) {
            this.addOpcode(177);
        } else if (ctClass.isPrimitive()) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            this.addOpcode(ctPrimitiveType.getReturnOp());
        } else {
            this.addOpcode(176);
        }
    }

    public void addRet(int n2) {
        if (n2 < 256) {
            this.addOpcode(169);
            this.add(n2);
        } else {
            this.addOpcode(196);
            this.addOpcode(169);
            this.addIndex(n2);
        }
    }

    public void addPrintln(String string) {
        this.addGetstatic("java.lang.System", "err", "Ljava/io/PrintStream;");
        this.addLdc(string);
        this.addInvokevirtual("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
    }

    static /* synthetic */ void _jr$ip$constPool(Object object, ConstPool constPool) {
        ((Bytecode)object).constPool = constPool;
    }

    protected /* synthetic */ Bytecode(h h2) {
        super(h2);
    }
}

