/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.DuplicateMemberException;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.InnerClassesAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.SourceFileAttribute;

public final class ClassFile
extends h {
    int major;
    int minor;
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    ArrayList fields;
    ArrayList methods;
    ArrayList attributes;
    String thisclassname;
    String[] cachedInterfaces;
    String cachedSuperclass;
    public static final int JAVA_1 = 45;
    public static final int JAVA_2 = 46;
    public static final int JAVA_3 = 47;
    public static final int JAVA_4 = 48;
    public static final int JAVA_5 = 49;
    public static final int JAVA_6 = 50;
    public static final int JAVA_7 = 51;
    public static final int JAVA_8 = 52;
    public static final int MAJOR_VERSION;

    public ClassFile(DataInputStream dataInputStream) throws IOException {
        this.read(dataInputStream);
    }

    public ClassFile(boolean bl, String string, String string2) {
        this.major = MAJOR_VERSION;
        this.minor = 0;
        this.constPool = new ConstPool(string);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = bl ? 1536 : 32;
        this.initSuperclass(string2);
        this.interfaces = null;
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        this.thisclassname = string;
        this.attributes = new ArrayList();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    private void initSuperclass(String string) {
        if (string != null) {
            this.superClass = this.constPool.addClassInfo(string);
            this.cachedSuperclass = string;
        } else {
            this.superClass = this.constPool.addClassInfo("java.lang.Object");
            this.cachedSuperclass = "java.lang.Object";
        }
    }

    private static String getSourcefileName(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        return new StringBuffer().append(string).append(".java").toString();
    }

    public void compact() {
        h h2;
        int n2;
        ConstPool constPool = this.compact0();
        ArrayList arrayList = this.methods;
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (MethodInfo)((Object)g.convertForCast(arrayList.get(n2), MethodInfo.class));
            h2.compact(constPool);
        }
        arrayList = this.fields;
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (FieldInfo)((Object)arrayList.get(n2));
            h2.compact(constPool);
        }
        this.attributes = AttributeInfo.copyAll(this.attributes, constPool);
        this.constPool = constPool;
    }

    private ConstPool compact0() {
        ConstPool constPool = new ConstPool(this.thisclassname);
        this.thisClass = constPool.getThisClassInfo();
        String string = this.getSuperclass();
        if (string != null) {
            this.superClass = constPool.addClassInfo(this.getSuperclass());
        }
        if (this.interfaces != null) {
            int n2 = this.interfaces.length;
            for (int i = 0; i < n2; ++i) {
                this.interfaces[i] = constPool.addClassInfo(this.constPool.getClassInfo(this.interfaces[i]));
            }
        }
        return constPool;
    }

    public void prune() {
        h h2;
        int n2;
        AttributeInfo attributeInfo;
        AttributeInfo attributeInfo2;
        ConstPool constPool = this.compact0();
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>();
        AttributeInfo attributeInfo3 = this.getAttribute("RuntimeInvisibleAnnotations");
        if (attributeInfo3 != null) {
            attributeInfo3 = attributeInfo3.copy(constPool, null);
            arrayList.add(attributeInfo3);
        }
        if ((attributeInfo2 = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            attributeInfo2 = attributeInfo2.copy(constPool, null);
            arrayList.add(attributeInfo2);
        }
        if ((attributeInfo = this.getAttribute("Signature")) != null) {
            attributeInfo = attributeInfo.copy(constPool, null);
            arrayList.add(attributeInfo);
        }
        ArrayList arrayList2 = this.methods;
        int n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (MethodInfo)((Object)g.convertForCast(arrayList2.get(n2), MethodInfo.class));
            h2.prune(constPool);
        }
        arrayList2 = this.fields;
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (FieldInfo)((Object)arrayList2.get(n2));
            h2.prune(constPool);
        }
        this.attributes = arrayList;
        this.constPool = constPool;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int n2) {
        if ((n2 & 0x200) == 0) {
            n2 |= 0x20;
        }
        this.accessFlags = n2;
    }

    public int getInnerAccessFlags() {
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)((Object)g.convertForCast((Object)((Object)this.getAttribute("InnerClasses")), InnerClassesAttribute.class));
        if (innerClassesAttribute == null) {
            return -1;
        }
        String string = this.getName();
        int n2 = innerClassesAttribute.tableLength();
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(innerClassesAttribute.innerClass(i))) continue;
            return innerClassesAttribute.accessFlags(i);
        }
        return -1;
    }

    public String getName() {
        return this.thisclassname;
    }

    public void setName(String string) {
        this.renameClass(this.thisclassname, string);
    }

    public String getSuperclass() {
        if (this.cachedSuperclass == null) {
            this.cachedSuperclass = this.constPool.getClassInfo(this.superClass);
        }
        return this.cachedSuperclass;
    }

    public int getSuperclassId() {
        return this.superClass;
    }

    public void setSuperclass(String string) throws CannotCompileException {
        if (string == null) {
            string = "java.lang.Object";
        }
        try {
            this.superClass = this.constPool.addClassInfo(string);
            ArrayList arrayList = this.methods;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                MethodInfo methodInfo = (MethodInfo)((Object)g.convertForCast(arrayList.get(i), MethodInfo.class));
                methodInfo.setSuperclass(string);
            }
        }
        catch (BadBytecode badBytecode) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CannotCompileException((Throwable)badBytecode));
        }
        this.cachedSuperclass = string;
    }

    public final void renameClass(String string, String string2) {
        String string3;
        h h2;
        int n2;
        if (string.equals(string2)) {
            return;
        }
        if (string.equals(this.thisclassname)) {
            this.thisclassname = string2;
        }
        string = Descriptor.toJvmName(string);
        string2 = Descriptor.toJvmName(string2);
        this.constPool.renameClass(string, string2);
        AttributeInfo.renameClass(this.attributes, string, string2);
        ArrayList arrayList = this.methods;
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (MethodInfo)((Object)g.convertForCast(arrayList.get(n2), MethodInfo.class));
            string3 = h2.getDescriptor();
            h2.setDescriptor(Descriptor.rename(string3, string, string2));
            AttributeInfo.renameClass(h2.getAttributes(), string, string2);
        }
        arrayList = this.fields;
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (FieldInfo)((Object)arrayList.get(n2));
            string3 = h2.getDescriptor();
            h2.setDescriptor(Descriptor.rename(string3, string, string2));
            AttributeInfo.renameClass(h2.getAttributes(), string, string2);
        }
    }

    public final void renameClass(Map map) {
        String string;
        h h2;
        int n2;
        String string2 = (String)map.get(Descriptor.toJvmName(this.thisclassname));
        if (string2 != null) {
            this.thisclassname = Descriptor.toJavaName(string2);
        }
        this.constPool.renameClass(map);
        AttributeInfo.renameClass(this.attributes, map);
        ArrayList arrayList = this.methods;
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (MethodInfo)((Object)g.convertForCast(arrayList.get(n2), MethodInfo.class));
            string = h2.getDescriptor();
            h2.setDescriptor(Descriptor.rename(string, map));
            AttributeInfo.renameClass(h2.getAttributes(), map);
        }
        arrayList = this.fields;
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (FieldInfo)((Object)arrayList.get(n2));
            string = h2.getDescriptor();
            h2.setDescriptor(Descriptor.rename(string, map));
            AttributeInfo.renameClass(h2.getAttributes(), map);
        }
    }

    public final void getRefClasses(Map map) {
        String string;
        h h2;
        int n2;
        this.constPool.renameClass(map);
        AttributeInfo.getRefClasses(this.attributes, map);
        ArrayList arrayList = this.methods;
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (MethodInfo)((Object)g.convertForCast(arrayList.get(n2), MethodInfo.class));
            string = h2.getDescriptor();
            Descriptor.rename(string, map);
            AttributeInfo.getRefClasses(h2.getAttributes(), map);
        }
        arrayList = this.fields;
        n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (FieldInfo)((Object)arrayList.get(n2));
            string = h2.getDescriptor();
            Descriptor.rename(string, map);
            AttributeInfo.getRefClasses(h2.getAttributes(), map);
        }
    }

    public String[] getInterfaces() {
        if (this.cachedInterfaces != null) {
            return this.cachedInterfaces;
        }
        String[] stringArray = null;
        if (this.interfaces == null) {
            stringArray = new String[]{};
        } else {
            int n2 = this.interfaces.length;
            String[] stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray2[i] = this.constPool.getClassInfo(this.interfaces[i]);
            }
            stringArray = stringArray2;
        }
        this.cachedInterfaces = stringArray;
        return stringArray;
    }

    public void setInterfaces(String[] stringArray) {
        this.cachedInterfaces = null;
        if (stringArray != null) {
            int n2 = stringArray.length;
            this.interfaces = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.interfaces[i] = this.constPool.addClassInfo(stringArray[i]);
            }
        }
    }

    public void addInterface(String string) {
        this.cachedInterfaces = null;
        int n2 = this.constPool.addClassInfo(string);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = n2;
        } else {
            int n3 = this.interfaces.length;
            int[] nArray = new int[n3 + 1];
            a.arraycopy((Object)this.interfaces, (int)0, (Object)nArray, (int)0, (int)n3);
            nArray[n3] = n2;
            this.interfaces = nArray;
        }
    }

    public List getFields() {
        return this.fields;
    }

    public void addField(FieldInfo fieldInfo) throws DuplicateMemberException {
        this.testExistingField(fieldInfo.getName(), fieldInfo.getDescriptor());
        this.fields.add(fieldInfo);
    }

    public final void addField2(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    private void testExistingField(String string, String string2) throws DuplicateMemberException {
        ListIterator listIterator = this.fields.listIterator(0);
        while (listIterator.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)((Object)listIterator.next());
            if (!fieldInfo.getName().equals(string)) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DuplicateMemberException(new StringBuffer().append("duplicate field: ").append(string).toString()));
        }
    }

    public List getMethods() {
        return this.methods;
    }

    public MethodInfo getMethod(String string) {
        ArrayList arrayList = this.methods;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            MethodInfo methodInfo = (MethodInfo)((Object)g.convertForCast(arrayList.get(i), MethodInfo.class));
            if (!methodInfo.getName().equals(string)) continue;
            return methodInfo;
        }
        return null;
    }

    public MethodInfo getStaticInitializer() {
        return this.getMethod("<clinit>");
    }

    public void addMethod(MethodInfo methodInfo) throws DuplicateMemberException {
        this.testExistingMethod(methodInfo);
        this.methods.add(methodInfo);
    }

    public final void addMethod2(MethodInfo methodInfo) {
        this.methods.add(methodInfo);
    }

    private void testExistingMethod(MethodInfo methodInfo) throws DuplicateMemberException {
        String string = methodInfo.getName();
        String string2 = methodInfo.getDescriptor();
        ListIterator listIterator = this.methods.listIterator(0);
        while (listIterator.hasNext()) {
            if (!ClassFile.isDuplicated(methodInfo, string, string2, (MethodInfo)((Object)g.convertForCast(listIterator.next(), MethodInfo.class)), listIterator)) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new DuplicateMemberException(new StringBuffer().append("duplicate method: ").append(string).append(" in ").append(this.getName()).toString()));
        }
    }

    private static boolean isDuplicated(MethodInfo methodInfo, String string, String string2, MethodInfo methodInfo2, ListIterator listIterator) {
        if (!methodInfo2.getName().equals(string)) {
            return false;
        }
        String string3 = methodInfo2.getDescriptor();
        if (!Descriptor.eqParamTypes(string3, string2)) {
            return false;
        }
        if (string3.equals(string2)) {
            if (ClassFile.notBridgeMethod(methodInfo2)) {
                return true;
            }
            listIterator.remove();
            return false;
        }
        return false;
    }

    private static boolean notBridgeMethod(MethodInfo methodInfo) {
        return (methodInfo.getAccessFlags() & 0x40) == 0;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String string) {
        ArrayList arrayList = this.attributes;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(arrayList.get(i), AttributeInfo.class));
            if (!attributeInfo.getName().equals(string)) continue;
            return attributeInfo;
        }
        return null;
    }

    public AttributeInfo removeAttribute(String string) {
        return AttributeInfo.remove(this.attributes, string);
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        AttributeInfo.remove(this.attributes, attributeInfo.getName());
        this.attributes.add(attributeInfo);
    }

    public String getSourceFile() {
        SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)((Object)g.convertForCast((Object)((Object)this.getAttribute("SourceFile")), SourceFileAttribute.class));
        if (sourceFileAttribute == null) {
            return null;
        }
        return sourceFileAttribute.getFileName();
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        int n2;
        int n3 = dataInputStream.readInt();
        if (n3 != -889275714) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(new StringBuffer().append("bad magic number: ").append(Integer.toHexString(n3)).toString()));
        }
        this.minor = dataInputStream.readUnsignedShort();
        this.major = dataInputStream.readUnsignedShort();
        this.constPool = new ConstPool(dataInputStream);
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.thisClass = dataInputStream.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedShort();
        if (n4 == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                this.interfaces[n2] = dataInputStream.readUnsignedShort();
            }
        }
        ConstPool constPool = this.constPool;
        n4 = dataInputStream.readUnsignedShort();
        this.fields = new ArrayList();
        for (n2 = 0; n2 < n4; ++n2) {
            this.addField2(new FieldInfo(constPool, dataInputStream));
        }
        n4 = dataInputStream.readUnsignedShort();
        this.methods = new ArrayList();
        for (n2 = 0; n2 < n4; ++n2) {
            this.addMethod2(new MethodInfo(constPool, dataInputStream));
        }
        this.attributes = new ArrayList();
        n4 = dataInputStream.readUnsignedShort();
        for (n2 = 0; n2 < n4; ++n2) {
            this.addAttribute(AttributeInfo.read(constPool, dataInputStream));
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        h h2;
        int n2;
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.constPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.thisClass);
        dataOutputStream.writeShort(this.superClass);
        int n3 = this.interfaces == null ? 0 : this.interfaces.length;
        dataOutputStream.writeShort(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            dataOutputStream.writeShort(this.interfaces[n2]);
        }
        ArrayList arrayList = this.fields;
        n3 = arrayList.size();
        dataOutputStream.writeShort(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (FieldInfo)((Object)arrayList.get(n2));
            h2.write(dataOutputStream);
        }
        arrayList = this.methods;
        n3 = arrayList.size();
        dataOutputStream.writeShort(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            h2 = (MethodInfo)((Object)g.convertForCast(arrayList.get(n2), MethodInfo.class));
            h2.write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, dataOutputStream);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public void setMajorVersion(int n2) {
        this.major = n2;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int n2) {
        this.minor = n2;
    }

    public void setVersionToJava5() {
        this.major = 49;
        this.minor = 0;
    }

    static {
        int n2 = 47;
        try {
            Class.forName("java.lang.StringBuilder");
            n2 = 49;
            Class.forName("java.util.zip.DeflaterInputStream");
            n2 = 50;
            Class.forName("java.lang.invoke.CallSite", false, ClassLoader.getSystemClassLoader());
            n2 = 51;
            Class.forName("java.util.function.Function");
            n2 = 52;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MAJOR_VERSION = n2;
    }

    static /* synthetic */ int _jr$ig$major(Object object) {
        return ((ClassFile)((Object)object)).major;
    }

    static /* synthetic */ void _jr$ip$major(Object object, int n2) {
        ((ClassFile)((Object)object)).major = n2;
    }

    static /* synthetic */ int _jr$ig$minor(Object object) {
        return ((ClassFile)((Object)object)).minor;
    }

    static /* synthetic */ void _jr$ip$minor(Object object, int n2) {
        ((ClassFile)((Object)object)).minor = n2;
    }

    static /* synthetic */ ConstPool _jr$ig$constPool(Object object) {
        return ((ClassFile)((Object)object)).constPool;
    }

    static /* synthetic */ void _jr$ip$constPool(Object object, ConstPool constPool) {
        ((ClassFile)((Object)object)).constPool = constPool;
    }

    static /* synthetic */ int _jr$ig$thisClass(Object object) {
        return ((ClassFile)((Object)object)).thisClass;
    }

    static /* synthetic */ void _jr$ip$thisClass(Object object, int n2) {
        ((ClassFile)((Object)object)).thisClass = n2;
    }

    static /* synthetic */ int _jr$ig$accessFlags(Object object) {
        return ((ClassFile)((Object)object)).accessFlags;
    }

    static /* synthetic */ void _jr$ip$accessFlags(Object object, int n2) {
        ((ClassFile)((Object)object)).accessFlags = n2;
    }

    static /* synthetic */ int _jr$ig$superClass(Object object) {
        return ((ClassFile)((Object)object)).superClass;
    }

    static /* synthetic */ void _jr$ip$superClass(Object object, int n2) {
        ((ClassFile)((Object)object)).superClass = n2;
    }

    static /* synthetic */ int[] _jr$ig$interfaces(Object object) {
        return ((ClassFile)((Object)object)).interfaces;
    }

    static /* synthetic */ void _jr$ip$interfaces(Object object, int[] nArray) {
        ((ClassFile)((Object)object)).interfaces = nArray;
    }

    static /* synthetic */ ArrayList _jr$ig$fields(Object object) {
        return ((ClassFile)((Object)object)).fields;
    }

    static /* synthetic */ void _jr$ip$fields(Object object, ArrayList arrayList) {
        ((ClassFile)((Object)object)).fields = arrayList;
    }

    static /* synthetic */ ArrayList _jr$ig$methods(Object object) {
        return ((ClassFile)((Object)object)).methods;
    }

    static /* synthetic */ void _jr$ip$methods(Object object, ArrayList arrayList) {
        ((ClassFile)((Object)object)).methods = arrayList;
    }

    static /* synthetic */ ArrayList _jr$ig$attributes(Object object) {
        return ((ClassFile)((Object)object)).attributes;
    }

    static /* synthetic */ void _jr$ip$attributes(Object object, ArrayList arrayList) {
        ((ClassFile)((Object)object)).attributes = arrayList;
    }

    static /* synthetic */ String _jr$ig$thisclassname(Object object) {
        return ((ClassFile)((Object)object)).thisclassname;
    }

    static /* synthetic */ void _jr$ip$thisclassname(Object object, String string) {
        ((ClassFile)((Object)object)).thisclassname = string;
    }

    static /* synthetic */ String[] _jr$ig$cachedInterfaces(Object object) {
        return ((ClassFile)((Object)object)).cachedInterfaces;
    }

    static /* synthetic */ void _jr$ip$cachedInterfaces(Object object, String[] stringArray) {
        ((ClassFile)((Object)object)).cachedInterfaces = stringArray;
    }

    static /* synthetic */ String _jr$ig$cachedSuperclass(Object object) {
        return ((ClassFile)((Object)object)).cachedSuperclass;
    }

    static /* synthetic */ void _jr$ip$cachedSuperclass(Object object, String string) {
        ((ClassFile)((Object)object)).cachedSuperclass = string;
    }
}

