/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAnalyzer;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute$LdcEntry;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;

public class CodeAttribute
extends AttributeInfo
implements Opcode {
    public static final String tag = "Code";
    private int maxStack;
    private int maxLocals;
    private ExceptionTable exceptions;
    private ArrayList attributes;

    public CodeAttribute(ConstPool constPool, int n2, int n3, byte[] byArray, ExceptionTable exceptionTable) {
        super(constPool, tag);
        this.maxStack = n2;
        this.maxLocals = n3;
        this.info = byArray;
        this.exceptions = exceptionTable;
        this.attributes = new ArrayList();
    }

    private CodeAttribute(ConstPool constPool, CodeAttribute codeAttribute, Map map) throws BadBytecode {
        super(constPool, tag);
        this.maxStack = codeAttribute.getMaxStack();
        this.maxLocals = codeAttribute.getMaxLocals();
        this.exceptions = codeAttribute.getExceptionTable().copy(constPool, map);
        this.attributes = new ArrayList();
        List list = codeAttribute.getAttributes();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)((Object)g.convertForCast(list.get(i), AttributeInfo.class));
            this.attributes.add(attributeInfo.copy(constPool, map));
        }
        this.info = codeAttribute.copyCode(constPool, map, this.exceptions, this);
    }

    CodeAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, (byte[])null);
        int n3 = dataInputStream.readInt();
        this.maxStack = dataInputStream.readUnsignedShort();
        this.maxLocals = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readInt();
        this.info = new byte[n4];
        dataInputStream.readFully(this.info);
        this.exceptions = new ExceptionTable(constPool, dataInputStream);
        this.attributes = new ArrayList();
        int n5 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n5; ++i) {
            this.attributes.add(AttributeInfo.read(constPool, dataInputStream));
        }
    }

    public AttributeInfo copy(ConstPool constPool, Map map) throws RuntimeCopyException {
        try {
            return new CodeAttribute(constPool, this, map);
        }
        catch (BadBytecode badBytecode) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeCopyException("bad bytecode. fatal?"));
        }
    }

    public int length() {
        return 18 + CodeAttribute._jr$ig$info((Object)this).length + this.exceptions.size() * 8 + AttributeInfo.getLength(this.attributes);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(CodeAttribute._jr$ig$name((Object)this));
        dataOutputStream.writeInt(this.length() - 6);
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(CodeAttribute._jr$ig$info((Object)this).length);
        dataOutputStream.write(CodeAttribute._jr$ig$info((Object)this));
        this.exceptions.write(dataOutputStream);
        dataOutputStream.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, dataOutputStream);
    }

    public byte[] get() {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("CodeAttribute.get()"));
    }

    public void set(byte[] byArray) {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("CodeAttribute.set()"));
    }

    void renameClass(String string, String string2) {
        AttributeInfo.renameClass(this.attributes, string, string2);
    }

    void renameClass(Map map) {
        AttributeInfo.renameClass(this.attributes, map);
    }

    void getRefClasses(Map map) {
        AttributeInfo.getRefClasses(this.attributes, map);
    }

    public String getDeclaringClass() {
        ConstPool constPool = this.getConstPool();
        return constPool.getClassName();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int n2) {
        this.maxStack = n2;
    }

    public int computeMaxStack() throws BadBytecode {
        this.maxStack = new CodeAnalyzer(this).computeMaxStack();
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int n2) {
        this.maxLocals = n2;
    }

    public int getCodeLength() {
        return CodeAttribute._jr$ig$info((Object)this).length;
    }

    public byte[] getCode() {
        return CodeAttribute._jr$ig$info((Object)this);
    }

    void setCode(byte[] byArray) {
        super.set(byArray);
    }

    public CodeIterator iterator() {
        return new CodeIterator(this);
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptions;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String string) {
        return AttributeInfo.lookup(this.attributes, string);
    }

    public void setAttribute(StackMapTable stackMapTable) {
        AttributeInfo.remove(this.attributes, "StackMapTable");
        if (stackMapTable != null) {
            this.attributes.add(stackMapTable);
        }
    }

    public void setAttribute(StackMap stackMap) {
        AttributeInfo.remove(this.attributes, "StackMap");
        if (stackMap != null) {
            this.attributes.add(stackMap);
        }
    }

    private byte[] copyCode(ConstPool constPool, Map map, ExceptionTable exceptionTable, CodeAttribute codeAttribute) throws BadBytecode {
        int n2 = this.getCodeLength();
        byte[] byArray = new byte[n2];
        CodeAttribute._jr$ip$info((Object)codeAttribute, byArray);
        CodeAttribute$LdcEntry codeAttribute$LdcEntry = CodeAttribute.copyCode(CodeAttribute._jr$ig$info((Object)this), 0, n2, this.getConstPool(), byArray, constPool, map);
        return CodeAttribute$LdcEntry.doit(byArray, codeAttribute$LdcEntry, exceptionTable, codeAttribute);
    }

    private static CodeAttribute$LdcEntry copyCode(byte[] byArray, int n2, int n3, ConstPool constPool, byte[] byArray2, ConstPool constPool2, Map map) throws BadBytecode {
        CodeAttribute$LdcEntry codeAttribute$LdcEntry = null;
        int n4 = n2;
        while (n4 < n3) {
            byte by;
            int n5 = CodeIterator.nextOpcode(byArray, n4);
            byArray2[n4] = by = byArray[n4];
            switch (by & 0xFF) {
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    CodeAttribute.copyConstPoolInfo(n4 + 1, byArray, constPool, byArray2, constPool2, map);
                    break;
                }
                case 18: {
                    int n6 = byArray[n4 + 1] & 0xFF;
                    n6 = constPool.copy(n6, constPool2, map);
                    if (n6 < 256) {
                        byArray2[n4 + 1] = (byte)n6;
                        break;
                    }
                    byArray2[n4] = 0;
                    byArray2[n4 + 1] = 0;
                    CodeAttribute$LdcEntry codeAttribute$LdcEntry2 = new CodeAttribute$LdcEntry();
                    CodeAttribute$LdcEntry._jr$ip$where((Object)codeAttribute$LdcEntry2, n4);
                    CodeAttribute$LdcEntry._jr$ip$index((Object)codeAttribute$LdcEntry2, n6);
                    CodeAttribute$LdcEntry._jr$ip$next((Object)codeAttribute$LdcEntry2, codeAttribute$LdcEntry);
                    codeAttribute$LdcEntry = codeAttribute$LdcEntry2;
                    break;
                }
                case 185: {
                    CodeAttribute.copyConstPoolInfo(n4 + 1, byArray, constPool, byArray2, constPool2, map);
                    byArray2[n4 + 3] = byArray[n4 + 3];
                    byArray2[n4 + 4] = byArray[n4 + 4];
                    break;
                }
                case 186: {
                    CodeAttribute.copyConstPoolInfo(n4 + 1, byArray, constPool, byArray2, constPool2, map);
                    byArray2[n4 + 3] = 0;
                    byArray2[n4 + 4] = 0;
                    break;
                }
                case 197: {
                    CodeAttribute.copyConstPoolInfo(n4 + 1, byArray, constPool, byArray2, constPool2, map);
                    byArray2[n4 + 3] = byArray[n4 + 3];
                    break;
                }
                default: {
                    while (++n4 < n5) {
                        byArray2[n4] = byArray[n4];
                    }
                    break block0;
                }
            }
            n4 = n5;
        }
        return codeAttribute$LdcEntry;
    }

    private static void copyConstPoolInfo(int n2, byte[] byArray, ConstPool constPool, byte[] byArray2, ConstPool constPool2, Map map) {
        int n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        n3 = constPool.copy(n3, constPool2, map);
        byArray2[n2] = (byte)(n3 >> 8);
        byArray2[n2 + 1] = (byte)n3;
    }

    public void insertLocalVar(int n2, int n3) throws BadBytecode {
        CodeIterator codeIterator = this.iterator();
        while (codeIterator.hasNext()) {
            CodeAttribute.shiftIndex(codeIterator, n2, n3);
        }
        this.setMaxLocals(this.getMaxLocals() + n3);
    }

    private static void shiftIndex(CodeIterator codeIterator, int n2, int n3) throws BadBytecode {
        int n4 = codeIterator.next();
        int n5 = codeIterator.byteAt(n4);
        if (n5 < 21) {
            return;
        }
        if (n5 < 79) {
            if (n5 < 26) {
                CodeAttribute.shiftIndex8(codeIterator, n4, n5, n2, n3);
            } else if (n5 < 46) {
                CodeAttribute.shiftIndex0(codeIterator, n4, n5, n2, n3, 26, 21);
            } else {
                if (n5 < 54) {
                    return;
                }
                if (n5 < 59) {
                    CodeAttribute.shiftIndex8(codeIterator, n4, n5, n2, n3);
                } else {
                    CodeAttribute.shiftIndex0(codeIterator, n4, n5, n2, n3, 59, 54);
                }
            }
        } else if (n5 == 132) {
            int n6 = codeIterator.byteAt(n4 + 1);
            if (n6 < n2) {
                return;
            }
            if ((n6 += n3) < 256) {
                codeIterator.writeByte(n6, n4 + 1);
            } else {
                byte by = (byte)codeIterator.byteAt(n4 + 2);
                int n7 = codeIterator.insertExGap(3);
                codeIterator.writeByte(196, n7 - 3);
                codeIterator.writeByte(132, n7 - 2);
                codeIterator.write16bit(n6, n7 - 1);
                codeIterator.write16bit(by, n7 + 1);
            }
        } else if (n5 == 169) {
            CodeAttribute.shiftIndex8(codeIterator, n4, n5, n2, n3);
        } else if (n5 == 196) {
            int n8 = codeIterator.u16bitAt(n4 + 2);
            if (n8 < n2) {
                return;
            }
            codeIterator.write16bit(n8 += n3, n4 + 2);
        }
    }

    private static void shiftIndex8(CodeIterator codeIterator, int n2, int n3, int n4, int n5) throws BadBytecode {
        int n6 = codeIterator.byteAt(n2 + 1);
        if (n6 < n4) {
            return;
        }
        if ((n6 += n5) < 256) {
            codeIterator.writeByte(n6, n2 + 1);
        } else {
            int n7 = codeIterator.insertExGap(2);
            codeIterator.writeByte(196, n7 - 2);
            codeIterator.writeByte(n3, n7 - 1);
            codeIterator.write16bit(n6, n7);
        }
    }

    private static void shiftIndex0(CodeIterator codeIterator, int n2, int n3, int n4, int n5, int n6, int n7) throws BadBytecode {
        int n8 = (n3 - n6) % 4;
        if (n8 < n4) {
            return;
        }
        if ((n8 += n5) < 4) {
            codeIterator.writeByte(n3 + n5, n2);
        } else {
            n3 = (n3 - n6) / 4 + n7;
            if (n8 < 256) {
                int n9 = codeIterator.insertExGap(1);
                codeIterator.writeByte(n3, n9 - 1);
                codeIterator.writeByte(n8, n9);
            } else {
                int n10 = codeIterator.insertExGap(3);
                codeIterator.writeByte(196, n10 - 1);
                codeIterator.writeByte(n3, n10);
                codeIterator.write16bit(n8, n10 + 1);
            }
        }
    }

    private static /* synthetic */ void _jr$ip$exceptions(CodeAttribute codeAttribute, ExceptionTable exceptionTable) {
        codeAttribute.exceptions = exceptionTable;
    }

    private static /* synthetic */ void _jr$ip$attributes(CodeAttribute codeAttribute, ArrayList arrayList) {
        codeAttribute.attributes = arrayList;
    }

    protected /* synthetic */ CodeAttribute(h h2) {
        super(h2);
    }
}

