/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.bytecode.ClassInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfoPadding;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.DoubleInfo;
import org.zeroturnaround.bundled.javassist.bytecode.FieldrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.FloatInfo;
import org.zeroturnaround.bundled.javassist.bytecode.IntegerInfo;
import org.zeroturnaround.bundled.javassist.bytecode.InterfaceMethodrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.InvokeDynamicInfo;
import org.zeroturnaround.bundled.javassist.bytecode.LongInfo;
import org.zeroturnaround.bundled.javassist.bytecode.LongVector;
import org.zeroturnaround.bundled.javassist.bytecode.MemberrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodHandleInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodTypeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodrefInfo;
import org.zeroturnaround.bundled.javassist.bytecode.NameAndTypeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.StringInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Utf8Info;

public final class ConstPool
extends h {
    LongVector items;
    int numOfItems;
    int thisClassInfo;
    HashMap itemsCache;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final int CONST_MethodHandle = 15;
    public static final int CONST_MethodType = 16;
    public static final int CONST_InvokeDynamic = 18;
    public static final CtClass THIS = null;
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    public ConstPool(String string) {
        this.items = new LongVector();
        this.itemsCache = null;
        this.numOfItems = 0;
        this.addItem0(null);
        this.thisClassInfo = this.addClassInfo(string);
    }

    public ConstPool(DataInputStream dataInputStream) throws IOException {
        this.itemsCache = null;
        this.thisClassInfo = 0;
        this.read(dataInputStream);
    }

    void prune() {
        this.itemsCache = null;
    }

    public int getSize() {
        return this.numOfItems;
    }

    public String getClassName() {
        return this.getClassInfo(this.thisClassInfo);
    }

    public int getThisClassInfo() {
        return this.thisClassInfo;
    }

    void setThisClassInfo(int n2) {
        this.thisClassInfo = n2;
    }

    ConstInfo getItem(int n2) {
        return this.items.elementAt(n2);
    }

    public int getTag(int n2) {
        return this.getItem(n2).getTag();
    }

    public String getClassInfo(int n2) {
        ClassInfo classInfo = (ClassInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), ClassInfo.class));
        if (classInfo == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(ClassInfo._jr$ig$name((Object)classInfo)));
    }

    public String getClassInfoByDescriptor(int n2) {
        ClassInfo classInfo = (ClassInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), ClassInfo.class));
        if (classInfo == null) {
            return null;
        }
        String string = this.getUtf8Info(ClassInfo._jr$ig$name((Object)classInfo));
        if (string.charAt(0) == '[') {
            return string;
        }
        return Descriptor.of(string);
    }

    public int getNameAndTypeName(int n2) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), NameAndTypeInfo.class));
        return NameAndTypeInfo._jr$ig$memberName((Object)nameAndTypeInfo);
    }

    public int getNameAndTypeDescriptor(int n2) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), NameAndTypeInfo.class));
        return NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo);
    }

    public int getMemberClass(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo);
    }

    public int getMemberNameAndType(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo);
    }

    public int getFieldrefClass(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), FieldrefInfo.class));
        return FieldrefInfo._jr$ig$classIndex((Object)fieldrefInfo);
    }

    public String getFieldrefClassName(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), FieldrefInfo.class));
        if (fieldrefInfo == null) {
            return null;
        }
        return this.getClassInfo(FieldrefInfo._jr$ig$classIndex((Object)fieldrefInfo));
    }

    public int getFieldrefNameAndType(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), FieldrefInfo.class));
        return FieldrefInfo._jr$ig$nameAndTypeIndex((Object)fieldrefInfo);
    }

    public String getFieldrefName(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), FieldrefInfo.class));
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(FieldrefInfo._jr$ig$nameAndTypeIndex((Object)fieldrefInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$memberName((Object)nameAndTypeInfo));
    }

    public String getFieldrefType(int n2) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), FieldrefInfo.class));
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(FieldrefInfo._jr$ig$nameAndTypeIndex((Object)fieldrefInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo));
    }

    public int getMethodrefClass(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo);
    }

    public String getMethodrefClassName(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        if (memberrefInfo == null) {
            return null;
        }
        return this.getClassInfo(MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo));
    }

    public int getMethodrefNameAndType(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo);
    }

    public String getMethodrefName(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$memberName((Object)nameAndTypeInfo));
    }

    public String getMethodrefType(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo));
    }

    public int getInterfaceMethodrefClass(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo);
    }

    public String getInterfaceMethodrefClassName(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return this.getClassInfo(MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo));
    }

    public int getInterfaceMethodrefNameAndType(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        return MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo);
    }

    public String getInterfaceMethodrefName(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$memberName((Object)nameAndTypeInfo));
    }

    public String getInterfaceMethodrefType(int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo));
    }

    public Object getLdcValue(int n2) {
        ConstInfo constInfo = this.getItem(n2);
        Object object = null;
        object = g.convertForInstanceOf((Object)((Object)constInfo), StringInfo.class) instanceof StringInfo ? this.getStringInfo(n2) : (g.convertForInstanceOf((Object)((Object)constInfo), FloatInfo.class) instanceof FloatInfo ? (Number)new Float(this.getFloatInfo(n2)) : (Number)(g.convertForInstanceOf((Object)((Object)constInfo), IntegerInfo.class) instanceof IntegerInfo ? (Number)new Integer(this.getIntegerInfo(n2)) : (Number)(g.convertForInstanceOf((Object)((Object)constInfo), LongInfo.class) instanceof LongInfo ? (Number)new Long(this.getLongInfo(n2)) : (Number)(g.convertForInstanceOf((Object)((Object)constInfo), DoubleInfo.class) instanceof DoubleInfo ? new Double(this.getDoubleInfo(n2)) : null))));
        return object;
    }

    public int getIntegerInfo(int n2) {
        IntegerInfo integerInfo = (IntegerInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), IntegerInfo.class));
        return IntegerInfo._jr$ig$value((Object)integerInfo);
    }

    public float getFloatInfo(int n2) {
        FloatInfo floatInfo = (FloatInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), FloatInfo.class));
        return FloatInfo._jr$ig$value((Object)floatInfo);
    }

    public long getLongInfo(int n2) {
        LongInfo longInfo = (LongInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), LongInfo.class));
        return LongInfo._jr$ig$value((Object)longInfo);
    }

    public double getDoubleInfo(int n2) {
        DoubleInfo doubleInfo = (DoubleInfo)g.convertForCast((Object)((Object)this.getItem(n2)), DoubleInfo.class);
        return DoubleInfo._jr$ig$value((Object)doubleInfo);
    }

    public String getStringInfo(int n2) {
        StringInfo stringInfo = (StringInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), StringInfo.class));
        return this.getUtf8Info(StringInfo._jr$ig$string((Object)stringInfo));
    }

    public String getUtf8Info(int n2) {
        Utf8Info utf8Info = (Utf8Info)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), Utf8Info.class));
        return Utf8Info._jr$ig$string((Object)utf8Info);
    }

    public int getMethodHandleKind(int n2) {
        MethodHandleInfo methodHandleInfo = (MethodHandleInfo)g.convertForCast((Object)((Object)this.getItem(n2)), MethodHandleInfo.class);
        return MethodHandleInfo._jr$ig$refKind((Object)methodHandleInfo);
    }

    public int getMethodHandleIndex(int n2) {
        MethodHandleInfo methodHandleInfo = (MethodHandleInfo)g.convertForCast((Object)((Object)this.getItem(n2)), MethodHandleInfo.class);
        return MethodHandleInfo._jr$ig$refIndex((Object)methodHandleInfo);
    }

    public int getMethodTypeInfo(int n2) {
        MethodTypeInfo methodTypeInfo = (MethodTypeInfo)g.convertForCast((Object)((Object)this.getItem(n2)), MethodTypeInfo.class);
        return MethodTypeInfo._jr$ig$descriptor((Object)methodTypeInfo);
    }

    public int getInvokeDynamicBootstrap(int n2) {
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)g.convertForCast((Object)((Object)this.getItem(n2)), InvokeDynamicInfo.class);
        return InvokeDynamicInfo._jr$ig$bootstrap((Object)invokeDynamicInfo);
    }

    public int getInvokeDynamicNameAndType(int n2) {
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)g.convertForCast((Object)((Object)this.getItem(n2)), InvokeDynamicInfo.class);
        return InvokeDynamicInfo._jr$ig$nameAndType((Object)invokeDynamicInfo);
    }

    public String getInvokeDynamicType(int n2) {
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)g.convertForCast((Object)((Object)this.getItem(n2)), InvokeDynamicInfo.class);
        if (invokeDynamicInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(InvokeDynamicInfo._jr$ig$nameAndType((Object)invokeDynamicInfo))), NameAndTypeInfo.class));
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo));
    }

    public int isConstructor(String string, int n2) {
        return this.isMember(string, "<init>", n2);
    }

    public int isMember(String string, String string2, int n2) {
        NameAndTypeInfo nameAndTypeInfo;
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        if (this.getClassInfo(MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo)).equals(string) && this.getUtf8Info(NameAndTypeInfo._jr$ig$memberName((Object)(nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo))), NameAndTypeInfo.class))))).equals(string2)) {
            return NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo);
        }
        return 0;
    }

    public String eqMember(String string, String string2, int n2) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)((Object)g.convertForCast((Object)((Object)this.getItem(n2)), MemberrefInfo.class));
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)((Object)g.convertForCast((Object)((Object)this.getItem(MemberrefInfo._jr$ig$nameAndTypeIndex((Object)memberrefInfo))), NameAndTypeInfo.class));
        if (this.getUtf8Info(NameAndTypeInfo._jr$ig$memberName((Object)nameAndTypeInfo)).equals(string) && this.getUtf8Info(NameAndTypeInfo._jr$ig$typeDescriptor((Object)nameAndTypeInfo)).equals(string2)) {
            return this.getClassInfo(MemberrefInfo._jr$ig$classIndex((Object)memberrefInfo));
        }
        return null;
    }

    private int addItem0(ConstInfo constInfo) {
        this.items.addElement(constInfo);
        return this.numOfItems++;
    }

    private int addItem(ConstInfo constInfo) {
        ConstInfo constInfo2;
        if (this.itemsCache == null) {
            this.itemsCache = ConstPool.makeItemsCache(this.items);
        }
        if ((constInfo2 = (ConstInfo)((Object)g.convertForCast(this.itemsCache.get((Object)constInfo), ConstInfo.class))) != null) {
            return ConstInfo._jr$ig$index((Object)constInfo2);
        }
        this.items.addElement(constInfo);
        this.itemsCache.put(constInfo, constInfo);
        return this.numOfItems++;
    }

    public int copy(int n2, ConstPool constPool, Map map) {
        if (n2 == 0) {
            return 0;
        }
        ConstInfo constInfo = this.getItem(n2);
        return constInfo.copy(this, constPool, map);
    }

    int addConstInfoPadding() {
        return this.addItem0(new ConstInfoPadding(this.numOfItems));
    }

    public int addClassInfo(CtClass ctClass) {
        if (!f.ifAcmp((Object)((Object)ctClass), (Object)((Object)THIS))) {
            return this.thisClassInfo;
        }
        if (!ctClass.isArray()) {
            return this.addClassInfo(ctClass.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(ctClass));
    }

    public int addClassInfo(String string) {
        int n2 = this.addUtf8Info(Descriptor.toJvmName(string));
        return this.addItem(new ClassInfo(n2, this.numOfItems));
    }

    public int addNameAndTypeInfo(String string, String string2) {
        return this.addNameAndTypeInfo(this.addUtf8Info(string), this.addUtf8Info(string2));
    }

    public int addNameAndTypeInfo(int n2, int n3) {
        return this.addItem(new NameAndTypeInfo(n2, n3, this.numOfItems));
    }

    public int addFieldrefInfo(int n2, String string, String string2) {
        int n3 = this.addNameAndTypeInfo(string, string2);
        return this.addFieldrefInfo(n2, n3);
    }

    public int addFieldrefInfo(int n2, int n3) {
        return this.addItem(new FieldrefInfo(n2, n3, this.numOfItems));
    }

    public int addMethodrefInfo(int n2, String string, String string2) {
        int n3 = this.addNameAndTypeInfo(string, string2);
        return this.addMethodrefInfo(n2, n3);
    }

    public int addMethodrefInfo(int n2, int n3) {
        return this.addItem(new MethodrefInfo(n2, n3, this.numOfItems));
    }

    public int addInterfaceMethodrefInfo(int n2, String string, String string2) {
        int n3 = this.addNameAndTypeInfo(string, string2);
        return this.addInterfaceMethodrefInfo(n2, n3);
    }

    public int addInterfaceMethodrefInfo(int n2, int n3) {
        return this.addItem(new InterfaceMethodrefInfo(n2, n3, this.numOfItems));
    }

    public int addStringInfo(String string) {
        int n2 = this.addUtf8Info(string);
        return this.addItem(new StringInfo(n2, this.numOfItems));
    }

    public int addIntegerInfo(int n2) {
        return this.addItem(new IntegerInfo(n2, this.numOfItems));
    }

    public int addFloatInfo(float f2) {
        return this.addItem(new FloatInfo(f2, this.numOfItems));
    }

    public int addLongInfo(long l) {
        int n2 = this.addItem(new LongInfo(l, this.numOfItems));
        if (n2 == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return n2;
    }

    public int addDoubleInfo(double d) {
        int n2 = this.addItem((ConstInfo)new DoubleInfo(d, this.numOfItems));
        if (n2 == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return n2;
    }

    public int addUtf8Info(String string) {
        return this.addItem(new Utf8Info(string, this.numOfItems));
    }

    public int addMethodHandleInfo(int n2, int n3) {
        return this.addItem((ConstInfo)new MethodHandleInfo(n2, n3, this.numOfItems));
    }

    public int addMethodTypeInfo(int n2) {
        return this.addItem((ConstInfo)new MethodTypeInfo(n2, this.numOfItems));
    }

    public int addInvokeDynamicInfo(int n2, int n3) {
        return this.addItem((ConstInfo)new InvokeDynamicInfo(n2, n3, this.numOfItems));
    }

    public Set getClassNames() {
        HashSet<String> hashSet = new HashSet<String>();
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i = 1; i < n2; ++i) {
            String string = longVector.elementAt(i).getClassName(this);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void renameClass(String string, String string2) {
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i = 1; i < n2; ++i) {
            ConstInfo constInfo = longVector.elementAt(i);
            constInfo.renameClass(this, string, string2, this.itemsCache);
        }
    }

    public void renameClass(Map map) {
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i = 1; i < n2; ++i) {
            ConstInfo constInfo = longVector.elementAt(i);
            constInfo.renameClass(this, map, this.itemsCache);
        }
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        this.items = new LongVector(n2);
        this.numOfItems = 0;
        this.addItem0(null);
        while (--n2 > 0) {
            int n3 = this.readOne(dataInputStream);
            if (n3 != 5 && n3 != 6) continue;
            this.addConstInfoPadding();
            --n2;
        }
    }

    private static HashMap makeItemsCache(LongVector longVector) {
        ConstInfo constInfo;
        HashMap<ConstInfo, ConstInfo> hashMap = new HashMap<ConstInfo, ConstInfo>();
        int n2 = 1;
        while ((constInfo = longVector.elementAt(n2++)) != null) {
            hashMap.put(constInfo, constInfo);
        }
        return hashMap;
    }

    private int readOne(DataInputStream dataInputStream) throws IOException {
        ConstInfo constInfo;
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 1: {
                constInfo = new Utf8Info(dataInputStream, this.numOfItems);
                break;
            }
            case 3: {
                constInfo = new IntegerInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 4: {
                constInfo = new FloatInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 5: {
                constInfo = new LongInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 6: {
                constInfo = new DoubleInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 7: {
                constInfo = new ClassInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 8: {
                constInfo = new StringInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 9: {
                constInfo = new FieldrefInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 10: {
                constInfo = new MethodrefInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 11: {
                constInfo = new InterfaceMethodrefInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 12: {
                constInfo = new NameAndTypeInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 15: {
                constInfo = new MethodHandleInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 16: {
                constInfo = new MethodTypeInfo(dataInputStream, this.numOfItems);
                break;
            }
            case 18: {
                constInfo = new InvokeDynamicInfo(dataInputStream, this.numOfItems);
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(new StringBuffer().append("invalid constant type: ").append(n2).append(" at ").append(this.numOfItems).toString()));
            }
        }
        this.addItem0(constInfo);
        return n2;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.numOfItems);
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i = 1; i < n2; ++i) {
            longVector.elementAt(i).write(dataOutputStream);
        }
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter printWriter) {
        int n2 = this.numOfItems;
        for (int i = 1; i < n2; ++i) {
            printWriter.print(i);
            printWriter.print(" ");
            this.items.elementAt(i).print(printWriter);
        }
    }

    static /* synthetic */ LongVector _jr$ig$items(Object object) {
        return ((ConstPool)((Object)object)).items;
    }

    static /* synthetic */ void _jr$ip$items(Object object, LongVector longVector) {
        ((ConstPool)((Object)object)).items = longVector;
    }

    static /* synthetic */ int _jr$ig$numOfItems(Object object) {
        return ((ConstPool)((Object)object)).numOfItems;
    }

    static /* synthetic */ void _jr$ip$numOfItems(Object object, int n2) {
        ((ConstPool)((Object)object)).numOfItems = n2;
    }

    static /* synthetic */ int _jr$ig$thisClassInfo(Object object) {
        return ((ConstPool)((Object)object)).thisClassInfo;
    }

    static /* synthetic */ void _jr$ip$thisClassInfo(Object object, int n2) {
        ((ConstPool)((Object)object)).thisClassInfo = n2;
    }

    static /* synthetic */ HashMap _jr$ig$itemsCache(Object object) {
        return ((ConstPool)((Object)object)).itemsCache;
    }

    static /* synthetic */ void _jr$ip$itemsCache(Object object, HashMap hashMap) {
        ((ConstPool)((Object)object)).itemsCache = hashMap;
    }
}

