/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationDefaultAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.MapMaker;

public class MethodInfo
extends h {
    ConstPool constPool;
    int accessFlags;
    int name;
    String cachedName;
    int descriptor;
    ArrayList attribute;
    public static boolean doPreverify = false;
    public static final String nameInit = "<init>";
    public static final String nameClinit = "<clinit>";

    private MethodInfo(ConstPool constPool) {
        this.constPool = constPool;
        this.attribute = null;
    }

    public MethodInfo(ConstPool constPool, String string, String string2) {
        this(constPool);
        this.accessFlags = 0;
        this.name = constPool.addUtf8Info(string);
        this.cachedName = string;
        this.descriptor = this.constPool.addUtf8Info(string2);
    }

    MethodInfo(ConstPool constPool, DataInputStream dataInputStream) throws IOException {
        this(constPool);
        this.read(dataInputStream);
    }

    public MethodInfo(ConstPool constPool, String string, MethodInfo methodInfo, Map map) throws BadBytecode {
        this(constPool);
        this.read(methodInfo, string, map);
    }

    public String toString() {
        return new StringBuffer().append(this.getName()).append(" ").append(this.getDescriptor()).toString();
    }

    void compact(ConstPool constPool) {
        ((MethodInfo)((Object)((Object)this))).name = constPool.addUtf8Info(this.getName());
        ((MethodInfo)((Object)((Object)this))).descriptor = constPool.addUtf8Info(this.getDescriptor());
        ((MethodInfo)((Object)((Object)this))).attribute = AttributeInfo.copyAll(((MethodInfo)((Object)((Object)this))).attribute, constPool);
        ((MethodInfo)((Object)((Object)this))).constPool = constPool;
    }

    void prune(ConstPool constPool) {
        AttributeInfo attributeInfo;
        ExceptionsAttribute exceptionsAttribute;
        AnnotationDefaultAttribute annotationDefaultAttribute;
        AttributeInfo attributeInfo2;
        AttributeInfo attributeInfo3;
        AttributeInfo attributeInfo4;
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>();
        AttributeInfo attributeInfo5 = this.getAttribute("RuntimeInvisibleAnnotations");
        if (attributeInfo5 != null) {
            attributeInfo5 = attributeInfo5.copy(constPool, null);
            arrayList.add(attributeInfo5);
        }
        if ((attributeInfo4 = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            attributeInfo4 = attributeInfo4.copy(constPool, null);
            arrayList.add(attributeInfo4);
        }
        if ((attributeInfo3 = this.getAttribute("RuntimeInvisibleParameterAnnotations")) != null) {
            attributeInfo3 = attributeInfo3.copy(constPool, null);
            arrayList.add(attributeInfo3);
        }
        if ((attributeInfo2 = this.getAttribute("RuntimeVisibleParameterAnnotations")) != null) {
            attributeInfo2 = attributeInfo2.copy(constPool, null);
            arrayList.add(attributeInfo2);
        }
        if ((annotationDefaultAttribute = (AnnotationDefaultAttribute)g.convertForCast((Object)((Object)this.getAttribute("AnnotationDefault")), AnnotationDefaultAttribute.class)) != null) {
            arrayList.add((AttributeInfo)annotationDefaultAttribute);
        }
        if ((exceptionsAttribute = this.getExceptionsAttribute()) != null) {
            arrayList.add(exceptionsAttribute);
        }
        if ((attributeInfo = this.getAttribute("Signature")) != null) {
            attributeInfo = attributeInfo.copy(constPool, null);
            arrayList.add(attributeInfo);
        }
        ((MethodInfo)((Object)((Object)this))).attribute = arrayList;
        ((MethodInfo)((Object)((Object)this))).name = constPool.addUtf8Info(this.getName());
        ((MethodInfo)((Object)((Object)this))).descriptor = constPool.addUtf8Info(this.getDescriptor());
        ((MethodInfo)((Object)((Object)this))).constPool = constPool;
    }

    public String getName() {
        if (((MethodInfo)((Object)((Object)this))).cachedName == null) {
            ((MethodInfo)((Object)((Object)this))).cachedName = ((MethodInfo)((Object)((Object)this))).constPool.getUtf8Info(((MethodInfo)((Object)((Object)this))).name);
        }
        return ((MethodInfo)((Object)((Object)this))).cachedName;
    }

    public void setName(String string) {
        ((MethodInfo)((Object)((Object)this))).name = ((MethodInfo)((Object)((Object)this))).constPool.addUtf8Info(string);
        ((MethodInfo)((Object)((Object)this))).cachedName = string;
    }

    public boolean isMethod() {
        String string = this.getName();
        return !string.equals(nameInit) && !string.equals(nameClinit);
    }

    public ConstPool getConstPool() {
        return ((MethodInfo)((Object)((Object)this))).constPool;
    }

    public boolean isConstructor() {
        return this.getName().equals(nameInit);
    }

    public boolean isStaticInitializer() {
        return this.getName().equals(nameClinit);
    }

    public int getAccessFlags() {
        return ((MethodInfo)((Object)((Object)this))).accessFlags;
    }

    public void setAccessFlags(int n2) {
        ((MethodInfo)((Object)((Object)this))).accessFlags = n2;
    }

    public String getDescriptor() {
        return ((MethodInfo)((Object)((Object)this))).constPool.getUtf8Info(((MethodInfo)((Object)((Object)this))).descriptor);
    }

    public void setDescriptor(String string) {
        if (!string.equals(this.getDescriptor())) {
            ((MethodInfo)((Object)((Object)this))).descriptor = ((MethodInfo)((Object)((Object)this))).constPool.addUtf8Info(string);
        }
    }

    public List getAttributes() {
        if (((MethodInfo)((Object)((Object)this))).attribute == null) {
            ((MethodInfo)((Object)((Object)this))).attribute = new ArrayList();
        }
        return ((MethodInfo)((Object)((Object)this))).attribute;
    }

    public AttributeInfo getAttribute(String string) {
        return AttributeInfo.lookup(((MethodInfo)((Object)((Object)this))).attribute, string);
    }

    public AttributeInfo removeAttribute(String string) {
        return AttributeInfo.remove(((MethodInfo)((Object)((Object)this))).attribute, string);
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        if (((MethodInfo)((Object)((Object)this))).attribute == null) {
            ((MethodInfo)((Object)((Object)this))).attribute = new ArrayList();
        }
        AttributeInfo.remove(((MethodInfo)((Object)((Object)this))).attribute, attributeInfo.getName());
        ((MethodInfo)((Object)((Object)this))).attribute.add(attributeInfo);
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        AttributeInfo attributeInfo = AttributeInfo.lookup(((MethodInfo)((Object)((Object)this))).attribute, "Exceptions");
        return (ExceptionsAttribute)((Object)g.convertForCast((Object)((Object)attributeInfo), ExceptionsAttribute.class));
    }

    public CodeAttribute getCodeAttribute() {
        AttributeInfo attributeInfo = AttributeInfo.lookup(((MethodInfo)((Object)((Object)this))).attribute, "Code");
        return (CodeAttribute)((Object)g.convertForCast((Object)((Object)attributeInfo), CodeAttribute.class));
    }

    public void removeExceptionsAttribute() {
        AttributeInfo.remove(((MethodInfo)((Object)((Object)this))).attribute, "Exceptions");
    }

    public void setExceptionsAttribute(ExceptionsAttribute exceptionsAttribute) {
        this.removeExceptionsAttribute();
        if (((MethodInfo)((Object)((Object)this))).attribute == null) {
            ((MethodInfo)((Object)((Object)this))).attribute = new ArrayList();
        }
        ((MethodInfo)((Object)((Object)this))).attribute.add(exceptionsAttribute);
    }

    public void removeCodeAttribute() {
        AttributeInfo.remove(((MethodInfo)((Object)((Object)this))).attribute, "Code");
    }

    public void setCodeAttribute(CodeAttribute codeAttribute) {
        this.removeCodeAttribute();
        if (((MethodInfo)((Object)((Object)this))).attribute == null) {
            ((MethodInfo)((Object)((Object)this))).attribute = new ArrayList();
        }
        ((MethodInfo)((Object)((Object)this))).attribute.add(codeAttribute);
    }

    public void rebuildStackMapIf6(ClassPool classPool, ClassFile classFile) throws BadBytecode {
        if (classFile.getMajorVersion() >= 50) {
            this.rebuildStackMap(classPool);
        }
        if (doPreverify) {
            this.rebuildStackMapForME(classPool);
        }
    }

    public void rebuildStackMap(ClassPool classPool) throws BadBytecode {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute != null) {
            StackMapTable stackMapTable = MapMaker.make(classPool, this);
            codeAttribute.setAttribute(stackMapTable);
        }
    }

    public void rebuildStackMapForME(ClassPool classPool) throws BadBytecode {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute != null) {
            StackMap stackMap = MapMaker.make2(classPool, this);
            codeAttribute.setAttribute(stackMap);
        }
    }

    public int getLineNumber(int n2) {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute == null) {
            return -1;
        }
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)((Object)g.convertForCast((Object)((Object)codeAttribute.getAttribute("LineNumberTable")), LineNumberAttribute.class));
        if (lineNumberAttribute == null) {
            return -1;
        }
        return lineNumberAttribute.toLineNumber(n2);
    }

    public void setSuperclass(String string) throws BadBytecode {
        if (!this.isConstructor()) {
            return;
        }
        CodeAttribute codeAttribute = this.getCodeAttribute();
        byte[] byArray = codeAttribute.getCode();
        CodeIterator codeIterator = codeAttribute.iterator();
        int n2 = codeIterator.skipSuperConstructor();
        if (n2 >= 0) {
            ConstPool constPool = ((MethodInfo)((Object)((Object)this))).constPool;
            int n3 = ByteArray.readU16bit(byArray, n2 + 1);
            int n4 = constPool.getMethodrefNameAndType(n3);
            int n5 = constPool.addClassInfo(string);
            int n6 = constPool.addMethodrefInfo(n5, n4);
            ByteArray.write16bit(n6, byArray, n2 + 1);
        }
    }

    private void read(MethodInfo methodInfo, String string, Map map) throws BadBytecode {
        CodeAttribute codeAttribute;
        ConstPool constPool = ((MethodInfo)((Object)((Object)this))).constPool;
        ((MethodInfo)((Object)((Object)this))).accessFlags = ((MethodInfo)((Object)((Object)methodInfo))).accessFlags;
        ((MethodInfo)((Object)((Object)this))).name = constPool.addUtf8Info(string);
        ((MethodInfo)((Object)((Object)this))).cachedName = string;
        ConstPool constPool2 = ((MethodInfo)((Object)((Object)methodInfo))).constPool;
        String string2 = constPool2.getUtf8Info(((MethodInfo)((Object)((Object)methodInfo))).descriptor);
        String string3 = Descriptor.rename(string2, map);
        ((MethodInfo)((Object)((Object)this))).descriptor = constPool.addUtf8Info(string3);
        ((MethodInfo)((Object)((Object)this))).attribute = new ArrayList();
        ExceptionsAttribute exceptionsAttribute = methodInfo.getExceptionsAttribute();
        if (exceptionsAttribute != null) {
            ((MethodInfo)((Object)((Object)this))).attribute.add(exceptionsAttribute.copy(constPool, map));
        }
        if ((codeAttribute = methodInfo.getCodeAttribute()) != null) {
            ((MethodInfo)((Object)((Object)this))).attribute.add(codeAttribute.copy(constPool, map));
        }
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        ((MethodInfo)((Object)((Object)this))).accessFlags = dataInputStream.readUnsignedShort();
        ((MethodInfo)((Object)((Object)this))).name = dataInputStream.readUnsignedShort();
        ((MethodInfo)((Object)((Object)this))).descriptor = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        ((MethodInfo)((Object)((Object)this))).attribute = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            ((MethodInfo)((Object)((Object)this))).attribute.add(AttributeInfo.read(((MethodInfo)((Object)((Object)this))).constPool, dataInputStream));
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(((MethodInfo)((Object)((Object)this))).accessFlags);
        dataOutputStream.writeShort(((MethodInfo)((Object)((Object)this))).name);
        dataOutputStream.writeShort(((MethodInfo)((Object)((Object)this))).descriptor);
        if (((MethodInfo)((Object)((Object)this))).attribute == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(((MethodInfo)((Object)((Object)this))).attribute.size());
            AttributeInfo.writeAll(((MethodInfo)((Object)((Object)this))).attribute, dataOutputStream);
        }
    }

    protected /* synthetic */ MethodInfo(h h2) {
        super(h2);
    }
}

