/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Lex;
import org.zeroturnaround.bundled.javassist.compiler.SymbolTable;
import org.zeroturnaround.bundled.javassist.compiler.SyntaxError;
import org.zeroturnaround.bundled.javassist.compiler.TokenId;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.ArrayInit;
import org.zeroturnaround.bundled.javassist.compiler.ast.AssignExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.BinExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CallExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CastExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CondExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Declarator;
import org.zeroturnaround.bundled.javassist.compiler.ast.DoubleConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Expr;
import org.zeroturnaround.bundled.javassist.compiler.ast.FieldDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.InstanceOfExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.IntConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Keyword;
import org.zeroturnaround.bundled.javassist.compiler.ast.Member;
import org.zeroturnaround.bundled.javassist.compiler.ast.MethodDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.NewExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Pair;
import org.zeroturnaround.bundled.javassist.compiler.ast.Stmnt;
import org.zeroturnaround.bundled.javassist.compiler.ast.StringL;
import org.zeroturnaround.bundled.javassist.compiler.ast.Symbol;
import org.zeroturnaround.bundled.javassist.compiler.ast.Variable;

public final class Parser
extends h
implements TokenId {
    private Lex lex;
    private static final int[] binaryOpPrecedence = new int[]{0, 0, 0, 0, 1, 6, 0, 0, 0, 1, 2, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0};

    public Parser(Lex lex) {
        this.lex = lex;
    }

    public boolean hasMore() {
        return this.lex.lookAhead() >= 0;
    }

    public ASTList parseMember(SymbolTable symbolTable) throws CompileError {
        ASTList aSTList = this.parseMember1(symbolTable);
        if (g.convertForInstanceOf((Object)aSTList, MethodDecl.class) instanceof MethodDecl) {
            return this.parseMethod2(symbolTable, (MethodDecl)g.convertForCast((Object)aSTList, MethodDecl.class));
        }
        return aSTList;
    }

    public ASTList parseMember1(SymbolTable symbolTable) throws CompileError {
        Declarator declarator;
        ASTList aSTList = this.parseMemberMods();
        boolean bl = false;
        if (this.lex.lookAhead() == 400 && this.lex.lookAhead(1) == 40) {
            declarator = new Declarator(344, 0);
            bl = true;
        } else {
            declarator = this.parseFormalType(symbolTable);
        }
        if (this.lex.get() != 400) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        String string = bl ? "<init>" : this.lex.getString();
        declarator.setVariable(new Symbol(string));
        if (bl || this.lex.lookAhead() == 40) {
            return this.parseMethod1(symbolTable, bl, aSTList, declarator);
        }
        return this.parseField(symbolTable, aSTList, declarator);
    }

    private FieldDecl parseField(SymbolTable symbolTable, ASTList aSTList, Declarator declarator) throws CompileError {
        int n2;
        ASTree aSTree = null;
        if (this.lex.lookAhead() == 61) {
            this.lex.get();
            aSTree = this.parseExpression(symbolTable);
        }
        if ((n2 = this.lex.get()) == 59) {
            return new FieldDecl(aSTList, new ASTList(declarator, new ASTList(aSTree)));
        }
        if (n2 == 44) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("only one field can be declared in one declaration", this.lex));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
    }

    private MethodDecl parseMethod1(SymbolTable symbolTable, boolean bl, ASTList aSTList, Declarator declarator) throws CompileError {
        if (this.lex.get() != 40) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        ASTList aSTList2 = null;
        if (this.lex.lookAhead() != 41) {
            while (true) {
                aSTList2 = ASTList.append(aSTList2, this.parseFormalParam(symbolTable));
                int n2 = this.lex.lookAhead();
                if (n2 == 44) {
                    this.lex.get();
                    continue;
                }
                if (n2 == 41) break;
            }
        }
        this.lex.get();
        declarator.addArrayDim(this.parseArrayDimension());
        if (bl && declarator.getArrayDim() > 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        ASTList aSTList3 = null;
        if (this.lex.lookAhead() == 341) {
            this.lex.get();
            while (true) {
                aSTList3 = ASTList.append(aSTList3, this.parseClassType(symbolTable));
                if (this.lex.lookAhead() != 44) break;
                this.lex.get();
            }
        }
        return new MethodDecl(aSTList, new ASTList(declarator, ASTList.make(aSTList2, aSTList3, null)));
    }

    public MethodDecl parseMethod2(SymbolTable symbolTable, MethodDecl methodDecl) throws CompileError {
        Stmnt stmnt = null;
        if (this.lex.lookAhead() == 59) {
            this.lex.get();
        } else {
            stmnt = this.parseBlock(symbolTable);
            if (stmnt == null) {
                stmnt = new Stmnt(66);
            }
        }
        methodDecl.sublist(4).setHead(stmnt);
        return methodDecl;
    }

    private ASTList parseMemberMods() {
        int n2;
        ASTList aSTList = null;
        while ((n2 = this.lex.lookAhead()) == 300 || n2 == 315 || n2 == 332 || n2 == 331 || n2 == 330 || n2 == 338 || n2 == 335 || n2 == 345 || n2 == 342 || n2 == 347) {
            aSTList = new ASTList(new Keyword(this.lex.get()), aSTList);
        }
        return aSTList;
    }

    private Declarator parseFormalType(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (Parser.isBuiltinType(n2) || n2 == 344) {
            this.lex.get();
            int n3 = this.parseArrayDimension();
            return new Declarator(n2, n3);
        }
        ASTList aSTList = this.parseClassType(symbolTable);
        int n4 = this.parseArrayDimension();
        return new Declarator(aSTList, n4);
    }

    private static boolean isBuiltinType(int n2) {
        return n2 == 301 || n2 == 303 || n2 == 306 || n2 == 334 || n2 == 324 || n2 == 326 || n2 == 317 || n2 == 312;
    }

    private Declarator parseFormalParam(SymbolTable symbolTable) throws CompileError {
        Declarator declarator = this.parseFormalType(symbolTable);
        if (this.lex.get() != 400) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        String string = this.lex.getString();
        declarator.setVariable(new Symbol(string));
        declarator.addArrayDim(this.parseArrayDimension());
        symbolTable.append(string, declarator);
        return declarator;
    }

    public Stmnt parseStatement(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (n2 == 123) {
            return this.parseBlock(symbolTable);
        }
        if (n2 == 59) {
            this.lex.get();
            return new Stmnt(66);
        }
        if (n2 == 400 && this.lex.lookAhead(1) == 58) {
            this.lex.get();
            String string = this.lex.getString();
            this.lex.get();
            return Stmnt.make(76, (ASTree)new Symbol(string), (ASTree)this.parseStatement(symbolTable));
        }
        if (n2 == 320) {
            return this.parseIf(symbolTable);
        }
        if (n2 == 346) {
            return this.parseWhile(symbolTable);
        }
        if (n2 == 311) {
            return this.parseDo(symbolTable);
        }
        if (n2 == 318) {
            return this.parseFor(symbolTable);
        }
        if (n2 == 343) {
            return this.parseTry(symbolTable);
        }
        if (n2 == 337) {
            return this.parseSwitch(symbolTable);
        }
        if (n2 == 338) {
            return this.parseSynchronized(symbolTable);
        }
        if (n2 == 333) {
            return this.parseReturn(symbolTable);
        }
        if (n2 == 340) {
            return this.parseThrow(symbolTable);
        }
        if (n2 == 302) {
            return this.parseBreak(symbolTable);
        }
        if (n2 == 309) {
            return this.parseContinue(symbolTable);
        }
        return this.parseDeclarationOrExpression(symbolTable, false);
    }

    private Stmnt parseBlock(SymbolTable symbolTable) throws CompileError {
        if (this.lex.get() != 123) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        Stmnt stmnt = null;
        SymbolTable symbolTable2 = new SymbolTable(symbolTable);
        while (this.lex.lookAhead() != 125) {
            Stmnt stmnt2 = this.parseStatement(symbolTable2);
            if (stmnt2 == null) continue;
            stmnt = (Stmnt)g.convertForCast((Object)ASTList.concat(stmnt, new Stmnt(66, (ASTree)stmnt2)), Stmnt.class);
        }
        this.lex.get();
        if (stmnt == null) {
            return new Stmnt(66);
        }
        return stmnt;
    }

    private Stmnt parseIf(SymbolTable symbolTable) throws CompileError {
        Stmnt stmnt;
        int n2 = this.lex.get();
        ASTree aSTree = this.parseParExpression(symbolTable);
        Stmnt stmnt2 = this.parseStatement(symbolTable);
        if (this.lex.lookAhead() == 313) {
            this.lex.get();
            stmnt = this.parseStatement(symbolTable);
        } else {
            stmnt = null;
        }
        return new Stmnt(n2, aSTree, new ASTList(stmnt2, new ASTList(stmnt)));
    }

    private Stmnt parseWhile(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        ASTree aSTree = this.parseParExpression(symbolTable);
        Stmnt stmnt = this.parseStatement(symbolTable);
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseDo(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        Stmnt stmnt = this.parseStatement(symbolTable);
        if (this.lex.get() != 346 || this.lex.get() != 40) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        ASTree aSTree = this.parseExpression(symbolTable);
        if (this.lex.get() != 41 || this.lex.get() != 59) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseFor(SymbolTable symbolTable) throws CompileError {
        Stmnt stmnt;
        int n2 = this.lex.get();
        SymbolTable symbolTable2 = new SymbolTable(symbolTable);
        if (this.lex.get() != 40) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        if (this.lex.lookAhead() == 59) {
            this.lex.get();
            stmnt = null;
        } else {
            stmnt = this.parseDeclarationOrExpression(symbolTable2, true);
        }
        ASTree aSTree = this.lex.lookAhead() == 59 ? null : this.parseExpression(symbolTable2);
        if (this.lex.get() != 59) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("; is missing", this.lex));
        }
        Stmnt stmnt2 = this.lex.lookAhead() == 41 ? null : this.parseExprList(symbolTable2);
        if (this.lex.get() != 41) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(") is missing", this.lex));
        }
        Stmnt stmnt3 = this.parseStatement(symbolTable2);
        return new Stmnt(n2, stmnt, new ASTList(aSTree, new ASTList(stmnt2, stmnt3)));
    }

    private Stmnt parseSwitch(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        ASTree aSTree = this.parseParExpression(symbolTable);
        Stmnt stmnt = this.parseSwitchBlock(symbolTable);
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseSwitchBlock(SymbolTable symbolTable) throws CompileError {
        if (this.lex.get() != 123) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        SymbolTable symbolTable2 = new SymbolTable(symbolTable);
        Stmnt stmnt = this.parseStmntOrCase(symbolTable2);
        if (stmnt == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("empty switch block", this.lex));
        }
        int n2 = stmnt.getOperator();
        if (n2 != 304 && n2 != 310) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("no case or default in a switch block", this.lex));
        }
        Stmnt stmnt2 = new Stmnt(66, (ASTree)stmnt);
        while (this.lex.lookAhead() != 125) {
            Stmnt stmnt3 = this.parseStmntOrCase(symbolTable2);
            if (stmnt3 == null) continue;
            int n3 = stmnt3.getOperator();
            if (n3 == 304 || n3 == 310) {
                stmnt2 = (Stmnt)g.convertForCast((Object)ASTList.concat(stmnt2, new Stmnt(66, (ASTree)stmnt3)), Stmnt.class);
                stmnt = stmnt3;
                continue;
            }
            stmnt = (Stmnt)g.convertForCast((Object)ASTList.concat(stmnt, new Stmnt(66, (ASTree)stmnt3)), Stmnt.class);
        }
        this.lex.get();
        return stmnt2;
    }

    private Stmnt parseStmntOrCase(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (n2 != 304 && n2 != 310) {
            return this.parseStatement(symbolTable);
        }
        this.lex.get();
        Stmnt stmnt = n2 == 304 ? new Stmnt(n2, this.parseExpression(symbolTable)) : new Stmnt(310);
        if (this.lex.get() != 58) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(": is missing", this.lex));
        }
        return stmnt;
    }

    private Stmnt parseSynchronized(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        if (this.lex.get() != 40) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        ASTree aSTree = this.parseExpression(symbolTable);
        if (this.lex.get() != 41) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        Stmnt stmnt = this.parseBlock(symbolTable);
        return new Stmnt(n2, aSTree, stmnt);
    }

    private Stmnt parseTry(SymbolTable symbolTable) throws CompileError {
        h h2;
        this.lex.get();
        Stmnt stmnt = this.parseBlock(symbolTable);
        ASTList aSTList = null;
        while (this.lex.lookAhead() == 305) {
            this.lex.get();
            if (this.lex.get() != 40) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
            }
            h2 = new SymbolTable(symbolTable);
            Declarator declarator = this.parseFormalParam((SymbolTable)h2);
            if (declarator.getArrayDim() > 0 || declarator.getType() != 307) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
            }
            if (this.lex.get() != 41) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
            }
            Stmnt stmnt2 = this.parseBlock((SymbolTable)h2);
            aSTList = ASTList.append(aSTList, (ASTree)new Pair((ASTree)declarator, (ASTree)stmnt2));
        }
        h2 = null;
        if (this.lex.lookAhead() == 316) {
            this.lex.get();
            h2 = this.parseBlock(symbolTable);
        }
        return Stmnt.make(343, stmnt, aSTList, h2);
    }

    private Stmnt parseReturn(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        Stmnt stmnt = new Stmnt(n2);
        if (this.lex.lookAhead() != 59) {
            stmnt.setLeft(this.parseExpression(symbolTable));
        }
        if (this.lex.get() != 59) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("; is missing", this.lex));
        }
        return stmnt;
    }

    private Stmnt parseThrow(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        ASTree aSTree = this.parseExpression(symbolTable);
        if (this.lex.get() != 59) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("; is missing", this.lex));
        }
        return new Stmnt(n2, aSTree);
    }

    private Stmnt parseBreak(SymbolTable symbolTable) throws CompileError {
        return this.parseContinue(symbolTable);
    }

    private Stmnt parseContinue(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        Stmnt stmnt = new Stmnt(n2);
        int n3 = this.lex.get();
        if (n3 == 400) {
            stmnt.setLeft(new Symbol(this.lex.getString()));
            n3 = this.lex.get();
        }
        if (n3 != 59) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("; is missing", this.lex));
        }
        return stmnt;
    }

    private Stmnt parseDeclarationOrExpression(SymbolTable symbolTable, boolean bl) throws CompileError {
        int n2;
        int n3 = this.lex.lookAhead();
        while (n3 == 315) {
            this.lex.get();
            n3 = this.lex.lookAhead();
        }
        if (Parser.isBuiltinType(n3)) {
            n3 = this.lex.get();
            int n4 = this.parseArrayDimension();
            return this.parseDeclarators(symbolTable, new Declarator(n3, n4));
        }
        if (n3 == 400 && (n2 = this.nextIsClassType(0)) >= 0 && this.lex.lookAhead(n2) == 400) {
            ASTList aSTList = this.parseClassType(symbolTable);
            int n5 = this.parseArrayDimension();
            return this.parseDeclarators(symbolTable, new Declarator(aSTList, n5));
        }
        Stmnt stmnt = bl ? this.parseExprList(symbolTable) : new Stmnt(69, this.parseExpression(symbolTable));
        if (this.lex.get() != 59) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("; is missing", this.lex));
        }
        return stmnt;
    }

    private Stmnt parseExprList(SymbolTable symbolTable) throws CompileError {
        Stmnt stmnt = null;
        while (true) {
            Stmnt stmnt2 = new Stmnt(69, this.parseExpression(symbolTable));
            stmnt = (Stmnt)g.convertForCast((Object)ASTList.concat(stmnt, new Stmnt(66, (ASTree)stmnt2)), Stmnt.class);
            if (this.lex.lookAhead() != 44) break;
            this.lex.get();
        }
        return stmnt;
    }

    private Stmnt parseDeclarators(SymbolTable symbolTable, Declarator declarator) throws CompileError {
        int n2;
        Stmnt stmnt = null;
        do {
            stmnt = (Stmnt)g.convertForCast((Object)ASTList.concat(stmnt, new Stmnt(68, (ASTree)this.parseDeclarator(symbolTable, declarator))), Stmnt.class);
            n2 = this.lex.get();
            if (n2 != 59) continue;
            return stmnt;
        } while (n2 == 44);
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("; is missing", this.lex));
    }

    private Declarator parseDeclarator(SymbolTable symbolTable, Declarator declarator) throws CompileError {
        if (this.lex.get() != 400 || declarator.getType() == 344) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        String string = this.lex.getString();
        Symbol symbol = new Symbol(string);
        int n2 = this.parseArrayDimension();
        ASTree aSTree = null;
        if (this.lex.lookAhead() == 61) {
            this.lex.get();
            aSTree = this.parseInitializer(symbolTable);
        }
        Declarator declarator2 = declarator.make(symbol, n2, aSTree);
        symbolTable.append(string, declarator2);
        return declarator2;
    }

    private ASTree parseInitializer(SymbolTable symbolTable) throws CompileError {
        if (this.lex.lookAhead() == 123) {
            return this.parseArrayInitializer(symbolTable);
        }
        return this.parseExpression(symbolTable);
    }

    private ArrayInit parseArrayInitializer(SymbolTable symbolTable) throws CompileError {
        this.lex.get();
        ASTree aSTree = this.parseExpression(symbolTable);
        ArrayInit arrayInit = new ArrayInit(aSTree);
        while (this.lex.lookAhead() == 44) {
            this.lex.get();
            aSTree = this.parseExpression(symbolTable);
            ASTList.append(arrayInit, aSTree);
        }
        if (this.lex.get() != 125) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        return arrayInit;
    }

    private ASTree parseParExpression(SymbolTable symbolTable) throws CompileError {
        if (this.lex.get() != 40) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        ASTree aSTree = this.parseExpression(symbolTable);
        if (this.lex.get() != 41) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        return aSTree;
    }

    public ASTree parseExpression(SymbolTable symbolTable) throws CompileError {
        ASTree aSTree = this.parseConditionalExpr(symbolTable);
        if (!Parser.isAssignOp(this.lex.lookAhead())) {
            return aSTree;
        }
        int n2 = this.lex.get();
        ASTree aSTree2 = this.parseExpression(symbolTable);
        return AssignExpr.makeAssign(n2, aSTree, aSTree2);
    }

    private static boolean isAssignOp(int n2) {
        return n2 == 61 || n2 == 351 || n2 == 352 || n2 == 353 || n2 == 354 || n2 == 355 || n2 == 356 || n2 == 360 || n2 == 361 || n2 == 365 || n2 == 367 || n2 == 371;
    }

    private ASTree parseConditionalExpr(SymbolTable symbolTable) throws CompileError {
        ASTree aSTree = this.parseBinaryExpr(symbolTable);
        if (this.lex.lookAhead() == 63) {
            this.lex.get();
            ASTree aSTree2 = this.parseExpression(symbolTable);
            if (this.lex.get() != 58) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(": is missing", this.lex));
            }
            ASTree aSTree3 = this.parseExpression(symbolTable);
            return new CondExpr(aSTree, aSTree2, aSTree3);
        }
        return aSTree;
    }

    private ASTree parseBinaryExpr(SymbolTable symbolTable) throws CompileError {
        ASTree aSTree = this.parseUnaryExpr(symbolTable);
        int n2;
        int n3;
        while ((n3 = this.getOpPrecedence(n2 = this.lex.lookAhead())) != 0) {
            aSTree = this.binaryExpr2(symbolTable, aSTree, n3);
        }
        return aSTree;
    }

    private ASTree parseInstanceOf(SymbolTable symbolTable, ASTree aSTree) throws CompileError {
        int n2 = this.lex.lookAhead();
        if (Parser.isBuiltinType(n2)) {
            this.lex.get();
            int n3 = this.parseArrayDimension();
            return new InstanceOfExpr(n2, n3, aSTree);
        }
        ASTList aSTList = this.parseClassType(symbolTable);
        int n4 = this.parseArrayDimension();
        return new InstanceOfExpr(aSTList, n4, aSTree);
    }

    private ASTree binaryExpr2(SymbolTable symbolTable, ASTree aSTree, int n2) throws CompileError {
        int n3;
        int n4;
        int n5 = this.lex.get();
        if (n5 == 323) {
            return this.parseInstanceOf(symbolTable, aSTree);
        }
        ASTree aSTree2 = this.parseUnaryExpr(symbolTable);
        while ((n4 = this.getOpPrecedence(n3 = this.lex.lookAhead())) != 0 && n2 > n4) {
            aSTree2 = this.binaryExpr2(symbolTable, aSTree2, n4);
        }
        return BinExpr.makeBin(n5, aSTree, aSTree2);
    }

    private int getOpPrecedence(int n2) {
        if (33 <= n2 && n2 <= 63) {
            return binaryOpPrecedence[n2 - 33];
        }
        if (n2 == 94) {
            return 7;
        }
        if (n2 == 124) {
            return 8;
        }
        if (n2 == 369) {
            return 9;
        }
        if (n2 == 368) {
            return 10;
        }
        if (n2 == 358 || n2 == 350) {
            return 5;
        }
        if (n2 == 357 || n2 == 359 || n2 == 323) {
            return 4;
        }
        if (n2 == 364 || n2 == 366 || n2 == 370) {
            return 3;
        }
        return 0;
    }

    private ASTree parseUnaryExpr(SymbolTable symbolTable) throws CompileError {
        switch (this.lex.lookAhead()) {
            case 33: 
            case 43: 
            case 45: 
            case 126: 
            case 362: 
            case 363: {
                int n2 = this.lex.get();
                if (n2 == 45) {
                    int n3 = this.lex.lookAhead();
                    switch (n3) {
                        case 401: 
                        case 402: 
                        case 403: {
                            this.lex.get();
                            return new IntConst(-this.lex.getLong(), n3);
                        }
                        case 404: 
                        case 405: {
                            this.lex.get();
                            return new DoubleConst(-this.lex.getDouble(), n3);
                        }
                    }
                }
                return Expr.make(n2, this.parseUnaryExpr(symbolTable));
            }
            case 40: {
                return this.parseCast(symbolTable);
            }
        }
        return this.parsePostfix(symbolTable);
    }

    private ASTree parseCast(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.lookAhead(1);
        if (Parser.isBuiltinType(n2) && this.nextIsBuiltinCast()) {
            this.lex.get();
            this.lex.get();
            int n3 = this.parseArrayDimension();
            if (this.lex.get() != 41) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(") is missing", this.lex));
            }
            return new CastExpr(n2, n3, this.parseUnaryExpr(symbolTable));
        }
        if (n2 == 400 && this.nextIsClassCast()) {
            this.lex.get();
            ASTList aSTList = this.parseClassType(symbolTable);
            int n4 = this.parseArrayDimension();
            if (this.lex.get() != 41) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(") is missing", this.lex));
            }
            return new CastExpr(aSTList, n4, this.parseUnaryExpr(symbolTable));
        }
        return this.parsePostfix(symbolTable);
    }

    private boolean nextIsBuiltinCast() {
        int n2;
        int n3 = 2;
        while ((n2 = this.lex.lookAhead(n3++)) == 91) {
            if (this.lex.lookAhead(n3++) == 93) continue;
            return false;
        }
        return this.lex.lookAhead(n3 - 1) == 41;
    }

    private boolean nextIsClassCast() {
        int n2 = this.nextIsClassType(1);
        if (n2 < 0) {
            return false;
        }
        int n3 = this.lex.lookAhead(n2);
        if (n3 != 41) {
            return false;
        }
        n3 = this.lex.lookAhead(n2 + 1);
        return n3 == 40 || n3 == 412 || n3 == 406 || n3 == 400 || n3 == 339 || n3 == 336 || n3 == 328 || n3 == 410 || n3 == 411 || n3 == 403 || n3 == 402 || n3 == 401 || n3 == 405 || n3 == 404;
    }

    private int nextIsClassType(int n2) {
        int n3;
        while (this.lex.lookAhead(++n2) == 46) {
            if (this.lex.lookAhead(++n2) == 400) continue;
            return -1;
        }
        while ((n3 = this.lex.lookAhead(n2++)) == 91) {
            if (this.lex.lookAhead(n2++) == 93) continue;
            return -1;
        }
        return n2 - 1;
    }

    private int parseArrayDimension() throws CompileError {
        int n2 = 0;
        while (this.lex.lookAhead() == 91) {
            ++n2;
            this.lex.get();
            if (this.lex.get() == 93) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("] is missing", this.lex));
        }
        return n2;
    }

    private ASTList parseClassType(SymbolTable symbolTable) throws CompileError {
        ASTList aSTList = null;
        while (true) {
            if (this.lex.get() != 400) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
            }
            aSTList = ASTList.append(aSTList, new Symbol(this.lex.getString()));
            if (this.lex.lookAhead() != 46) break;
            this.lex.get();
        }
        return aSTList;
    }

    private ASTree parsePostfix(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.lookAhead();
        switch (n2) {
            case 401: 
            case 402: 
            case 403: {
                this.lex.get();
                return new IntConst(this.lex.getLong(), n2);
            }
            case 404: 
            case 405: {
                this.lex.get();
                return new DoubleConst(this.lex.getDouble(), n2);
            }
        }
        ASTree aSTree = this.parsePrimaryExpr(symbolTable);
        block11: while (true) {
            switch (this.lex.lookAhead()) {
                case 40: {
                    aSTree = this.parseMethodCall(symbolTable, aSTree);
                    continue block11;
                }
                case 91: {
                    if (this.lex.lookAhead(1) == 93) {
                        int n3 = this.parseArrayDimension();
                        if (this.lex.get() != 46 || this.lex.get() != 307) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
                        }
                        aSTree = this.parseDotClass(aSTree, n3);
                        continue block11;
                    }
                    ASTree aSTree2 = this.parseArrayIndex(symbolTable);
                    if (aSTree2 == null) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
                    }
                    aSTree = Expr.make(65, aSTree, aSTree2);
                    continue block11;
                }
                case 362: 
                case 363: {
                    int n4 = this.lex.get();
                    aSTree = Expr.make(n4, null, aSTree);
                    continue block11;
                }
                case 46: {
                    String string;
                    this.lex.get();
                    int n4 = this.lex.get();
                    if (n4 == 307) {
                        aSTree = this.parseDotClass(aSTree, 0);
                        continue block11;
                    }
                    if (n4 == 336) {
                        aSTree = Expr.make(46, (ASTree)new Symbol(this.toClassName(aSTree)), (ASTree)new Keyword(n4));
                        continue block11;
                    }
                    if (n4 == 400) {
                        string = this.lex.getString();
                        aSTree = Expr.make(46, aSTree, (ASTree)new Member(string));
                        continue block11;
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("missing member name", this.lex));
                }
                case 35: {
                    this.lex.get();
                    int n4 = this.lex.get();
                    if (n4 != 400) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("missing static member name", this.lex));
                    }
                    String string = this.lex.getString();
                    aSTree = Expr.make(35, (ASTree)new Symbol(this.toClassName(aSTree)), (ASTree)new Member(string));
                    continue block11;
                }
            }
            break;
        }
        return aSTree;
    }

    private ASTree parseDotClass(ASTree aSTree, int n2) throws CompileError {
        String string = this.toClassName(aSTree);
        if (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            while (n2-- > 0) {
                stringBuffer.append('[');
            }
            stringBuffer.append('L').append(string.replace('.', '/')).append(';');
            string = stringBuffer.toString();
        }
        return Expr.make(46, (ASTree)new Symbol(string), (ASTree)new Member("class"));
    }

    private ASTree parseDotClass(int n2, int n3) throws CompileError {
        String string;
        if (n3 > 0) {
            String string2 = CodeGen.toJvmTypeName(n2, n3);
            return Expr.make(46, (ASTree)new Symbol(string2), (ASTree)new Member("class"));
        }
        switch (n2) {
            case 301: {
                string = "java.lang.Boolean";
                break;
            }
            case 303: {
                string = "java.lang.Byte";
                break;
            }
            case 306: {
                string = "java.lang.Character";
                break;
            }
            case 334: {
                string = "java.lang.Short";
                break;
            }
            case 324: {
                string = "java.lang.Integer";
                break;
            }
            case 326: {
                string = "java.lang.Long";
                break;
            }
            case 317: {
                string = "java.lang.Float";
                break;
            }
            case 312: {
                string = "java.lang.Double";
                break;
            }
            case 344: {
                string = "java.lang.Void";
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(new StringBuffer().append("invalid builtin type: ").append(n2).toString()));
            }
        }
        return Expr.make(35, (ASTree)new Symbol(string), (ASTree)new Member("TYPE"));
    }

    private ASTree parseMethodCall(SymbolTable symbolTable, ASTree aSTree) throws CompileError {
        int n2;
        int n3;
        if (g.convertForInstanceOf((Object)aSTree, Keyword.class) instanceof Keyword ? (n3 = ((Keyword)g.convertForCast((Object)aSTree, Keyword.class)).get()) != 339 && n3 != 336 : !(g.convertForInstanceOf((Object)aSTree, Symbol.class) instanceof Symbol) && g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr && (n2 = ((Expr)g.convertForCast((Object)aSTree, Expr.class)).getOperator()) != 46 && n2 != 35) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
        }
        return CallExpr.makeCall(aSTree, this.parseArgumentList(symbolTable));
    }

    private String toClassName(ASTree aSTree) throws CompileError {
        StringBuffer stringBuffer = new StringBuffer();
        this.toClassName(aSTree, stringBuffer);
        return stringBuffer.toString();
    }

    private void toClassName(ASTree aSTree, StringBuffer stringBuffer) throws CompileError {
        Expr expr;
        if (g.convertForInstanceOf((Object)aSTree, Symbol.class) instanceof Symbol) {
            stringBuffer.append(((Symbol)g.convertForCast((Object)aSTree, Symbol.class)).get());
            return;
        }
        if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr && (expr = (Expr)g.convertForCast((Object)aSTree, Expr.class)).getOperator() == 46) {
            this.toClassName(expr.oprand1(), stringBuffer);
            stringBuffer.append('.');
            this.toClassName(expr.oprand2(), stringBuffer);
            return;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("bad static member access", this.lex));
    }

    private ASTree parsePrimaryExpr(SymbolTable symbolTable) throws CompileError {
        int n2 = this.lex.get();
        switch (n2) {
            case 336: 
            case 339: 
            case 410: 
            case 411: 
            case 412: {
                return new Keyword(n2);
            }
            case 400: {
                String string = this.lex.getString();
                Declarator declarator = symbolTable.lookup(string);
                if (declarator == null) {
                    return new Member(string);
                }
                return new Variable(string, declarator);
            }
            case 406: {
                return new StringL(this.lex.getString());
            }
            case 328: {
                return this.parseNew(symbolTable);
            }
            case 40: {
                ASTree aSTree = this.parseExpression(symbolTable);
                if (this.lex.get() == 41) {
                    return aSTree;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(") is missing", this.lex));
            }
        }
        if (Parser.isBuiltinType(n2) || n2 == 344) {
            int n3 = this.parseArrayDimension();
            if (this.lex.get() == 46 && this.lex.get() == 307) {
                return this.parseDotClass(n2, n3);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
    }

    private NewExpr parseNew(SymbolTable symbolTable) throws CompileError {
        ArrayInit arrayInit = null;
        int n2 = this.lex.lookAhead();
        if (Parser.isBuiltinType(n2)) {
            this.lex.get();
            ASTList aSTList = this.parseArraySize(symbolTable);
            if (this.lex.lookAhead() == 123) {
                arrayInit = this.parseArrayInitializer(symbolTable);
            }
            return new NewExpr(n2, aSTList, arrayInit);
        }
        if (n2 == 400) {
            ASTList aSTList = this.parseClassType(symbolTable);
            n2 = this.lex.lookAhead();
            if (n2 == 40) {
                ASTList aSTList2 = this.parseArgumentList(symbolTable);
                return new NewExpr(aSTList, aSTList2);
            }
            if (n2 == 91) {
                ASTList aSTList3 = this.parseArraySize(symbolTable);
                if (this.lex.lookAhead() == 123) {
                    arrayInit = this.parseArrayInitializer(symbolTable);
                }
                return NewExpr.makeObjectArray(aSTList, aSTList3, arrayInit);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SyntaxError(this.lex));
    }

    private ASTList parseArraySize(SymbolTable symbolTable) throws CompileError {
        ASTList aSTList = null;
        while (this.lex.lookAhead() == 91) {
            aSTList = ASTList.append(aSTList, this.parseArrayIndex(symbolTable));
        }
        return aSTList;
    }

    private ASTree parseArrayIndex(SymbolTable symbolTable) throws CompileError {
        this.lex.get();
        if (this.lex.lookAhead() == 93) {
            this.lex.get();
            return null;
        }
        ASTree aSTree = this.parseExpression(symbolTable);
        if (this.lex.get() != 93) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("] is missing", this.lex));
        }
        return aSTree;
    }

    private ASTList parseArgumentList(SymbolTable symbolTable) throws CompileError {
        if (this.lex.get() != 40) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("( is missing", this.lex));
        }
        ASTList aSTList = null;
        if (this.lex.lookAhead() != 41) {
            while (true) {
                aSTList = ASTList.append(aSTList, this.parseExpression(symbolTable));
                if (this.lex.lookAhead() != 44) break;
                this.lex.get();
            }
        }
        if (this.lex.get() != 41) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(") is missing", this.lex));
        }
        return aSTList;
    }

    private static /* synthetic */ Lex _jr$ig$lex(Parser parser) {
        return parser.lex;
    }

    private static /* synthetic */ void _jr$ip$lex(Parser parser, Lex lex) {
        parser.lex = lex;
    }
}

