/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver$Method;
import org.zeroturnaround.bundled.javassist.compiler.NoFieldException;
import org.zeroturnaround.bundled.javassist.compiler.TokenId;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.ArrayInit;
import org.zeroturnaround.bundled.javassist.compiler.ast.AssignExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.BinExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CallExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CastExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CondExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Declarator;
import org.zeroturnaround.bundled.javassist.compiler.ast.DoubleConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Expr;
import org.zeroturnaround.bundled.javassist.compiler.ast.InstanceOfExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.IntConst;
import org.zeroturnaround.bundled.javassist.compiler.ast.Keyword;
import org.zeroturnaround.bundled.javassist.compiler.ast.Member;
import org.zeroturnaround.bundled.javassist.compiler.ast.NewExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.StringL;
import org.zeroturnaround.bundled.javassist.compiler.ast.Symbol;
import org.zeroturnaround.bundled.javassist.compiler.ast.Variable;
import org.zeroturnaround.bundled.javassist.compiler.ast.Visitor;

public class TypeChecker
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String jvmJavaLangString = "java/lang/String";
    static final String jvmJavaLangClass = "java/lang/Class";
    protected int exprType;
    protected int arrayDim;
    protected String className;
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;

    public TypeChecker(CtClass ctClass, ClassPool classPool) {
        this.resolver = new MemberResolver(classPool);
        this.thisClass = ctClass;
        this.thisMethod = null;
    }

    protected static String argTypesToString(int[] nArray, int[] nArray2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            while (true) {
                TypeChecker.typeToString(stringBuffer, nArray[n2], nArray2[n2], (String)a.arrayLoad((Object[])stringArray, (int)n2));
                if (++n2 >= n) break;
                stringBuffer.append(',');
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected static StringBuffer typeToString(StringBuffer stringBuffer, int n, int n2, String string) {
        String string2;
        if (n == 307) {
            string2 = MemberResolver.jvmToJavaName(string);
        } else if (n == 412) {
            string2 = "Object";
        } else {
            try {
                string2 = MemberResolver.getTypeName(n);
            }
            catch (CompileError compileError) {
                string2 = "?";
            }
        }
        stringBuffer.append(string2);
        while (n2-- > 0) {
            stringBuffer.append("[]");
        }
        return stringBuffer;
    }

    public void setThisMethod(MethodInfo methodInfo) {
        ((TypeChecker)((Object)((Object)this))).thisMethod = methodInfo;
    }

    protected static void fatal() throws CompileError {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("fatal"));
    }

    protected String getThisName() {
        return MemberResolver.javaToJvmName(((TypeChecker)((Object)((Object)this))).thisClass.getName());
    }

    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(((TypeChecker)((Object)((Object)this))).thisClass).getName());
    }

    protected String resolveClassName(ASTList aSTList) throws CompileError {
        return ((TypeChecker)((Object)((Object)this))).resolver.resolveClassName(aSTList);
    }

    protected String resolveClassName(String string) throws CompileError {
        return ((TypeChecker)((Object)((Object)this))).resolver.resolveJvmClassName(string);
    }

    public void atNewExpr(NewExpr newExpr) throws CompileError {
        if (newExpr.isArray()) {
            this.atNewArrayExpr(newExpr);
        } else {
            CtClass ctClass = ((TypeChecker)((Object)((Object)this))).resolver.lookupClassByName(newExpr.getClassName());
            String string = ctClass.getName();
            ASTList aSTList = newExpr.getArguments();
            this.atMethodCallCore(ctClass, "<init>", aSTList);
            ((TypeChecker)((Object)((Object)this))).exprType = 307;
            ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
            ((TypeChecker)((Object)((Object)this))).className = MemberResolver.javaToJvmName(string);
        }
    }

    public void atNewArrayExpr(NewExpr newExpr) throws CompileError {
        int n = newExpr.getArrayType();
        ASTList aSTList = newExpr.getArraySize();
        ASTList aSTList2 = newExpr.getClassName();
        ArrayInit arrayInit = newExpr.getInitializer();
        if (arrayInit != null) {
            ((ASTree)arrayInit).accept(this);
        }
        if (aSTList.length() > 1) {
            this.atMultiNewArray(n, aSTList2, aSTList);
        } else {
            ASTree aSTree = aSTList.head();
            if (aSTree != null) {
                aSTree.accept(this);
            }
            ((TypeChecker)((Object)((Object)this))).exprType = n;
            ((TypeChecker)((Object)((Object)this))).arrayDim = 1;
            if (n == 307) {
                ((TypeChecker)((Object)((Object)this))).className = this.resolveClassName(aSTList2);
            } else {
                ((TypeChecker)((Object)((Object)this))).className = null;
            }
        }
    }

    public void atArrayInit(ArrayInit arrayInit) throws CompileError {
        for (ASTList aSTList = arrayInit; aSTList != null; aSTList = aSTList.tail()) {
            ASTree aSTree = aSTList.head();
            if (aSTree == null) continue;
            aSTree.accept(this);
        }
    }

    protected void atMultiNewArray(int n, ASTList aSTList, ASTList aSTList2) throws CompileError {
        ASTree aSTree;
        int n2 = aSTList2.length();
        int n3 = 0;
        while (aSTList2 != null && (aSTree = aSTList2.head()) != null) {
            ++n3;
            aSTree.accept(this);
            aSTList2 = aSTList2.tail();
        }
        ((TypeChecker)((Object)((Object)this))).exprType = n;
        ((TypeChecker)((Object)((Object)this))).arrayDim = n2;
        if (n == 307) {
            ((TypeChecker)((Object)((Object)this))).className = this.resolveClassName(aSTList);
        } else {
            ((TypeChecker)((Object)((Object)this))).className = null;
        }
    }

    public void atAssignExpr(AssignExpr assignExpr) throws CompileError {
        int n = assignExpr.getOperator();
        ASTree aSTree = assignExpr.oprand1();
        ASTree aSTree2 = assignExpr.oprand2();
        if (g.convertForInstanceOf((Object)aSTree, Variable.class) instanceof Variable) {
            this.atVariableAssign(assignExpr, n, (Variable)g.convertForCast((Object)aSTree, Variable.class), ((Variable)g.convertForCast((Object)aSTree, Variable.class)).getDeclarator(), aSTree2);
        } else {
            Expr expr;
            if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr && (expr = (Expr)g.convertForCast((Object)aSTree, Expr.class)).getOperator() == 65) {
                this.atArrayAssign(assignExpr, n, (Expr)g.convertForCast((Object)aSTree, Expr.class), aSTree2);
                return;
            }
            this.atFieldAssign(assignExpr, n, aSTree, aSTree2);
        }
    }

    private void atVariableAssign(Expr expr, int n, Variable variable, Declarator declarator, ASTree aSTree) throws CompileError {
        int n2 = declarator.getType();
        int n3 = declarator.getArrayDim();
        String string = declarator.getClassName();
        if (n != 61) {
            this.atVariable(variable);
        }
        aSTree.accept(this);
        ((TypeChecker)((Object)((Object)this))).exprType = n2;
        ((TypeChecker)((Object)((Object)this))).arrayDim = n3;
        ((TypeChecker)((Object)((Object)this))).className = string;
    }

    private void atArrayAssign(Expr expr, int n, Expr expr2, ASTree aSTree) throws CompileError {
        this.atArrayRead(expr2.oprand1(), expr2.oprand2());
        int n2 = ((TypeChecker)((Object)((Object)this))).exprType;
        int n3 = ((TypeChecker)((Object)((Object)this))).arrayDim;
        String string = ((TypeChecker)((Object)((Object)this))).className;
        aSTree.accept(this);
        ((TypeChecker)((Object)((Object)this))).exprType = n2;
        ((TypeChecker)((Object)((Object)this))).arrayDim = n3;
        ((TypeChecker)((Object)((Object)this))).className = string;
    }

    protected void atFieldAssign(Expr expr, int n, ASTree aSTree, ASTree aSTree2) throws CompileError {
        CtField ctField = this.fieldAccess(aSTree);
        this.atFieldRead(ctField);
        int n2 = ((TypeChecker)((Object)((Object)this))).exprType;
        int n3 = ((TypeChecker)((Object)((Object)this))).arrayDim;
        String string = ((TypeChecker)((Object)((Object)this))).className;
        aSTree2.accept(this);
        ((TypeChecker)((Object)((Object)this))).exprType = n2;
        ((TypeChecker)((Object)((Object)this))).arrayDim = n3;
        ((TypeChecker)((Object)((Object)this))).className = string;
    }

    public void atCondExpr(CondExpr condExpr) throws CompileError {
        this.booleanExpr(condExpr.condExpr());
        condExpr.thenExpr().accept(this);
        int n = ((TypeChecker)((Object)((Object)this))).exprType;
        int n2 = ((TypeChecker)((Object)((Object)this))).arrayDim;
        String string = ((TypeChecker)((Object)((Object)this))).className;
        condExpr.elseExpr().accept(this);
        if (n2 == 0 && n2 == ((TypeChecker)((Object)((Object)this))).arrayDim) {
            if (CodeGen.rightIsStrong(n, ((TypeChecker)((Object)((Object)this))).exprType)) {
                condExpr.setThen((ASTree)new CastExpr(((TypeChecker)((Object)((Object)this))).exprType, 0, condExpr.thenExpr()));
            } else if (CodeGen.rightIsStrong(((TypeChecker)((Object)((Object)this))).exprType, n)) {
                condExpr.setElse((ASTree)new CastExpr(n, 0, condExpr.elseExpr()));
                ((TypeChecker)((Object)((Object)this))).exprType = n;
            }
        }
    }

    public void atBinExpr(BinExpr binExpr) throws CompileError {
        int n = binExpr.getOperator();
        int n2 = CodeGen.lookupBinOp(n);
        if (n2 >= 0) {
            if (n == 43) {
                Expr expr = this.atPlusExpr(binExpr);
                if (expr != null) {
                    expr = CallExpr.makeCall(Expr.make(46, (ASTree)expr, (ASTree)new Member("toString")), null);
                    binExpr.setOprand1(expr);
                    binExpr.setOprand2(null);
                    ((TypeChecker)((Object)((Object)this))).className = jvmJavaLangString;
                }
            } else {
                ASTree aSTree = binExpr.oprand1();
                ASTree aSTree2 = binExpr.oprand2();
                aSTree.accept(this);
                int n3 = ((TypeChecker)((Object)((Object)this))).exprType;
                aSTree2.accept(this);
                if (!this.isConstant(binExpr, n, aSTree, aSTree2)) {
                    this.computeBinExprType(binExpr, n, n3);
                }
            }
        } else {
            this.booleanExpr(binExpr);
        }
    }

    private Expr atPlusExpr(BinExpr binExpr) throws CompileError {
        ASTree aSTree = binExpr.oprand1();
        ASTree aSTree2 = binExpr.oprand2();
        if (aSTree2 == null) {
            aSTree.accept(this);
            return null;
        }
        if (TypeChecker.isPlusExpr(aSTree)) {
            Expr expr = this.atPlusExpr((BinExpr)g.convertForCast((Object)aSTree, BinExpr.class));
            if (expr != null) {
                aSTree2.accept(this);
                ((TypeChecker)((Object)((Object)this))).exprType = 307;
                ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
                ((TypeChecker)((Object)((Object)this))).className = "java/lang/StringBuffer";
                return TypeChecker.makeAppendCall(expr, aSTree2);
            }
        } else {
            aSTree.accept(this);
        }
        int n = ((TypeChecker)((Object)((Object)this))).exprType;
        int n2 = ((TypeChecker)((Object)((Object)this))).arrayDim;
        String string = ((TypeChecker)((Object)((Object)this))).className;
        aSTree2.accept(this);
        if (this.isConstant(binExpr, 43, aSTree, aSTree2)) {
            return null;
        }
        if (n == 307 && n2 == 0 && jvmJavaLangString.equals(string) || ((TypeChecker)((Object)((Object)this))).exprType == 307 && ((TypeChecker)((Object)((Object)this))).arrayDim == 0 && jvmJavaLangString.equals(((TypeChecker)((Object)((Object)this))).className)) {
            ASTList aSTList = ASTList.make(new Symbol("java"), new Symbol("lang"), new Symbol("StringBuffer"));
            NewExpr newExpr = new NewExpr(aSTList, null);
            ((TypeChecker)((Object)((Object)this))).exprType = 307;
            ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
            ((TypeChecker)((Object)((Object)this))).className = "java/lang/StringBuffer";
            return TypeChecker.makeAppendCall(TypeChecker.makeAppendCall(newExpr, aSTree), aSTree2);
        }
        this.computeBinExprType(binExpr, 43, n);
        return null;
    }

    private boolean isConstant(BinExpr binExpr, int n, ASTree aSTree, ASTree aSTree2) throws CompileError {
        aSTree = TypeChecker.stripPlusExpr(aSTree);
        aSTree2 = TypeChecker.stripPlusExpr(aSTree2);
        ASTree aSTree3 = null;
        if (g.convertForInstanceOf((Object)aSTree, StringL.class) instanceof StringL && g.convertForInstanceOf((Object)aSTree2, StringL.class) instanceof StringL && n == 43) {
            aSTree3 = new StringL(new StringBuffer().append(((StringL)g.convertForCast((Object)aSTree, StringL.class)).get()).append(((StringL)g.convertForCast((Object)aSTree2, StringL.class)).get()).toString());
        } else if (g.convertForInstanceOf((Object)aSTree, IntConst.class) instanceof IntConst) {
            aSTree3 = ((IntConst)g.convertForCast((Object)aSTree, IntConst.class)).compute(n, aSTree2);
        } else if (g.convertForInstanceOf((Object)aSTree, DoubleConst.class) instanceof DoubleConst) {
            aSTree3 = ((DoubleConst)g.convertForCast((Object)aSTree, DoubleConst.class)).compute(n, aSTree2);
        }
        if (aSTree3 == null) {
            return false;
        }
        binExpr.setOperator(43);
        binExpr.setOprand1(aSTree3);
        binExpr.setOprand2(null);
        aSTree3.accept(this);
        return true;
    }

    static ASTree stripPlusExpr(ASTree aSTree) {
        ASTree aSTree2;
        if (g.convertForInstanceOf((Object)aSTree, BinExpr.class) instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)g.convertForCast((Object)aSTree, BinExpr.class);
            if (binExpr.getOperator() == 43 && binExpr.oprand2() == null) {
                return binExpr.getLeft();
            }
        } else if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr) {
            Expr expr = (Expr)g.convertForCast((Object)aSTree, Expr.class);
            int n = expr.getOperator();
            if (n == 35) {
                ASTree aSTree3 = TypeChecker.getConstantFieldValue((Member)g.convertForCast((Object)expr.oprand2(), Member.class));
                if (aSTree3 != null) {
                    return aSTree3;
                }
            } else if (n == 43 && expr.getRight() == null) {
                return expr.getLeft();
            }
        } else if (g.convertForInstanceOf((Object)aSTree, Member.class) instanceof Member && (aSTree2 = TypeChecker.getConstantFieldValue((Member)g.convertForCast((Object)aSTree, Member.class))) != null) {
            return aSTree2;
        }
        return aSTree;
    }

    private static ASTree getConstantFieldValue(Member member) {
        return TypeChecker.getConstantFieldValue(member.getField());
    }

    public static ASTree getConstantFieldValue(CtField ctField) {
        if (ctField == null) {
            return null;
        }
        Object object = ctField.getConstantValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringL((String)object);
        }
        if (object instanceof Double || g.convertForInstanceOf((Object)object, Float.class) instanceof Float) {
            int n = object instanceof Double ? 405 : 404;
            return new DoubleConst(((Number)g.convertForCast((Object)object, Number.class)).doubleValue(), n);
        }
        if (g.convertForInstanceOf((Object)object, Number.class) instanceof Number) {
            int n = g.convertForInstanceOf((Object)object, Long.class) instanceof Long ? 403 : 402;
            return new IntConst(((Number)g.convertForCast((Object)object, Number.class)).longValue(), n);
        }
        if (g.convertForInstanceOf((Object)object, Boolean.class) instanceof Boolean) {
            return new Keyword((Boolean)g.convertForCast((Object)object, Boolean.class) != false ? 410 : 411);
        }
        return null;
    }

    private static boolean isPlusExpr(ASTree aSTree) {
        if (g.convertForInstanceOf((Object)aSTree, BinExpr.class) instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)g.convertForCast((Object)aSTree, BinExpr.class);
            int n = binExpr.getOperator();
            return n == 43;
        }
        return false;
    }

    private static Expr makeAppendCall(ASTree aSTree, ASTree aSTree2) {
        return CallExpr.makeCall(Expr.make(46, aSTree, (ASTree)new Member("append")), new ASTList(aSTree2));
    }

    private void computeBinExprType(BinExpr binExpr, int n, int n2) throws CompileError {
        int n3 = ((TypeChecker)((Object)((Object)this))).exprType;
        if (n == 364 || n == 366 || n == 370) {
            ((TypeChecker)((Object)((Object)this))).exprType = n2;
        } else {
            this.insertCast(binExpr, n2, n3);
        }
        if (CodeGen.isP_INT(((TypeChecker)((Object)((Object)this))).exprType) && ((TypeChecker)((Object)((Object)this))).exprType != 301) {
            ((TypeChecker)((Object)((Object)this))).exprType = 324;
        }
    }

    private void booleanExpr(ASTree aSTree) throws CompileError {
        int n = CodeGen.getCompOperator(aSTree);
        if (n == 358) {
            BinExpr binExpr = (BinExpr)g.convertForCast((Object)aSTree, BinExpr.class);
            binExpr.oprand1().accept(this);
            int n2 = ((TypeChecker)((Object)((Object)this))).exprType;
            int n3 = ((TypeChecker)((Object)((Object)this))).arrayDim;
            binExpr.oprand2().accept(this);
            if (n3 == 0 && ((TypeChecker)((Object)((Object)this))).arrayDim == 0) {
                this.insertCast(binExpr, n2, ((TypeChecker)((Object)((Object)this))).exprType);
            }
        } else if (n == 33) {
            ((Expr)g.convertForCast((Object)aSTree, Expr.class)).oprand1().accept(this);
        } else if (n == 369 || n == 368) {
            BinExpr binExpr = (BinExpr)g.convertForCast((Object)aSTree, BinExpr.class);
            binExpr.oprand1().accept(this);
            binExpr.oprand2().accept(this);
        } else {
            aSTree.accept(this);
        }
        ((TypeChecker)((Object)((Object)this))).exprType = 301;
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
    }

    private void insertCast(BinExpr binExpr, int n, int n2) throws CompileError {
        if (CodeGen.rightIsStrong(n, n2)) {
            binExpr.setLeft((ASTree)new CastExpr(n2, 0, binExpr.oprand1()));
        } else {
            ((TypeChecker)((Object)((Object)this))).exprType = n;
        }
    }

    public void atCastExpr(CastExpr castExpr) throws CompileError {
        String string = this.resolveClassName(castExpr.getClassName());
        castExpr.getOprand().accept(this);
        ((TypeChecker)((Object)((Object)this))).exprType = castExpr.getType();
        ((TypeChecker)((Object)((Object)this))).arrayDim = castExpr.getArrayDim();
        ((TypeChecker)((Object)((Object)this))).className = string;
    }

    public void atInstanceOfExpr(InstanceOfExpr instanceOfExpr) throws CompileError {
        instanceOfExpr.getOprand().accept(this);
        ((TypeChecker)((Object)((Object)this))).exprType = 301;
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
    }

    public void atExpr(Expr expr) throws CompileError {
        int n = expr.getOperator();
        ASTree aSTree = expr.oprand1();
        if (n == 46) {
            String string = ((Symbol)g.convertForCast((Object)expr.oprand2(), Symbol.class)).get();
            if (string.equals("length")) {
                try {
                    this.atArrayLength(expr);
                }
                catch (NoFieldException noFieldException) {
                    this.atFieldRead(expr);
                }
            } else if (string.equals("class")) {
                this.atClassObject(expr);
            } else {
                this.atFieldRead(expr);
            }
        } else if (n == 35) {
            String string = ((Symbol)g.convertForCast((Object)expr.oprand2(), Symbol.class)).get();
            if (string.equals("class")) {
                this.atClassObject(expr);
            } else {
                this.atFieldRead(expr);
            }
        } else if (n == 65) {
            this.atArrayRead(aSTree, expr.oprand2());
        } else if (n == 362 || n == 363) {
            this.atPlusPlus(n, aSTree, expr);
        } else if (n == 33) {
            this.booleanExpr(expr);
        } else if (n == 67) {
            TypeChecker.fatal();
        } else {
            aSTree.accept(this);
            if (!this.isConstant(expr, n, aSTree) && (n == 45 || n == 126) && CodeGen.isP_INT(((TypeChecker)((Object)((Object)this))).exprType)) {
                ((TypeChecker)((Object)((Object)this))).exprType = 324;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConstant(Expr expr, int n, ASTree aSTree) {
        if (g.convertForInstanceOf((Object)(aSTree = TypeChecker.stripPlusExpr(aSTree)), IntConst.class) instanceof IntConst) {
            IntConst intConst = (IntConst)g.convertForCast((Object)aSTree, IntConst.class);
            long l = intConst.get();
            if (n == 45) {
                l = -l;
            } else {
                if (n != 126) return false;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            intConst.set(l);
        } else {
            if (!(g.convertForInstanceOf((Object)aSTree, DoubleConst.class) instanceof DoubleConst)) return false;
            DoubleConst doubleConst = (DoubleConst)g.convertForCast((Object)aSTree, DoubleConst.class);
            if (n != 45) return false;
            doubleConst.set(-doubleConst.get());
        }
        expr.setOperator(43);
        return true;
    }

    public void atCallExpr(CallExpr callExpr) throws CompileError {
        h h2;
        String string = null;
        CtClass ctClass = null;
        ASTree aSTree = callExpr.oprand1();
        ASTList aSTList = (ASTList)g.convertForCast((Object)callExpr.oprand2(), ASTList.class);
        if (g.convertForInstanceOf((Object)aSTree, Member.class) instanceof Member) {
            string = ((Member)g.convertForCast((Object)aSTree, Member.class)).get();
            ctClass = ((TypeChecker)((Object)((Object)this))).thisClass;
        } else if (g.convertForInstanceOf((Object)aSTree, Keyword.class) instanceof Keyword) {
            string = "<init>";
            ctClass = ((Keyword)g.convertForCast((Object)aSTree, Keyword.class)).get() == 336 ? MemberResolver.getSuperclass(((TypeChecker)((Object)((Object)this))).thisClass) : ((TypeChecker)((Object)((Object)this))).thisClass;
        } else if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr) {
            h2 = (Expr)g.convertForCast((Object)aSTree, Expr.class);
            string = ((Symbol)g.convertForCast((Object)h2.oprand2(), Symbol.class)).get();
            int n = h2.getOperator();
            if (n == 35) {
                ctClass = ((TypeChecker)((Object)((Object)this))).resolver.lookupClass(((Symbol)g.convertForCast((Object)h2.oprand1(), Symbol.class)).get(), false);
            } else if (n == 46) {
                ASTree aSTree2 = h2.oprand1();
                String string2 = TypeChecker.isDotSuper(aSTree2);
                if (string2 != null) {
                    ctClass = MemberResolver.getSuperInterface(((TypeChecker)((Object)((Object)this))).thisClass, string2);
                } else {
                    try {
                        aSTree2.accept(this);
                    }
                    catch (NoFieldException noFieldException) {
                        if (f.ifAcmp((Object)noFieldException.getExpr(), (Object)aSTree2)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)noFieldException);
                        }
                        ((TypeChecker)((Object)((Object)this))).exprType = 307;
                        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
                        ((TypeChecker)((Object)((Object)this))).className = noFieldException.getField();
                        h2.setOperator(35);
                        h2.setOprand1(new Symbol(MemberResolver.jvmToJavaName(((TypeChecker)((Object)((Object)this))).className)));
                    }
                    if (((TypeChecker)((Object)((Object)this))).arrayDim > 0) {
                        ctClass = ((TypeChecker)((Object)((Object)this))).resolver.lookupClass(javaLangObject, true);
                    } else if (((TypeChecker)((Object)((Object)this))).exprType == 307) {
                        ctClass = ((TypeChecker)((Object)((Object)this))).resolver.lookupClassByJvmName(((TypeChecker)((Object)((Object)this))).className);
                    } else {
                        TypeChecker.badMethod();
                    }
                }
            } else {
                TypeChecker.badMethod();
            }
        } else {
            TypeChecker.fatal();
        }
        h2 = this.atMethodCallCore(ctClass, string, aSTList);
        callExpr.setMethod((MemberResolver$Method)h2);
    }

    private static void badMethod() throws CompileError {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("bad method"));
    }

    static String isDotSuper(ASTree aSTree) {
        ASTree aSTree2;
        Expr expr;
        if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr && (expr = (Expr)g.convertForCast((Object)aSTree, Expr.class)).getOperator() == 46 && g.convertForInstanceOf((Object)(aSTree2 = expr.oprand2()), Keyword.class) instanceof Keyword && ((Keyword)g.convertForCast((Object)aSTree2, Keyword.class)).get() == 336) {
            return ((Symbol)g.convertForCast((Object)expr.oprand1(), Symbol.class)).get();
        }
        return null;
    }

    public MemberResolver$Method atMethodCallCore(CtClass ctClass, String string, ASTList aSTList) throws CompileError {
        int n = this.getMethodArgsLength(aSTList);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        String[] stringArray = new String[n];
        this.atMethodArgs(aSTList, nArray, nArray2, stringArray);
        MemberResolver$Method memberResolver$Method = ((TypeChecker)((Object)((Object)this))).resolver.lookupMethod(ctClass, ((TypeChecker)((Object)((Object)this))).thisClass, ((TypeChecker)((Object)((Object)this))).thisMethod, string, nArray, nArray2, stringArray);
        if (memberResolver$Method == null) {
            String string2 = ctClass.getName();
            String string3 = TypeChecker.argTypesToString(nArray, nArray2, stringArray);
            String string4 = string.equals("<init>") ? new StringBuffer().append("cannot find constructor ").append(string2).append(string3).toString() : new StringBuffer().append(string).append(string3).append(" not found in ").append(string2).toString();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError(string4));
        }
        String string5 = MemberResolver$Method._jr$ig$info((Object)memberResolver$Method).getDescriptor();
        this.setReturnType(string5);
        return memberResolver$Method;
    }

    public int getMethodArgsLength(ASTList aSTList) {
        return ASTList.length(aSTList);
    }

    public void atMethodArgs(ASTList aSTList, int[] nArray, int[] nArray2, String[] stringArray) throws CompileError {
        int n = 0;
        while (aSTList != null) {
            ASTree aSTree = aSTList.head();
            aSTree.accept(this);
            nArray[n] = ((TypeChecker)((Object)((Object)this))).exprType;
            nArray2[n] = ((TypeChecker)((Object)((Object)this))).arrayDim;
            a.arrayStore((Object[])stringArray, (int)n, (Object)((TypeChecker)((Object)((Object)this))).className);
            ++n;
            aSTList = aSTList.tail();
        }
    }

    void setReturnType(String string) throws CompileError {
        int n = string.indexOf(41);
        if (n < 0) {
            TypeChecker.badMethod();
        }
        char c = string.charAt(++n);
        int n2 = 0;
        while (c == '[') {
            ++n2;
            c = string.charAt(++n);
        }
        ((TypeChecker)((Object)((Object)this))).arrayDim = n2;
        if (c == 'L') {
            int n3 = string.indexOf(59, n + 1);
            if (n3 < 0) {
                TypeChecker.badMethod();
            }
            ((TypeChecker)((Object)((Object)this))).exprType = 307;
            ((TypeChecker)((Object)((Object)this))).className = string.substring(n + 1, n3);
        } else {
            ((TypeChecker)((Object)((Object)this))).exprType = MemberResolver.descToType(c);
            ((TypeChecker)((Object)((Object)this))).className = null;
        }
    }

    private void atFieldRead(ASTree aSTree) throws CompileError {
        this.atFieldRead(this.fieldAccess(aSTree));
    }

    private void atFieldRead(CtField ctField) throws CompileError {
        FieldInfo fieldInfo = ctField.getFieldInfo2();
        String string = fieldInfo.getDescriptor();
        int n = 0;
        int n2 = 0;
        char c = string.charAt(n);
        while (c == '[') {
            ++n2;
            c = string.charAt(++n);
        }
        ((TypeChecker)((Object)((Object)this))).arrayDim = n2;
        ((TypeChecker)((Object)((Object)this))).exprType = MemberResolver.descToType(c);
        if (c == 'L') {
            ((TypeChecker)((Object)((Object)this))).className = string.substring(n + 1, string.indexOf(59, n + 1));
        } else {
            ((TypeChecker)((Object)((Object)this))).className = null;
        }
    }

    protected CtField fieldAccess(ASTree aSTree) throws CompileError {
        if (g.convertForInstanceOf((Object)aSTree, Member.class) instanceof Member) {
            Member member = (Member)g.convertForCast((Object)aSTree, Member.class);
            String string = member.get();
            try {
                CtField ctField = ((TypeChecker)((Object)((Object)this))).thisClass.getField(string);
                if (Modifier.isStatic(ctField.getModifiers())) {
                    member.setField(ctField);
                }
                return ctField;
            }
            catch (NotFoundException notFoundException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoFieldException(string, aSTree));
            }
        }
        if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr) {
            Expr expr = (Expr)g.convertForCast((Object)aSTree, Expr.class);
            int n = expr.getOperator();
            if (n == 35) {
                Member member = (Member)g.convertForCast((Object)expr.oprand2(), Member.class);
                CtField ctField = ((TypeChecker)((Object)((Object)this))).resolver.lookupField(((Symbol)g.convertForCast((Object)expr.oprand1(), Symbol.class)).get(), member);
                member.setField(ctField);
                return ctField;
            }
            if (n == 46) {
                try {
                    expr.oprand1().accept(this);
                }
                catch (NoFieldException noFieldException) {
                    if (f.ifAcmp((Object)noFieldException.getExpr(), (Object)expr.oprand1())) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)noFieldException);
                    }
                    return this.fieldAccess2(expr, noFieldException.getField());
                }
                CompileError compileError = null;
                try {
                    if (((TypeChecker)((Object)((Object)this))).exprType == 307 && ((TypeChecker)((Object)((Object)this))).arrayDim == 0) {
                        return ((TypeChecker)((Object)((Object)this))).resolver.lookupFieldByJvmName(((TypeChecker)((Object)((Object)this))).className, (Symbol)g.convertForCast((Object)expr.oprand2(), Symbol.class));
                    }
                }
                catch (CompileError compileError2) {
                    compileError = compileError2;
                }
                ASTree aSTree2 = expr.oprand1();
                if (g.convertForInstanceOf((Object)aSTree2, Symbol.class) instanceof Symbol) {
                    return this.fieldAccess2(expr, ((Symbol)g.convertForCast((Object)aSTree2, Symbol.class)).get());
                }
                if (compileError != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)compileError);
                }
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CompileError("bad filed access"));
    }

    private CtField fieldAccess2(Expr expr, String string) throws CompileError {
        Member member = (Member)g.convertForCast((Object)expr.oprand2(), Member.class);
        CtField ctField = ((TypeChecker)((Object)((Object)this))).resolver.lookupFieldByJvmName2(string, member, expr);
        expr.setOperator(35);
        expr.setOprand1(new Symbol(MemberResolver.jvmToJavaName(string)));
        member.setField(ctField);
        return ctField;
    }

    public void atClassObject(Expr expr) throws CompileError {
        ((TypeChecker)((Object)((Object)this))).exprType = 307;
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
        ((TypeChecker)((Object)((Object)this))).className = jvmJavaLangClass;
    }

    public void atArrayLength(Expr expr) throws CompileError {
        expr.oprand1().accept(this);
        if (((TypeChecker)((Object)((Object)this))).arrayDim == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoFieldException("length", expr));
        }
        ((TypeChecker)((Object)((Object)this))).exprType = 324;
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
    }

    public void atArrayRead(ASTree aSTree, ASTree aSTree2) throws CompileError {
        aSTree.accept(this);
        int n = ((TypeChecker)((Object)((Object)this))).exprType;
        int n2 = ((TypeChecker)((Object)((Object)this))).arrayDim;
        String string = ((TypeChecker)((Object)((Object)this))).className;
        aSTree2.accept(this);
        ((TypeChecker)((Object)((Object)this))).exprType = n;
        ((TypeChecker)((Object)((Object)this))).arrayDim = n2 - 1;
        ((TypeChecker)((Object)((Object)this))).className = string;
    }

    private void atPlusPlus(int n, ASTree aSTree, Expr expr) throws CompileError {
        boolean bl;
        boolean bl2 = bl = aSTree == null;
        if (bl) {
            aSTree = expr.oprand2();
        }
        if (g.convertForInstanceOf((Object)aSTree, Variable.class) instanceof Variable) {
            Declarator declarator = ((Variable)g.convertForCast((Object)aSTree, Variable.class)).getDeclarator();
            ((TypeChecker)((Object)((Object)this))).exprType = declarator.getType();
            ((TypeChecker)((Object)((Object)this))).arrayDim = declarator.getArrayDim();
        } else {
            Expr expr2;
            if (g.convertForInstanceOf((Object)aSTree, Expr.class) instanceof Expr && (expr2 = (Expr)g.convertForCast((Object)aSTree, Expr.class)).getOperator() == 65) {
                this.atArrayRead(expr2.oprand1(), expr2.oprand2());
                int n2 = ((TypeChecker)((Object)((Object)this))).exprType;
                if (n2 == 324 || n2 == 303 || n2 == 306 || n2 == 334) {
                    ((TypeChecker)((Object)((Object)this))).exprType = 324;
                }
                return;
            }
            this.atFieldPlusPlus(aSTree);
        }
    }

    protected void atFieldPlusPlus(ASTree aSTree) throws CompileError {
        CtField ctField = this.fieldAccess(aSTree);
        this.atFieldRead(ctField);
        int n = ((TypeChecker)((Object)((Object)this))).exprType;
        if (n == 324 || n == 303 || n == 306 || n == 334) {
            ((TypeChecker)((Object)((Object)this))).exprType = 324;
        }
    }

    public void atMember(Member member) throws CompileError {
        this.atFieldRead(member);
    }

    public void atVariable(Variable variable) throws CompileError {
        Declarator declarator = variable.getDeclarator();
        ((TypeChecker)((Object)((Object)this))).exprType = declarator.getType();
        ((TypeChecker)((Object)((Object)this))).arrayDim = declarator.getArrayDim();
        ((TypeChecker)((Object)((Object)this))).className = declarator.getClassName();
    }

    public void atKeyword(Keyword keyword) throws CompileError {
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
        int n = keyword.get();
        switch (n) {
            case 410: 
            case 411: {
                ((TypeChecker)((Object)((Object)this))).exprType = 301;
                break;
            }
            case 412: {
                ((TypeChecker)((Object)((Object)this))).exprType = 412;
                break;
            }
            case 336: 
            case 339: {
                ((TypeChecker)((Object)((Object)this))).exprType = 307;
                if (n == 339) {
                    ((TypeChecker)((Object)((Object)this))).className = this.getThisName();
                    break;
                }
                ((TypeChecker)((Object)((Object)this))).className = this.getSuperName();
                break;
            }
            default: {
                TypeChecker.fatal();
            }
        }
    }

    public void atStringL(StringL stringL) throws CompileError {
        ((TypeChecker)((Object)((Object)this))).exprType = 307;
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
        ((TypeChecker)((Object)((Object)this))).className = jvmJavaLangString;
    }

    public void atIntConst(IntConst intConst) throws CompileError {
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
        int n = intConst.getType();
        if (n == 402 || n == 401) {
            ((TypeChecker)((Object)((Object)this))).exprType = n == 402 ? 324 : 306;
        } else {
            ((TypeChecker)((Object)((Object)this))).exprType = 326;
        }
    }

    public void atDoubleConst(DoubleConst doubleConst) throws CompileError {
        ((TypeChecker)((Object)((Object)this))).arrayDim = 0;
        if (doubleConst.getType() == 405) {
            ((TypeChecker)((Object)((Object)this))).exprType = 312;
        } else {
            ((TypeChecker)((Object)((Object)this))).exprType = 317;
        }
    }

    protected static /* synthetic */ void _jr$ip$resolver(Object object, MemberResolver memberResolver) {
        ((TypeChecker)((Object)object)).resolver = memberResolver;
    }

    protected static /* synthetic */ void _jr$ip$thisClass(Object object, CtClass ctClass) {
        ((TypeChecker)((Object)object)).thisClass = ctClass;
    }

    protected /* synthetic */ TypeChecker(h h2) {
        super(h2);
    }
}

