/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class StandardClassLoaderCBP
extends JavassistClassBytecodeProcessor {
    public StandardClassLoaderCBP() {
    }

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.generic");
        this.patchFindClass(ctClass);
        this.patchFindResource(classPool, ctClass);
        this.patchFindResources(classPool, ctClass);
    }

    private void patchFindClass(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod = ctClass.getMethod("findClass", "(Ljava/lang/String;)Ljava/lang/Class;");
        ctMethod.insertBefore("{ synchronized ($0) {    Class result =      findLoadedClass($1);    if (result != null)      return result;    result =       IntegrationFactory.getInstance().findReloadableClass($0, $1);    if (result != null)      return result;}}");
    }

    private void patchFindResource(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        try {
            CtClass[] ctClassArray = classPool.get(new String[]{x.getName(String.class)});
            CtMethod ctMethod = ctClass.getDeclaredMethod("findResource", ctClassArray);
            ctMethod.insertBefore("Integration integration = IntegrationFactory.getInstance();if (integration.isResourceReplaced($0, $1)) {    return integration.findResource($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void patchFindResources(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        try {
            CtClass[] ctClassArray = classPool.get(new String[]{x.getName(String.class)});
            CtMethod ctMethod = ctClass.getDeclaredMethod("findResources", ctClassArray);
            ctMethod.insertBefore("Integration integration = IntegrationFactory.getInstance();if (integration.isResourceReplaced($0, $1)) {  return integration.findResources($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected /* synthetic */ StandardClassLoaderCBP(h h2) {
        super(h2);
    }
}

