/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.resin;

import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.IOException;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.javarebel.MiscIntegrationFactory;
import org.zeroturnaround.javarebel.integration.resin.ResinPatchHelper;
import org.zeroturnaround.javarebel.integration.resin.WatchdogProcessCBP;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class WatchdogProcessCBP
extends JavassistClassBytecodeProcessor {
    private static final char CLASSPATH_SEPARATOR = File.pathSeparatorChar;
    private File cachedJar;
    static Class class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader;

    public WatchdogProcessCBP() {
    }

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("java.io");
        classPool.importPackage("java.net");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.resin");
        if (MiscIntegrationFactory.getInstance().isLegacyAgent() && !this.isWatchdogClasspathPatched(classPool)) {
            this.patchServerClasspath(ctClass, this.getPatchedJar(classLoader));
        }
        this.processConnectToChild(ctClass);
        this.processCreateProcess(classLoader, ctClass);
    }

    private boolean isWatchdogClasspathPatched(ClassPool classPool) {
        return classPool.getOrNull("com.caucho.boot.ResinWatchdogManager") != null;
    }

    private File getPatchedJar(ClassLoader classLoader) throws IOException {
        if (this.cachedJar == null) {
            this.cachedJar = ResinPatchHelper.createResinPatch((ClassLoader)classLoader);
        }
        return this.cachedJar;
    }

    private void patchServerClasspath(CtClass ctClass, File file) throws CannotCompileException, NotFoundException {
        this.getClasspathDefiningMethod(ctClass).instrument((ExprEditor)new 1(this, file));
    }

    private CtMethod getClasspathDefiningMethod(CtClass ctClass) throws NotFoundException {
        try {
            return ctClass.getDeclaredMethod("buildEnv");
        }
        catch (NotFoundException notFoundException) {
            return ctClass.getDeclaredMethod("createProcess");
        }
    }

    private void processConnectToChild(CtClass ctClass) throws CannotCompileException {
        boolean bl = ctClass.getName().endsWith("WatchdogProcess");
        try {
            CtMethod ctMethod = ctClass.getDeclaredMethod("connectToChild");
            if (bl) {
                ctMethod.insertBefore(new StringBuffer().append(x.getName((Class)(class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader == null ? (class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader = WatchdogProcessCBP.class$("org.zeroturnaround.javarebel.integration.resin.ResinOutputReader")) : class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader))).append(".start($2, $3);").toString());
                ctMethod.insertAfter(new StringBuffer().append(x.getName((Class)(class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader == null ? (class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader = WatchdogProcessCBP.class$("org.zeroturnaround.javarebel.integration.resin.ResinOutputReader")) : class$org$zeroturnaround$javarebel$integration$resin$ResinOutputReader))).append(".terminate();").toString(), true);
            }
            ctMethod.instrument((ExprEditor)new 2(this, bl));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void processCreateProcess(ClassLoader classLoader, CtClass ctClass) throws Exception {
        ctClass.getDeclaredMethod("createProcess").instrument((ExprEditor)new 3(this));
    }

    static char access$000() {
        return CLASSPATH_SEPARATOR;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NoClassDefFoundError().initCause(classNotFoundException));
        }
    }

    protected /* synthetic */ WatchdogProcessCBP(h h2) {
        super(h2);
    }
}

