/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class AvoidDuplicatePatchingCBP
extends JavassistClassBytecodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger("SDK-CBP");
    private static final String FIELD = "jrAlreadyPatched";
    private final JavassistClassBytecodeProcessor cbp;
    private final String cbpName;

    public AvoidDuplicatePatchingCBP(JavassistClassBytecodeProcessor javassistClassBytecodeProcessor) {
        this(javassistClassBytecodeProcessor, x.getName(((Object)((Object)javassistClassBytecodeProcessor)).getClass()));
    }

    public AvoidDuplicatePatchingCBP(JavassistClassBytecodeProcessor javassistClassBytecodeProcessor, String string) {
        this.cbp = javassistClassBytecodeProcessor;
        this.cbpName = string;
    }

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        LOG.info("Check for duplicate patching of class: " + ctClass.getName() + " by: " + this.cbpName);
        if (!this.isAlreadyPatched(ctClass, this.cbp)) {
            LOG.info("Patching class: " + ctClass.getName() + " by: " + this.cbpName);
            this.cbp.process(classPool, classLoader, ctClass);
            this.setAlreadyPatched(ctClass, this.cbp);
        } else {
            LOG.info("Class: " + ctClass.getName() + " already patched, skipping: " + this.cbpName);
        }
    }

    private boolean isAlreadyPatched(CtClass ctClass, JavassistClassBytecodeProcessor javassistClassBytecodeProcessor) throws Exception {
        try {
            CtField ctField = ctClass.getDeclaredField(FIELD);
            String[] stringArray = ((String)ctField.getConstantValue()).split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.equals(this.cbpName)) continue;
                return true;
            }
            return false;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    private void setAlreadyPatched(CtClass ctClass, JavassistClassBytecodeProcessor javassistClassBytecodeProcessor) throws Exception {
        try {
            CtField ctField = ctClass.getDeclaredField(FIELD);
            String string = (String)ctField.getConstantValue();
            ctClass.removeField(ctField);
            ctClass.addField(CtField.make((ctClass.isInterface() ? "public" : "private") + " static final String " + FIELD + " = \"" + string + "," + this.cbpName + "\";", ctClass));
        }
        catch (NotFoundException notFoundException) {
            ctClass.addField(CtField.make((ctClass.isInterface() ? "public" : "private") + " static final String " + FIELD + " = \"" + this.cbpName + "\";", ctClass));
        }
    }

    private static /* synthetic */ void _jr$ip$cbp(AvoidDuplicatePatchingCBP avoidDuplicatePatchingCBP, JavassistClassBytecodeProcessor javassistClassBytecodeProcessor) {
        avoidDuplicatePatchingCBP.cbp = javassistClassBytecodeProcessor;
    }

    private static /* synthetic */ void _jr$ip$cbpName(AvoidDuplicatePatchingCBP avoidDuplicatePatchingCBP, String string) {
        avoidDuplicatePatchingCBP.cbpName = string;
    }

    protected /* synthetic */ AvoidDuplicatePatchingCBP(h h2) {
        super(h2);
    }
}

