/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import com.zeroturnaround.javarebel.avn;
import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FileUtil
extends h {
    private static final Logger log = LoggerFactory.getLogger("Util");

    public FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (log.isEnabled()) {
            log.log("Copying " + file + " to " + file2);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            FileUtil.copy(fileInputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(fileInputStream);
            FileUtil.closeQuietly(fileOutputStream);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        FileUtil.closeQuietly(fileInputStream);
        FileUtil.closeQuietly(fileOutputStream);
    }

    public static void copyAndClose(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.copy(inputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(inputStream);
            FileUtil.closeQuietly(fileOutputStream);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        FileUtil.closeQuietly(inputStream);
        FileUtil.closeQuietly(fileOutputStream);
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (log.isEnabled()) {
            log.log("Deleting " + file);
        }
        FileUtil.doForceDelete(file);
        if (log.isEnabled()) {
            log.log("Deleted " + file);
        }
    }

    private static void doForceDelete(File file) throws IOException {
        Object[] objectArray;
        if (file.isDirectory() && (objectArray = file.listFiles()) != null) {
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                FileUtil.doForceDelete((File)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), File.class));
            }
        }
        FileUtil.delete(file);
    }

    private static void delete(File file) throws IOException {
        Boolean bl = (Boolean)g.convertForCast(AccessController.doPrivileged(new 1(file)), Boolean.class);
        if (!bl.booleanValue()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Could not delete " + file));
        }
    }

    public static String getExtension(File file) {
        String string = file.getPath();
        int n2 = string.lastIndexOf(46);
        return n2 == -1 ? null : string.substring(n2 + 1);
    }

    private static void closeQuietly(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean canWriteToDir(File file) {
        boolean bl;
        if (file == null) {
            return false;
        }
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        if (!(file.isDirectory() && file.canRead() && file.canWrite())) {
            return false;
        }
        String string = "permissions_check_" + System.currentTimeMillis() % 1000L;
        File file2 = new File(file, string);
        try {
            file2.createNewFile();
            bl = file2.canRead() && file2.canWrite();
        }
        catch (IOException iOException) {
            boolean bl2 = false;
            avn.a((File)file2);
            return bl2;
        }
        catch (SecurityException securityException) {
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    avn.a((File)file2);
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            avn.a((File)file2);
            return bl3;
        }
        avn.a((File)file2);
        return bl;
    }

    public static Collection<File> getUniqueParentDirs(Collection<File> collection) {
        File file;
        if (collection.size() < 2) {
            return collection;
        }
        ArrayList<File> arrayList = new ArrayList<File>(collection.size());
        ArrayList<FileEntry> arrayList2 = new ArrayList<FileEntry>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        Iterator<File> iterator = collection.iterator();
        while (iterator.hasNext()) {
            file = (File)g.convertForCast((Object)iterator.next(), File.class);
            try {
                arrayList2.add(new FileEntry(file, null));
            }
            catch (IOException iOException) {
                log.error("Unable to resolve file canonical path for " + file, (Throwable)iOException);
                arrayList3.add(file);
            }
        }
        Collections.sort(arrayList2);
        iterator = arrayList2.iterator();
        block3: while (iterator.hasNext()) {
            file = (FileEntry)g.convertForCast((Object)iterator.next(), FileEntry.class);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                FileEntry fileEntry = (FileEntry)g.convertForCast(iterator2.next(), FileEntry.class);
                if (!FileEntry.access$100((FileEntry)file, (FileEntry)fileEntry)) continue;
                continue block3;
            }
            arrayList.add(file);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            file = (FileEntry)g.convertForCast((Object)iterator.next(), FileEntry.class);
            arrayList3.add(FileEntry.access$200((FileEntry)file));
        }
        return arrayList3;
    }

    protected /* synthetic */ FileUtil(h h2) {
        super(h2);
    }
}

