/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.ResourceSource;
import org.zeroturnaround.javarebel.integration.util.IoUtil;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;
import org.zeroturnaround.javarebel.support.FileResource;
import org.zeroturnaround.javarebel.support.ResourceUtils;
import org.zeroturnaround.javarebel.support.URLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil
extends h {
    private static final Method FIND_RESOURCE_METHOD;
    private static final Method FIND_RESOURCES_METHOD;

    public ResourceUtil() {
    }

    private static Method getClassLoaderMethod(String string, Class<?>[] classArray) {
        Method method = null;
        try {
            aj aj2 = ai.convertArgsAndName(ClassLoader.class, (String)string, (Class[])classArray);
            method = aj2.clazz.getDeclaredMethod(aj2.name, aj2.args);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerFactory.getLogger("Util").errorEcho((Throwable)noSuchMethodException);
        }
        return method;
    }

    public static URL findResource(ClassLoader classLoader, String string) {
        URL uRL;
        if (string == null) {
            return null;
        }
        if (g.convertForInstanceOf((Object)((Object)classLoader), URLClassLoader.class) instanceof URLClassLoader) {
            uRL = ((URLClassLoader)g.convertForCast((Object)((Object)classLoader), URLClassLoader.class)).findResource(string);
        } else {
            try {
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)string);
                uRL = (URL)g.convertForCast((Object)FIND_RESOURCE_METHOD.invoke((Object)classLoader, objectArray), URL.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(illegalArgumentException));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(invocationTargetException.getTargetException()));
            }
        }
        return uRL;
    }

    public static URL[] findResources(ClassLoader classLoader, String string) {
        Enumeration enumeration;
        if (g.convertForInstanceOf((Object)((Object)classLoader), URLClassLoader.class) instanceof URLClassLoader) {
            try {
                enumeration = ((URLClassLoader)g.convertForCast((Object)((Object)classLoader), URLClassLoader.class)).findResources(string);
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
            }
        }
        try {
            enumeration = (Enumeration)g.convertForCast((Object)FIND_RESOURCES_METHOD.invoke((Object)classLoader, string), Enumeration.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(illegalArgumentException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(invocationTargetException.getTargetException()));
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] findResources(URLClassLoader uRLClassLoader, String string) {
        Enumeration<URL> enumeration;
        try {
            enumeration = uRLClassLoader.findResources(string);
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] toURLs(Enumeration<URL> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((URL)g.convertForCast((Object)enumeration.nextElement(), URL.class));
        }
        return (URL[])g.convertForCast((Object)((URL[])g.convertForCast((Object)arrayList.toArray(new URL[arrayList.size()]), URL[].class)), URL[].class);
    }

    public static Enumeration<URL> toEnumeration(URL[] uRLArray) {
        return new Vector<URL>(Arrays.asList(uRLArray)).elements();
    }

    public static Enumeration<URL> toEnumeration(File file) {
        Object[] objectArray = new URL[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)IoUtil.getURL(file));
        return new Vector<Object>(Arrays.asList(objectArray)).elements();
    }

    public static URL[] concat(URL[] uRLArray, URL[] uRLArray2) {
        if (uRLArray == null) {
            return uRLArray2;
        }
        if (uRLArray2 == null) {
            return uRLArray;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(Arrays.asList(uRLArray));
        arrayList.addAll(Arrays.asList(uRLArray2));
        return (URL[])g.convertForCast((Object)arrayList.toArray(new URL[arrayList.size()]), URL[].class);
    }

    public static String concatClassPath(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    public static String toClassPath(URL[] uRLArray) {
        if (uRLArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < a.arrayLength((Object[])uRLArray); ++i) {
            URL uRL = (URL)g.convertForCast((Object)a.arrayLoad((Object[])uRLArray, (int)i), URL.class);
            File file = ResourceUtils.getFile(uRL);
            stringBuilder.append(file.getPath());
            if (i >= a.arrayLength((Object[])uRLArray) - 1) continue;
            stringBuilder.append(File.pathSeparator);
        }
        return stringBuilder.toString();
    }

    public static Resource getClassResource(ResourceSource resourceSource, String string) {
        return resourceSource.getLocalResource(string.replace('.', '/') + ".class");
    }

    public static Resource[] asArray(Resource resource) {
        if (resource == null) {
            return null;
        }
        Object[] objectArray = new Resource[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)resource);
        return objectArray;
    }

    public static Resource asResource(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (ResourceUtils.isFileURL(uRL)) {
            return new FileResource(uRL);
        }
        return new URLResource(uRL);
    }

    public static Resource[] asResources(URL[] uRLArray) {
        if (uRLArray == null) {
            return null;
        }
        Object[] objectArray = new Resource[a.arrayLength((Object[])uRLArray)];
        for (int i = 0; i < a.arrayLength((Object[])uRLArray); ++i) {
            a.arrayStore((Object[])objectArray, (int)i, (Object)ResourceUtil.asResource((URL)g.convertForCast((Object)a.arrayLoad((Object[])uRLArray, (int)i), URL.class)));
        }
        return objectArray;
    }

    public static Resource[] asResources(Enumeration<URL> enumeration) {
        return ResourceUtil.asResources(ResourceUtil.toURLs(enumeration));
    }

    public static Resource[] asResources(List<URL> list) {
        if (list == null) {
            return null;
        }
        Object[] objectArray = new Resource[list.size()];
        int n2 = 0;
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)g.convertForCast((Object)iterator.next(), URL.class);
            a.arrayStore((Object[])objectArray, (int)n2++, (Object)ResourceUtil.asResource(uRL));
        }
        return objectArray;
    }

    public static InputStream asRawInputStream(URL uRL) {
        try {
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream asInputStream(URL uRL) {
        if (uRL == null) {
            return null;
        }
        byte[] byArray = ResourceUtil.asResource(uRL).getBytes();
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    private static URI toURI(File file) {
        if (System.getSecurityManager() == null) {
            return file.toURI();
        }
        return (URI)AccessController.doPrivileged(new 1(file));
    }

    public static URL makeURL(File file) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        return ResourceUtil.toURI(file).toURL();
    }

    public static URL makeURL(File file, String string) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        if (string == null) {
            return ResourceUtil.makeURL(file);
        }
        return new URL("jar:" + ResourceUtil.toURI(file).toURL() + "!/" + string);
    }

    public static File getFileFromPathOrURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return ResourceUtils.getFile(new URL(string));
    }

    public static File getFileFromURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        return ResourceUtils.getFile(new URL(string));
    }

    public static File getFileFromURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return ResourceUtils.getFile(uRL);
    }

    static {
        Object[] objectArray = new Class[1];
        a.arrayStore((Object[])objectArray, (int)0, String.class);
        FIND_RESOURCE_METHOD = ResourceUtil.getClassLoaderMethod("findResource", objectArray);
        Object[] objectArray2 = new Class[1];
        a.arrayStore((Object[])objectArray2, (int)0, String.class);
        FIND_RESOURCES_METHOD = ResourceUtil.getClassLoaderMethod("findResources", objectArray2);
    }

    protected /* synthetic */ ResourceUtil(h h2) {
        super(h2);
    }
}

